// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.BuiltinFunctions.IsInstanceNode;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory.IsInstanceNodeFactory;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.CreateMatchFromTRegexResultNode;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.PythonMethod;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.RECheckInputTypeNode;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.TRegexCache;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.TRegexCallExec;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.TRegexCompile;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.TRegexInitCache;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.TRegexSearch;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins.TRegexCallExec.BufferToTruffleStringNode;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsIntNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberIndexNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectSizeNodeGen;
import com.oracle.graal.python.nodes.HiddenAttr.WriteNode;
import com.oracle.graal.python.nodes.HiddenAttrFactory.WriteNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNodeGen;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.FromByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;

@GeneratedBy(SREModuleBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class SREModuleBuiltinsFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);
    private static final LibraryFactory<PythonBufferAcquireLibrary> PYTHON_BUFFER_ACQUIRE_LIBRARY_ = LibraryFactory.resolve(PythonBufferAcquireLibrary.class);
    @CompilationFinal(dimensions = 1) private static final PythonMethod[] PYTHON_METHOD_VALUES = DSLSupport.lookupEnumConstants(PythonMethod.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(TRegexInitCacheFactory.getInstance(), TRegexCompileFactory.getInstance(), TRegexSearchFactory.getInstance(), TRegexCallExecFactory.getInstance());
    }

    private static PythonMethod decodePythonMethod(int state) {
        if (state >= 0) {
            return PYTHON_METHOD_VALUES[state];
        } else {
            return null;
        }
    }

    @GeneratedBy(TRegexInitCache.class)
    static final class TRegexInitCacheFactory implements NodeFactory<TRegexInitCache> {

        private static final TRegexInitCacheFactory TREGEX_INIT_CACHE_FACTORY_INSTANCE = new TRegexInitCacheFactory();

        private TRegexInitCacheFactory() {
        }

        @Override
        public Class<TRegexInitCache> getNodeClass() {
            return TRegexInitCache.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TRegexInitCache createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TRegexInitCache> getInstance() {
            return TREGEX_INIT_CACHE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TRegexInitCache create() {
            return new TRegexInitCacheNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TRegexInitCache#call}
         *     Activation probability: 1.00000
         *     With/without class size: 36/14 bytes
         * </pre> */
        @GeneratedBy(TRegexInitCache.class)
        @SuppressWarnings("javadoc")
        static final class TRegexInitCacheNodeGen extends TRegexInitCache {

            private static final StateField STATE_0_TRegexInitCache_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexInitCache#call}
             *   Parameter: {@link PyLongAsIntNode} flagsToIntNode
             *   Inline method: {@link PyLongAsIntNodeGen#inline}</pre> */
            private static final PyLongAsIntNode INLINED_FLAGS_TO_INT_NODE_ = PyLongAsIntNodeGen.inline(InlineTarget.create(PyLongAsIntNode.class, STATE_0_TRegexInitCache_UPDATER.subUpdater(1, 9), ReferenceField.create(MethodHandles.lookup(), "flagsToIntNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "flagsToIntNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexInitCache#call}
             *   Parameter: {@link WriteNode} writeCacheNode
             *   Inline method: {@link WriteNodeGen#inline}</pre> */
            private static final WriteNode INLINED_WRITE_CACHE_NODE_ = WriteNodeGen.inline(InlineTarget.create(WriteNode.class, STATE_0_TRegexInitCache_UPDATER.subUpdater(10, 3), ReferenceField.create(MethodHandles.lookup(), "writeCacheNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TRegexInitCache#call}
             *   1-9: InlinedCache
             *        Specialization: {@link TRegexInitCache#call}
             *        Parameter: {@link PyLongAsIntNode} flagsToIntNode
             *        Inline method: {@link PyLongAsIntNodeGen#inline}
             *   10-12: InlinedCache
             *        Specialization: {@link TRegexInitCache#call}
             *        Parameter: {@link WriteNode} writeCacheNode
             *        Inline method: {@link WriteNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexInitCache#call}
             *   Parameter: {@link PyLongAsIntNode} flagsToIntNode
             *   Inline method: {@link PyLongAsIntNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node flagsToIntNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexInitCache#call}
             *   Parameter: {@link PyLongAsIntNode} flagsToIntNode
             *   Inline method: {@link PyLongAsIntNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node flagsToIntNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexInitCache#call}
             *   Parameter: {@link WriteNode} writeCacheNode
             *   Inline method: {@link WriteNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node writeCacheNode__field1_;

            private TRegexInitCacheNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexInitCache.call(VirtualFrame, PythonObject, Object, Object, Node, PyLongAsIntNode, WriteNode)] */ && arg0Value instanceof PythonObject) {
                    PythonObject arg0Value_ = (PythonObject) arg0Value;
                    {
                        Node inliningTarget__ = (this);
                        return call(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, INLINED_FLAGS_TO_INT_NODE_, INLINED_WRITE_CACHE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PythonObject) {
                        PythonObject arg0Value_ = (PythonObject) arg0Value;
                        inliningTarget__ = (this);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[SREModuleBuiltins.TRegexInitCache.call(VirtualFrame, PythonObject, Object, Object, Node, PyLongAsIntNode, WriteNode)] */;
                        this.state_0_ = state_0;
                        return call(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, INLINED_FLAGS_TO_INT_NODE_, INLINED_WRITE_CACHE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

        }
    }
    @GeneratedBy(TRegexCompile.class)
    static final class TRegexCompileFactory implements NodeFactory<TRegexCompile> {

        private static final TRegexCompileFactory TREGEX_COMPILE_FACTORY_INSTANCE = new TRegexCompileFactory();

        private TRegexCompileFactory() {
        }

        @Override
        public Class<TRegexCompile> getNodeClass() {
            return TRegexCompile.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TRegexCompile createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TRegexCompile> getInstance() {
            return TREGEX_COMPILE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TRegexCompile create() {
            return new TRegexCompileNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TRegexCompile#cached}
         *     Activation probability: 0.48333
         *     With/without class size: 18/13 bytes
         *   Specialization {@link TRegexCompile#localeNonSensitive}
         *     Activation probability: 0.33333
         *     With/without class size: 11/5 bytes
         *   Specialization {@link TRegexCompile#localeSensitive}
         *     Activation probability: 0.18333
         *     With/without class size: 12/26 bytes
         * </pre> */
        @GeneratedBy(TRegexCompile.class)
        @SuppressWarnings("javadoc")
        static final class TRegexCompileNodeGen extends TRegexCompile {

            private static final StateField LOCALE_SENSITIVE_TREGEX_COMPILE_LOCALE_SENSITIVE_STATE_0_UPDATER = StateField.create(LocaleSensitiveData.lookup_(), "localeSensitive_state_0_");
            static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
            static final ReferenceField<LocaleNonSensitiveData> LOCALE_NON_SENSITIVE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "localeNonSensitive_cache", LocaleNonSensitiveData.class);
            static final ReferenceField<LocaleSensitiveData> LOCALE_SENSITIVE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "localeSensitive_cache", LocaleSensitiveData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCompile#localeSensitive}
             *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}</pre> */
            private static final CastToTruffleStringNode INLINED_LOCALE_SENSITIVE_CAST_TO_TRUFFLE_STRING_NODE_ = CastToTruffleStringNodeGen.inline(InlineTarget.create(CastToTruffleStringNode.class, LOCALE_SENSITIVE_TREGEX_COMPILE_LOCALE_SENSITIVE_STATE_0_UPDATER.subUpdater(3, 8), ReferenceField.create(LocaleSensitiveData.lookup_(), "localeSensitive_castToTruffleStringNode__field1_", Node.class), ReferenceField.create(LocaleSensitiveData.lookup_(), "localeSensitive_castToTruffleStringNode__field2_", Node.class), ReferenceField.create(LocaleSensitiveData.lookup_(), "localeSensitive_castToTruffleStringNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TRegexCompile#cached}
             *   1: SpecializationActive {@link TRegexCompile#localeNonSensitive}
             *   2: SpecializationActive {@link TRegexCompile#localeSensitive}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @CompilationFinal private CachedData cached_cache;
            @UnsafeAccessedField @CompilationFinal private LocaleNonSensitiveData localeNonSensitive_cache;
            @UnsafeAccessedField @Child private LocaleSensitiveData localeSensitive_cache;

            private TRegexCompileNodeGen() {
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCompile.cached(PythonObject, PythonMethod, boolean, TRegexCache, PythonMethod, boolean, Object)] || SpecializationActive[SREModuleBuiltins.TRegexCompile.localeNonSensitive(PythonObject, PythonMethod, boolean, PythonMethod, boolean)] || SpecializationActive[SREModuleBuiltins.TRegexCompile.localeSensitive(VirtualFrame, PythonObject, PythonMethod, boolean, Node, PythonMethod, boolean, Object, CallNode, CastToTruffleStringNode)] */ && arg0Value instanceof PythonObject) {
                    PythonObject arg0Value_ = (PythonObject) arg0Value;
                    if (arg1Value instanceof PythonMethod) {
                        PythonMethod arg1Value_ = (PythonMethod) arg1Value;
                        if (arg2Value instanceof Boolean) {
                            boolean arg2Value_ = (boolean) arg2Value;
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCompile.cached(PythonObject, PythonMethod, boolean, TRegexCache, PythonMethod, boolean, Object)] */) {
                                CachedData s0_ = this.cached_cache;
                                while (s0_ != null) {
                                    {
                                        TRegexCache cachedTRegexCache__ = (s0_.weakCachedTRegexCacheGen__.get());
                                        if ((cachedTRegexCache__ != null) && (getTRegexCache(arg0Value_) == cachedTRegexCache__) && (arg1Value_ == decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg2Value_ == s0_.cachedMustAdvance_) && (!(cachedTRegexCache__.isLocaleSensitive()))) {
                                            return cached(arg0Value_, arg1Value_, arg2Value_, cachedTRegexCache__, decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)] */) - 1), s0_.cachedMustAdvance_, s0_.compiledRegex_);
                                        }
                                    }
                                    s0_ = s0_.next_;
                                }
                            }
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCompile.localeNonSensitive(PythonObject, PythonMethod, boolean, PythonMethod, boolean)] */) {
                                LocaleNonSensitiveData s1_ = this.localeNonSensitive_cache;
                                while (s1_ != null) {
                                    if ((arg1Value_ == decodePythonMethod((s1_.localeNonSensitive_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg2Value_ == s1_.cachedMustAdvance_) && (!(getTRegexCache(arg0Value_).isLocaleSensitive()))) {
                                        return localeNonSensitive(arg0Value_, arg1Value_, arg2Value_, decodePythonMethod((s1_.localeNonSensitive_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)] */) - 1), s1_.cachedMustAdvance_);
                                    }
                                    s1_ = s1_.next_;
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCompile.localeSensitive(VirtualFrame, PythonObject, PythonMethod, boolean, Node, PythonMethod, boolean, Object, CallNode, CastToTruffleStringNode)] */) {
                                LocaleSensitiveData s2_ = this.localeSensitive_cache;
                                while (s2_ != null) {
                                    if ((arg1Value_ == decodePythonMethod(((s2_.localeSensitive_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg2Value_ == s2_.cachedMustAdvance_) && (getTRegexCache(arg0Value_).isLocaleSensitive())) {
                                        Node inliningTarget__ = (s2_);
                                        return localeSensitive(frameValue, arg0Value_, arg1Value_, arg2Value_, inliningTarget__, decodePythonMethod(((s2_.localeSensitive_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)] */) - 1), s2_.cachedMustAdvance_, s2_.getLocale_, s2_.callGetLocale_, INLINED_LOCALE_SENSITIVE_CAST_TO_TRUFFLE_STRING_NODE_);
                                    }
                                    s2_ = s2_.next_;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PythonObject) {
                    PythonObject arg0Value_ = (PythonObject) arg0Value;
                    if (arg1Value instanceof PythonMethod) {
                        PythonMethod arg1Value_ = (PythonMethod) arg1Value;
                        if (arg2Value instanceof Boolean) {
                            boolean arg2Value_ = (boolean) arg2Value;
                            {
                                TRegexCache cachedTRegexCache__ = null;
                                if (((state_0 & 0b110)) == 0 /* is-not SpecializationActive[SREModuleBuiltins.TRegexCompile.localeNonSensitive(PythonObject, PythonMethod, boolean, PythonMethod, boolean)] && SpecializationActive[SREModuleBuiltins.TRegexCompile.localeSensitive(VirtualFrame, PythonObject, PythonMethod, boolean, Node, PythonMethod, boolean, Object, CallNode, CastToTruffleStringNode)] */) {
                                    while (true) {
                                        int count0_ = 0;
                                        CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                                        CachedData s0_original = s0_;
                                        while (s0_ != null) {
                                            {
                                                cachedTRegexCache__ = (s0_.weakCachedTRegexCacheGen__.get());
                                                if ((cachedTRegexCache__ != null) && (getTRegexCache(arg0Value_) == cachedTRegexCache__) && (arg1Value_ == decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg2Value_ == s0_.cachedMustAdvance_) && (!(cachedTRegexCache__.isLocaleSensitive()))) {
                                                    break;
                                                }
                                            }
                                            count0_++;
                                            s0_ = s0_.next_;
                                        }
                                        if (s0_ == null) {
                                            {
                                                TruffleWeakReference<TRegexCache> weakCachedTRegexCacheGen___ = (new TruffleWeakReference<>(getTRegexCache(arg0Value_)));
                                                cachedTRegexCache__ = (weakCachedTRegexCacheGen___.get());
                                                if ((cachedTRegexCache__ != null) && (getTRegexCache(arg0Value_) == cachedTRegexCache__)) {
                                                    if ((!(cachedTRegexCache__.isLocaleSensitive())) && count0_ < (2)) {
                                                        // assert (arg1Value_ == decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)] */) - 1));
                                                        // assert (arg2Value_ == s0_.cachedMustAdvance_);
                                                        s0_ = new CachedData(s0_original);
                                                        s0_.weakCachedTRegexCacheGen__ = weakCachedTRegexCacheGen___;
                                                        s0_.cached_state_0_ = (s0_.cached_state_0_ | (((arg1Value_).ordinal() + 1) << 0) /* set-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)] */);
                                                        s0_.cachedMustAdvance_ = (arg2Value_);
                                                        s0_.compiledRegex_ = (getCompiledRegex(arg0Value_, arg1Value_, arg2Value_));
                                                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                            continue;
                                                        }
                                                        state_0 = state_0 | 0b1 /* add SpecializationActive[SREModuleBuiltins.TRegexCompile.cached(PythonObject, PythonMethod, boolean, TRegexCache, PythonMethod, boolean, Object)] */;
                                                        this.state_0_ = state_0;
                                                    }
                                                }
                                            }
                                        }
                                        if (s0_ != null) {
                                            return cached(arg0Value_, arg1Value_, arg2Value_, cachedTRegexCache__, decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)] */) - 1), s0_.cachedMustAdvance_, s0_.compiledRegex_);
                                        }
                                        break;
                                    }
                                }
                            }
                            while (true) {
                                int count1_ = 0;
                                LocaleNonSensitiveData s1_ = LOCALE_NON_SENSITIVE_CACHE_UPDATER.getVolatile(this);
                                LocaleNonSensitiveData s1_original = s1_;
                                while (s1_ != null) {
                                    if ((arg1Value_ == decodePythonMethod((s1_.localeNonSensitive_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg2Value_ == s1_.cachedMustAdvance_) && (!(getTRegexCache(arg0Value_).isLocaleSensitive()))) {
                                        break;
                                    }
                                    count1_++;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ == null) {
                                    if ((!(getTRegexCache(arg0Value_).isLocaleSensitive())) && count1_ < (TRegexCompile.SPECIALIZATION_LIMIT)) {
                                        // assert (arg1Value_ == decodePythonMethod((s1_.localeNonSensitive_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)] */) - 1));
                                        // assert (arg2Value_ == s1_.cachedMustAdvance_);
                                        s1_ = new LocaleNonSensitiveData(s1_original);
                                        s1_.localeNonSensitive_state_0_ = (s1_.localeNonSensitive_state_0_ | (((arg1Value_).ordinal() + 1) << 0) /* set-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)] */);
                                        s1_.cachedMustAdvance_ = (arg2Value_);
                                        if (!LOCALE_NON_SENSITIVE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        this.cached_cache = null;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SREModuleBuiltins.TRegexCompile.cached(PythonObject, PythonMethod, boolean, TRegexCache, PythonMethod, boolean, Object)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[SREModuleBuiltins.TRegexCompile.localeNonSensitive(PythonObject, PythonMethod, boolean, PythonMethod, boolean)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s1_ != null) {
                                    return localeNonSensitive(arg0Value_, arg1Value_, arg2Value_, decodePythonMethod((s1_.localeNonSensitive_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)] */) - 1), s1_.cachedMustAdvance_);
                                }
                                break;
                            }
                            {
                                Node inliningTarget__ = null;
                                while (true) {
                                    int count2_ = 0;
                                    LocaleSensitiveData s2_ = LOCALE_SENSITIVE_CACHE_UPDATER.getVolatile(this);
                                    LocaleSensitiveData s2_original = s2_;
                                    while (s2_ != null) {
                                        if ((arg1Value_ == decodePythonMethod(((s2_.localeSensitive_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg2Value_ == s2_.cachedMustAdvance_) && (getTRegexCache(arg0Value_).isLocaleSensitive())) {
                                            inliningTarget__ = (s2_);
                                            break;
                                        }
                                        count2_++;
                                        s2_ = s2_.next_;
                                    }
                                    if (s2_ == null) {
                                        if ((getTRegexCache(arg0Value_).isLocaleSensitive()) && count2_ < (TRegexCompile.SPECIALIZATION_LIMIT)) {
                                            // assert (arg1Value_ == decodePythonMethod(((s2_.localeSensitive_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)] */) - 1));
                                            // assert (arg2Value_ == s2_.cachedMustAdvance_);
                                            s2_ = this.insert(new LocaleSensitiveData(s2_original));
                                            inliningTarget__ = (s2_);
                                            s2_.localeSensitive_state_0_ = (s2_.localeSensitive_state_0_ | (((arg1Value_).ordinal() + 1) << 0) /* set-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)] */);
                                            s2_.cachedMustAdvance_ = (arg2Value_);
                                            Object getLocale__ = (lookupGetLocaleFunction());
                                            Objects.requireNonNull(getLocale__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s2_.getLocale_ = getLocale__;
                                            CallNode callGetLocale__ = s2_.insert((CallNode.create()));
                                            Objects.requireNonNull(callGetLocale__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s2_.callGetLocale_ = callGetLocale__;
                                            if (!LOCALE_SENSITIVE_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                                continue;
                                            }
                                            this.cached_cache = null;
                                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SREModuleBuiltins.TRegexCompile.cached(PythonObject, PythonMethod, boolean, TRegexCache, PythonMethod, boolean, Object)] */;
                                            state_0 = state_0 | 0b100 /* add SpecializationActive[SREModuleBuiltins.TRegexCompile.localeSensitive(VirtualFrame, PythonObject, PythonMethod, boolean, Node, PythonMethod, boolean, Object, CallNode, CastToTruffleStringNode)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                    if (s2_ != null) {
                                        return localeSensitive(frameValue, arg0Value_, arg1Value_, arg2Value_, inliningTarget__, decodePythonMethod(((s2_.localeSensitive_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)] */) - 1), s2_.cachedMustAdvance_, s2_.getLocale_, s2_.callGetLocale_, INLINED_LOCALE_SENSITIVE_CAST_TO_TRUFFLE_STRING_NODE_);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @GeneratedBy(TRegexCompile.class)
            @DenyReplace
            private static final class CachedData implements SpecializationDataNode {

                @CompilationFinal final CachedData next_;
                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.cached(..., PythonMethod cachedMethod, ...)]
                 * </pre> */
                @CompilationFinal private int cached_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#cached}
                 *   Parameter: {@link TruffleWeakReference} weakCachedTRegexCacheGen_</pre> */
                @CompilationFinal TruffleWeakReference<TRegexCache> weakCachedTRegexCacheGen__;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#cached}
                 *   Parameter: boolean cachedMustAdvance</pre> */
                @CompilationFinal boolean cachedMustAdvance_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#cached}
                 *   Parameter: {@link Object} compiledRegex</pre> */
                @CompilationFinal Object compiledRegex_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(TRegexCompile.class)
            @DenyReplace
            private static final class LocaleNonSensitiveData implements SpecializationDataNode {

                @CompilationFinal final LocaleNonSensitiveData next_;
                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeNonSensitive(..., PythonMethod cachedMethod, ...)]
                 * </pre> */
                @CompilationFinal private int localeNonSensitive_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeNonSensitive}
                 *   Parameter: boolean cachedMustAdvance</pre> */
                @CompilationFinal boolean cachedMustAdvance_;

                LocaleNonSensitiveData(LocaleNonSensitiveData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(TRegexCompile.class)
            @DenyReplace
            private static final class LocaleSensitiveData extends Node implements SpecializationDataNode {

                @Child LocaleSensitiveData next_;
                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=SREModuleBuiltins.TRegexCompile.localeSensitive(..., PythonMethod cachedMethod, ...)]
                 *   3-10: InlinedCache
                 *        Specialization: {@link TRegexCompile#localeSensitive}
                 *        Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *        Inline method: {@link CastToTruffleStringNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int localeSensitive_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeSensitive}
                 *   Parameter: boolean cachedMustAdvance</pre> */
                @CompilationFinal boolean cachedMustAdvance_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeSensitive}
                 *   Parameter: {@link Object} getLocale</pre> */
                @CompilationFinal Object getLocale_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeSensitive}
                 *   Parameter: {@link CallNode} callGetLocale</pre> */
                @Child CallNode callGetLocale_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeSensitive}
                 *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *   Inline method: {@link CastToTruffleStringNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node localeSensitive_castToTruffleStringNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeSensitive}
                 *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *   Inline method: {@link CastToTruffleStringNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node localeSensitive_castToTruffleStringNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCompile#localeSensitive}
                 *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *   Inline method: {@link CastToTruffleStringNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node localeSensitive_castToTruffleStringNode__field3_;

                LocaleSensitiveData(LocaleSensitiveData next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RECheckInputTypeNode#check}
     *     Activation probability: 1.00000
     *     With/without class size: 40/17 bytes
     * </pre> */
    @GeneratedBy(RECheckInputTypeNode.class)
    @SuppressWarnings("javadoc")
    static final class RECheckInputTypeNodeGen extends RECheckInputTypeNode {

        private static final StateField STATE_0_RECheckInputTypeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link InlinedConditionProfile} unsupportedInputTypeProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
        private static final InlinedConditionProfile INLINED_UNSUPPORTED_INPUT_TYPE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_RECheckInputTypeNode_UPDATER.subUpdater(1, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link InlinedConditionProfile} unexpectedInputTypeProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
        private static final InlinedConditionProfile INLINED_UNEXPECTED_INPUT_TYPE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_RECheckInputTypeNode_UPDATER.subUpdater(3, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link Lazy} raiseNode
         *   Inline method: {@link LazyNodeGen#inline}</pre> */
        private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_RECheckInputTypeNode_UPDATER.subUpdater(5, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link RECheckInputTypeNode#check}
         *   1-2: InlinedCache
         *        Specialization: {@link RECheckInputTypeNode#check}
         *        Parameter: {@link InlinedConditionProfile} unsupportedInputTypeProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   3-4: InlinedCache
         *        Specialization: {@link RECheckInputTypeNode#check}
         *        Parameter: {@link InlinedConditionProfile} unexpectedInputTypeProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   5: InlinedCache
         *        Specialization: {@link RECheckInputTypeNode#check}
         *        Parameter: {@link Lazy} raiseNode
         *        Inline method: {@link LazyNodeGen#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link PTuple} supportedBinaryInputTypes</pre> */
        @CompilationFinal private PTuple supportedBinaryInputTypes_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link IsInstanceNode} isStringNode</pre> */
        @Child private IsInstanceNode isStringNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link IsInstanceNode} isBytesNode</pre> */
        @Child private IsInstanceNode isBytesNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link RECheckInputTypeNode#check}
         *   Parameter: {@link Lazy} raiseNode
         *   Inline method: {@link LazyNodeGen#inline}
         *   Inline field: {@link Node} field1</pre> */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

        private RECheckInputTypeNodeGen() {
        }

        @Override
        public void execute(VirtualFrame frameValue, Object arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[SREModuleBuiltins.RECheckInputTypeNode.check(VirtualFrame, Object, boolean, Node, PTuple, IsInstanceNode, IsInstanceNode, InlinedConditionProfile, InlinedConditionProfile, Lazy)] */) {
                {
                    PTuple supportedBinaryInputTypes__ = this.supportedBinaryInputTypes_;
                    if (supportedBinaryInputTypes__ != null) {
                        IsInstanceNode isStringNode__ = this.isStringNode_;
                        if (isStringNode__ != null) {
                            IsInstanceNode isBytesNode__ = this.isBytesNode_;
                            if (isBytesNode__ != null) {
                                Node inliningTarget__ = (this);
                                RECheckInputTypeNode.check(frameValue, arg0Value, arg1Value, inliningTarget__, supportedBinaryInputTypes__, isStringNode__, isBytesNode__, INLINED_UNSUPPORTED_INPUT_TYPE_PROFILE_, INLINED_UNEXPECTED_INPUT_TYPE_PROFILE_, INLINED_RAISE_NODE_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            {
                Node inliningTarget__ = null;
                inliningTarget__ = (this);
                PTuple supportedBinaryInputTypes__ = (getSupportedBinaryInputTypes());
                Objects.requireNonNull(supportedBinaryInputTypes__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.supportedBinaryInputTypes_ = supportedBinaryInputTypes__;
                IsInstanceNode isStringNode__ = this.insert((IsInstanceNodeFactory.create()));
                Objects.requireNonNull(isStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.isStringNode_ = isStringNode__;
                IsInstanceNode isBytesNode__ = this.insert((IsInstanceNodeFactory.create()));
                Objects.requireNonNull(isBytesNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.isBytesNode_ = isBytesNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[SREModuleBuiltins.RECheckInputTypeNode.check(VirtualFrame, Object, boolean, Node, PTuple, IsInstanceNode, IsInstanceNode, InlinedConditionProfile, InlinedConditionProfile, Lazy)] */;
                this.state_0_ = state_0;
                RECheckInputTypeNode.check(frameValue, arg0Value, arg1Value, inliningTarget__, supportedBinaryInputTypes__, isStringNode__, isBytesNode__, INLINED_UNSUPPORTED_INPUT_TYPE_PROFILE_, INLINED_UNEXPECTED_INPUT_TYPE_PROFILE_, INLINED_RAISE_NODE_);
                return;
            }
        }

        @NeverDefault
        public static RECheckInputTypeNode create() {
            return new RECheckInputTypeNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CreateMatchFromTRegexResultNode#createMatch}
     *     Activation probability: 1.00000
     *     With/without class size: 68/45 bytes
     * </pre> */
    @GeneratedBy(CreateMatchFromTRegexResultNode.class)
    @SuppressWarnings("javadoc")
    static final class CreateMatchFromTRegexResultNodeGen {

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#matchConstructor_}
         * <li>{@link Inlined#libResult_}
         * <li>{@link Inlined#lookupIndexGroupNode__field1_}
         * <li>{@link Inlined#lookupIndexGroupNode__field2_}
         * <li>{@link Inlined#lookupIndexGroupNode__field3_}
         * <li>{@link Inlined#lookupIndexGroupNode__field4_}
         * <li>{@link Inlined#lookupIndexGroupNode__field5_}
         * <li>{@link Inlined#lookupIndexGroupNode__field6_}
         * <li>{@link Inlined#lookupIndexGroupNode__field7_}
         * <li>{@link Inlined#lookupIndexGroupNode__field8_}
         * <li>{@link Inlined#constructResultNode_}
         * </ul> */
        @NeverDefault
        public static CreateMatchFromTRegexResultNode inline(@RequiredField(bits = 8, value = StateField.class)@RequiredField(type = Object.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new CreateMatchFromTRegexResultNodeGen.Inlined(target);
        }

        @GeneratedBy(CreateMatchFromTRegexResultNode.class)
        @DenyReplace
        private static final class Inlined extends CreateMatchFromTRegexResultNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CreateMatchFromTRegexResultNode#createMatch}
             *   1-2: InlinedCache
             *        Specialization: {@link CreateMatchFromTRegexResultNode#createMatch}
             *        Parameter: {@link InlinedConditionProfile} matchProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   3-7: InlinedCache
             *        Specialization: {@link CreateMatchFromTRegexResultNode#createMatch}
             *        Parameter: {@link PyObjectLookupAttr} lookupIndexGroupNode
             *        Inline method: {@link PyObjectLookupAttrNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<Object> matchConstructor_;
            private final ReferenceField<InteropLibrary> libResult_;
            private final ReferenceField<Node> lookupIndexGroupNode__field1_;
            private final ReferenceField<Node> lookupIndexGroupNode__field2_;
            private final ReferenceField<Node> lookupIndexGroupNode__field3_;
            private final ReferenceField<Node> lookupIndexGroupNode__field4_;
            private final ReferenceField<Node> lookupIndexGroupNode__field5_;
            private final ReferenceField<Node> lookupIndexGroupNode__field6_;
            private final ReferenceField<Node> lookupIndexGroupNode__field7_;
            private final ReferenceField<Node> lookupIndexGroupNode__field8_;
            private final ReferenceField<CallNode> constructResultNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CreateMatchFromTRegexResultNode#createMatch}
             *   Parameter: {@link InlinedConditionProfile} matchProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile matchProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CreateMatchFromTRegexResultNode#createMatch}
             *   Parameter: {@link PyObjectLookupAttr} lookupIndexGroupNode
             *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}</pre> */
            private final PyObjectLookupAttr lookupIndexGroupNode_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CreateMatchFromTRegexResultNode.class);
                this.state_0_ = target.getState(0, 8);
                this.matchConstructor_ = target.getReference(1, Object.class);
                this.libResult_ = target.getReference(2, InteropLibrary.class);
                this.lookupIndexGroupNode__field1_ = target.getReference(3, Node.class);
                this.lookupIndexGroupNode__field2_ = target.getReference(4, Node.class);
                this.lookupIndexGroupNode__field3_ = target.getReference(5, Node.class);
                this.lookupIndexGroupNode__field4_ = target.getReference(6, Node.class);
                this.lookupIndexGroupNode__field5_ = target.getReference(7, Node.class);
                this.lookupIndexGroupNode__field6_ = target.getReference(8, Node.class);
                this.lookupIndexGroupNode__field7_ = target.getReference(9, Node.class);
                this.lookupIndexGroupNode__field8_ = target.getReference(10, Node.class);
                this.constructResultNode_ = target.getReference(11, CallNode.class);
                this.matchProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(1, 2)));
                this.lookupIndexGroupNode_ = PyObjectLookupAttrNodeGen.inline(InlineTarget.create(PyObjectLookupAttr.class, state_0_.subUpdater(3, 5), lookupIndexGroupNode__field1_, lookupIndexGroupNode__field2_, lookupIndexGroupNode__field3_, lookupIndexGroupNode__field4_, lookupIndexGroupNode__field5_, lookupIndexGroupNode__field6_, lookupIndexGroupNode__field7_, lookupIndexGroupNode__field8_));
            }

            @Override
            public Object execute(VirtualFrame frameValue, Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, Object arg4Value, Object arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[SREModuleBuiltins.CreateMatchFromTRegexResultNode.createMatch(VirtualFrame, Node, Object, int, int, Object, Object, Object, InlinedConditionProfile, InteropLibrary, PyObjectLookupAttr, CallNode)] */) {
                    {
                        Object matchConstructor__ = this.matchConstructor_.get(arg0Value);
                        if (matchConstructor__ != null) {
                            InteropLibrary libResult__ = this.libResult_.get(arg0Value);
                            if (libResult__ != null) {
                                CallNode constructResultNode__ = this.constructResultNode_.get(arg0Value);
                                if (constructResultNode__ != null) {
                                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.lookupIndexGroupNode__field1_, this.lookupIndexGroupNode__field2_, this.lookupIndexGroupNode__field3_, this.lookupIndexGroupNode__field4_, this.lookupIndexGroupNode__field5_, this.lookupIndexGroupNode__field6_, this.lookupIndexGroupNode__field7_, this.lookupIndexGroupNode__field8_);
                                    return CreateMatchFromTRegexResultNode.createMatch(frameValue, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, matchConstructor__, this.matchProfile_, libResult__, this.lookupIndexGroupNode_, constructResultNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, Object arg4Value, Object arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                Object matchConstructor__ = (lookupMatchConstructor());
                Objects.requireNonNull(matchConstructor__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.matchConstructor_.set(arg0Value, matchConstructor__);
                InteropLibrary libResult__ = arg0Value.insert((INTEROP_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(libResult__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.libResult_.set(arg0Value, libResult__);
                CallNode constructResultNode__ = arg0Value.insert((CallNode.create()));
                Objects.requireNonNull(constructResultNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.constructResultNode_.set(arg0Value, constructResultNode__);
                state_0 = state_0 | 0b1 /* add SpecializationActive[SREModuleBuiltins.CreateMatchFromTRegexResultNode.createMatch(VirtualFrame, Node, Object, int, int, Object, Object, Object, InlinedConditionProfile, InteropLibrary, PyObjectLookupAttr, CallNode)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.lookupIndexGroupNode__field1_, this.lookupIndexGroupNode__field2_, this.lookupIndexGroupNode__field3_, this.lookupIndexGroupNode__field4_, this.lookupIndexGroupNode__field5_, this.lookupIndexGroupNode__field6_, this.lookupIndexGroupNode__field7_, this.lookupIndexGroupNode__field8_);
                return CreateMatchFromTRegexResultNode.createMatch(frameValue, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, matchConstructor__, this.matchProfile_, libResult__, this.lookupIndexGroupNode_, constructResultNode__);
            }

        }
    }
    @GeneratedBy(TRegexSearch.class)
    static final class TRegexSearchFactory implements NodeFactory<TRegexSearch> {

        private static final TRegexSearchFactory TREGEX_SEARCH_FACTORY_INSTANCE = new TRegexSearchFactory();

        private TRegexSearchFactory() {
        }

        @Override
        public Class<TRegexSearch> getNodeClass() {
            return TRegexSearch.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class, Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TRegexSearch createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TRegexSearch> getInstance() {
            return TREGEX_SEARCH_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TRegexSearch create() {
            return new TRegexSearchNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TRegexSearch#doCached}
         *     Activation probability: 0.48333
         *     With/without class size: 21/21 bytes
         *   Specialization {@link TRegexSearch#doCachedRegex}
         *     Activation probability: 0.33333
         *     With/without class size: 15/17 bytes
         *   Specialization {@link TRegexSearch#doDynamic}
         *     Activation probability: 0.18333
         *     With/without class size: 9/8 bytes
         * </pre> */
        @GeneratedBy(TRegexSearch.class)
        @SuppressWarnings("javadoc")
        static final class TRegexSearchNodeGen extends TRegexSearch {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
            static final ReferenceField<CachedRegexData> CACHED_REGEX_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedRegex_cache", CachedRegexData.class);
            static final ReferenceField<DynamicData> DYNAMIC_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "dynamic_cache", DynamicData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link InlinedConditionProfile} fallbackProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_FALLBACK_PROFILE = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(3, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link InlinedConditionProfile} truncatingInputProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_TRUNCATING_INPUT_PROFILE = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(5, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberIndexNode} indexNode
             *   Inline method: {@link PyNumberIndexNodeGen#inline}</pre> */
            private static final PyNumberIndexNode INLINED_INDEX_NODE = PyNumberIndexNodeGen.inline(InlineTarget.create(PyNumberIndexNode.class, STATE_0_UPDATER.subUpdater(7, 6), ReferenceField.create(MethodHandles.lookup(), "indexNode_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "indexNode_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "indexNode_field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "indexNode_field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "indexNode_field5_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}</pre> */
            private static final PyNumberAsSizeNode INLINED_AS_SIZE_NODE = PyNumberAsSizeNodeGen.inline(InlineTarget.create(PyNumberAsSizeNode.class, STATE_0_UPDATER.subUpdater(13, 5), ReferenceField.create(MethodHandles.lookup(), "asSizeNode_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "asSizeNode_field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyObjectSizeNode} lengthNode
             *   Inline method: {@link PyObjectSizeNodeGen#inline}</pre> */
            private static final PyObjectSizeNode INLINED_LENGTH_NODE = PyObjectSizeNodeGen.inline(InlineTarget.create(PyObjectSizeNode.class, STATE_0_UPDATER.subUpdater(18, 13), ReferenceField.create(MethodHandles.lookup(), "lengthNode_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "lengthNode_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "lengthNode_field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "lengthNode_field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "lengthNode_field5_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}</pre> */
            private static final CreateMatchFromTRegexResultNode INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE = CreateMatchFromTRegexResultNodeGen.inline(InlineTarget.create(CreateMatchFromTRegexResultNode.class, STATE_1_UPDATER.subUpdater(0, 8), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field1_", Object.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field6_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field7_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field8_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field9_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field10_", Node.class), ReferenceField.create(MethodHandles.lookup(), "createMatchFromTRegexResultNode_field11_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TRegexSearch#doCached}
             *   1: SpecializationActive {@link TRegexSearch#doCachedRegex}
             *   2: SpecializationActive {@link TRegexSearch#doDynamic}
             *   3-4: InlinedCache
             *        Specialization: {@link TRegexSearch#doCached}
             *        Parameter: {@link InlinedConditionProfile} fallbackProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   5-6: InlinedCache
             *        Specialization: {@link TRegexSearch#doCached}
             *        Parameter: {@link InlinedConditionProfile} truncatingInputProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   7-12: InlinedCache
             *        Specialization: {@link TRegexSearch#doCached}
             *        Parameter: {@link PyNumberIndexNode} indexNode
             *        Inline method: {@link PyNumberIndexNodeGen#inline}
             *   13-17: InlinedCache
             *        Specialization: {@link TRegexSearch#doCached}
             *        Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *        Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   18-30: InlinedCache
             *        Specialization: {@link TRegexSearch#doCached}
             *        Parameter: {@link PyObjectSizeNode} lengthNode
             *        Inline method: {@link PyObjectSizeNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-7: InlinedCache
             *        Specialization: {@link TRegexSearch#doCached}
             *        Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *        Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link TRegexCompile} tRegexCompileNode</pre> */
            @Child private TRegexCompile tRegexCompileNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link RECheckInputTypeNode} reCheckInputTypeNode</pre> */
            @Child private RECheckInputTypeNode reCheckInputTypeNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberIndexNode} indexNode
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node indexNode_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberIndexNode} indexNode
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node indexNode_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberIndexNode} indexNode
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node indexNode_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberIndexNode} indexNode
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node indexNode_field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberIndexNode} indexNode
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field5</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node indexNode_field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyObjectSizeNode} lengthNode
             *   Inline method: {@link PyObjectSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node lengthNode_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyObjectSizeNode} lengthNode
             *   Inline method: {@link PyObjectSizeNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node lengthNode_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyObjectSizeNode} lengthNode
             *   Inline method: {@link PyObjectSizeNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node lengthNode_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyObjectSizeNode} lengthNode
             *   Inline method: {@link PyObjectSizeNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node lengthNode_field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link PyObjectSizeNode} lengthNode
             *   Inline method: {@link PyObjectSizeNodeGen#inline}
             *   Inline field: {@link Node} field5</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node lengthNode_field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link InteropLibrary} libCompiledRegex</pre> */
            @Child private InteropLibrary libCompiledRegex;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link TRegexCallExec} tRegexCallExec</pre> */
            @Child private TRegexCallExec tRegexCallExec;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Object} field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object createMatchFromTRegexResultNode_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field5</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field6</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field6_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field7</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field7_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field8</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field8_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field9</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field9_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field10</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field10_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexSearch#doCached}
             *   Parameter: {@link CreateMatchFromTRegexResultNode} createMatchFromTRegexResultNode
             *   Inline method: {@link CreateMatchFromTRegexResultNodeGen#inline}
             *   Inline field: {@link Node} field11</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createMatchFromTRegexResultNode_field11_;
            @UnsafeAccessedField @Child private CachedData cached_cache;
            @UnsafeAccessedField @Child private CachedRegexData cachedRegex_cache;
            @UnsafeAccessedField @Child private DynamicData dynamic_cache;

            private TRegexSearchNodeGen() {
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value, Object arg5Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexSearch.doCached(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonObject, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] || SpecializationActive[SREModuleBuiltins.TRegexSearch.doCachedRegex(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] || SpecializationActive[SREModuleBuiltins.TRegexSearch.doDynamic(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, TRegexCompile, PyNumberIndexNode, PyNumberAsSizeNode, RECheckInputTypeNode, PyObjectSizeNode, InlinedConditionProfile, InlinedConditionProfile, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */ && arg0Value instanceof PythonObject) {
                    PythonObject arg0Value_ = (PythonObject) arg0Value;
                    if (arg4Value instanceof PythonMethod) {
                        PythonMethod arg4Value_ = (PythonMethod) arg4Value;
                        if (arg5Value instanceof Boolean) {
                            boolean arg5Value_ = (boolean) arg5Value;
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexSearch.doCached(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonObject, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */) {
                                CachedData s0_ = this.cached_cache;
                                if (s0_ != null) {
                                    {
                                        TRegexCompile tRegexCompileNode_ = this.tRegexCompileNode;
                                        if (tRegexCompileNode_ != null) {
                                            RECheckInputTypeNode reCheckInputTypeNode_ = this.reCheckInputTypeNode;
                                            if (reCheckInputTypeNode_ != null) {
                                                InteropLibrary libCompiledRegex_ = this.libCompiledRegex;
                                                if (libCompiledRegex_ != null) {
                                                    TRegexCallExec tRegexCallExec_ = this.tRegexCallExec;
                                                    if (tRegexCallExec_ != null) {
                                                        PythonObject cachedPattern__ = (s0_.weakCachedPatternGen__.get());
                                                        assert DSLSupport.assertIdempotence((isSingleContext()));
                                                        if ((cachedPattern__ != null) && (arg0Value_ == cachedPattern__) && (arg4Value_ == decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg5Value_ == s0_.cachedMustAdvance_)) {
                                                            TRegexCache tRegexCache__ = (s0_.weakTRegexCacheGen__.get());
                                                            if ((tRegexCache__ != null) && (!(tRegexCache__.isLocaleSensitive()))) {
                                                                Node inliningTarget__ = (this);
                                                                return doCached(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value_, inliningTarget__, cachedPattern__, decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)] */) - 1), s0_.cachedMustAdvance_, tRegexCompileNode_, tRegexCache__, s0_.compiledRegex_, INLINED_FALLBACK_PROFILE, INLINED_TRUNCATING_INPUT_PROFILE, reCheckInputTypeNode_, INLINED_INDEX_NODE, INLINED_AS_SIZE_NODE, INLINED_LENGTH_NODE, libCompiledRegex_, s0_.getFallbackMethodNode_, tRegexCallExec_, INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexSearch.doCachedRegex(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */) {
                                CachedRegexData s1_ = this.cachedRegex_cache;
                                if (s1_ != null) {
                                    {
                                        TRegexCompile tRegexCompileNode_1 = this.tRegexCompileNode;
                                        if (tRegexCompileNode_1 != null) {
                                            RECheckInputTypeNode reCheckInputTypeNode_1 = this.reCheckInputTypeNode;
                                            if (reCheckInputTypeNode_1 != null) {
                                                InteropLibrary libCompiledRegex_1 = this.libCompiledRegex;
                                                if (libCompiledRegex_1 != null) {
                                                    TRegexCallExec tRegexCallExec_1 = this.tRegexCallExec;
                                                    if (tRegexCallExec_1 != null) {
                                                        if ((tRegexCompileNode_1.execute(frameValue, arg0Value_, arg4Value_, arg5Value_) == s1_.compiledRegex_) && (arg4Value_ == decodePythonMethod((s1_.cachedRegex_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg5Value_ == s1_.cachedMustAdvance_)) {
                                                            TRegexCache tRegexCache__1 = (s1_.weakTRegexCacheGen__.get());
                                                            if ((tRegexCache__1 != null) && (!(tRegexCache__1.isLocaleSensitive()))) {
                                                                Node inliningTarget__1 = (this);
                                                                return doCachedRegex(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value_, inliningTarget__1, decodePythonMethod((s1_.cachedRegex_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)] */) - 1), s1_.cachedMustAdvance_, tRegexCompileNode_1, tRegexCache__1, s1_.compiledRegex_, INLINED_FALLBACK_PROFILE, INLINED_TRUNCATING_INPUT_PROFILE, reCheckInputTypeNode_1, INLINED_INDEX_NODE, INLINED_AS_SIZE_NODE, INLINED_LENGTH_NODE, libCompiledRegex_1, s1_.getFallbackMethodNode_, tRegexCallExec_1, INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexSearch.doDynamic(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, TRegexCompile, PyNumberIndexNode, PyNumberAsSizeNode, RECheckInputTypeNode, PyObjectSizeNode, InlinedConditionProfile, InlinedConditionProfile, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */) {
                                DynamicData s2_ = this.dynamic_cache;
                                while (s2_ != null) {
                                    {
                                        TRegexCompile tRegexCompileNode_2 = this.tRegexCompileNode;
                                        if (tRegexCompileNode_2 != null) {
                                            RECheckInputTypeNode reCheckInputTypeNode_2 = this.reCheckInputTypeNode;
                                            if (reCheckInputTypeNode_2 != null) {
                                                InteropLibrary libCompiledRegex_2 = this.libCompiledRegex;
                                                if (libCompiledRegex_2 != null) {
                                                    TRegexCallExec tRegexCallExec_2 = this.tRegexCallExec;
                                                    if (tRegexCallExec_2 != null) {
                                                        if ((arg4Value_ == decodePythonMethod((s2_.dynamic_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)] */) - 1))) {
                                                            Node inliningTarget__2 = (this);
                                                            return doDynamic(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value_, inliningTarget__2, decodePythonMethod((s2_.dynamic_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)] */) - 1), tRegexCompileNode_2, INLINED_INDEX_NODE, INLINED_AS_SIZE_NODE, reCheckInputTypeNode_2, INLINED_LENGTH_NODE, INLINED_FALLBACK_PROFILE, INLINED_TRUNCATING_INPUT_PROFILE, libCompiledRegex_2, s2_.getFallbackMethodNode_, tRegexCallExec_2, INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    s2_ = s2_.next_;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value, Object arg5Value) {
                int state_0 = this.state_0_;
                int oldState_0 = (state_0 & 0b111);
                try {
                    if (arg0Value instanceof PythonObject) {
                        PythonObject arg0Value_ = (PythonObject) arg0Value;
                        if (arg4Value instanceof PythonMethod) {
                            PythonMethod arg4Value_ = (PythonMethod) arg4Value;
                            if (arg5Value instanceof Boolean) {
                                boolean arg5Value_ = (boolean) arg5Value;
                                {
                                    TRegexCache tRegexCache__ = null;
                                    PythonObject cachedPattern__ = null;
                                    Node inliningTarget__ = null;
                                    if (((state_0 & 0b110)) == 0 /* is-not SpecializationActive[SREModuleBuiltins.TRegexSearch.doCachedRegex(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] && SpecializationActive[SREModuleBuiltins.TRegexSearch.doDynamic(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, TRegexCompile, PyNumberIndexNode, PyNumberAsSizeNode, RECheckInputTypeNode, PyObjectSizeNode, InlinedConditionProfile, InlinedConditionProfile, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */) {
                                        while (true) {
                                            int count0_ = 0;
                                            CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                                            CachedData s0_original = s0_;
                                            while (s0_ != null) {
                                                {
                                                    TRegexCompile tRegexCompileNode_ = this.tRegexCompileNode;
                                                    if (tRegexCompileNode_ != null) {
                                                        RECheckInputTypeNode reCheckInputTypeNode_ = this.reCheckInputTypeNode;
                                                        if (reCheckInputTypeNode_ != null) {
                                                            InteropLibrary libCompiledRegex_ = this.libCompiledRegex;
                                                            if (libCompiledRegex_ != null) {
                                                                TRegexCallExec tRegexCallExec_ = this.tRegexCallExec;
                                                                if (tRegexCallExec_ != null) {
                                                                    cachedPattern__ = (s0_.weakCachedPatternGen__.get());
                                                                    assert DSLSupport.assertIdempotence((isSingleContext()));
                                                                    if ((cachedPattern__ != null) && (arg0Value_ == cachedPattern__) && (arg4Value_ == decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg5Value_ == s0_.cachedMustAdvance_)) {
                                                                        tRegexCache__ = (s0_.weakTRegexCacheGen__.get());
                                                                        if ((tRegexCache__ != null) && (!(tRegexCache__.isLocaleSensitive()))) {
                                                                            inliningTarget__ = (this);
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                count0_++;
                                                s0_ = null;
                                                break;
                                            }
                                            if (s0_ == null && count0_ < 1) {
                                                if ((isSingleContext())) {
                                                    TruffleWeakReference<PythonObject> weakCachedPatternGen___ = (new TruffleWeakReference<>(arg0Value_));
                                                    cachedPattern__ = (weakCachedPatternGen___.get());
                                                    if ((cachedPattern__ != null) && (arg0Value_ == cachedPattern__)) {
                                                        TruffleWeakReference<TRegexCache> weakTRegexCacheGen___ = (new TruffleWeakReference<>(getTRegexCache(arg0Value_)));
                                                        tRegexCache__ = (weakTRegexCacheGen___.get());
                                                        // assert (arg4Value_ == decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)] */) - 1));
                                                        // assert (arg5Value_ == s0_.cachedMustAdvance_);
                                                        if ((tRegexCache__ != null) && (!(tRegexCache__.isLocaleSensitive()))) {
                                                            s0_ = this.insert(new CachedData());
                                                            s0_.weakTRegexCacheGen__ = weakTRegexCacheGen___;
                                                            s0_.weakCachedPatternGen__ = weakCachedPatternGen___;
                                                            inliningTarget__ = (this);
                                                            s0_.cached_state_0_ = (s0_.cached_state_0_ | (((arg4Value_).ordinal() + 1) << 0) /* set-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)] */);
                                                            s0_.cachedMustAdvance_ = (arg5Value_);
                                                            TRegexCompile tRegexCompileNode_;
                                                            TRegexCompile tRegexCompileNode__shared = this.tRegexCompileNode;
                                                            if (tRegexCompileNode__shared != null) {
                                                                tRegexCompileNode_ = tRegexCompileNode__shared;
                                                            } else {
                                                                tRegexCompileNode_ = s0_.insert((TRegexCompileFactory.create()));
                                                                if (tRegexCompileNode_ == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.tRegexCompileNode == null) {
                                                                this.tRegexCompileNode = tRegexCompileNode_;
                                                            }
                                                            s0_.compiledRegex_ = (tRegexCompileNode_.execute(frameValue, arg0Value_, arg4Value_, arg5Value_));
                                                            RECheckInputTypeNode reCheckInputTypeNode_;
                                                            RECheckInputTypeNode reCheckInputTypeNode__shared = this.reCheckInputTypeNode;
                                                            if (reCheckInputTypeNode__shared != null) {
                                                                reCheckInputTypeNode_ = reCheckInputTypeNode__shared;
                                                            } else {
                                                                reCheckInputTypeNode_ = s0_.insert((RECheckInputTypeNodeGen.create()));
                                                                if (reCheckInputTypeNode_ == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.reCheckInputTypeNode == null) {
                                                                this.reCheckInputTypeNode = reCheckInputTypeNode_;
                                                            }
                                                            InteropLibrary libCompiledRegex_;
                                                            InteropLibrary libCompiledRegex__shared = this.libCompiledRegex;
                                                            if (libCompiledRegex__shared != null) {
                                                                libCompiledRegex_ = libCompiledRegex__shared;
                                                            } else {
                                                                libCompiledRegex_ = s0_.insert((INTEROP_LIBRARY_.createDispatched(1)));
                                                                if (libCompiledRegex_ == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.libCompiledRegex == null) {
                                                                this.libCompiledRegex = libCompiledRegex_;
                                                            }
                                                            GetAttributeNode getFallbackMethodNode__ = s0_.insert((GetAttributeNode.create(arg4Value_.getMethodName())));
                                                            Objects.requireNonNull(getFallbackMethodNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                            s0_.getFallbackMethodNode_ = getFallbackMethodNode__;
                                                            TRegexCallExec tRegexCallExec_;
                                                            TRegexCallExec tRegexCallExec__shared = this.tRegexCallExec;
                                                            if (tRegexCallExec__shared != null) {
                                                                tRegexCallExec_ = tRegexCallExec__shared;
                                                            } else {
                                                                tRegexCallExec_ = s0_.insert((TRegexCallExecFactory.create()));
                                                                if (tRegexCallExec_ == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.tRegexCallExec == null) {
                                                                this.tRegexCallExec = tRegexCallExec_;
                                                            }
                                                            if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                                continue;
                                                            }
                                                            state_0 = state_0 | 0b1 /* add SpecializationActive[SREModuleBuiltins.TRegexSearch.doCached(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonObject, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */;
                                                            this.state_0_ = state_0;
                                                        }
                                                    }
                                                }
                                            }
                                            if (s0_ != null) {
                                                return doCached(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value_, inliningTarget__, cachedPattern__, decodePythonMethod((s0_.cached_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)] */) - 1), s0_.cachedMustAdvance_, this.tRegexCompileNode, tRegexCache__, s0_.compiledRegex_, INLINED_FALLBACK_PROFILE, INLINED_TRUNCATING_INPUT_PROFILE, this.reCheckInputTypeNode, INLINED_INDEX_NODE, INLINED_AS_SIZE_NODE, INLINED_LENGTH_NODE, this.libCompiledRegex, s0_.getFallbackMethodNode_, this.tRegexCallExec, INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE);
                                            }
                                            break;
                                        }
                                    }
                                }
                                {
                                    TRegexCache tRegexCache__1 = null;
                                    Node inliningTarget__1 = null;
                                    if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SREModuleBuiltins.TRegexSearch.doDynamic(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, TRegexCompile, PyNumberIndexNode, PyNumberAsSizeNode, RECheckInputTypeNode, PyObjectSizeNode, InlinedConditionProfile, InlinedConditionProfile, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */) {
                                        while (true) {
                                            int count1_ = 0;
                                            CachedRegexData s1_ = CACHED_REGEX_CACHE_UPDATER.getVolatile(this);
                                            CachedRegexData s1_original = s1_;
                                            while (s1_ != null) {
                                                {
                                                    TRegexCompile tRegexCompileNode_1 = this.tRegexCompileNode;
                                                    if (tRegexCompileNode_1 != null) {
                                                        RECheckInputTypeNode reCheckInputTypeNode_1 = this.reCheckInputTypeNode;
                                                        if (reCheckInputTypeNode_1 != null) {
                                                            InteropLibrary libCompiledRegex_1 = this.libCompiledRegex;
                                                            if (libCompiledRegex_1 != null) {
                                                                TRegexCallExec tRegexCallExec_1 = this.tRegexCallExec;
                                                                if (tRegexCallExec_1 != null) {
                                                                    if ((tRegexCompileNode_1.execute(frameValue, arg0Value_, arg4Value_, arg5Value_) == s1_.compiledRegex_) && (arg4Value_ == decodePythonMethod((s1_.cachedRegex_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)] */) - 1)) && (arg5Value_ == s1_.cachedMustAdvance_)) {
                                                                        tRegexCache__1 = (s1_.weakTRegexCacheGen__.get());
                                                                        if ((tRegexCache__1 != null) && (!(tRegexCache__1.isLocaleSensitive()))) {
                                                                            inliningTarget__1 = (this);
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                count1_++;
                                                s1_ = null;
                                                break;
                                            }
                                            if (s1_ == null && count1_ < 1) {
                                                {
                                                    TRegexCompile tRegexCompileNode_1;
                                                    TRegexCompile tRegexCompileNode_1_shared = this.tRegexCompileNode;
                                                    if (tRegexCompileNode_1_shared != null) {
                                                        tRegexCompileNode_1 = tRegexCompileNode_1_shared;
                                                    } else {
                                                        tRegexCompileNode_1 = this.insert((TRegexCompileFactory.create()));
                                                        if (tRegexCompileNode_1 == null) {
                                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                        }
                                                    }
                                                    Object compiledRegex__ = (tRegexCompileNode_1.execute(frameValue, arg0Value_, arg4Value_, arg5Value_));
                                                    if ((tRegexCompileNode_1.execute(frameValue, arg0Value_, arg4Value_, arg5Value_) == compiledRegex__)) {
                                                        TruffleWeakReference<TRegexCache> weakTRegexCacheGen___1 = (new TruffleWeakReference<>(getTRegexCache(arg0Value_)));
                                                        tRegexCache__1 = (weakTRegexCacheGen___1.get());
                                                        // assert (arg4Value_ == decodePythonMethod((s1_.cachedRegex_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)] */) - 1));
                                                        // assert (arg5Value_ == s1_.cachedMustAdvance_);
                                                        if ((tRegexCache__1 != null) && (!(tRegexCache__1.isLocaleSensitive()))) {
                                                            s1_ = this.insert(new CachedRegexData());
                                                            s1_.weakTRegexCacheGen__ = weakTRegexCacheGen___1;
                                                            inliningTarget__1 = (this);
                                                            s1_.cachedRegex_state_0_ = (s1_.cachedRegex_state_0_ | (((arg4Value_).ordinal() + 1) << 0) /* set-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)] */);
                                                            s1_.cachedMustAdvance_ = (arg5Value_);
                                                            if (this.tRegexCompileNode == null) {
                                                                this.tRegexCompileNode = tRegexCompileNode_1;
                                                            }
                                                            s1_.compiledRegex_ = compiledRegex__;
                                                            RECheckInputTypeNode reCheckInputTypeNode_1;
                                                            RECheckInputTypeNode reCheckInputTypeNode_1_shared = this.reCheckInputTypeNode;
                                                            if (reCheckInputTypeNode_1_shared != null) {
                                                                reCheckInputTypeNode_1 = reCheckInputTypeNode_1_shared;
                                                            } else {
                                                                reCheckInputTypeNode_1 = s1_.insert((RECheckInputTypeNodeGen.create()));
                                                                if (reCheckInputTypeNode_1 == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.reCheckInputTypeNode == null) {
                                                                this.reCheckInputTypeNode = reCheckInputTypeNode_1;
                                                            }
                                                            InteropLibrary libCompiledRegex_1;
                                                            InteropLibrary libCompiledRegex_1_shared = this.libCompiledRegex;
                                                            if (libCompiledRegex_1_shared != null) {
                                                                libCompiledRegex_1 = libCompiledRegex_1_shared;
                                                            } else {
                                                                libCompiledRegex_1 = s1_.insert((INTEROP_LIBRARY_.createDispatched(1)));
                                                                if (libCompiledRegex_1 == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.libCompiledRegex == null) {
                                                                this.libCompiledRegex = libCompiledRegex_1;
                                                            }
                                                            GetAttributeNode getFallbackMethodNode__1 = s1_.insert((GetAttributeNode.create(arg4Value_.getMethodName())));
                                                            Objects.requireNonNull(getFallbackMethodNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                            s1_.getFallbackMethodNode_ = getFallbackMethodNode__1;
                                                            TRegexCallExec tRegexCallExec_1;
                                                            TRegexCallExec tRegexCallExec_1_shared = this.tRegexCallExec;
                                                            if (tRegexCallExec_1_shared != null) {
                                                                tRegexCallExec_1 = tRegexCallExec_1_shared;
                                                            } else {
                                                                tRegexCallExec_1 = s1_.insert((TRegexCallExecFactory.create()));
                                                                if (tRegexCallExec_1 == null) {
                                                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                                }
                                                            }
                                                            if (this.tRegexCallExec == null) {
                                                                this.tRegexCallExec = tRegexCallExec_1;
                                                            }
                                                            if (!CACHED_REGEX_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                                                continue;
                                                            }
                                                            this.cached_cache = null;
                                                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SREModuleBuiltins.TRegexSearch.doCached(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonObject, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */;
                                                            state_0 = state_0 | 0b10 /* add SpecializationActive[SREModuleBuiltins.TRegexSearch.doCachedRegex(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */;
                                                            this.state_0_ = state_0;
                                                        }
                                                    }
                                                }
                                            }
                                            if (s1_ != null) {
                                                return doCachedRegex(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value_, inliningTarget__1, decodePythonMethod((s1_.cachedRegex_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)] */) - 1), s1_.cachedMustAdvance_, this.tRegexCompileNode, tRegexCache__1, s1_.compiledRegex_, INLINED_FALLBACK_PROFILE, INLINED_TRUNCATING_INPUT_PROFILE, this.reCheckInputTypeNode, INLINED_INDEX_NODE, INLINED_AS_SIZE_NODE, INLINED_LENGTH_NODE, this.libCompiledRegex, s1_.getFallbackMethodNode_, this.tRegexCallExec, INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE);
                                            }
                                            break;
                                        }
                                    }
                                }
                                {
                                    Node inliningTarget__2 = null;
                                    while (true) {
                                        int count2_ = 0;
                                        DynamicData s2_ = DYNAMIC_CACHE_UPDATER.getVolatile(this);
                                        DynamicData s2_original = s2_;
                                        while (s2_ != null) {
                                            {
                                                TRegexCompile tRegexCompileNode_2 = this.tRegexCompileNode;
                                                if (tRegexCompileNode_2 != null) {
                                                    RECheckInputTypeNode reCheckInputTypeNode_2 = this.reCheckInputTypeNode;
                                                    if (reCheckInputTypeNode_2 != null) {
                                                        InteropLibrary libCompiledRegex_2 = this.libCompiledRegex;
                                                        if (libCompiledRegex_2 != null) {
                                                            TRegexCallExec tRegexCallExec_2 = this.tRegexCallExec;
                                                            if (tRegexCallExec_2 != null) {
                                                                if ((arg4Value_ == decodePythonMethod((s2_.dynamic_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)] */) - 1))) {
                                                                    inliningTarget__2 = (this);
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            count2_++;
                                            s2_ = s2_.next_;
                                        }
                                        if (s2_ == null) {
                                            // assert (arg4Value_ == decodePythonMethod((s2_.dynamic_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)] */) - 1));
                                            if (count2_ < (PythonMethod.PYTHON_METHOD_COUNT)) {
                                                s2_ = this.insert(new DynamicData(s2_original));
                                                inliningTarget__2 = (this);
                                                s2_.dynamic_state_0_ = (s2_.dynamic_state_0_ | (((arg4Value_).ordinal() + 1) << 0) /* set-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)] */);
                                                TRegexCompile tRegexCompileNode_2;
                                                TRegexCompile tRegexCompileNode_2_shared = this.tRegexCompileNode;
                                                if (tRegexCompileNode_2_shared != null) {
                                                    tRegexCompileNode_2 = tRegexCompileNode_2_shared;
                                                } else {
                                                    tRegexCompileNode_2 = s2_.insert((TRegexCompileFactory.create()));
                                                    if (tRegexCompileNode_2 == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.tRegexCompileNode == null) {
                                                    this.tRegexCompileNode = tRegexCompileNode_2;
                                                }
                                                RECheckInputTypeNode reCheckInputTypeNode_2;
                                                RECheckInputTypeNode reCheckInputTypeNode_2_shared = this.reCheckInputTypeNode;
                                                if (reCheckInputTypeNode_2_shared != null) {
                                                    reCheckInputTypeNode_2 = reCheckInputTypeNode_2_shared;
                                                } else {
                                                    reCheckInputTypeNode_2 = s2_.insert((RECheckInputTypeNodeGen.create()));
                                                    if (reCheckInputTypeNode_2 == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.reCheckInputTypeNode == null) {
                                                    this.reCheckInputTypeNode = reCheckInputTypeNode_2;
                                                }
                                                InteropLibrary libCompiledRegex_2;
                                                InteropLibrary libCompiledRegex_2_shared = this.libCompiledRegex;
                                                if (libCompiledRegex_2_shared != null) {
                                                    libCompiledRegex_2 = libCompiledRegex_2_shared;
                                                } else {
                                                    libCompiledRegex_2 = s2_.insert((INTEROP_LIBRARY_.createDispatched(1)));
                                                    if (libCompiledRegex_2 == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.libCompiledRegex == null) {
                                                    this.libCompiledRegex = libCompiledRegex_2;
                                                }
                                                GetAttributeNode getFallbackMethodNode__2 = s2_.insert((GetAttributeNode.create(arg4Value_.getMethodName())));
                                                Objects.requireNonNull(getFallbackMethodNode__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                s2_.getFallbackMethodNode_ = getFallbackMethodNode__2;
                                                TRegexCallExec tRegexCallExec_2;
                                                TRegexCallExec tRegexCallExec_2_shared = this.tRegexCallExec;
                                                if (tRegexCallExec_2_shared != null) {
                                                    tRegexCallExec_2 = tRegexCallExec_2_shared;
                                                } else {
                                                    tRegexCallExec_2 = s2_.insert((TRegexCallExecFactory.create()));
                                                    if (tRegexCallExec_2 == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.tRegexCallExec == null) {
                                                    this.tRegexCallExec = tRegexCallExec_2;
                                                }
                                                if (!DYNAMIC_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                                    continue;
                                                }
                                                this.cached_cache = null;
                                                this.cachedRegex_cache = null;
                                                state_0 = state_0 & 0xfffffffc /* remove SpecializationActive[SREModuleBuiltins.TRegexSearch.doCached(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonObject, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)], SpecializationActive[SREModuleBuiltins.TRegexSearch.doCachedRegex(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, boolean, TRegexCompile, TRegexCache, Object, InlinedConditionProfile, InlinedConditionProfile, RECheckInputTypeNode, PyNumberIndexNode, PyNumberAsSizeNode, PyObjectSizeNode, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */;
                                                state_0 = state_0 | 0b100 /* add SpecializationActive[SREModuleBuiltins.TRegexSearch.doDynamic(VirtualFrame, PythonObject, Object, Object, Object, PythonMethod, boolean, Node, PythonMethod, TRegexCompile, PyNumberIndexNode, PyNumberAsSizeNode, RECheckInputTypeNode, PyObjectSizeNode, InlinedConditionProfile, InlinedConditionProfile, InteropLibrary, GetAttributeNode, TRegexCallExec, CreateMatchFromTRegexResultNode)] */;
                                                this.state_0_ = state_0;
                                            }
                                        }
                                        if (s2_ != null) {
                                            return doDynamic(frameValue, arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value_, inliningTarget__2, decodePythonMethod((s2_.dynamic_state_0_ >>> 0 /* get-int EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)] */) - 1), this.tRegexCompileNode, INLINED_INDEX_NODE, INLINED_AS_SIZE_NODE, this.reCheckInputTypeNode, INLINED_LENGTH_NODE, INLINED_FALLBACK_PROFILE, INLINED_TRUNCATING_INPUT_PROFILE, this.libCompiledRegex, s2_.getFallbackMethodNode_, this.tRegexCallExec, INLINED_CREATE_MATCH_FROM_TREGEX_RESULT_NODE);
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                } finally {
                    if (oldState_0 != 0) {
                        checkForPolymorphicSpecialize(oldState_0);
                    }
                }
            }

            private void checkForPolymorphicSpecialize(int oldState_0) {
                if (((oldState_0 & 0b100) == 0 && (state_0_ & 0b100) != 0)) {
                    this.reportPolymorphicSpecialize();
                }
            }

            @GeneratedBy(TRegexSearch.class)
            @DenyReplace
            private static final class CachedData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCached(..., PythonMethod cachedMethod, ...)]
                 * </pre> */
                @CompilationFinal private int cached_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCached}
                 *   Parameter: {@link TruffleWeakReference} weakTRegexCacheGen_</pre> */
                @CompilationFinal TruffleWeakReference<TRegexCache> weakTRegexCacheGen__;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCached}
                 *   Parameter: {@link TruffleWeakReference} weakCachedPatternGen_</pre> */
                @CompilationFinal TruffleWeakReference<PythonObject> weakCachedPatternGen__;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCached}
                 *   Parameter: boolean cachedMustAdvance</pre> */
                @CompilationFinal boolean cachedMustAdvance_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCached}
                 *   Parameter: {@link Object} compiledRegex</pre> */
                @CompilationFinal Object compiledRegex_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCached}
                 *   Parameter: {@link GetAttributeNode} getFallbackMethodNode</pre> */
                @Child GetAttributeNode getFallbackMethodNode_;

                CachedData() {
                }

            }
            @GeneratedBy(TRegexSearch.class)
            @DenyReplace
            private static final class CachedRegexData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doCachedRegex(..., PythonMethod cachedMethod, ...)]
                 * </pre> */
                @CompilationFinal private int cachedRegex_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCachedRegex}
                 *   Parameter: {@link TruffleWeakReference} weakTRegexCacheGen_</pre> */
                @CompilationFinal TruffleWeakReference<TRegexCache> weakTRegexCacheGen__;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCachedRegex}
                 *   Parameter: boolean cachedMustAdvance</pre> */
                @CompilationFinal boolean cachedMustAdvance_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCachedRegex}
                 *   Parameter: {@link Object} compiledRegex</pre> */
                @CompilationFinal Object compiledRegex_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doCachedRegex}
                 *   Parameter: {@link GetAttributeNode} getFallbackMethodNode</pre> */
                @Child GetAttributeNode getFallbackMethodNode_;

                CachedRegexData() {
                }

            }
            @GeneratedBy(TRegexSearch.class)
            @DenyReplace
            private static final class DynamicData extends Node implements SpecializationDataNode {

                @Child DynamicData next_;
                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=SREModuleBuiltins.TRegexSearch.doDynamic(..., PythonMethod cachedMethod, ...)]
                 * </pre> */
                @CompilationFinal private int dynamic_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexSearch#doDynamic}
                 *   Parameter: {@link GetAttributeNode} getFallbackMethodNode</pre> */
                @Child GetAttributeNode getFallbackMethodNode_;

                DynamicData(DynamicData next_) {
                    this.next_ = next_;
                }

            }
        }
    }
    @GeneratedBy(TRegexCallExec.class)
    static final class TRegexCallExecFactory implements NodeFactory<TRegexCallExec> {

        private static final TRegexCallExecFactory TREGEX_CALL_EXEC_FACTORY_INSTANCE = new TRegexCallExecFactory();

        private TRegexCallExecFactory() {
        }

        @Override
        public Class<TRegexCallExec> getNodeClass() {
            return TRegexCallExec.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TRegexCallExec createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TRegexCallExec> getInstance() {
            return TREGEX_CALL_EXEC_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TRegexCallExec create() {
            return new TRegexCallExecNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TRegexCallExec#doCached}
         *     Activation probability: 0.48333
         *     With/without class size: 17/8 bytes
         *   Specialization {@link TRegexCallExec#doUncached}
         *     Activation probability: 0.33333
         *     With/without class size: 10/4 bytes
         *   Specialization {@link TRegexCallExec#doUncached}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(TRegexCallExec.class)
        @SuppressWarnings("javadoc")
        static final class TRegexCallExecNodeGen extends TRegexCallExec {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
            static final ReferenceField<Uncached0Data> UNCACHED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "uncached0_cache", Uncached0Data.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}</pre> */
            private static final CastToTruffleStringNode INLINED_CAST = CastToTruffleStringNodeGen.inline(InlineTarget.create(CastToTruffleStringNode.class, STATE_0_UPDATER.subUpdater(3, 8), ReferenceField.create(MethodHandles.lookup(), "cast_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "cast_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "cast_field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link InlinedBranchProfile} binaryProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_BINARY_PROFILE = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(11, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TRegexCallExec#doCached}
             *   1: SpecializationActive {@link TRegexCallExec#doUncached}
             *   2: SpecializationActive {@link TRegexCallExec#doUncached}
             *   3-10: InlinedCache
             *        Specialization: {@link TRegexCallExec#doCached}
             *        Parameter: {@link CastToTruffleStringNode} cast
             *        Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   11: InlinedCache
             *        Specialization: {@link TRegexCallExec#doCached}
             *        Parameter: {@link InlinedBranchProfile} binaryProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
            @CompilationFinal private IndirectCallData indirectCallData;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cast_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cast_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cast_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link PythonBufferAcquireLibrary} bufferAcquireLib</pre> */
            @Child private PythonBufferAcquireLibrary bufferAcquireLib;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TRegexCallExec#doCached}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
            @Child private PythonBufferAccessLibrary bufferLib;
            @UnsafeAccessedField @Child private CachedData cached_cache;
            @UnsafeAccessedField @Child private Uncached0Data uncached0_cache;

            private TRegexCallExecNodeGen() {
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCallExec.doCached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, Object, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] || SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] || SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */ && arg2Value instanceof Number) {
                    Number arg2Value_ = (Number) arg2Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCallExec.doCached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, Object, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        CachedData s0_ = this.cached_cache;
                        while (s0_ != null) {
                            {
                                IndirectCallData indirectCallData_ = this.indirectCallData;
                                if (indirectCallData_ != null) {
                                    PythonBufferAcquireLibrary bufferAcquireLib_ = this.bufferAcquireLib;
                                    if (bufferAcquireLib_ != null) {
                                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                                        if (bufferLib_ != null) {
                                            if ((s0_.interop_.accepts(arg0Value))) {
                                                Object cachedCallable__ = (s0_.weakCachedCallableGen__.get());
                                                if ((cachedCallable__ != null) && (arg0Value == cachedCallable__)) {
                                                    Node inliningTarget__ = (this);
                                                    return doCached(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__, indirectCallData_, cachedCallable__, INLINED_CAST, bufferAcquireLib_, bufferLib_, s0_.interop_, INLINED_BINARY_PROFILE);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        Uncached0Data s1_ = this.uncached0_cache;
                        if (s1_ != null) {
                            {
                                IndirectCallData indirectCallData_1 = this.indirectCallData;
                                if (indirectCallData_1 != null) {
                                    PythonBufferAcquireLibrary bufferAcquireLib_1 = this.bufferAcquireLib;
                                    if (bufferAcquireLib_1 != null) {
                                        PythonBufferAccessLibrary bufferLib_1 = this.bufferLib;
                                        if (bufferLib_1 != null) {
                                            if ((s1_.interop_.accepts(arg0Value))) {
                                                Node inliningTarget__1 = (this);
                                                return doUncached(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__1, indirectCallData_1, INLINED_CAST, bufferAcquireLib_1, bufferLib_1, s1_.interop_, INLINED_BINARY_PROFILE);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            IndirectCallData indirectCallData_1 = this.indirectCallData;
                            if (indirectCallData_1 != null) {
                                PythonBufferAcquireLibrary bufferAcquireLib_1 = this.bufferAcquireLib;
                                if (bufferAcquireLib_1 != null) {
                                    PythonBufferAccessLibrary bufferLib_1 = this.bufferLib;
                                    if (bufferLib_1 != null) {
                                        return this.uncached1Boundary(state_0, frameValue.materialize(), arg0Value, arg1Value, arg2Value_, indirectCallData_1, bufferAcquireLib_1, bufferLib_1);
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object uncached1Boundary(int state_0, MaterializedFrame frameValue, Object arg0Value, Object arg1Value, Number arg2Value_, IndirectCallData indirectCallData_1, PythonBufferAcquireLibrary bufferAcquireLib_1, PythonBufferAccessLibrary bufferLib_1) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__1 = (this);
                        InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                        return doUncached(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__1, indirectCallData_1, INLINED_CAST, bufferAcquireLib_1, bufferLib_1, interop__, INLINED_BINARY_PROFILE);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                int oldState_0 = (state_0 & 0b111);
                try {
                    if (arg2Value instanceof Number) {
                        Number arg2Value_ = (Number) arg2Value;
                        {
                            Object cachedCallable__ = null;
                            Node inliningTarget__ = null;
                            if (((state_0 & 0b110)) == 0 /* is-not SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] && SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                                while (true) {
                                    int count0_ = 0;
                                    CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                                    CachedData s0_original = s0_;
                                    while (s0_ != null) {
                                        {
                                            IndirectCallData indirectCallData_ = this.indirectCallData;
                                            if (indirectCallData_ != null) {
                                                PythonBufferAcquireLibrary bufferAcquireLib_ = this.bufferAcquireLib;
                                                if (bufferAcquireLib_ != null) {
                                                    PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                                                    if (bufferLib_ != null) {
                                                        if ((s0_.interop_.accepts(arg0Value))) {
                                                            cachedCallable__ = (s0_.weakCachedCallableGen__.get());
                                                            if ((cachedCallable__ != null) && (arg0Value == cachedCallable__)) {
                                                                inliningTarget__ = (this);
                                                                break;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        count0_++;
                                        s0_ = s0_.next_;
                                    }
                                    if (s0_ == null) {
                                        {
                                            TruffleWeakReference<Object> weakCachedCallableGen___ = (new TruffleWeakReference<>(arg0Value));
                                            cachedCallable__ = (weakCachedCallableGen___.get());
                                            // assert (s0_.interop_.accepts(arg0Value));
                                            if ((cachedCallable__ != null) && (arg0Value == cachedCallable__) && count0_ < (2)) {
                                                s0_ = this.insert(new CachedData(s0_original));
                                                s0_.weakCachedCallableGen__ = weakCachedCallableGen___;
                                                inliningTarget__ = (this);
                                                IndirectCallData indirectCallData_;
                                                IndirectCallData indirectCallData__shared = this.indirectCallData;
                                                if (indirectCallData__shared != null) {
                                                    indirectCallData_ = indirectCallData__shared;
                                                } else {
                                                    indirectCallData_ = (IndirectCallData.createFor(this));
                                                    if (indirectCallData_ == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.indirectCallData == null) {
                                                    this.indirectCallData = indirectCallData_;
                                                }
                                                PythonBufferAcquireLibrary bufferAcquireLib_;
                                                PythonBufferAcquireLibrary bufferAcquireLib__shared = this.bufferAcquireLib;
                                                if (bufferAcquireLib__shared != null) {
                                                    bufferAcquireLib_ = bufferAcquireLib__shared;
                                                } else {
                                                    bufferAcquireLib_ = s0_.insert((PYTHON_BUFFER_ACQUIRE_LIBRARY_.createDispatched(3)));
                                                    if (bufferAcquireLib_ == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.bufferAcquireLib == null) {
                                                    this.bufferAcquireLib = bufferAcquireLib_;
                                                }
                                                PythonBufferAccessLibrary bufferLib_;
                                                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                                                if (bufferLib__shared != null) {
                                                    bufferLib_ = bufferLib__shared;
                                                } else {
                                                    bufferLib_ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                                                    if (bufferLib_ == null) {
                                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                                    }
                                                }
                                                if (this.bufferLib == null) {
                                                    this.bufferLib = bufferLib_;
                                                }
                                                InteropLibrary interop__1 = s0_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                                                Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                s0_.interop_ = interop__1;
                                                if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                    continue;
                                                }
                                                state_0 = state_0 | 0b1 /* add SpecializationActive[SREModuleBuiltins.TRegexCallExec.doCached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, Object, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */;
                                                this.state_0_ = state_0;
                                            }
                                        }
                                    }
                                    if (s0_ != null) {
                                        return doCached(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__, this.indirectCallData, cachedCallable__, INLINED_CAST, this.bufferAcquireLib, this.bufferLib, s0_.interop_, INLINED_BINARY_PROFILE);
                                    }
                                    break;
                                }
                            }
                        }
                        {
                            Node inliningTarget__1 = null;
                            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                                while (true) {
                                    int count1_ = 0;
                                    Uncached0Data s1_ = UNCACHED0_CACHE_UPDATER.getVolatile(this);
                                    Uncached0Data s1_original = s1_;
                                    while (s1_ != null) {
                                        {
                                            IndirectCallData indirectCallData_1 = this.indirectCallData;
                                            if (indirectCallData_1 != null) {
                                                PythonBufferAcquireLibrary bufferAcquireLib_1 = this.bufferAcquireLib;
                                                if (bufferAcquireLib_1 != null) {
                                                    PythonBufferAccessLibrary bufferLib_1 = this.bufferLib;
                                                    if (bufferLib_1 != null) {
                                                        if ((s1_.interop_.accepts(arg0Value))) {
                                                            inliningTarget__1 = (this);
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        count1_++;
                                        s1_ = null;
                                        break;
                                    }
                                    if (s1_ == null && count1_ < 1) {
                                        // assert (s1_.interop_.accepts(arg0Value));
                                        s1_ = this.insert(new Uncached0Data());
                                        inliningTarget__1 = (this);
                                        IndirectCallData indirectCallData_1;
                                        IndirectCallData indirectCallData_1_shared = this.indirectCallData;
                                        if (indirectCallData_1_shared != null) {
                                            indirectCallData_1 = indirectCallData_1_shared;
                                        } else {
                                            indirectCallData_1 = (IndirectCallData.createFor(this));
                                            if (indirectCallData_1 == null) {
                                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                            }
                                        }
                                        if (this.indirectCallData == null) {
                                            this.indirectCallData = indirectCallData_1;
                                        }
                                        PythonBufferAcquireLibrary bufferAcquireLib_1;
                                        PythonBufferAcquireLibrary bufferAcquireLib_1_shared = this.bufferAcquireLib;
                                        if (bufferAcquireLib_1_shared != null) {
                                            bufferAcquireLib_1 = bufferAcquireLib_1_shared;
                                        } else {
                                            bufferAcquireLib_1 = s1_.insert((PYTHON_BUFFER_ACQUIRE_LIBRARY_.createDispatched(3)));
                                            if (bufferAcquireLib_1 == null) {
                                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                            }
                                        }
                                        if (this.bufferAcquireLib == null) {
                                            this.bufferAcquireLib = bufferAcquireLib_1;
                                        }
                                        PythonBufferAccessLibrary bufferLib_1;
                                        PythonBufferAccessLibrary bufferLib_1_shared = this.bufferLib;
                                        if (bufferLib_1_shared != null) {
                                            bufferLib_1 = bufferLib_1_shared;
                                        } else {
                                            bufferLib_1 = s1_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                                            if (bufferLib_1 == null) {
                                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                            }
                                        }
                                        if (this.bufferLib == null) {
                                            this.bufferLib = bufferLib_1;
                                        }
                                        InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                                        Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s1_.interop_ = interop__;
                                        if (!UNCACHED0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        this.cached_cache = null;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SREModuleBuiltins.TRegexCallExec.doCached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, Object, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                    if (s1_ != null) {
                                        return doUncached(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__1, this.indirectCallData, INLINED_CAST, this.bufferAcquireLib, this.bufferLib, s1_.interop_, INLINED_BINARY_PROFILE);
                                    }
                                    break;
                                }
                            }
                        }
                        {
                            InteropLibrary interop__ = null;
                            Node inliningTarget__1 = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    inliningTarget__1 = (this);
                                    IndirectCallData indirectCallData_1;
                                    IndirectCallData indirectCallData_1_shared = this.indirectCallData;
                                    if (indirectCallData_1_shared != null) {
                                        indirectCallData_1 = indirectCallData_1_shared;
                                    } else {
                                        indirectCallData_1 = (IndirectCallData.createFor(this));
                                        if (indirectCallData_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.indirectCallData == null) {
                                        VarHandle.storeStoreFence();
                                        this.indirectCallData = indirectCallData_1;
                                    }
                                    PythonBufferAcquireLibrary bufferAcquireLib_1;
                                    PythonBufferAcquireLibrary bufferAcquireLib_1_shared = this.bufferAcquireLib;
                                    if (bufferAcquireLib_1_shared != null) {
                                        bufferAcquireLib_1 = bufferAcquireLib_1_shared;
                                    } else {
                                        bufferAcquireLib_1 = this.insert((PYTHON_BUFFER_ACQUIRE_LIBRARY_.createDispatched(3)));
                                        if (bufferAcquireLib_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.bufferAcquireLib == null) {
                                        VarHandle.storeStoreFence();
                                        this.bufferAcquireLib = bufferAcquireLib_1;
                                    }
                                    PythonBufferAccessLibrary bufferLib_1;
                                    PythonBufferAccessLibrary bufferLib_1_shared = this.bufferLib;
                                    if (bufferLib_1_shared != null) {
                                        bufferLib_1 = bufferLib_1_shared;
                                    } else {
                                        bufferLib_1 = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                                        if (bufferLib_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.bufferLib == null) {
                                        VarHandle.storeStoreFence();
                                        this.bufferLib = bufferLib_1;
                                    }
                                    interop__ = (INTEROP_LIBRARY_.getUncached());
                                    this.cached_cache = null;
                                    this.uncached0_cache = null;
                                    state_0 = state_0 & 0xfffffffc /* remove SpecializationActive[SREModuleBuiltins.TRegexCallExec.doCached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, Object, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)], SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SREModuleBuiltins.TRegexCallExec.doUncached(VirtualFrame, Object, Object, Number, Node, IndirectCallData, CastToTruffleStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, InteropLibrary, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return doUncached(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__1, indirectCallData_1, INLINED_CAST, bufferAcquireLib_1, bufferLib_1, interop__, INLINED_BINARY_PROFILE);
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                    throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
                } finally {
                    if (oldState_0 != 0) {
                        checkForPolymorphicSpecialize(oldState_0);
                    }
                }
            }

            private void checkForPolymorphicSpecialize(int oldState_0) {
                if (((oldState_0 & 0b110) == 0 && (state_0_ & 0b110) != 0)) {
                    this.reportPolymorphicSpecialize();
                }
            }

            @GeneratedBy(TRegexCallExec.class)
            @DenyReplace
            private static final class CachedData extends Node implements SpecializationDataNode {

                @Child CachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCallExec#doCached}
                 *   Parameter: {@link TruffleWeakReference} weakCachedCallableGen_</pre> */
                @CompilationFinal TruffleWeakReference<Object> weakCachedCallableGen__;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCallExec#doCached}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(TRegexCallExec.class)
            @DenyReplace
            private static final class Uncached0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TRegexCallExec#doUncached}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Uncached0Data() {
                }

            }
        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link BufferToTruffleStringNode#convert}
         *     Activation probability: 0.65000
         *     With/without class size: 27/13 bytes
         *   Specialization {@link BufferToTruffleStringNode#convert}
         *     Activation probability: 0.35000
         *     With/without class size: 13/9 bytes
         * </pre> */
        @GeneratedBy(BufferToTruffleStringNode.class)
        @SuppressWarnings("javadoc")
        static final class BufferToTruffleStringNodeGen extends BufferToTruffleStringNode {

            private static final StateField CONVERT0_BUFFER_TO_TRUFFLE_STRING_NODE_CONVERT0_STATE_0_UPDATER = StateField.create(Convert0Data.lookup_(), "convert0_state_0_");
            private static final StateField STATE_0_BufferToTruffleStringNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            static final ReferenceField<Convert0Data> CONVERT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "convert0_cache", Convert0Data.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link InlinedBranchProfile} internalArrayProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CONVERT0_INTERNAL_ARRAY_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, CONVERT0_BUFFER_TO_TRUFFLE_STRING_NODE_CONVERT0_STATE_0_UPDATER.subUpdater(0, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link InlinedBranchProfile} nativeProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CONVERT0_NATIVE_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, CONVERT0_BUFFER_TO_TRUFFLE_STRING_NODE_CONVERT0_STATE_0_UPDATER.subUpdater(1, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link InlinedBranchProfile} fallbackProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CONVERT0_FALLBACK_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, CONVERT0_BUFFER_TO_TRUFFLE_STRING_NODE_CONVERT0_STATE_0_UPDATER.subUpdater(2, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link InlinedBranchProfile} internalArrayProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CONVERT1_INTERNAL_ARRAY_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_BufferToTruffleStringNode_UPDATER.subUpdater(2, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link InlinedBranchProfile} nativeProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CONVERT1_NATIVE_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_BufferToTruffleStringNode_UPDATER.subUpdater(3, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link InlinedBranchProfile} fallbackProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CONVERT1_FALLBACK_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_BufferToTruffleStringNode_UPDATER.subUpdater(4, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BufferToTruffleStringNode#convert}
             *   1: SpecializationActive {@link BufferToTruffleStringNode#convert}
             *   2: InlinedCache
             *        Specialization: {@link BufferToTruffleStringNode#convert}
             *        Parameter: {@link InlinedBranchProfile} internalArrayProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   3: InlinedCache
             *        Specialization: {@link BufferToTruffleStringNode#convert}
             *        Parameter: {@link InlinedBranchProfile} nativeProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   4: InlinedCache
             *        Specialization: {@link BufferToTruffleStringNode#convert}
             *        Parameter: {@link InlinedBranchProfile} fallbackProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private Convert0Data convert0_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link FromByteArrayNode} fromByteArrayNode</pre> */
            @Child private FromByteArrayNode convert1_fromByteArrayNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferToTruffleStringNode#convert}
             *   Parameter: {@link FromNativePointerNode} fromNativePointerNode</pre> */
            @Child private FromNativePointerNode convert1_fromNativePointerNode_;

            private BufferToTruffleStringNodeGen() {
            }

            @ExplodeLoop
            @Override
            public TruffleString execute(Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */) {
                        Convert0Data s0_ = this.convert0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                Node inliningTarget__ = (s0_);
                                return BufferToTruffleStringNode.convert(arg0Value, inliningTarget__, s0_.bufferLib_, s0_.fromByteArrayNode_, s0_.fromNativePointerNode_, INLINED_CONVERT0_INTERNAL_ARRAY_PROFILE_, INLINED_CONVERT0_NATIVE_PROFILE_, INLINED_CONVERT0_FALLBACK_PROFILE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */) {
                        {
                            FromByteArrayNode fromByteArrayNode__ = this.convert1_fromByteArrayNode_;
                            if (fromByteArrayNode__ != null) {
                                FromNativePointerNode fromNativePointerNode__ = this.convert1_fromNativePointerNode_;
                                if (fromNativePointerNode__ != null) {
                                    return this.convert1Boundary(state_0, arg0Value, fromByteArrayNode__, fromNativePointerNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private TruffleString convert1Boundary(int state_0, Object arg0Value, FromByteArrayNode fromByteArrayNode__, FromNativePointerNode fromNativePointerNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached(arg0Value));
                        return BufferToTruffleStringNode.convert(arg0Value, inliningTarget__, bufferLib__, fromByteArrayNode__, fromNativePointerNode__, INLINED_CONVERT1_INTERNAL_ARRAY_PROFILE_, INLINED_CONVERT1_NATIVE_PROFILE_, INLINED_CONVERT1_FALLBACK_PROFILE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */) {
                        while (true) {
                            int count0_ = 0;
                            Convert0Data s0_ = CONVERT0_CACHE_UPDATER.getVolatile(this);
                            Convert0Data s0_original = s0_;
                            while (s0_ != null) {
                                if ((s0_.bufferLib_.accepts(arg0Value))) {
                                    inliningTarget__ = (s0_);
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (s0_.bufferLib_.accepts(arg0Value));
                                if (count0_ < (4)) {
                                    s0_ = this.insert(new Convert0Data(s0_original));
                                    inliningTarget__ = (s0_);
                                    PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                    Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.bufferLib_ = bufferLib__;
                                    FromByteArrayNode fromByteArrayNode__ = s0_.insert((FromByteArrayNode.create()));
                                    Objects.requireNonNull(fromByteArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.fromByteArrayNode_ = fromByteArrayNode__;
                                    FromNativePointerNode fromNativePointerNode__ = s0_.insert((FromNativePointerNode.create()));
                                    Objects.requireNonNull(fromNativePointerNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.fromNativePointerNode_ = fromNativePointerNode__;
                                    if (!CONVERT0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s0_ != null) {
                                return BufferToTruffleStringNode.convert(arg0Value, inliningTarget__, s0_.bufferLib_, s0_.fromByteArrayNode_, s0_.fromNativePointerNode_, INLINED_CONVERT0_INTERNAL_ARRAY_PROFILE_, INLINED_CONVERT0_NATIVE_PROFILE_, INLINED_CONVERT0_FALLBACK_PROFILE_);
                            }
                            break;
                        }
                    }
                }
                {
                    PythonBufferAccessLibrary bufferLib__ = null;
                    Node inliningTarget__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            inliningTarget__ = (this);
                            bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached(arg0Value));
                            FromByteArrayNode fromByteArrayNode__ = this.insert((FromByteArrayNode.create()));
                            Objects.requireNonNull(fromByteArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.convert1_fromByteArrayNode_ = fromByteArrayNode__;
                            FromNativePointerNode fromNativePointerNode__ = this.insert((FromNativePointerNode.create()));
                            Objects.requireNonNull(fromNativePointerNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.convert1_fromNativePointerNode_ = fromNativePointerNode__;
                            this.convert0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[TRegexCallExec.BufferToTruffleStringNode.convert(Object, Node, PythonBufferAccessLibrary, FromByteArrayNode, FromNativePointerNode, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return BufferToTruffleStringNode.convert(arg0Value, inliningTarget__, bufferLib__, fromByteArrayNode__, fromNativePointerNode__, INLINED_CONVERT1_INTERNAL_ARRAY_PROFILE_, INLINED_CONVERT1_NATIVE_PROFILE_, INLINED_CONVERT1_FALLBACK_PROFILE_);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @NeverDefault
            public static BufferToTruffleStringNode create() {
                return new BufferToTruffleStringNodeGen();
            }

            @GeneratedBy(BufferToTruffleStringNode.class)
            @DenyReplace
            private static final class Convert0Data extends Node implements SpecializationDataNode {

                @Child Convert0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link BufferToTruffleStringNode#convert}
                 *        Parameter: {@link InlinedBranchProfile} internalArrayProfile
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   1: InlinedCache
                 *        Specialization: {@link BufferToTruffleStringNode#convert}
                 *        Parameter: {@link InlinedBranchProfile} nativeProfile
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   2: InlinedCache
                 *        Specialization: {@link BufferToTruffleStringNode#convert}
                 *        Parameter: {@link InlinedBranchProfile} fallbackProfile
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int convert0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link BufferToTruffleStringNode#convert}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
                @Child PythonBufferAccessLibrary bufferLib_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link BufferToTruffleStringNode#convert}
                 *   Parameter: {@link FromByteArrayNode} fromByteArrayNode</pre> */
                @Child FromByteArrayNode fromByteArrayNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link BufferToTruffleStringNode#convert}
                 *   Parameter: {@link FromNativePointerNode} fromNativePointerNode</pre> */
                @Child FromNativePointerNode fromNativePointerNode_;

                Convert0Data(Convert0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
}
