// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PythonBufferAccessLibrary.class)
final class PythonBufferAccessLibraryGen extends LibraryFactory<PythonBufferAccessLibrary> {

    private static final Class<PythonBufferAccessLibrary> LIBRARY_CLASS = PythonBufferAccessLibraryGen.lazyLibraryClass();
    private static final Message IS_BUFFER = new MessageImpl("isBuffer", 0, false, boolean.class, Object.class);
    private static final Message RELEASE = new MessageImpl("release", 1, false, void.class, Object.class);
    private static final Message GET_BUFFER_LENGTH = new MessageImpl("getBufferLength", 2, false, int.class, Object.class);
    private static final Message IS_READONLY = new MessageImpl("isReadonly", 3, false, boolean.class, Object.class);
    private static final Message HAS_INTERNAL_BYTE_ARRAY = new MessageImpl("hasInternalByteArray", 4, false, boolean.class, Object.class);
    private static final Message GET_INTERNAL_BYTE_ARRAY = new MessageImpl("getInternalByteArray", 5, false, byte[].class, Object.class);
    private static final Message READ_INTO_BYTE_ARRAY = new MessageImpl("readIntoByteArray", 6, false, void.class, Object.class, int.class, byte[].class, int.class, int.class);
    private static final Message WRITE_FROM_BYTE_ARRAY = new MessageImpl("writeFromByteArray", 7, false, void.class, Object.class, int.class, byte[].class, int.class, int.class);
    private static final Message READ_INTO_BUFFER = new MessageImpl("readIntoBuffer", 8, false, void.class, Object.class, int.class, Object.class, int.class, int.class, PythonBufferAccessLibrary.class);
    private static final Message READ_BYTE = new MessageImpl("readByte", 9, false, byte.class, Object.class, int.class);
    private static final Message READ_SHORT = new MessageImpl("readShort", 10, false, short.class, Object.class, int.class);
    private static final Message READ_SHORT_BYTE_ORDER = new MessageImpl("readShortByteOrder", 11, false, short.class, Object.class, int.class, ByteOrder.class);
    private static final Message READ_INT = new MessageImpl("readInt", 12, false, int.class, Object.class, int.class);
    private static final Message READ_INT_BYTE_ORDER = new MessageImpl("readIntByteOrder", 13, false, int.class, Object.class, int.class, ByteOrder.class);
    private static final Message READ_LONG = new MessageImpl("readLong", 14, false, long.class, Object.class, int.class);
    private static final Message READ_LONG_BYTE_ORDER = new MessageImpl("readLongByteOrder", 15, false, long.class, Object.class, int.class, ByteOrder.class);
    private static final Message READ_FLOAT = new MessageImpl("readFloat", 16, false, float.class, Object.class, int.class);
    private static final Message READ_FLOAT_BYTE_ORDER = new MessageImpl("readFloatByteOrder", 17, false, float.class, Object.class, int.class, ByteOrder.class);
    private static final Message READ_DOUBLE = new MessageImpl("readDouble", 18, false, double.class, Object.class, int.class);
    private static final Message READ_DOUBLE_BYTE_ORDER = new MessageImpl("readDoubleByteOrder", 19, false, double.class, Object.class, int.class, ByteOrder.class);
    private static final Message WRITE_BYTE = new MessageImpl("writeByte", 20, false, void.class, Object.class, int.class, byte.class);
    private static final Message WRITE_SHORT = new MessageImpl("writeShort", 21, false, void.class, Object.class, int.class, short.class);
    private static final Message WRITE_SHORT_BYTE_ORDER = new MessageImpl("writeShortByteOrder", 22, false, void.class, Object.class, int.class, short.class, ByteOrder.class);
    private static final Message WRITE_INT = new MessageImpl("writeInt", 23, false, void.class, Object.class, int.class, int.class);
    private static final Message WRITE_INT_BYTE_ORDER = new MessageImpl("writeIntByteOrder", 24, false, void.class, Object.class, int.class, int.class, ByteOrder.class);
    private static final Message WRITE_LONG = new MessageImpl("writeLong", 25, false, void.class, Object.class, int.class, long.class);
    private static final Message WRITE_LONG_BYTE_ORDER = new MessageImpl("writeLongByteOrder", 26, false, void.class, Object.class, int.class, long.class, ByteOrder.class);
    private static final Message WRITE_FLOAT = new MessageImpl("writeFloat", 27, false, void.class, Object.class, int.class, float.class);
    private static final Message WRITE_FLOAT_BYTE_ORDER = new MessageImpl("writeFloatByteOrder", 28, false, void.class, Object.class, int.class, float.class, ByteOrder.class);
    private static final Message WRITE_DOUBLE = new MessageImpl("writeDouble", 29, false, void.class, Object.class, int.class, double.class);
    private static final Message WRITE_DOUBLE_BYTE_ORDER = new MessageImpl("writeDoubleByteOrder", 30, false, void.class, Object.class, int.class, double.class, ByteOrder.class);
    private static final Message GET_OWNER = new MessageImpl("getOwner", 31, false, Object.class, Object.class);
    private static final Message GET_ITEM_SIZE = new MessageImpl("getItemSize", 32, false, int.class, Object.class);
    private static final Message GET_FORMAT_STRING = new MessageImpl("getFormatString", 33, false, TruffleString.class, Object.class);
    private static final Message IS_NATIVE = new MessageImpl("isNative", 34, false, boolean.class, Object.class);
    private static final Message GET_NATIVE_POINTER = new MessageImpl("getNativePointer", 35, false, Object.class, Object.class);
    private static final PythonBufferAccessLibraryGen INSTANCE = new PythonBufferAccessLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(PythonBufferAccessLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(PythonBufferAccessLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private PythonBufferAccessLibraryGen() {
        super(PythonBufferAccessLibraryGen.LIBRARY_CLASS, List.of(PythonBufferAccessLibraryGen.IS_BUFFER, PythonBufferAccessLibraryGen.RELEASE, PythonBufferAccessLibraryGen.GET_BUFFER_LENGTH, PythonBufferAccessLibraryGen.IS_READONLY, PythonBufferAccessLibraryGen.HAS_INTERNAL_BYTE_ARRAY, PythonBufferAccessLibraryGen.GET_INTERNAL_BYTE_ARRAY, PythonBufferAccessLibraryGen.READ_INTO_BYTE_ARRAY, PythonBufferAccessLibraryGen.WRITE_FROM_BYTE_ARRAY, PythonBufferAccessLibraryGen.READ_INTO_BUFFER, PythonBufferAccessLibraryGen.READ_BYTE, PythonBufferAccessLibraryGen.READ_SHORT, PythonBufferAccessLibraryGen.READ_SHORT_BYTE_ORDER, PythonBufferAccessLibraryGen.READ_INT, PythonBufferAccessLibraryGen.READ_INT_BYTE_ORDER, PythonBufferAccessLibraryGen.READ_LONG, PythonBufferAccessLibraryGen.READ_LONG_BYTE_ORDER, PythonBufferAccessLibraryGen.READ_FLOAT, PythonBufferAccessLibraryGen.READ_FLOAT_BYTE_ORDER, PythonBufferAccessLibraryGen.READ_DOUBLE, PythonBufferAccessLibraryGen.READ_DOUBLE_BYTE_ORDER, PythonBufferAccessLibraryGen.WRITE_BYTE, PythonBufferAccessLibraryGen.WRITE_SHORT, PythonBufferAccessLibraryGen.WRITE_SHORT_BYTE_ORDER, PythonBufferAccessLibraryGen.WRITE_INT, PythonBufferAccessLibraryGen.WRITE_INT_BYTE_ORDER, PythonBufferAccessLibraryGen.WRITE_LONG, PythonBufferAccessLibraryGen.WRITE_LONG_BYTE_ORDER, PythonBufferAccessLibraryGen.WRITE_FLOAT, PythonBufferAccessLibraryGen.WRITE_FLOAT_BYTE_ORDER, PythonBufferAccessLibraryGen.WRITE_DOUBLE, PythonBufferAccessLibraryGen.WRITE_DOUBLE_BYTE_ORDER, PythonBufferAccessLibraryGen.GET_OWNER, PythonBufferAccessLibraryGen.GET_ITEM_SIZE, PythonBufferAccessLibraryGen.GET_FORMAT_STRING, PythonBufferAccessLibraryGen.IS_NATIVE, PythonBufferAccessLibraryGen.GET_NATIVE_POINTER));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return PythonBufferAccessLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected PythonBufferAccessLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected PythonBufferAccessLibrary createDelegate(PythonBufferAccessLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PythonBufferAccessLibrary lib = (PythonBufferAccessLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isBuffer(receiver);
            case 1 :
                lib.release(receiver);
                return null;
            case 2 :
                return lib.getBufferLength(receiver);
            case 3 :
                return lib.isReadonly(receiver);
            case 4 :
                return lib.hasInternalByteArray(receiver);
            case 5 :
                return lib.getInternalByteArray(receiver);
            case 6 :
                lib.readIntoByteArray(receiver, (int) args[offset], (byte[]) args[offset + 1], (int) args[offset + 2], (int) args[offset + 3]);
                return null;
            case 7 :
                lib.writeFromByteArray(receiver, (int) args[offset], (byte[]) args[offset + 1], (int) args[offset + 2], (int) args[offset + 3]);
                return null;
            case 8 :
                lib.readIntoBuffer(receiver, (int) args[offset], args[offset + 1], (int) args[offset + 2], (int) args[offset + 3], (PythonBufferAccessLibrary) args[offset + 4]);
                return null;
            case 9 :
                return lib.readByte(receiver, (int) args[offset]);
            case 10 :
                return lib.readShort(receiver, (int) args[offset]);
            case 11 :
                return lib.readShortByteOrder(receiver, (int) args[offset], (ByteOrder) args[offset + 1]);
            case 12 :
                return lib.readInt(receiver, (int) args[offset]);
            case 13 :
                return lib.readIntByteOrder(receiver, (int) args[offset], (ByteOrder) args[offset + 1]);
            case 14 :
                return lib.readLong(receiver, (int) args[offset]);
            case 15 :
                return lib.readLongByteOrder(receiver, (int) args[offset], (ByteOrder) args[offset + 1]);
            case 16 :
                return lib.readFloat(receiver, (int) args[offset]);
            case 17 :
                return lib.readFloatByteOrder(receiver, (int) args[offset], (ByteOrder) args[offset + 1]);
            case 18 :
                return lib.readDouble(receiver, (int) args[offset]);
            case 19 :
                return lib.readDoubleByteOrder(receiver, (int) args[offset], (ByteOrder) args[offset + 1]);
            case 20 :
                lib.writeByte(receiver, (int) args[offset], (byte) args[offset + 1]);
                return null;
            case 21 :
                lib.writeShort(receiver, (int) args[offset], (short) args[offset + 1]);
                return null;
            case 22 :
                lib.writeShortByteOrder(receiver, (int) args[offset], (short) args[offset + 1], (ByteOrder) args[offset + 2]);
                return null;
            case 23 :
                lib.writeInt(receiver, (int) args[offset], (int) args[offset + 1]);
                return null;
            case 24 :
                lib.writeIntByteOrder(receiver, (int) args[offset], (int) args[offset + 1], (ByteOrder) args[offset + 2]);
                return null;
            case 25 :
                lib.writeLong(receiver, (int) args[offset], (long) args[offset + 1]);
                return null;
            case 26 :
                lib.writeLongByteOrder(receiver, (int) args[offset], (long) args[offset + 1], (ByteOrder) args[offset + 2]);
                return null;
            case 27 :
                lib.writeFloat(receiver, (int) args[offset], (float) args[offset + 1]);
                return null;
            case 28 :
                lib.writeFloatByteOrder(receiver, (int) args[offset], (float) args[offset + 1], (ByteOrder) args[offset + 2]);
                return null;
            case 29 :
                lib.writeDouble(receiver, (int) args[offset], (double) args[offset + 1]);
                return null;
            case 30 :
                lib.writeDoubleByteOrder(receiver, (int) args[offset], (double) args[offset + 1], (ByteOrder) args[offset + 2]);
                return null;
            case 31 :
                return lib.getOwner(receiver);
            case 32 :
                return lib.getItemSize(receiver);
            case 33 :
                return lib.getFormatString(receiver);
            case 34 :
                return lib.isNative(receiver);
            case 35 :
                return lib.getNativePointer(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected PythonBufferAccessLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected PythonBufferAccessLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<PythonBufferAccessLibrary> lazyLibraryClass() {
        try {
            return (Class<PythonBufferAccessLibrary>) Class.forName("com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary", false, PythonBufferAccessLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static final class Default extends LibraryExport<PythonBufferAccessLibrary> {

        private Default() {
            super(PythonBufferAccessLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            PythonBufferAccessLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected PythonBufferAccessLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(PythonBufferAccessLibrary.class)
        private static final class Cached extends PythonBufferAccessLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBuffer((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public void release(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.release((dynamicDispatch_.cast(receiver)));
                return;
            }

            @Override
            public int getBufferLength(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getBufferLength((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isReadonly(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isReadonly((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean hasInternalByteArray(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasInternalByteArray((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public byte[] getInternalByteArray(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getInternalByteArray((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public void readIntoByteArray(Object receiver, int srcOffset, byte[] dest, int destOffset, int length) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoByteArray((dynamicDispatch_.cast(receiver)), srcOffset, dest, destOffset, length);
                return;
            }

            @Override
            public void writeFromByteArray(Object receiver, int destOffset, byte[] src, int srcOffset, int length) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFromByteArray((dynamicDispatch_.cast(receiver)), destOffset, src, srcOffset, length);
                return;
            }

            @Override
            public void readIntoBuffer(Object receiver, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoBuffer((dynamicDispatch_.cast(receiver)), srcOffset, dest, destOffset, length, otherLib);
                return;
            }

            @Override
            public byte readByte(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readByte((dynamicDispatch_.cast(receiver)), byteOffset);
            }

            @Override
            public short readShort(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShort((dynamicDispatch_.cast(receiver)), byteOffset);
            }

            @Override
            public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShortByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, byteOrder);
            }

            @Override
            public int readInt(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readInt((dynamicDispatch_.cast(receiver)), byteOffset);
            }

            @Override
            public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readIntByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, byteOrder);
            }

            @Override
            public long readLong(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLong((dynamicDispatch_.cast(receiver)), byteOffset);
            }

            @Override
            public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLongByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, byteOrder);
            }

            @Override
            public float readFloat(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloat((dynamicDispatch_.cast(receiver)), byteOffset);
            }

            @Override
            public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloatByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, byteOrder);
            }

            @Override
            public double readDouble(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDouble((dynamicDispatch_.cast(receiver)), byteOffset);
            }

            @Override
            public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDoubleByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, byteOrder);
            }

            @Override
            public void writeByte(Object receiver, int byteOffset, byte value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeByte((dynamicDispatch_.cast(receiver)), byteOffset, value);
                return;
            }

            @Override
            public void writeShort(Object receiver, int byteOffset, short value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShort((dynamicDispatch_.cast(receiver)), byteOffset, value);
                return;
            }

            @Override
            public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShortByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, value, byteOrder);
                return;
            }

            @Override
            public void writeInt(Object receiver, int byteOffset, int value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeInt((dynamicDispatch_.cast(receiver)), byteOffset, value);
                return;
            }

            @Override
            public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeIntByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, value, byteOrder);
                return;
            }

            @Override
            public void writeLong(Object receiver, int byteOffset, long value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLong((dynamicDispatch_.cast(receiver)), byteOffset, value);
                return;
            }

            @Override
            public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLongByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, value, byteOrder);
                return;
            }

            @Override
            public void writeFloat(Object receiver, int byteOffset, float value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloat((dynamicDispatch_.cast(receiver)), byteOffset, value);
                return;
            }

            @Override
            public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloatByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, value, byteOrder);
                return;
            }

            @Override
            public void writeDouble(Object receiver, int byteOffset, double value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDouble((dynamicDispatch_.cast(receiver)), byteOffset, value);
                return;
            }

            @Override
            public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDoubleByteOrder((dynamicDispatch_.cast(receiver)), byteOffset, value, byteOrder);
                return;
            }

            @Override
            public Object getOwner(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getOwner((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public int getItemSize(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getItemSize((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public TruffleString getFormatString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getFormatString((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isNative(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isNative((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object getNativePointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativePointer((dynamicDispatch_.cast(receiver)));
            }

        }
        @GeneratedBy(PythonBufferAccessLibrary.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAccessLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public boolean isBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBuffer(receiver);
            }

            @TruffleBoundary
            @Override
            public void release(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.release(receiver);
                return;
            }

            @TruffleBoundary
            @Override
            public int getBufferLength(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getBufferLength(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean isReadonly(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isReadonly(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean hasInternalByteArray(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasInternalByteArray(receiver);
            }

            @TruffleBoundary
            @Override
            public byte[] getInternalByteArray(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getInternalByteArray(receiver);
            }

            @TruffleBoundary
            @Override
            public void readIntoByteArray(Object receiver, int srcOffset, byte[] dest, int destOffset, int length) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoByteArray(receiver, srcOffset, dest, destOffset, length);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFromByteArray(Object receiver, int destOffset, byte[] src, int srcOffset, int length) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFromByteArray(receiver, destOffset, src, srcOffset, length);
                return;
            }

            @TruffleBoundary
            @Override
            public void readIntoBuffer(Object receiver, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoBuffer(receiver, srcOffset, dest, destOffset, length, otherLib);
                return;
            }

            @TruffleBoundary
            @Override
            public byte readByte(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readByte(receiver, byteOffset);
            }

            @TruffleBoundary
            @Override
            public short readShort(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShort(receiver, byteOffset);
            }

            @TruffleBoundary
            @Override
            public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShortByteOrder(receiver, byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public int readInt(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readInt(receiver, byteOffset);
            }

            @TruffleBoundary
            @Override
            public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readIntByteOrder(receiver, byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public long readLong(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLong(receiver, byteOffset);
            }

            @TruffleBoundary
            @Override
            public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLongByteOrder(receiver, byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloat(receiver, byteOffset);
            }

            @TruffleBoundary
            @Override
            public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloatByteOrder(receiver, byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDouble(receiver, byteOffset);
            }

            @TruffleBoundary
            @Override
            public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDoubleByteOrder(receiver, byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public void writeByte(Object receiver, int byteOffset, byte value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeByte(receiver, byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeShort(Object receiver, int byteOffset, short value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShort(receiver, byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShortByteOrder(receiver, byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeInt(Object receiver, int byteOffset, int value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeInt(receiver, byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeIntByteOrder(receiver, byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeLong(Object receiver, int byteOffset, long value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLong(receiver, byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLongByteOrder(receiver, byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFloat(Object receiver, int byteOffset, float value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloat(receiver, byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloatByteOrder(receiver, byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeDouble(Object receiver, int byteOffset, double value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDouble(receiver, byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDoubleByteOrder(receiver, byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public Object getOwner(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getOwner(receiver);
            }

            @TruffleBoundary
            @Override
            public int getItemSize(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getItemSize(receiver);
            }

            @TruffleBoundary
            @Override
            public TruffleString getFormatString(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getFormatString(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean isNative(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isNative(receiver);
            }

            @TruffleBoundary
            @Override
            public Object getNativePointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativePointer(receiver);
            }

        }
    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(PythonBufferAccessLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static final class Proxy extends PythonBufferAccessLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isBuffer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, PythonBufferAccessLibraryGen.IS_BUFFER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void release(Object receiver_) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.RELEASE);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getBufferLength(Object receiver_) {
            try {
                return (int) lib.send(receiver_, PythonBufferAccessLibraryGen.GET_BUFFER_LENGTH);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean isReadonly(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, PythonBufferAccessLibraryGen.IS_READONLY);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, PythonBufferAccessLibraryGen.HAS_INTERNAL_BYTE_ARRAY);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            try {
                return (byte[]) lib.send(receiver_, PythonBufferAccessLibraryGen.GET_INTERNAL_BYTE_ARRAY);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.READ_INTO_BYTE_ARRAY, srcOffset, dest, destOffset, length);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_FROM_BYTE_ARRAY, destOffset, src, srcOffset, length);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.READ_INTO_BUFFER, srcOffset, dest, destOffset, length, otherLib);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            try {
                return (byte) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_BYTE, byteOffset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public short readShort(Object receiver_, int byteOffset) {
            try {
                return (short) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_SHORT, byteOffset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (short) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_SHORT_BYTE_ORDER, byteOffset, byteOrder);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int readInt(Object receiver_, int byteOffset) {
            try {
                return (int) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_INT, byteOffset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (int) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_INT_BYTE_ORDER, byteOffset, byteOrder);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public long readLong(Object receiver_, int byteOffset) {
            try {
                return (long) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_LONG, byteOffset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (long) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_LONG_BYTE_ORDER, byteOffset, byteOrder);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            try {
                return (float) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_FLOAT, byteOffset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (float) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_FLOAT_BYTE_ORDER, byteOffset, byteOrder);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            try {
                return (double) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_DOUBLE, byteOffset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (double) lib.send(receiver_, PythonBufferAccessLibraryGen.READ_DOUBLE_BYTE_ORDER, byteOffset, byteOrder);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_BYTE, byteOffset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_SHORT, byteOffset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_SHORT_BYTE_ORDER, byteOffset, value, byteOrder);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_INT, byteOffset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_INT_BYTE_ORDER, byteOffset, value, byteOrder);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_LONG, byteOffset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_LONG_BYTE_ORDER, byteOffset, value, byteOrder);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_FLOAT, byteOffset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_FLOAT_BYTE_ORDER, byteOffset, value, byteOrder);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_DOUBLE, byteOffset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            try {
                lib.send(receiver_, PythonBufferAccessLibraryGen.WRITE_DOUBLE_BYTE_ORDER, byteOffset, value, byteOrder);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object getOwner(Object receiver_) {
            try {
                return lib.send(receiver_, PythonBufferAccessLibraryGen.GET_OWNER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getItemSize(Object receiver_) {
            try {
                return (int) lib.send(receiver_, PythonBufferAccessLibraryGen.GET_ITEM_SIZE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public TruffleString getFormatString(Object receiver_) {
            try {
                return (TruffleString) lib.send(receiver_, PythonBufferAccessLibraryGen.GET_FORMAT_STRING);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean isNative(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, PythonBufferAccessLibraryGen.IS_NATIVE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object getNativePointer(Object receiver_) {
            try {
                return lib.send(receiver_, PythonBufferAccessLibraryGen.GET_NATIVE_POINTER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static final class Delegate extends PythonBufferAccessLibrary {

        @Child private PythonBufferAccessLibrary delegateLibrary;

        Delegate(PythonBufferAccessLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isBuffer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isBuffer(delegate);
            } else {
                return this.delegateLibrary.isBuffer(receiver_);
            }
        }

        @Override
        public void release(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).release(delegate);
                return;
            } else {
                this.delegateLibrary.release(receiver_);
                return;
            }
        }

        @Override
        public int getBufferLength(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getBufferLength(delegate);
            } else {
                return this.delegateLibrary.getBufferLength(receiver_);
            }
        }

        @Override
        public boolean isReadonly(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isReadonly(delegate);
            } else {
                return this.delegateLibrary.isReadonly(receiver_);
            }
        }

        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 4)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).hasInternalByteArray(delegate);
            } else {
                return this.delegateLibrary.hasInternalByteArray(receiver_);
            }
        }

        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 5)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getInternalByteArray(delegate);
            } else {
                return this.delegateLibrary.getInternalByteArray(receiver_);
            }
        }

        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            if (LibraryFactory.isDelegated(delegateLibrary, 6)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readIntoByteArray(delegate, srcOffset, dest, destOffset, length);
                return;
            } else {
                this.delegateLibrary.readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
                return;
            }
        }

        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            if (LibraryFactory.isDelegated(delegateLibrary, 7)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeFromByteArray(delegate, destOffset, src, srcOffset, length);
                return;
            } else {
                this.delegateLibrary.writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
                return;
            }
        }

        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            if (LibraryFactory.isDelegated(delegateLibrary, 8)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readIntoBuffer(delegate, srcOffset, dest, destOffset, length, otherLib);
                return;
            } else {
                this.delegateLibrary.readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
                return;
            }
        }

        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 9)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readByte(delegate, byteOffset);
            } else {
                return this.delegateLibrary.readByte(receiver_, byteOffset);
            }
        }

        @Override
        public short readShort(Object receiver_, int byteOffset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 10)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readShort(delegate, byteOffset);
            } else {
                return this.delegateLibrary.readShort(receiver_, byteOffset);
            }
        }

        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 11)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readShortByteOrder(delegate, byteOffset, byteOrder);
            } else {
                return this.delegateLibrary.readShortByteOrder(receiver_, byteOffset, byteOrder);
            }
        }

        @Override
        public int readInt(Object receiver_, int byteOffset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 12)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readInt(delegate, byteOffset);
            } else {
                return this.delegateLibrary.readInt(receiver_, byteOffset);
            }
        }

        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 13)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readIntByteOrder(delegate, byteOffset, byteOrder);
            } else {
                return this.delegateLibrary.readIntByteOrder(receiver_, byteOffset, byteOrder);
            }
        }

        @Override
        public long readLong(Object receiver_, int byteOffset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 14)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readLong(delegate, byteOffset);
            } else {
                return this.delegateLibrary.readLong(receiver_, byteOffset);
            }
        }

        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 15)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readLongByteOrder(delegate, byteOffset, byteOrder);
            } else {
                return this.delegateLibrary.readLongByteOrder(receiver_, byteOffset, byteOrder);
            }
        }

        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 16)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readFloat(delegate, byteOffset);
            } else {
                return this.delegateLibrary.readFloat(receiver_, byteOffset);
            }
        }

        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 17)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readFloatByteOrder(delegate, byteOffset, byteOrder);
            } else {
                return this.delegateLibrary.readFloatByteOrder(receiver_, byteOffset, byteOrder);
            }
        }

        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 18)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readDouble(delegate, byteOffset);
            } else {
                return this.delegateLibrary.readDouble(receiver_, byteOffset);
            }
        }

        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 19)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readDoubleByteOrder(delegate, byteOffset, byteOrder);
            } else {
                return this.delegateLibrary.readDoubleByteOrder(receiver_, byteOffset, byteOrder);
            }
        }

        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 20)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeByte(delegate, byteOffset, value);
                return;
            } else {
                this.delegateLibrary.writeByte(receiver_, byteOffset, value);
                return;
            }
        }

        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 21)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeShort(delegate, byteOffset, value);
                return;
            } else {
                this.delegateLibrary.writeShort(receiver_, byteOffset, value);
                return;
            }
        }

        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 22)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeShortByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            } else {
                this.delegateLibrary.writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
        }

        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 23)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeInt(delegate, byteOffset, value);
                return;
            } else {
                this.delegateLibrary.writeInt(receiver_, byteOffset, value);
                return;
            }
        }

        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 24)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeIntByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            } else {
                this.delegateLibrary.writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
        }

        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 25)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeLong(delegate, byteOffset, value);
                return;
            } else {
                this.delegateLibrary.writeLong(receiver_, byteOffset, value);
                return;
            }
        }

        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 26)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeLongByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            } else {
                this.delegateLibrary.writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
        }

        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 27)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeFloat(delegate, byteOffset, value);
                return;
            } else {
                this.delegateLibrary.writeFloat(receiver_, byteOffset, value);
                return;
            }
        }

        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 28)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeFloatByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            } else {
                this.delegateLibrary.writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
        }

        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 29)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeDouble(delegate, byteOffset, value);
                return;
            } else {
                this.delegateLibrary.writeDouble(receiver_, byteOffset, value);
                return;
            }
        }

        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            if (LibraryFactory.isDelegated(delegateLibrary, 30)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeDoubleByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            } else {
                this.delegateLibrary.writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
        }

        @Override
        public Object getOwner(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 31)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getOwner(delegate);
            } else {
                return this.delegateLibrary.getOwner(receiver_);
            }
        }

        @Override
        public int getItemSize(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 32)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getItemSize(delegate);
            } else {
                return this.delegateLibrary.getItemSize(receiver_);
            }
        }

        @Override
        public TruffleString getFormatString(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 33)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getFormatString(delegate);
            } else {
                return this.delegateLibrary.getFormatString(receiver_);
            }
        }

        @Override
        public boolean isNative(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 34)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isNative(delegate);
            } else {
                return this.delegateLibrary.isNative(receiver_);
            }
        }

        @Override
        public Object getNativePointer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 35)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getNativePointer(delegate);
            } else {
                return this.delegateLibrary.getNativePointer(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static final class CachedToUncachedDispatch extends PythonBufferAccessLibrary {

        @TruffleBoundary
        @Override
        public boolean isBuffer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isBuffer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void release(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).release(receiver_);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getBufferLength(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getBufferLength(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean isReadonly(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isReadonly(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).hasInternalByteArray(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getInternalByteArray(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readByte(receiver_, byteOffset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public short readShort(Object receiver_, int byteOffset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readShort(receiver_, byteOffset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readShortByteOrder(receiver_, byteOffset, byteOrder);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int readInt(Object receiver_, int byteOffset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readInt(receiver_, byteOffset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readIntByteOrder(receiver_, byteOffset, byteOrder);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public long readLong(Object receiver_, int byteOffset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readLong(receiver_, byteOffset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readLongByteOrder(receiver_, byteOffset, byteOrder);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readFloat(receiver_, byteOffset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readFloatByteOrder(receiver_, byteOffset, byteOrder);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readDouble(receiver_, byteOffset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readDoubleByteOrder(receiver_, byteOffset, byteOrder);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeByte(receiver_, byteOffset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeShort(receiver_, byteOffset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeInt(receiver_, byteOffset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeLong(receiver_, byteOffset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeFloat(receiver_, byteOffset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeDouble(receiver_, byteOffset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object getOwner(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getOwner(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getItemSize(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getItemSize(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public TruffleString getFormatString(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getFormatString(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean isNative(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isNative(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object getNativePointer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getNativePointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends PythonBufferAccessLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean isBuffer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isBuffer(receiver_);
        }

        @TruffleBoundary
        @Override
        public void release(Object receiver_) {
            INSTANCE.getUncached(receiver_).release(receiver_);
            return;
        }

        @TruffleBoundary
        @Override
        public int getBufferLength(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getBufferLength(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean isReadonly(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isReadonly(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            return INSTANCE.getUncached(receiver_).hasInternalByteArray(receiver_);
        }

        @TruffleBoundary
        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getInternalByteArray(receiver_);
        }

        @TruffleBoundary
        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            INSTANCE.getUncached(receiver_).readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            INSTANCE.getUncached(receiver_).writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
            return;
        }

        @TruffleBoundary
        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            INSTANCE.getUncached(receiver_).readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
            return;
        }

        @TruffleBoundary
        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            return INSTANCE.getUncached(receiver_).readByte(receiver_, byteOffset);
        }

        @TruffleBoundary
        @Override
        public short readShort(Object receiver_, int byteOffset) {
            return INSTANCE.getUncached(receiver_).readShort(receiver_, byteOffset);
        }

        @TruffleBoundary
        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return INSTANCE.getUncached(receiver_).readShortByteOrder(receiver_, byteOffset, byteOrder);
        }

        @TruffleBoundary
        @Override
        public int readInt(Object receiver_, int byteOffset) {
            return INSTANCE.getUncached(receiver_).readInt(receiver_, byteOffset);
        }

        @TruffleBoundary
        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return INSTANCE.getUncached(receiver_).readIntByteOrder(receiver_, byteOffset, byteOrder);
        }

        @TruffleBoundary
        @Override
        public long readLong(Object receiver_, int byteOffset) {
            return INSTANCE.getUncached(receiver_).readLong(receiver_, byteOffset);
        }

        @TruffleBoundary
        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return INSTANCE.getUncached(receiver_).readLongByteOrder(receiver_, byteOffset, byteOrder);
        }

        @TruffleBoundary
        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            return INSTANCE.getUncached(receiver_).readFloat(receiver_, byteOffset);
        }

        @TruffleBoundary
        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return INSTANCE.getUncached(receiver_).readFloatByteOrder(receiver_, byteOffset, byteOrder);
        }

        @TruffleBoundary
        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            return INSTANCE.getUncached(receiver_).readDouble(receiver_, byteOffset);
        }

        @TruffleBoundary
        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return INSTANCE.getUncached(receiver_).readDoubleByteOrder(receiver_, byteOffset, byteOrder);
        }

        @TruffleBoundary
        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            INSTANCE.getUncached(receiver_).writeByte(receiver_, byteOffset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            INSTANCE.getUncached(receiver_).writeShort(receiver_, byteOffset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            INSTANCE.getUncached(receiver_).writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            INSTANCE.getUncached(receiver_).writeInt(receiver_, byteOffset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            INSTANCE.getUncached(receiver_).writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            INSTANCE.getUncached(receiver_).writeLong(receiver_, byteOffset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            INSTANCE.getUncached(receiver_).writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            INSTANCE.getUncached(receiver_).writeFloat(receiver_, byteOffset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            INSTANCE.getUncached(receiver_).writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            INSTANCE.getUncached(receiver_).writeDouble(receiver_, byteOffset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            INSTANCE.getUncached(receiver_).writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
            return;
        }

        @TruffleBoundary
        @Override
        public Object getOwner(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getOwner(receiver_);
        }

        @TruffleBoundary
        @Override
        public int getItemSize(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getItemSize(receiver_);
        }

        @TruffleBoundary
        @Override
        public TruffleString getFormatString(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getFormatString(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean isNative(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isNative(receiver_);
        }

        @TruffleBoundary
        @Override
        public Object getNativePointer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getNativePointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(PythonBufferAccessLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(PythonBufferAccessLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

    }
    @GeneratedBy(PythonBufferAccessLibrary.class)
    private abstract static class CachedDispatch extends PythonBufferAccessLibrary {

        @Child PythonBufferAccessLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(PythonBufferAccessLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public boolean isBuffer(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isBuffer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void release(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.release(receiver_);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getBufferLength(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getBufferLength(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean isReadonly(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isReadonly(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.hasInternalByteArray(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getInternalByteArray(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readByte(receiver_, byteOffset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public short readShort(Object receiver_, int byteOffset) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readShort(receiver_, byteOffset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readShortByteOrder(receiver_, byteOffset, byteOrder);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int readInt(Object receiver_, int byteOffset) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readInt(receiver_, byteOffset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readIntByteOrder(receiver_, byteOffset, byteOrder);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public long readLong(Object receiver_, int byteOffset) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readLong(receiver_, byteOffset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readLongByteOrder(receiver_, byteOffset, byteOrder);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readFloat(receiver_, byteOffset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readFloatByteOrder(receiver_, byteOffset, byteOrder);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readDouble(receiver_, byteOffset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readDoubleByteOrder(receiver_, byteOffset, byteOrder);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeByte(receiver_, byteOffset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeShort(receiver_, byteOffset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeInt(receiver_, byteOffset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeLong(receiver_, byteOffset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeFloat(receiver_, byteOffset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeDouble(receiver_, byteOffset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object getOwner(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getOwner(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getItemSize(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getItemSize(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public TruffleString getFormatString(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getFormatString(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean isNative(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isNative(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object getNativePointer(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getNativePointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PythonBufferAccessLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        PythonBufferAccessLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
