/*
 * Copyright (c) 2017, 2023, Oracle and/or its affiliates.
 * Copyright (c) 2013, Regents of the University of California
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(InteropLibrary.class)
public final class PMethod extends PMethodBase {

    public PMethod(Object cls, Shape instanceShape, Object self, Object function) {
        super(cls, instanceShape, self, function);
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "<method '" + getFunction() + "' of " + getSelf() + " object at " + getFunction().hashCode() + ">";
    }

    @ExportMessage
    boolean hasExecutableName(
                    @CachedLibrary("this.function") InteropLibrary lib) {
        return lib.hasExecutableName(function);
    }

    @ExportMessage
    Object getExecutableName(
                    @CachedLibrary("this.function") InteropLibrary lib) throws UnsupportedMessageException {
        return lib.getExecutableName(function);
    }

    @ExportMessage
    protected SourceSection getSourceLocation(@CachedLibrary("this.function") InteropLibrary lib) throws UnsupportedMessageException {
        return lib.getSourceLocation(function);
    }

    @ExportMessage
    protected boolean hasSourceLocation(@CachedLibrary("this.function") InteropLibrary lib) {
        return lib.hasSourceLocation(function);
    }
}
