/*
 * Copyright (c) 2021, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import static com.oracle.graal.python.util.PythonUtils.toTruffleStringUncached;
import static com.oracle.graal.python.util.PythonUtils.tsLiteral;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.truffle.api.strings.TruffleString;

/**
 * This file has been automatically generated using scripts/generate_ssl_data.py. Do not edit!
 * Generated using: OpenSSL 1.1.1w 11 Sep 2023
 * 
 * This class represents OpenSSL metadata of all SSL/TLS cipher suites.
 **/
public enum SSLCipher {
    TLS_AES_256_GCM_SHA384(
                    50336514,
                    "TLS_AES_256_GCM_SHA384",
                    "TLSv1.3",
                    "TLS_AES_256_GCM_SHA384  TLSv1.3 Kx=any      Au=any  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-any",
                    "auth-any"),
    TLS_CHACHA20_POLY1305_SHA256(
                    50336515,
                    "TLS_CHACHA20_POLY1305_SHA256",
                    "TLSv1.3",
                    "TLS_CHACHA20_POLY1305_SHA256 TLSv1.3 Kx=any      Au=any  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-any",
                    "auth-any"),
    TLS_AES_128_GCM_SHA256(
                    50336513,
                    "TLS_AES_128_GCM_SHA256",
                    "TLSv1.3",
                    "TLS_AES_128_GCM_SHA256  TLSv1.3 Kx=any      Au=any  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-any",
                    "auth-any"),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(
                    50380844,
                    "ECDHE-ECDSA-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES256-GCM-SHA384 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(
                    50380848,
                    "ECDHE-RSA-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "ECDHE-RSA-AES256-GCM-SHA384 TLSv1.2 Kx=ECDH     Au=RSA  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384(
                    50331811,
                    "DHE-DSS-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "DHE-DSS-AES256-GCM-SHA384 TLSv1.2 Kx=DH       Au=DSS  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384(
                    50331807,
                    "DHE-RSA-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "DHE-RSA-AES256-GCM-SHA384 TLSv1.2 Kx=DH       Au=RSA  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(
                    50384041,
                    "ECDHE-ECDSA-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "ECDHE-ECDSA-CHACHA20-POLY1305 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(
                    50384040,
                    "ECDHE-RSA-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "ECDHE-RSA-CHACHA20-POLY1305 TLSv1.2 Kx=ECDH     Au=RSA  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256(
                    50384042,
                    "DHE-RSA-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "DHE-RSA-CHACHA20-POLY1305 TLSv1.2 Kx=DH       Au=RSA  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8(
                    50380975,
                    "ECDHE-ECDSA-AES256-CCM8",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES256-CCM8 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AESCCM8(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM(
                    50380973,
                    "ECDHE-ECDSA-AES256-CCM",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES256-CCM  TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AESCCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_DHE_RSA_WITH_AES_256_CCM_8(
                    50380963,
                    "DHE-RSA-AES256-CCM8",
                    "TLSv1.2",
                    "DHE-RSA-AES256-CCM8     TLSv1.2 Kx=DH       Au=RSA  Enc=AESCCM8(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_AES_256_CCM(
                    50380959,
                    "DHE-RSA-AES256-CCM",
                    "TLSv1.2",
                    "DHE-RSA-AES256-CCM      TLSv1.2 Kx=DH       Au=RSA  Enc=AESCCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384(
                    50380893,
                    "ECDHE-ECDSA-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "ECDHE-ECDSA-ARIA256-GCM-SHA384 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384(
                    50380897,
                    "ECDHE-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "ECDHE-ARIA256-GCM-SHA384 TLSv1.2 Kx=ECDH     Au=RSA  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384(
                    50380887,
                    "DHE-DSS-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "DHE-DSS-ARIA256-GCM-SHA384 TLSv1.2 Kx=DH       Au=DSS  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384(
                    50380883,
                    "DHE-RSA-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "DHE-RSA-ARIA256-GCM-SHA384 TLSv1.2 Kx=DH       Au=RSA  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DH_anon_WITH_AES_256_GCM_SHA384(
                    50331815,
                    "ADH-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "ADH-AES256-GCM-SHA384   TLSv1.2 Kx=DH       Au=None Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-dhe",
                    "auth-null"),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(
                    50380843,
                    "ECDHE-ECDSA-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES128-GCM-SHA256 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(
                    50380847,
                    "ECDHE-RSA-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "ECDHE-RSA-AES128-GCM-SHA256 TLSv1.2 Kx=ECDH     Au=RSA  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256(
                    50331810,
                    "DHE-DSS-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "DHE-DSS-AES128-GCM-SHA256 TLSv1.2 Kx=DH       Au=DSS  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256(
                    50331806,
                    "DHE-RSA-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "DHE-RSA-AES128-GCM-SHA256 TLSv1.2 Kx=DH       Au=RSA  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8(
                    50380974,
                    "ECDHE-ECDSA-AES128-CCM8",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES128-CCM8 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AESCCM8(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM(
                    50380972,
                    "ECDHE-ECDSA-AES128-CCM",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES128-CCM  TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AESCCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_DHE_RSA_WITH_AES_128_CCM_8(
                    50380962,
                    "DHE-RSA-AES128-CCM8",
                    "TLSv1.2",
                    "DHE-RSA-AES128-CCM8     TLSv1.2 Kx=DH       Au=RSA  Enc=AESCCM8(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_AES_128_CCM(
                    50380958,
                    "DHE-RSA-AES128-CCM",
                    "TLSv1.2",
                    "DHE-RSA-AES128-CCM      TLSv1.2 Kx=DH       Au=RSA  Enc=AESCCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256(
                    50380892,
                    "ECDHE-ECDSA-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "ECDHE-ECDSA-ARIA128-GCM-SHA256 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256(
                    50380896,
                    "ECDHE-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "ECDHE-ARIA128-GCM-SHA256 TLSv1.2 Kx=ECDH     Au=RSA  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256(
                    50380886,
                    "DHE-DSS-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "DHE-DSS-ARIA128-GCM-SHA256 TLSv1.2 Kx=DH       Au=DSS  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256(
                    50380882,
                    "DHE-RSA-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "DHE-RSA-ARIA128-GCM-SHA256 TLSv1.2 Kx=DH       Au=RSA  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DH_anon_WITH_AES_128_GCM_SHA256(
                    50331814,
                    "ADH-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "ADH-AES128-GCM-SHA256   TLSv1.2 Kx=DH       Au=None Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-dhe",
                    "auth-null"),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(
                    50380836,
                    "ECDHE-ECDSA-AES256-SHA384",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES256-SHA384 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AES(256)  Mac=SHA384",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha384",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384(
                    50380840,
                    "ECDHE-RSA-AES256-SHA384",
                    "TLSv1.2",
                    "ECDHE-RSA-AES256-SHA384 TLSv1.2 Kx=ECDH     Au=RSA  Enc=AES(256)  Mac=SHA384",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha384",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256(
                    50331755,
                    "DHE-RSA-AES256-SHA256",
                    "TLSv1.2",
                    "DHE-RSA-AES256-SHA256   TLSv1.2 Kx=DH       Au=RSA  Enc=AES(256)  Mac=SHA256",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256(
                    50331754,
                    "DHE-DSS-AES256-SHA256",
                    "TLSv1.2",
                    "DHE-DSS-AES256-SHA256   TLSv1.2 Kx=DH       Au=DSS  Enc=AES(256)  Mac=SHA256",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-dss"),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384(
                    50380915,
                    "ECDHE-ECDSA-CAMELLIA256-SHA384",
                    "TLSv1.2",
                    "ECDHE-ECDSA-CAMELLIA256-SHA384 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=Camellia(256) Mac=SHA384",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha384",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384(
                    50380919,
                    "ECDHE-RSA-CAMELLIA256-SHA384",
                    "TLSv1.2",
                    "ECDHE-RSA-CAMELLIA256-SHA384 TLSv1.2 Kx=ECDH     Au=RSA  Enc=Camellia(256) Mac=SHA384",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha384",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256(
                    50331844,
                    "DHE-RSA-CAMELLIA256-SHA256",
                    "TLSv1.2",
                    "DHE-RSA-CAMELLIA256-SHA256 TLSv1.2 Kx=DH       Au=RSA  Enc=Camellia(256) Mac=SHA256",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256(
                    50331843,
                    "DHE-DSS-CAMELLIA256-SHA256",
                    "TLSv1.2",
                    "DHE-DSS-CAMELLIA256-SHA256 TLSv1.2 Kx=DH       Au=DSS  Enc=Camellia(256) Mac=SHA256",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-dss"),
    TLS_DH_anon_WITH_AES_256_CBC_SHA256(
                    50331757,
                    "ADH-AES256-SHA256",
                    "TLSv1.2",
                    "ADH-AES256-SHA256       TLSv1.2 Kx=DH       Au=None Enc=AES(256)  Mac=SHA256",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-null"),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256(
                    50331845,
                    "ADH-CAMELLIA256-SHA256",
                    "TLSv1.2",
                    "ADH-CAMELLIA256-SHA256  TLSv1.2 Kx=DH       Au=None Enc=Camellia(256) Mac=SHA256",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-null"),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(
                    50380835,
                    "ECDHE-ECDSA-AES128-SHA256",
                    "TLSv1.2",
                    "ECDHE-ECDSA-AES128-SHA256 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256(
                    50380839,
                    "ECDHE-RSA-AES128-SHA256",
                    "TLSv1.2",
                    "ECDHE-RSA-AES128-SHA256 TLSv1.2 Kx=ECDH     Au=RSA  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256(
                    50331751,
                    "DHE-RSA-AES128-SHA256",
                    "TLSv1.2",
                    "DHE-RSA-AES128-SHA256   TLSv1.2 Kx=DH       Au=RSA  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256(
                    50331712,
                    "DHE-DSS-AES128-SHA256",
                    "TLSv1.2",
                    "DHE-DSS-AES128-SHA256   TLSv1.2 Kx=DH       Au=DSS  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-dss"),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256(
                    50380914,
                    "ECDHE-ECDSA-CAMELLIA128-SHA256",
                    "TLSv1.2",
                    "ECDHE-ECDSA-CAMELLIA128-SHA256 TLSv1.2 Kx=ECDH     Au=ECDSA Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256(
                    50380918,
                    "ECDHE-RSA-CAMELLIA128-SHA256",
                    "TLSv1.2",
                    "ECDHE-RSA-CAMELLIA128-SHA256 TLSv1.2 Kx=ECDH     Au=RSA  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256(
                    50331838,
                    "DHE-RSA-CAMELLIA128-SHA256",
                    "TLSv1.2",
                    "DHE-RSA-CAMELLIA128-SHA256 TLSv1.2 Kx=DH       Au=RSA  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256(
                    50331837,
                    "DHE-DSS-CAMELLIA128-SHA256",
                    "TLSv1.2",
                    "DHE-DSS-CAMELLIA128-SHA256 TLSv1.2 Kx=DH       Au=DSS  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-dss"),
    TLS_DH_anon_WITH_AES_128_CBC_SHA256(
                    50331756,
                    "ADH-AES128-SHA256",
                    "TLSv1.2",
                    "ADH-AES128-SHA256       TLSv1.2 Kx=DH       Au=None Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-null"),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256(
                    50331839,
                    "ADH-CAMELLIA128-SHA256",
                    "TLSv1.2",
                    "ADH-CAMELLIA128-SHA256  TLSv1.2 Kx=DH       Au=None Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-dhe",
                    "auth-null"),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(
                    50380810,
                    "ECDHE-ECDSA-AES256-SHA",
                    "TLSv1.0",
                    "ECDHE-ECDSA-AES256-SHA  TLSv1 Kx=ECDH     Au=ECDSA Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(
                    50380820,
                    "ECDHE-RSA-AES256-SHA",
                    "TLSv1.0",
                    "ECDHE-RSA-AES256-SHA    TLSv1 Kx=ECDH     Au=RSA  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA(
                    50331705,
                    "DHE-RSA-AES256-SHA",
                    "SSLv3",
                    "DHE-RSA-AES256-SHA      SSLv3 Kx=DH       Au=RSA  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA(
                    50331704,
                    "DHE-DSS-AES256-SHA",
                    "SSLv3",
                    "DHE-DSS-AES256-SHA      SSLv3 Kx=DH       Au=DSS  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA(
                    50331784,
                    "DHE-RSA-CAMELLIA256-SHA",
                    "SSLv3",
                    "DHE-RSA-CAMELLIA256-SHA SSLv3 Kx=DH       Au=RSA  Enc=Camellia(256) Mac=SHA1",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA(
                    50331783,
                    "DHE-DSS-CAMELLIA256-SHA",
                    "SSLv3",
                    "DHE-DSS-CAMELLIA256-SHA SSLv3 Kx=DH       Au=DSS  Enc=Camellia(256) Mac=SHA1",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-dss"),
    TLS_ECDH_anon_WITH_AES_256_CBC_SHA(
                    50380825,
                    "AECDH-AES256-SHA",
                    "TLSv1.0",
                    "AECDH-AES256-SHA        TLSv1 Kx=ECDH     Au=None Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-ecdhe",
                    "auth-null"),
    TLS_DH_anon_WITH_AES_256_CBC_SHA(
                    50331706,
                    "ADH-AES256-SHA",
                    "SSLv3",
                    "ADH-AES256-SHA          SSLv3 Kx=DH       Au=None Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-null"),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA(
                    50331785,
                    "ADH-CAMELLIA256-SHA",
                    "SSLv3",
                    "ADH-CAMELLIA256-SHA     SSLv3 Kx=DH       Au=None Enc=Camellia(256) Mac=SHA1",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-null"),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA(
                    50380809,
                    "ECDHE-ECDSA-AES128-SHA",
                    "TLSv1.0",
                    "ECDHE-ECDSA-AES128-SHA  TLSv1 Kx=ECDH     Au=ECDSA Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA(
                    50380819,
                    "ECDHE-RSA-AES128-SHA",
                    "TLSv1.0",
                    "ECDHE-RSA-AES128-SHA    TLSv1 Kx=ECDH     Au=RSA  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA(
                    50331699,
                    "DHE-RSA-AES128-SHA",
                    "SSLv3",
                    "DHE-RSA-AES128-SHA      SSLv3 Kx=DH       Au=RSA  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA(
                    50331698,
                    "DHE-DSS-AES128-SHA",
                    "SSLv3",
                    "DHE-DSS-AES128-SHA      SSLv3 Kx=DH       Au=DSS  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_SEED_CBC_SHA(
                    50331802,
                    "DHE-RSA-SEED-SHA",
                    "SSLv3",
                    "DHE-RSA-SEED-SHA        SSLv3 Kx=DH       Au=RSA  Enc=SEED(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "seed-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_SEED_CBC_SHA(
                    50331801,
                    "DHE-DSS-SEED-SHA",
                    "SSLv3",
                    "DHE-DSS-SEED-SHA        SSLv3 Kx=DH       Au=DSS  Enc=SEED(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "seed-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-dss"),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA(
                    50331717,
                    "DHE-RSA-CAMELLIA128-SHA",
                    "SSLv3",
                    "DHE-RSA-CAMELLIA128-SHA SSLv3 Kx=DH       Au=RSA  Enc=Camellia(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-rsa"),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA(
                    50331716,
                    "DHE-DSS-CAMELLIA128-SHA",
                    "SSLv3",
                    "DHE-DSS-CAMELLIA128-SHA SSLv3 Kx=DH       Au=DSS  Enc=Camellia(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-dss"),
    TLS_ECDH_anon_WITH_AES_128_CBC_SHA(
                    50380824,
                    "AECDH-AES128-SHA",
                    "TLSv1.0",
                    "AECDH-AES128-SHA        TLSv1 Kx=ECDH     Au=None Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-ecdhe",
                    "auth-null"),
    TLS_DH_anon_WITH_AES_128_CBC_SHA(
                    50331700,
                    "ADH-AES128-SHA",
                    "SSLv3",
                    "ADH-AES128-SHA          SSLv3 Kx=DH       Au=None Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-null"),
    TLS_DH_anon_WITH_SEED_CBC_SHA(
                    50331803,
                    "ADH-SEED-SHA",
                    "SSLv3",
                    "ADH-SEED-SHA            SSLv3 Kx=DH       Au=None Enc=SEED(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "seed-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-null"),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA(
                    50331718,
                    "ADH-CAMELLIA128-SHA",
                    "SSLv3",
                    "ADH-CAMELLIA128-SHA     SSLv3 Kx=DH       Au=None Enc=Camellia(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha1",
                    "kx-dhe",
                    "auth-null"),
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384(
                    50331821,
                    "RSA-PSK-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "RSA-PSK-AES256-GCM-SHA384 TLSv1.2 Kx=RSAPSK   Au=RSA  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384(
                    50331819,
                    "DHE-PSK-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "DHE-PSK-AES256-GCM-SHA384 TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256(
                    50384046,
                    "RSA-PSK-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "RSA-PSK-CHACHA20-POLY1305 TLSv1.2 Kx=RSAPSK   Au=RSA  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256(
                    50384045,
                    "DHE-PSK-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "DHE-PSK-CHACHA20-POLY1305 TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256(
                    50384044,
                    "ECDHE-PSK-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "ECDHE-PSK-CHACHA20-POLY1305 TLSv1.2 Kx=ECDHEPSK Au=PSK  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_PSK_DHE_WITH_AES_256_CCM_8(
                    50380971,
                    "DHE-PSK-AES256-CCM8",
                    "TLSv1.2",
                    "DHE-PSK-AES256-CCM8     TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=AESCCM8(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_DHE_PSK_WITH_AES_256_CCM(
                    50380967,
                    "DHE-PSK-AES256-CCM",
                    "TLSv1.2",
                    "DHE-PSK-AES256-CCM      TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=AESCCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384(
                    50380911,
                    "RSA-PSK-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "RSA-PSK-ARIA256-GCM-SHA384 TLSv1.2 Kx=RSAPSK   Au=RSA  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384(
                    50380909,
                    "DHE-PSK-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "DHE-PSK-ARIA256-GCM-SHA384 TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_WITH_AES_256_GCM_SHA384(
                    50331805,
                    "AES256-GCM-SHA384",
                    "TLSv1.2",
                    "AES256-GCM-SHA384       TLSv1.2 Kx=RSA      Au=RSA  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_AES_256_CCM_8(
                    50380961,
                    "AES256-CCM8",
                    "TLSv1.2",
                    "AES256-CCM8             TLSv1.2 Kx=RSA      Au=RSA  Enc=AESCCM8(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_AES_256_CCM(
                    50380957,
                    "AES256-CCM",
                    "TLSv1.2",
                    "AES256-CCM              TLSv1.2 Kx=RSA      Au=RSA  Enc=AESCCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_ARIA_256_GCM_SHA384(
                    50380881,
                    "ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "ARIA256-GCM-SHA384      TLSv1.2 Kx=RSA      Au=RSA  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_PSK_WITH_AES_256_GCM_SHA384(
                    50331817,
                    "PSK-AES256-GCM-SHA384",
                    "TLSv1.2",
                    "PSK-AES256-GCM-SHA384   TLSv1.2 Kx=PSK      Au=PSK  Enc=AESGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-gcm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256(
                    50384043,
                    "PSK-CHACHA20-POLY1305",
                    "TLSv1.2",
                    "PSK-CHACHA20-POLY1305   TLSv1.2 Kx=PSK      Au=PSK  Enc=CHACHA20/POLY1305(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "chacha20-poly1305",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_AES_256_CCM_8(
                    50380969,
                    "PSK-AES256-CCM8",
                    "TLSv1.2",
                    "PSK-AES256-CCM8         TLSv1.2 Kx=PSK      Au=PSK  Enc=AESCCM8(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_AES_256_CCM(
                    50380965,
                    "PSK-AES256-CCM",
                    "TLSv1.2",
                    "PSK-AES256-CCM          TLSv1.2 Kx=PSK      Au=PSK  Enc=AESCCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aes-256-ccm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_ARIA_256_GCM_SHA384(
                    50380907,
                    "PSK-ARIA256-GCM-SHA384",
                    "TLSv1.2",
                    "PSK-ARIA256-GCM-SHA384  TLSv1.2 Kx=PSK      Au=PSK  Enc=ARIAGCM(256) Mac=AEAD",
                    256,
                    256,
                    true,
                    "aria-256-gcm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256(
                    50331820,
                    "RSA-PSK-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "RSA-PSK-AES128-GCM-SHA256 TLSv1.2 Kx=RSAPSK   Au=RSA  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256(
                    50331818,
                    "DHE-PSK-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "DHE-PSK-AES128-GCM-SHA256 TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_PSK_DHE_WITH_AES_128_CCM_8(
                    50380970,
                    "DHE-PSK-AES128-CCM8",
                    "TLSv1.2",
                    "DHE-PSK-AES128-CCM8     TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=AESCCM8(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_DHE_PSK_WITH_AES_128_CCM(
                    50380966,
                    "DHE-PSK-AES128-CCM",
                    "TLSv1.2",
                    "DHE-PSK-AES128-CCM      TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=AESCCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256(
                    50380910,
                    "RSA-PSK-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "RSA-PSK-ARIA128-GCM-SHA256 TLSv1.2 Kx=RSAPSK   Au=RSA  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256(
                    50380908,
                    "DHE-PSK-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "DHE-PSK-ARIA128-GCM-SHA256 TLSv1.2 Kx=DHEPSK   Au=PSK  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_WITH_AES_128_GCM_SHA256(
                    50331804,
                    "AES128-GCM-SHA256",
                    "TLSv1.2",
                    "AES128-GCM-SHA256       TLSv1.2 Kx=RSA      Au=RSA  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_AES_128_CCM_8(
                    50380960,
                    "AES128-CCM8",
                    "TLSv1.2",
                    "AES128-CCM8             TLSv1.2 Kx=RSA      Au=RSA  Enc=AESCCM8(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_AES_128_CCM(
                    50380956,
                    "AES128-CCM",
                    "TLSv1.2",
                    "AES128-CCM              TLSv1.2 Kx=RSA      Au=RSA  Enc=AESCCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_ARIA_128_GCM_SHA256(
                    50380880,
                    "ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "ARIA128-GCM-SHA256      TLSv1.2 Kx=RSA      Au=RSA  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-rsa",
                    "auth-rsa"),
    TLS_PSK_WITH_AES_128_GCM_SHA256(
                    50331816,
                    "PSK-AES128-GCM-SHA256",
                    "TLSv1.2",
                    "PSK-AES128-GCM-SHA256   TLSv1.2 Kx=PSK      Au=PSK  Enc=AESGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-gcm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_AES_128_CCM_8(
                    50380968,
                    "PSK-AES128-CCM8",
                    "TLSv1.2",
                    "PSK-AES128-CCM8         TLSv1.2 Kx=PSK      Au=PSK  Enc=AESCCM8(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_AES_128_CCM(
                    50380964,
                    "PSK-AES128-CCM",
                    "TLSv1.2",
                    "PSK-AES128-CCM          TLSv1.2 Kx=PSK      Au=PSK  Enc=AESCCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aes-128-ccm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_ARIA_128_GCM_SHA256(
                    50380906,
                    "PSK-ARIA128-GCM-SHA256",
                    "TLSv1.2",
                    "PSK-ARIA128-GCM-SHA256  TLSv1.2 Kx=PSK      Au=PSK  Enc=ARIAGCM(128) Mac=AEAD",
                    128,
                    128,
                    true,
                    "aria-128-gcm",
                    null,
                    "kx-psk",
                    "auth-psk"),
    TLS_RSA_WITH_AES_256_CBC_SHA256(
                    50331709,
                    "AES256-SHA256",
                    "TLSv1.2",
                    "AES256-SHA256           TLSv1.2 Kx=RSA      Au=RSA  Enc=AES(256)  Mac=SHA256",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha256",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256(
                    50331840,
                    "CAMELLIA256-SHA256",
                    "TLSv1.2",
                    "CAMELLIA256-SHA256      TLSv1.2 Kx=RSA      Au=RSA  Enc=Camellia(256) Mac=SHA256",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha256",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_AES_128_CBC_SHA256(
                    50331708,
                    "AES128-SHA256",
                    "TLSv1.2",
                    "AES128-SHA256           TLSv1.2 Kx=RSA      Au=RSA  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256(
                    50331834,
                    "CAMELLIA128-SHA256",
                    "TLSv1.2",
                    "CAMELLIA128-SHA256      TLSv1.2 Kx=RSA      Au=RSA  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384(
                    50380856,
                    "ECDHE-PSK-AES256-CBC-SHA384",
                    "TLSv1.0",
                    "ECDHE-PSK-AES256-CBC-SHA384 TLSv1 Kx=ECDHEPSK Au=PSK  Enc=AES(256)  Mac=SHA384",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha384",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA(
                    50380854,
                    "ECDHE-PSK-AES256-CBC-SHA",
                    "TLSv1.0",
                    "ECDHE-PSK-AES256-CBC-SHA TLSv1 Kx=ECDHEPSK Au=PSK  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA(
                    50380834,
                    "SRP-DSS-AES-256-CBC-SHA",
                    "SSLv3",
                    "SRP-DSS-AES-256-CBC-SHA SSLv3 Kx=SRP      Au=DSS  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-srp",
                    "auth-dss"),
    TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA(
                    50380833,
                    "SRP-RSA-AES-256-CBC-SHA",
                    "SSLv3",
                    "SRP-RSA-AES-256-CBC-SHA SSLv3 Kx=SRP      Au=RSA  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-srp",
                    "auth-rsa"),
    TLS_SRP_SHA_WITH_AES_256_CBC_SHA(
                    50380832,
                    "SRP-AES-256-CBC-SHA",
                    "SSLv3",
                    "SRP-AES-256-CBC-SHA     SSLv3 Kx=SRP      Au=SRP  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-srp",
                    "auth-srp"),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384(
                    50331831,
                    "RSA-PSK-AES256-CBC-SHA384",
                    "TLSv1.0",
                    "RSA-PSK-AES256-CBC-SHA384 TLSv1 Kx=RSAPSK   Au=RSA  Enc=AES(256)  Mac=SHA384",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha384",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384(
                    50331827,
                    "DHE-PSK-AES256-CBC-SHA384",
                    "TLSv1.0",
                    "DHE-PSK-AES256-CBC-SHA384 TLSv1 Kx=DHEPSK   Au=PSK  Enc=AES(256)  Mac=SHA384",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha384",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA(
                    50331797,
                    "RSA-PSK-AES256-CBC-SHA",
                    "SSLv3",
                    "RSA-PSK-AES256-CBC-SHA  SSLv3 Kx=RSAPSK   Au=RSA  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA(
                    50331793,
                    "DHE-PSK-AES256-CBC-SHA",
                    "SSLv3",
                    "DHE-PSK-AES256-CBC-SHA  SSLv3 Kx=DHEPSK   Au=PSK  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384(
                    50380955,
                    "ECDHE-PSK-CAMELLIA256-SHA384",
                    "TLSv1.0",
                    "ECDHE-PSK-CAMELLIA256-SHA384 TLSv1 Kx=ECDHEPSK Au=PSK  Enc=Camellia(256) Mac=SHA384",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha384",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384(
                    50380953,
                    "RSA-PSK-CAMELLIA256-SHA384",
                    "TLSv1.0",
                    "RSA-PSK-CAMELLIA256-SHA384 TLSv1 Kx=RSAPSK   Au=RSA  Enc=Camellia(256) Mac=SHA384",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha384",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384(
                    50380951,
                    "DHE-PSK-CAMELLIA256-SHA384",
                    "TLSv1.0",
                    "DHE-PSK-CAMELLIA256-SHA384 TLSv1 Kx=DHEPSK   Au=PSK  Enc=Camellia(256) Mac=SHA384",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha384",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_WITH_AES_256_CBC_SHA(
                    50331701,
                    "AES256-SHA",
                    "SSLv3",
                    "AES256-SHA              SSLv3 Kx=RSA      Au=RSA  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA(
                    50331780,
                    "CAMELLIA256-SHA",
                    "SSLv3",
                    "CAMELLIA256-SHA         SSLv3 Kx=RSA      Au=RSA  Enc=Camellia(256) Mac=SHA1",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha1",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_PSK_WITH_AES_256_CBC_SHA384(
                    50331823,
                    "PSK-AES256-CBC-SHA384",
                    "TLSv1.0",
                    "PSK-AES256-CBC-SHA384   TLSv1 Kx=PSK      Au=PSK  Enc=AES(256)  Mac=SHA384",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha384",
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_AES_256_CBC_SHA(
                    50331789,
                    "PSK-AES256-CBC-SHA",
                    "SSLv3",
                    "PSK-AES256-CBC-SHA      SSLv3 Kx=PSK      Au=PSK  Enc=AES(256)  Mac=SHA1",
                    256,
                    256,
                    false,
                    "aes-256-cbc",
                    "sha1",
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384(
                    50380949,
                    "PSK-CAMELLIA256-SHA384",
                    "TLSv1.0",
                    "PSK-CAMELLIA256-SHA384  TLSv1 Kx=PSK      Au=PSK  Enc=Camellia(256) Mac=SHA384",
                    256,
                    256,
                    false,
                    "camellia-256-cbc",
                    "sha384",
                    "kx-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256(
                    50380855,
                    "ECDHE-PSK-AES128-CBC-SHA256",
                    "TLSv1.0",
                    "ECDHE-PSK-AES128-CBC-SHA256 TLSv1 Kx=ECDHEPSK Au=PSK  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA(
                    50380853,
                    "ECDHE-PSK-AES128-CBC-SHA",
                    "TLSv1.0",
                    "ECDHE-PSK-AES128-CBC-SHA TLSv1 Kx=ECDHEPSK Au=PSK  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA(
                    50380831,
                    "SRP-DSS-AES-128-CBC-SHA",
                    "SSLv3",
                    "SRP-DSS-AES-128-CBC-SHA SSLv3 Kx=SRP      Au=DSS  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-srp",
                    "auth-dss"),
    TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA(
                    50380830,
                    "SRP-RSA-AES-128-CBC-SHA",
                    "SSLv3",
                    "SRP-RSA-AES-128-CBC-SHA SSLv3 Kx=SRP      Au=RSA  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-srp",
                    "auth-rsa"),
    TLS_SRP_SHA_WITH_AES_128_CBC_SHA(
                    50380829,
                    "SRP-AES-128-CBC-SHA",
                    "SSLv3",
                    "SRP-AES-128-CBC-SHA     SSLv3 Kx=SRP      Au=SRP  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-srp",
                    "auth-srp"),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256(
                    50331830,
                    "RSA-PSK-AES128-CBC-SHA256",
                    "TLSv1.0",
                    "RSA-PSK-AES128-CBC-SHA256 TLSv1 Kx=RSAPSK   Au=RSA  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256(
                    50331826,
                    "DHE-PSK-AES128-CBC-SHA256",
                    "TLSv1.0",
                    "DHE-PSK-AES128-CBC-SHA256 TLSv1 Kx=DHEPSK   Au=PSK  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA(
                    50331796,
                    "RSA-PSK-AES128-CBC-SHA",
                    "SSLv3",
                    "RSA-PSK-AES128-CBC-SHA  SSLv3 Kx=RSAPSK   Au=RSA  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA(
                    50331792,
                    "DHE-PSK-AES128-CBC-SHA",
                    "SSLv3",
                    "DHE-PSK-AES128-CBC-SHA  SSLv3 Kx=DHEPSK   Au=PSK  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256(
                    50380954,
                    "ECDHE-PSK-CAMELLIA128-SHA256",
                    "TLSv1.0",
                    "ECDHE-PSK-CAMELLIA128-SHA256 TLSv1 Kx=ECDHEPSK Au=PSK  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256(
                    50380952,
                    "RSA-PSK-CAMELLIA128-SHA256",
                    "TLSv1.0",
                    "RSA-PSK-CAMELLIA128-SHA256 TLSv1 Kx=RSAPSK   Au=RSA  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256(
                    50380950,
                    "DHE-PSK-CAMELLIA128-SHA256",
                    "TLSv1.0",
                    "DHE-PSK-CAMELLIA128-SHA256 TLSv1 Kx=DHEPSK   Au=PSK  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_WITH_AES_128_CBC_SHA(
                    50331695,
                    "AES128-SHA",
                    "SSLv3",
                    "AES128-SHA              SSLv3 Kx=RSA      Au=RSA  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_SEED_CBC_SHA(50331798, "SEED-SHA", "SSLv3", "SEED-SHA                SSLv3 Kx=RSA      Au=RSA  Enc=SEED(128) Mac=SHA1", 128, 128, false, "seed-cbc", "sha1", "kx-rsa", "auth-rsa"),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA(
                    50331713,
                    "CAMELLIA128-SHA",
                    "SSLv3",
                    "CAMELLIA128-SHA         SSLv3 Kx=RSA      Au=RSA  Enc=Camellia(128) Mac=SHA1",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha1",
                    "kx-rsa",
                    "auth-rsa"),
    TLS_RSA_WITH_IDEA_CBC_SHA(50331655, "IDEA-CBC-SHA", "SSLv3", "IDEA-CBC-SHA            SSLv3 Kx=RSA      Au=RSA  Enc=IDEA(128) Mac=SHA1", 128, 128, false, "idea-cbc", "sha1", "kx-rsa", "auth-rsa"),
    TLS_PSK_WITH_AES_128_CBC_SHA256(
                    50331822,
                    "PSK-AES128-CBC-SHA256",
                    "TLSv1.0",
                    "PSK-AES128-CBC-SHA256   TLSv1 Kx=PSK      Au=PSK  Enc=AES(128)  Mac=SHA256",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha256",
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_AES_128_CBC_SHA(
                    50331788,
                    "PSK-AES128-CBC-SHA",
                    "SSLv3",
                    "PSK-AES128-CBC-SHA      SSLv3 Kx=PSK      Au=PSK  Enc=AES(128)  Mac=SHA1",
                    128,
                    128,
                    false,
                    "aes-128-cbc",
                    "sha1",
                    "kx-psk",
                    "auth-psk"),
    TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256(
                    50380948,
                    "PSK-CAMELLIA128-SHA256",
                    "TLSv1.0",
                    "PSK-CAMELLIA128-SHA256  TLSv1 Kx=PSK      Au=PSK  Enc=Camellia(128) Mac=SHA256",
                    128,
                    128,
                    false,
                    "camellia-128-cbc",
                    "sha256",
                    "kx-psk",
                    "auth-psk"),
    TLS_ECDHE_ECDSA_WITH_NULL_SHA(
                    50380806,
                    "ECDHE-ECDSA-NULL-SHA",
                    "TLSv1.0",
                    "ECDHE-ECDSA-NULL-SHA    TLSv1 Kx=ECDH     Au=ECDSA Enc=None      Mac=SHA1",
                    0,
                    0,
                    false,
                    null,
                    "sha1",
                    "kx-ecdhe",
                    "auth-ecdsa"),
    TLS_ECDHE_RSA_WITH_NULL_SHA(
                    50380816,
                    "ECDHE-RSA-NULL-SHA",
                    "TLSv1.0",
                    "ECDHE-RSA-NULL-SHA      TLSv1 Kx=ECDH     Au=RSA  Enc=None      Mac=SHA1",
                    0,
                    0,
                    false,
                    null,
                    "sha1",
                    "kx-ecdhe",
                    "auth-rsa"),
    TLS_ECDH_anon_WITH_NULL_SHA(50380821, "AECDH-NULL-SHA", "TLSv1.0", "AECDH-NULL-SHA          TLSv1 Kx=ECDH     Au=None Enc=None      Mac=SHA1", 0, 0, false, null, "sha1", "kx-ecdhe", "auth-null"),
    TLS_RSA_WITH_NULL_SHA256(50331707, "NULL-SHA256", "TLSv1.2", "NULL-SHA256             TLSv1.2 Kx=RSA      Au=RSA  Enc=None      Mac=SHA256", 0, 0, false, null, "sha256", "kx-rsa", "auth-rsa"),
    TLS_ECDHE_PSK_WITH_NULL_SHA384(
                    50380859,
                    "ECDHE-PSK-NULL-SHA384",
                    "TLSv1.0",
                    "ECDHE-PSK-NULL-SHA384   TLSv1 Kx=ECDHEPSK Au=PSK  Enc=None      Mac=SHA384",
                    0,
                    0,
                    false,
                    null,
                    "sha384",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_NULL_SHA256(
                    50380858,
                    "ECDHE-PSK-NULL-SHA256",
                    "TLSv1.0",
                    "ECDHE-PSK-NULL-SHA256   TLSv1 Kx=ECDHEPSK Au=PSK  Enc=None      Mac=SHA256",
                    0,
                    0,
                    false,
                    null,
                    "sha256",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_ECDHE_PSK_WITH_NULL_SHA(
                    50380857,
                    "ECDHE-PSK-NULL-SHA",
                    "TLSv1.0",
                    "ECDHE-PSK-NULL-SHA      TLSv1 Kx=ECDHEPSK Au=PSK  Enc=None      Mac=SHA1",
                    0,
                    0,
                    false,
                    null,
                    "sha1",
                    "kx-ecdhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_NULL_SHA384(
                    50331833,
                    "RSA-PSK-NULL-SHA384",
                    "TLSv1.0",
                    "RSA-PSK-NULL-SHA384     TLSv1 Kx=RSAPSK   Au=RSA  Enc=None      Mac=SHA384",
                    0,
                    0,
                    false,
                    null,
                    "sha384",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_RSA_PSK_WITH_NULL_SHA256(
                    50331832,
                    "RSA-PSK-NULL-SHA256",
                    "TLSv1.0",
                    "RSA-PSK-NULL-SHA256     TLSv1 Kx=RSAPSK   Au=RSA  Enc=None      Mac=SHA256",
                    0,
                    0,
                    false,
                    null,
                    "sha256",
                    "kx-rsa-psk",
                    "auth-rsa"),
    TLS_DHE_PSK_WITH_NULL_SHA384(
                    50331829,
                    "DHE-PSK-NULL-SHA384",
                    "TLSv1.0",
                    "DHE-PSK-NULL-SHA384     TLSv1 Kx=DHEPSK   Au=PSK  Enc=None      Mac=SHA384",
                    0,
                    0,
                    false,
                    null,
                    "sha384",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_DHE_PSK_WITH_NULL_SHA256(
                    50331828,
                    "DHE-PSK-NULL-SHA256",
                    "TLSv1.0",
                    "DHE-PSK-NULL-SHA256     TLSv1 Kx=DHEPSK   Au=PSK  Enc=None      Mac=SHA256",
                    0,
                    0,
                    false,
                    null,
                    "sha256",
                    "kx-dhe-psk",
                    "auth-psk"),
    TLS_RSA_PSK_WITH_NULL_SHA(50331694, "RSA-PSK-NULL-SHA", "SSLv3", "RSA-PSK-NULL-SHA        SSLv3 Kx=RSAPSK   Au=RSA  Enc=None      Mac=SHA1", 0, 0, false, null, "sha1", "kx-rsa-psk", "auth-rsa"),
    TLS_DHE_PSK_WITH_NULL_SHA(50331693, "DHE-PSK-NULL-SHA", "SSLv3", "DHE-PSK-NULL-SHA        SSLv3 Kx=DHEPSK   Au=PSK  Enc=None      Mac=SHA1", 0, 0, false, null, "sha1", "kx-dhe-psk", "auth-psk"),
    TLS_RSA_WITH_NULL_SHA(50331650, "NULL-SHA", "SSLv3", "NULL-SHA                SSLv3 Kx=RSA      Au=RSA  Enc=None      Mac=SHA1", 0, 0, false, null, "sha1", "kx-rsa", "auth-rsa"),
    TLS_RSA_WITH_NULL_MD5(50331649, "NULL-MD5", "SSLv3", "NULL-MD5                SSLv3 Kx=RSA      Au=RSA  Enc=None      Mac=MD5 ", 0, 0, false, null, "md5", "kx-rsa", "auth-rsa"),
    TLS_PSK_WITH_NULL_SHA384(50331825, "PSK-NULL-SHA384", "TLSv1.0", "PSK-NULL-SHA384         TLSv1 Kx=PSK      Au=PSK  Enc=None      Mac=SHA384", 0, 0, false, null, "sha384", "kx-psk", "auth-psk"),
    TLS_PSK_WITH_NULL_SHA256(50331824, "PSK-NULL-SHA256", "TLSv1.0", "PSK-NULL-SHA256         TLSv1 Kx=PSK      Au=PSK  Enc=None      Mac=SHA256", 0, 0, false, null, "sha256", "kx-psk", "auth-psk"),
    TLS_PSK_WITH_NULL_SHA(50331692, "PSK-NULL-SHA", "SSLv3", "PSK-NULL-SHA            SSLv3 Kx=PSK      Au=PSK  Enc=None      Mac=SHA1", 0, 0, false, null, "sha1", "kx-psk", "auth-psk");

    private final int opensslId;
    private final TruffleString opensslName;
    private final TruffleString protocol;
    private final TruffleString description;
    private final int strengthBits;
    private final int algorithmBits;
    private final boolean aead;
    private final TruffleString symmetric;
    private final TruffleString digest;
    private final TruffleString kea;
    private final TruffleString auth;

    private static final TruffleString T_ID = tsLiteral("id");
    private static final TruffleString T_NAME = tsLiteral("name");
    private static final TruffleString T_PROTOCOL = tsLiteral("protocol");
    private static final TruffleString T_DESCRIPTION = tsLiteral("description");
    private static final TruffleString T_STRENGTH_BITS = tsLiteral("strength_bits");
    private static final TruffleString T_ALG_BITS = tsLiteral("alg_bits");
    private static final TruffleString T_AEAD = tsLiteral("aead");
    private static final TruffleString T_SYMMETRIC = tsLiteral("symmetric");
    private static final TruffleString T_DIGEST = tsLiteral("digest");
    private static final TruffleString T_KEA = tsLiteral("kea");
    private static final TruffleString T_AUTH = tsLiteral("auth");

    SSLCipher(int opensslId, String opensslName, String protocol, String description, int strengthBits, int algorithmBits, boolean aead, String symmetric, String digest, String kea, String auth) {
        this.opensslId = opensslId;
        this.opensslName = toTruffleStringUncached(opensslName);
        this.protocol = toTruffleStringUncached(protocol);
        this.description = toTruffleStringUncached(description);
        this.strengthBits = strengthBits;
        this.algorithmBits = algorithmBits;
        this.aead = aead;
        this.symmetric = toTruffleStringUncached(symmetric);
        this.digest = toTruffleStringUncached(digest);
        this.kea = toTruffleStringUncached(kea);
        this.auth = toTruffleStringUncached(auth);

    }

    public PKeyword[] asKeywords() {
        return new PKeyword[]{new PKeyword(T_ID, getOpensslId()),
                        new PKeyword(T_NAME, getOpensslName() != null ? getOpensslName() : PNone.NONE),
                        new PKeyword(T_PROTOCOL, getProtocol() != null ? getProtocol() : PNone.NONE),
                        new PKeyword(T_DESCRIPTION, getDescription() != null ? getDescription() : PNone.NONE),
                        new PKeyword(T_STRENGTH_BITS, getStrengthBits()),
                        new PKeyword(T_ALG_BITS, getAlgorithmBits()),
                        new PKeyword(T_AEAD, getAead()),
                        new PKeyword(T_SYMMETRIC, getSymmetric() != null ? getSymmetric() : PNone.NONE),
                        new PKeyword(T_DIGEST, getDigest() != null ? getDigest() : PNone.NONE),
                        new PKeyword(T_KEA, getKea() != null ? getKea() : PNone.NONE),
                        new PKeyword(T_AUTH, getAuth() != null ? getAuth() : PNone.NONE)
        };
    }

    public int getOpensslId() {
        return opensslId;
    }

    public TruffleString getOpensslName() {
        return opensslName;
    }

    public TruffleString getProtocol() {
        return protocol;
    }

    public TruffleString getDescription() {
        return description;
    }

    public int getStrengthBits() {
        return strengthBits;
    }

    public int getAlgorithmBits() {
        return algorithmBits;
    }

    public boolean getAead() {
        return aead;
    }

    public TruffleString getSymmetric() {
        return symmetric;
    }

    public TruffleString getDigest() {
        return digest;
    }

    public TruffleString getKea() {
        return kea;
    }

    public TruffleString getAuth() {
        return auth;
    }

}
