// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.CmpNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ConcatNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ItemIndexNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.RepeatNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.SequenceStorageMpSubscriptNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.ItemIndexNodeGen;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.SequenceStorageMpSubscriptNodeGen;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.AbstractCmpNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ClassGetItemNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.CountNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GeNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetNewargsNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GtNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.HashNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.IndexNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.LeNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.LenNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.LtNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.MulNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.NeNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.RichCompareNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.TupleConcatNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.TupleSqItem;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNodeGen;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNodeGen;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.lib.PyTupleCheckNodeGen;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyTupleGetItemNodeGen;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.lib.PyTupleSizeNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes.GetNativeTupleStorage;
import com.oracle.graal.python.nodes.builtins.TupleNodes.GetTupleStorage;
import com.oracle.graal.python.nodes.builtins.TupleNodesFactory.GetNativeTupleStorageNodeGen;
import com.oracle.graal.python.nodes.builtins.TupleNodesFactory.GetTupleStorageNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendStringNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.ToStringNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;

@GeneratedBy(TupleBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class TupleBuiltinsFactory {

    @CompilationFinal(dimensions = 1) private static final ComparisonOp[] COMPARISON_OP_VALUES = DSLSupport.lookupEnumConstants(ComparisonOp.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(IndexNodeFactory.getInstance(), CountNodeFactory.getInstance(), LenNodeFactory.getInstance(), ReprNodeFactory.getInstance(), TupleSqItemFactory.getInstance(), GetItemNodeFactory.getInstance(), EqNodeFactory.getInstance(), NeNodeFactory.getInstance(), GeNodeFactory.getInstance(), LeNodeFactory.getInstance(), GtNodeFactory.getInstance(), LtNodeFactory.getInstance(), RichCompareNodeFactory.getInstance(), TupleConcatNodeFactory.getInstance(), MulNodeFactory.getInstance(), ContainsNodeFactory.getInstance(), IterNodeFactory.getInstance(), HashNodeFactory.getInstance(), GetNewargsNodeFactory.getInstance(), ClassGetItemNodeFactory.getInstance());
    }

    private static ComparisonOp decodeComparisonOp(int state) {
        if (state >= 0) {
            return COMPARISON_OP_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeComparisonOp(ComparisonOp e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    @GeneratedBy(IndexNode.class)
    public static final class IndexNodeFactory implements NodeFactory<IndexNode> {

        private static final IndexNodeFactory INDEX_NODE_FACTORY_INSTANCE = new IndexNodeFactory();

        private IndexNodeFactory() {
        }

        @Override
        public Class<IndexNode> getNodeClass() {
            return IndexNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IndexNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IndexNode> getInstance() {
            return INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IndexNode create() {
            return new IndexNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IndexNode#index}
         *     Activation probability: 1.00000
         *     With/without class size: 36/14 bytes
         * </pre> */
        @GeneratedBy(IndexNode.class)
        @SuppressWarnings("javadoc")
        public static final class IndexNodeGen extends IndexNode {

            private static final StateField STATE_0_IndexNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_IndexNode_UPDATER.subUpdater(5, 2), ReferenceField.create(MethodHandles.lookup(), "getTupleStorage__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link InlinedBranchProfile} startLe0Profile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_START_LE0PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_IndexNode_UPDATER.subUpdater(7, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link InlinedBranchProfile} endLe0Profile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_END_LE0PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_IndexNode_UPDATER.subUpdater(8, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link ItemIndexNode} itemIndexNode
             *   Inline method: {@link ItemIndexNodeGen#inline}</pre> */
            private static final ItemIndexNode INLINED_ITEM_INDEX_NODE_ = ItemIndexNodeGen.inline(InlineTarget.create(ItemIndexNode.class, STATE_0_IndexNode_UPDATER.subUpdater(9, 6), ReferenceField.create(MethodHandles.lookup(), "itemIndexNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.nodes.PRaiseNode.Lazy INLINED_RAISE_NODE_ = com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.nodes.PRaiseNode.Lazy.class, STATE_0_IndexNode_UPDATER.subUpdater(15, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexNode#index}
             *   1-2: ImplicitCast[type=int, index=2]
             *   3-4: ImplicitCast[type=int, index=3]
             *   5-6: InlinedCache
             *        Specialization: {@link IndexNode#index}
             *        Parameter: {@link GetTupleStorage} getTupleStorage
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   7: InlinedCache
             *        Specialization: {@link IndexNode#index}
             *        Parameter: {@link InlinedBranchProfile} startLe0Profile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   8: InlinedCache
             *        Specialization: {@link IndexNode#index}
             *        Parameter: {@link InlinedBranchProfile} endLe0Profile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   9-14: InlinedCache
             *        Specialization: {@link IndexNode#index}
             *        Parameter: {@link ItemIndexNode} itemIndexNode
             *        Inline method: {@link ItemIndexNodeGen#inline}
             *   15: InlinedCache
             *        Specialization: {@link IndexNode#index}
             *        Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *        Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getTupleStorage__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link ItemIndexNode} itemIndexNode
             *   Inline method: {@link ItemIndexNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node itemIndexNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#index}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private IndexNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.IndexNode.index(VirtualFrame, Object, Object, int, int, Node, GetTupleStorage, InlinedBranchProfile, InlinedBranchProfile, ItemIndexNode, Lazy)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b110) >>> 1 /* get-int ImplicitCast[type=int, index=2] */, arg2Value)) {
                    int arg2Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b110) >>> 1 /* get-int ImplicitCast[type=int, index=2] */, arg2Value);
                    if (PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=3] */, arg3Value)) {
                        int arg3Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=3] */, arg3Value);
                        {
                            Node inliningTarget__ = (this);
                            return index(frameValue, arg0Value, arg1Value, arg2Value_, arg3Value_, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, INLINED_START_LE0PROFILE_, INLINED_END_LE0PROFILE_, INLINED_ITEM_INDEX_NODE_, INLINED_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    int intCast2;
                    if ((intCast2 = PythonArithmeticTypesGen.specializeImplicitInteger(arg2Value)) != 0) {
                        int arg2Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast2, arg2Value);
                        int intCast3;
                        if ((intCast3 = PythonArithmeticTypesGen.specializeImplicitInteger(arg3Value)) != 0) {
                            int arg3Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast3, arg3Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (intCast2 << 1) /* set-int ImplicitCast[type=int, index=2] */);
                            state_0 = (state_0 | (intCast3 << 3) /* set-int ImplicitCast[type=int, index=3] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.IndexNode.index(VirtualFrame, Object, Object, int, int, Node, GetTupleStorage, InlinedBranchProfile, InlinedBranchProfile, ItemIndexNode, Lazy)] */;
                            this.state_0_ = state_0;
                            return index(frameValue, arg0Value, arg1Value, arg2Value_, arg3Value_, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, INLINED_START_LE0PROFILE_, INLINED_END_LE0PROFILE_, INLINED_ITEM_INDEX_NODE_, INLINED_RAISE_NODE_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
            }

        }
    }
    @GeneratedBy(CountNode.class)
    public static final class CountNodeFactory implements NodeFactory<CountNode> {

        private static final CountNodeFactory COUNT_NODE_FACTORY_INSTANCE = new CountNodeFactory();

        private CountNodeFactory() {
        }

        @Override
        public Class<CountNode> getNodeClass() {
            return CountNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public CountNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<CountNode> getInstance() {
            return COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CountNode create() {
            return new CountNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CountNode#count}
         *     Activation probability: 1.00000
         *     With/without class size: 40/20 bytes
         * </pre> */
        @GeneratedBy(CountNode.class)
        @SuppressWarnings("javadoc")
        public static final class CountNodeGen extends CountNode {

            private static final StateField STATE_0_CountNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link CountNode#count}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_CountNode_UPDATER.subUpdater(1, 2), ReferenceField.create(MethodHandles.lookup(), "getTupleStorage__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link CountNode#count}
             *   Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *   Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode INLINED_EQ_NODE_ = com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen.inline(InlineTarget.create(com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode.class, STATE_0_CountNode_UPDATER.subUpdater(3, 25), ReferenceField.create(MethodHandles.lookup(), "eqNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eqNode__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CountNode#count}
             *   1-2: InlinedCache
             *        Specialization: {@link CountNode#count}
             *        Parameter: {@link GetTupleStorage} getTupleStorage
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   3-27: InlinedCache
             *        Specialization: {@link CountNode#count}
             *        Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *        Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CountNode#count}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getTupleStorage__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CountNode#count}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode} getItemNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItemNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CountNode#count}
             *   Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *   Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eqNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CountNode#count}
             *   Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *   Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eqNode__field2_;

            private CountNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.CountNode.count(VirtualFrame, Object, Object, Node, GetTupleStorage, GetItemNode, EqNode)] */) {
                    {
                        com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItemNode__ = this.getItemNode_;
                        if (getItemNode__ != null) {
                            Node inliningTarget__ = (this);
                            return count(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_EQ_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItemNode__ = this.insert((com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode.createNotNormalized()));
                    Objects.requireNonNull(getItemNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getItemNode_ = getItemNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.CountNode.count(VirtualFrame, Object, Object, Node, GetTupleStorage, GetItemNode, EqNode)] */;
                    this.state_0_ = state_0;
                    return count(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_EQ_NODE_);
                }
            }

        }
    }
    @GeneratedBy(LenNode.class)
    public static final class LenNodeFactory implements NodeFactory<LenNode> {

        private static final LenNodeFactory LEN_NODE_FACTORY_INSTANCE = new LenNodeFactory();

        private LenNodeFactory() {
        }

        @Override
        public Class<LenNode> getNodeClass() {
            return LenNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public LenNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public LenNode getUncachedInstance() {
            return LenNodeGen.UNCACHED;
        }

        public static NodeFactory<LenNode> getInstance() {
            return LEN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LenNode create() {
            return new LenNodeGen();
        }

        @NeverDefault
        public static LenNode getUncached() {
            return LenNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LenNode#len}
         *     Activation probability: 1.00000
         *     With/without class size: 32/9 bytes
         * </pre> */
        @GeneratedBy(LenNode.class)
        @SuppressWarnings("javadoc")
        public static final class LenNodeGen extends LenNode {

            private static final StateField STATE_0_LenNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link LenNode#len}
             *   Parameter: {@link PyTupleSizeNode} pyTupleSizeNode
             *   Inline method: {@link PyTupleSizeNodeGen#inline}</pre> */
            private static final PyTupleSizeNode INLINED_PY_TUPLE_SIZE_NODE_ = PyTupleSizeNodeGen.inline(InlineTarget.create(PyTupleSizeNode.class, STATE_0_LenNode_UPDATER.subUpdater(0, 3), ReferenceField.create(MethodHandles.lookup(), "pyTupleSizeNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "pyTupleSizeNode__field2_", Node.class)));
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0-2: InlinedCache
             *        Specialization: {@link LenNode#len}
             *        Parameter: {@link PyTupleSizeNode} pyTupleSizeNode
             *        Inline method: {@link PyTupleSizeNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LenNode#len}
             *   Parameter: {@link PyTupleSizeNode} pyTupleSizeNode
             *   Inline method: {@link PyTupleSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node pyTupleSizeNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LenNode#len}
             *   Parameter: {@link PyTupleSizeNode} pyTupleSizeNode
             *   Inline method: {@link PyTupleSizeNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node pyTupleSizeNode__field2_;

            private LenNodeGen() {
            }

            @Override
            public int executeInt(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return len(arg0Value, inliningTarget__, INLINED_PY_TUPLE_SIZE_NODE_);
                }
            }

            @GeneratedBy(LenNode.class)
            @DenyReplace
            private static final class Uncached extends LenNode implements UnadoptableNode {

                @Override
                public int executeInt(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return len(arg0Value, (this), (PyTupleSizeNodeGen.getUncached()));
                }

            }
        }
    }
    @GeneratedBy(ReprNode.class)
    public static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#repr}
         *     Activation probability: 1.00000
         *     With/without class size: 76/56 bytes
         * </pre> */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        public static final class ReprNodeGen extends ReprNode {

            private static final StateField STATE_0_ReprNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_ReprNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_ReprNode_UPDATER.subUpdater(1, 2), ReferenceField.create(MethodHandles.lookup(), "getTupleStorage__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}</pre> */
            private static final PyObjectReprAsTruffleStringNode INLINED_REPR_NODE_ = PyObjectReprAsTruffleStringNodeGen.inline(InlineTarget.create(PyObjectReprAsTruffleStringNode.class, STATE_1_ReprNode_UPDATER.subUpdater(0, 30), ReferenceField.create(MethodHandles.lookup(), "reprNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field6_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field7_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field8_", Node.class), ReferenceField.create(MethodHandles.lookup(), "reprNode__field9_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReprNode#repr}
             *   1-2: InlinedCache
             *        Specialization: {@link ReprNode#repr}
             *        Parameter: {@link GetTupleStorage} getTupleStorage
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-29: InlinedCache
             *        Specialization: {@link ReprNode#repr}
             *        Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *        Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getTupleStorage__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode} getItemNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItemNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field5</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field6</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field6_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field7</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field7_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field8</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field8_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link PyObjectReprAsTruffleStringNode} reprNode
             *   Inline method: {@link PyObjectReprAsTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field9</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reprNode__field9_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link AppendStringNode} appendStringNode</pre> */
            @Child private AppendStringNode appendStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link ToStringNode} toStringNode</pre> */
            @Child private ToStringNode toStringNode_;

            private ReprNodeGen() {
            }

            @Override
            public TruffleString execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.ReprNode.repr(VirtualFrame, Object, Node, GetTupleStorage, GetItemNode, PyObjectReprAsTruffleStringNode, AppendStringNode, ToStringNode)] */) {
                    {
                        com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItemNode__ = this.getItemNode_;
                        if (getItemNode__ != null) {
                            AppendStringNode appendStringNode__ = this.appendStringNode_;
                            if (appendStringNode__ != null) {
                                ToStringNode toStringNode__ = this.toStringNode_;
                                if (toStringNode__ != null) {
                                    Node inliningTarget__ = (this);
                                    return ReprNode.repr(frameValue, arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_REPR_NODE_, appendStringNode__, toStringNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItemNode__ = this.insert((com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode.createNotNormalized()));
                    Objects.requireNonNull(getItemNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getItemNode_ = getItemNode__;
                    AppendStringNode appendStringNode__ = this.insert((AppendStringNode.create()));
                    Objects.requireNonNull(appendStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.appendStringNode_ = appendStringNode__;
                    ToStringNode toStringNode__ = this.insert((ToStringNode.create()));
                    Objects.requireNonNull(toStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.toStringNode_ = toStringNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.ReprNode.repr(VirtualFrame, Object, Node, GetTupleStorage, GetItemNode, PyObjectReprAsTruffleStringNode, AppendStringNode, ToStringNode)] */;
                    this.state_0_ = state_0;
                    return ReprNode.repr(frameValue, arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_REPR_NODE_, appendStringNode__, toStringNode__);
                }
            }

        }
    }
    @GeneratedBy(TupleSqItem.class)
    public static final class TupleSqItemFactory implements NodeFactory<TupleSqItem> {

        private static final TupleSqItemFactory TUPLE_SQ_ITEM_FACTORY_INSTANCE = new TupleSqItemFactory();

        private TupleSqItemFactory() {
        }

        @Override
        public Class<TupleSqItem> getNodeClass() {
            return TupleSqItem.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TupleSqItem createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<TupleSqItem> getInstance() {
            return TUPLE_SQ_ITEM_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleSqItem create() {
            return new TupleSqItemNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TupleSqItem#doIt}
         *     Activation probability: 1.00000
         *     With/without class size: 40/18 bytes
         * </pre> */
        @GeneratedBy(TupleSqItem.class)
        @SuppressWarnings("javadoc")
        public static final class TupleSqItemNodeGen extends TupleSqItem {

            private static final StateField STATE_0_TupleSqItem_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleSqItem#doIt}
             *   Parameter: {@link PyTupleGetItem} getItem
             *   Inline method: {@link PyTupleGetItemNodeGen#inline}</pre> */
            private static final PyTupleGetItem INLINED_GET_ITEM_ = PyTupleGetItemNodeGen.inline(InlineTarget.create(PyTupleGetItem.class, STATE_0_TupleSqItem_UPDATER.subUpdater(0, 13), ReferenceField.create(MethodHandles.lookup(), "getItem__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItem__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItem__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItem__field4_", Node.class)));

            /**
             * State Info: <pre>
             *   0-12: InlinedCache
             *        Specialization: {@link TupleSqItem#doIt}
             *        Parameter: {@link PyTupleGetItem} getItem
             *        Inline method: {@link PyTupleGetItemNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleSqItem#doIt}
             *   Parameter: {@link PyTupleGetItem} getItem
             *   Inline method: {@link PyTupleGetItemNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleSqItem#doIt}
             *   Parameter: {@link PyTupleGetItem} getItem
             *   Inline method: {@link PyTupleGetItemNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleSqItem#doIt}
             *   Parameter: {@link PyTupleGetItem} getItem
             *   Inline method: {@link PyTupleGetItemNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleSqItem#doIt}
             *   Parameter: {@link PyTupleGetItem} getItem
             *   Inline method: {@link PyTupleGetItemNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field4_;

            private TupleSqItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, int arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    return TupleSqItem.doIt(arg0Value, arg1Value, inliningTarget__, INLINED_GET_ITEM_);
                }
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode.class)
    public static final class GetItemNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode> {

        private static final GetItemNodeFactory GET_ITEM_NODE_FACTORY_INSTANCE = new GetItemNodeFactory();

        private GetItemNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode> getInstance() {
            return GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode create() {
            return new GetItemNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
         *     Activation probability: 1.00000
         *     With/without class size: 60/40 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetItemNodeGen extends com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode {

            private static final StateField STATE_0_GetItemNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_VALID_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_GetItemNode_UPDATER.subUpdater(0, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link PyIndexCheckNode} indexCheckNode
             *   Inline method: {@link PyIndexCheckNodeGen#inline}</pre> */
            private static final PyIndexCheckNode INLINED_INDEX_CHECK_NODE_ = PyIndexCheckNodeGen.inline(InlineTarget.create(PyIndexCheckNode.class, STATE_0_GetItemNode_UPDATER.subUpdater(2, 7), ReferenceField.create(MethodHandles.lookup(), "indexCheckNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.nodes.PRaiseNode.Lazy INLINED_RAISE_NODE_ = com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.nodes.PRaiseNode.Lazy.class, STATE_0_GetItemNode_UPDATER.subUpdater(9, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_GetItemNode_UPDATER.subUpdater(10, 2), ReferenceField.create(MethodHandles.lookup(), "getTupleStorage__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}</pre> */
            private static final SequenceStorageMpSubscriptNode INLINED_SUBSCRIPT_NODE_ = SequenceStorageMpSubscriptNodeGen.inline(InlineTarget.create(SequenceStorageMpSubscriptNode.class, STATE_0_GetItemNode_UPDATER.subUpdater(12, 20), ReferenceField.create(MethodHandles.lookup(), "subscriptNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "subscriptNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "subscriptNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "subscriptNode__field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "subscriptNode__field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "subscriptNode__field6_", Node.class)));

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-8: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *        Parameter: {@link PyIndexCheckNode} indexCheckNode
             *        Inline method: {@link PyIndexCheckNodeGen#inline}
             *   9: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *        Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *        Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *        Parameter: {@link GetTupleStorage} getTupleStorage
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   12-31: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *        Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *        Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link PyIndexCheckNode} indexCheckNode
             *   Inline method: {@link PyIndexCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node indexCheckNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getTupleStorage__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node subscriptNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node subscriptNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node subscriptNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node subscriptNode__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             *   Inline field: {@link Node} field5</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node subscriptNode__field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode#doIt}
             *   Parameter: {@link SequenceStorageMpSubscriptNode} subscriptNode
             *   Inline method: {@link SequenceStorageMpSubscriptNodeGen#inline}
             *   Inline field: {@link Node} field6</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node subscriptNode__field6_;

            private GetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    return com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode.doIt(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_VALID_PROFILE_, INLINED_INDEX_CHECK_NODE_, INLINED_RAISE_NODE_, INLINED_GET_TUPLE_STORAGE_, INLINED_SUBSCRIPT_NODE_);
                }
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode.class)
    static final class EqNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode> {

        private static final EqNodeFactory EQ_NODE_FACTORY_INSTANCE = new EqNodeFactory();

        private EqNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode> getInstance() {
            return EQ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode create() {
            return new com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory.EqNodeFactory.EqNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbstractCmpNode#doPTuple}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AbstractCmpNode#doTuple}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link AbstractCmpNode#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode.class)
        @SuppressWarnings("javadoc")
        static final class EqNodeGen extends com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.EqNode {

            private static final StateField STATE_0_EqNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, STATE_0_EqNode_UPDATER.subUpdater(4, 3), ReferenceField.create(MethodHandles.lookup(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_EqNode_UPDATER.subUpdater(7, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_EqNode_UPDATER.subUpdater(9, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbstractCmpNode#doPTuple}
             *   1: SpecializationActive {@link AbstractCmpNode#doTuple}
             *   2: GuardActive[guardIndex=0] {@link AbstractCmpNode#doTuple}
             *   3: SpecializationActive {@link AbstractCmpNode#doOther}
             *   4-6: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link PyTupleCheckNode} checkRight
             *        Inline method: {@link PyTupleCheckNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getRight
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doPTuple}
             *   Parameter: {@link CmpNode} cmp</pre> */
            @Child private CmpNode cmp;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;

            private EqNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) && (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */ || inliningTarget__ == null || checkRight__ == null || (checkRight__.execute(inliningTarget__, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1011) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            {
                                CmpNode cmp_ = this.cmp;
                                if (cmp_ != null) {
                                    return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1010) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            {
                                CmpNode cmp_1 = this.cmp;
                                if (cmp_1 != null) {
                                    Node inliningTarget__ = (this);
                                    if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                        return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return AbstractCmpNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        CmpNode cmp_;
                        CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = this.insert((createCmp()));
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                        this.state_0_ = state_0;
                        return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        boolean Tuple_duplicateFound_ = false;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            CmpNode cmp_1 = this.cmp;
                            if (cmp_1 != null) {
                                inliningTarget__ = (this);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (!Tuple_duplicateFound_) {
                            {
                                inliningTarget__ = (this);
                                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */) {
                                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */;
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) && ((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                                    CmpNode cmp_1;
                                    CmpNode cmp_1_shared = this.cmp;
                                    if (cmp_1_shared != null) {
                                        cmp_1 = cmp_1_shared;
                                    } else {
                                        cmp_1 = this.insert((createCmp()));
                                        if (cmp_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.cmp == null) {
                                        this.cmp = cmp_1;
                                    }
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                    this.state_0_ = state_0;
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Tuple_duplicateFound_) {
                            return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                        }
                        break;
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */;
                this.state_0_ = state_0;
                return AbstractCmpNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(NeNode.class)
    static final class NeNodeFactory implements NodeFactory<NeNode> {

        private static final NeNodeFactory NE_NODE_FACTORY_INSTANCE = new NeNodeFactory();

        private NeNodeFactory() {
        }

        @Override
        public Class<NeNode> getNodeClass() {
            return NeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NeNode> getInstance() {
            return NE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NeNode create() {
            return new NeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbstractCmpNode#doPTuple}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AbstractCmpNode#doTuple}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link AbstractCmpNode#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(NeNode.class)
        @SuppressWarnings("javadoc")
        static final class NeNodeGen extends NeNode {

            private static final StateField STATE_0_NeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, STATE_0_NeNode_UPDATER.subUpdater(4, 3), ReferenceField.create(MethodHandles.lookup(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_NeNode_UPDATER.subUpdater(7, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_NeNode_UPDATER.subUpdater(9, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbstractCmpNode#doPTuple}
             *   1: SpecializationActive {@link AbstractCmpNode#doTuple}
             *   2: GuardActive[guardIndex=0] {@link AbstractCmpNode#doTuple}
             *   3: SpecializationActive {@link AbstractCmpNode#doOther}
             *   4-6: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link PyTupleCheckNode} checkRight
             *        Inline method: {@link PyTupleCheckNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getRight
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doPTuple}
             *   Parameter: {@link CmpNode} cmp</pre> */
            @Child private CmpNode cmp;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;

            private NeNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) && (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */ || inliningTarget__ == null || checkRight__ == null || (checkRight__.execute(inliningTarget__, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1011) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            {
                                CmpNode cmp_ = this.cmp;
                                if (cmp_ != null) {
                                    return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1010) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            {
                                CmpNode cmp_1 = this.cmp;
                                if (cmp_1 != null) {
                                    Node inliningTarget__ = (this);
                                    if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                        return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return AbstractCmpNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        CmpNode cmp_;
                        CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = this.insert((createCmp()));
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                        this.state_0_ = state_0;
                        return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        boolean Tuple_duplicateFound_ = false;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            CmpNode cmp_1 = this.cmp;
                            if (cmp_1 != null) {
                                inliningTarget__ = (this);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (!Tuple_duplicateFound_) {
                            {
                                inliningTarget__ = (this);
                                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */) {
                                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */;
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) && ((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                                    CmpNode cmp_1;
                                    CmpNode cmp_1_shared = this.cmp;
                                    if (cmp_1_shared != null) {
                                        cmp_1 = cmp_1_shared;
                                    } else {
                                        cmp_1 = this.insert((createCmp()));
                                        if (cmp_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.cmp == null) {
                                        this.cmp = cmp_1;
                                    }
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                    this.state_0_ = state_0;
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Tuple_duplicateFound_) {
                            return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                        }
                        break;
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */;
                this.state_0_ = state_0;
                return AbstractCmpNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(GeNode.class)
    static final class GeNodeFactory implements NodeFactory<GeNode> {

        private static final GeNodeFactory GE_NODE_FACTORY_INSTANCE = new GeNodeFactory();

        private GeNodeFactory() {
        }

        @Override
        public Class<GeNode> getNodeClass() {
            return GeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GeNode> getInstance() {
            return GE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GeNode create() {
            return new GeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbstractCmpNode#doPTuple}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AbstractCmpNode#doTuple}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link AbstractCmpNode#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(GeNode.class)
        @SuppressWarnings("javadoc")
        static final class GeNodeGen extends GeNode {

            private static final StateField STATE_0_GeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, STATE_0_GeNode_UPDATER.subUpdater(4, 3), ReferenceField.create(MethodHandles.lookup(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_GeNode_UPDATER.subUpdater(7, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_GeNode_UPDATER.subUpdater(9, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbstractCmpNode#doPTuple}
             *   1: SpecializationActive {@link AbstractCmpNode#doTuple}
             *   2: GuardActive[guardIndex=0] {@link AbstractCmpNode#doTuple}
             *   3: SpecializationActive {@link AbstractCmpNode#doOther}
             *   4-6: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link PyTupleCheckNode} checkRight
             *        Inline method: {@link PyTupleCheckNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getRight
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doPTuple}
             *   Parameter: {@link CmpNode} cmp</pre> */
            @Child private CmpNode cmp;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;

            private GeNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) && (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */ || inliningTarget__ == null || checkRight__ == null || (checkRight__.execute(inliningTarget__, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1011) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            {
                                CmpNode cmp_ = this.cmp;
                                if (cmp_ != null) {
                                    return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1010) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            {
                                CmpNode cmp_1 = this.cmp;
                                if (cmp_1 != null) {
                                    Node inliningTarget__ = (this);
                                    if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                        return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return AbstractCmpNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        CmpNode cmp_;
                        CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = this.insert((createCmp()));
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                        this.state_0_ = state_0;
                        return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        boolean Tuple_duplicateFound_ = false;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            CmpNode cmp_1 = this.cmp;
                            if (cmp_1 != null) {
                                inliningTarget__ = (this);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (!Tuple_duplicateFound_) {
                            {
                                inliningTarget__ = (this);
                                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */) {
                                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */;
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) && ((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                                    CmpNode cmp_1;
                                    CmpNode cmp_1_shared = this.cmp;
                                    if (cmp_1_shared != null) {
                                        cmp_1 = cmp_1_shared;
                                    } else {
                                        cmp_1 = this.insert((createCmp()));
                                        if (cmp_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.cmp == null) {
                                        this.cmp = cmp_1;
                                    }
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                    this.state_0_ = state_0;
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Tuple_duplicateFound_) {
                            return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                        }
                        break;
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */;
                this.state_0_ = state_0;
                return AbstractCmpNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(LeNode.class)
    static final class LeNodeFactory implements NodeFactory<LeNode> {

        private static final LeNodeFactory LE_NODE_FACTORY_INSTANCE = new LeNodeFactory();

        private LeNodeFactory() {
        }

        @Override
        public Class<LeNode> getNodeClass() {
            return LeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public LeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<LeNode> getInstance() {
            return LE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LeNode create() {
            return new LeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbstractCmpNode#doPTuple}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AbstractCmpNode#doTuple}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link AbstractCmpNode#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(LeNode.class)
        @SuppressWarnings("javadoc")
        static final class LeNodeGen extends LeNode {

            private static final StateField STATE_0_LeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, STATE_0_LeNode_UPDATER.subUpdater(4, 3), ReferenceField.create(MethodHandles.lookup(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_LeNode_UPDATER.subUpdater(7, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_LeNode_UPDATER.subUpdater(9, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbstractCmpNode#doPTuple}
             *   1: SpecializationActive {@link AbstractCmpNode#doTuple}
             *   2: GuardActive[guardIndex=0] {@link AbstractCmpNode#doTuple}
             *   3: SpecializationActive {@link AbstractCmpNode#doOther}
             *   4-6: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link PyTupleCheckNode} checkRight
             *        Inline method: {@link PyTupleCheckNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getRight
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doPTuple}
             *   Parameter: {@link CmpNode} cmp</pre> */
            @Child private CmpNode cmp;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;

            private LeNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) && (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */ || inliningTarget__ == null || checkRight__ == null || (checkRight__.execute(inliningTarget__, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1011) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            {
                                CmpNode cmp_ = this.cmp;
                                if (cmp_ != null) {
                                    return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1010) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            {
                                CmpNode cmp_1 = this.cmp;
                                if (cmp_1 != null) {
                                    Node inliningTarget__ = (this);
                                    if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                        return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return AbstractCmpNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        CmpNode cmp_;
                        CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = this.insert((createCmp()));
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                        this.state_0_ = state_0;
                        return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        boolean Tuple_duplicateFound_ = false;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            CmpNode cmp_1 = this.cmp;
                            if (cmp_1 != null) {
                                inliningTarget__ = (this);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (!Tuple_duplicateFound_) {
                            {
                                inliningTarget__ = (this);
                                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */) {
                                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */;
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) && ((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                                    CmpNode cmp_1;
                                    CmpNode cmp_1_shared = this.cmp;
                                    if (cmp_1_shared != null) {
                                        cmp_1 = cmp_1_shared;
                                    } else {
                                        cmp_1 = this.insert((createCmp()));
                                        if (cmp_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.cmp == null) {
                                        this.cmp = cmp_1;
                                    }
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                    this.state_0_ = state_0;
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Tuple_duplicateFound_) {
                            return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                        }
                        break;
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */;
                this.state_0_ = state_0;
                return AbstractCmpNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(GtNode.class)
    static final class GtNodeFactory implements NodeFactory<GtNode> {

        private static final GtNodeFactory GT_NODE_FACTORY_INSTANCE = new GtNodeFactory();

        private GtNodeFactory() {
        }

        @Override
        public Class<GtNode> getNodeClass() {
            return GtNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GtNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GtNode> getInstance() {
            return GT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GtNode create() {
            return new GtNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbstractCmpNode#doPTuple}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AbstractCmpNode#doTuple}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link AbstractCmpNode#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(GtNode.class)
        @SuppressWarnings("javadoc")
        static final class GtNodeGen extends GtNode {

            private static final StateField STATE_0_GtNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, STATE_0_GtNode_UPDATER.subUpdater(4, 3), ReferenceField.create(MethodHandles.lookup(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_GtNode_UPDATER.subUpdater(7, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_GtNode_UPDATER.subUpdater(9, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbstractCmpNode#doPTuple}
             *   1: SpecializationActive {@link AbstractCmpNode#doTuple}
             *   2: GuardActive[guardIndex=0] {@link AbstractCmpNode#doTuple}
             *   3: SpecializationActive {@link AbstractCmpNode#doOther}
             *   4-6: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link PyTupleCheckNode} checkRight
             *        Inline method: {@link PyTupleCheckNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getRight
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doPTuple}
             *   Parameter: {@link CmpNode} cmp</pre> */
            @Child private CmpNode cmp;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;

            private GtNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) && (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */ || inliningTarget__ == null || checkRight__ == null || (checkRight__.execute(inliningTarget__, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1011) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            {
                                CmpNode cmp_ = this.cmp;
                                if (cmp_ != null) {
                                    return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1010) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            {
                                CmpNode cmp_1 = this.cmp;
                                if (cmp_1 != null) {
                                    Node inliningTarget__ = (this);
                                    if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                        return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return AbstractCmpNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        CmpNode cmp_;
                        CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = this.insert((createCmp()));
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                        this.state_0_ = state_0;
                        return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        boolean Tuple_duplicateFound_ = false;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            CmpNode cmp_1 = this.cmp;
                            if (cmp_1 != null) {
                                inliningTarget__ = (this);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (!Tuple_duplicateFound_) {
                            {
                                inliningTarget__ = (this);
                                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */) {
                                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */;
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) && ((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                                    CmpNode cmp_1;
                                    CmpNode cmp_1_shared = this.cmp;
                                    if (cmp_1_shared != null) {
                                        cmp_1 = cmp_1_shared;
                                    } else {
                                        cmp_1 = this.insert((createCmp()));
                                        if (cmp_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.cmp == null) {
                                        this.cmp = cmp_1;
                                    }
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                    this.state_0_ = state_0;
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Tuple_duplicateFound_) {
                            return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                        }
                        break;
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */;
                this.state_0_ = state_0;
                return AbstractCmpNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(LtNode.class)
    static final class LtNodeFactory implements NodeFactory<LtNode> {

        private static final LtNodeFactory LT_NODE_FACTORY_INSTANCE = new LtNodeFactory();

        private LtNodeFactory() {
        }

        @Override
        public Class<LtNode> getNodeClass() {
            return LtNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public LtNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<LtNode> getInstance() {
            return LT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LtNode create() {
            return new LtNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbstractCmpNode#doPTuple}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AbstractCmpNode#doTuple}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link AbstractCmpNode#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(LtNode.class)
        @SuppressWarnings("javadoc")
        static final class LtNodeGen extends LtNode {

            private static final StateField STATE_0_LtNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, STATE_0_LtNode_UPDATER.subUpdater(4, 3), ReferenceField.create(MethodHandles.lookup(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_LtNode_UPDATER.subUpdater(7, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_LtNode_UPDATER.subUpdater(9, 2), ReferenceField.create(MethodHandles.lookup(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbstractCmpNode#doPTuple}
             *   1: SpecializationActive {@link AbstractCmpNode#doTuple}
             *   2: GuardActive[guardIndex=0] {@link AbstractCmpNode#doTuple}
             *   3: SpecializationActive {@link AbstractCmpNode#doOther}
             *   4-6: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link PyTupleCheckNode} checkRight
             *        Inline method: {@link PyTupleCheckNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link AbstractCmpNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getRight
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doPTuple}
             *   Parameter: {@link CmpNode} cmp</pre> */
            @Child private CmpNode cmp;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbstractCmpNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;

            private LtNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) && (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */ || inliningTarget__ == null || checkRight__ == null || (checkRight__.execute(inliningTarget__, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1011) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            {
                                CmpNode cmp_ = this.cmp;
                                if (cmp_ != null) {
                                    return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1010) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] || SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            {
                                CmpNode cmp_1 = this.cmp;
                                if (cmp_1 != null) {
                                    Node inliningTarget__ = (this);
                                    if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                        return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return AbstractCmpNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        CmpNode cmp_;
                        CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = this.insert((createCmp()));
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                        this.state_0_ = state_0;
                        return AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        boolean Tuple_duplicateFound_ = false;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                            CmpNode cmp_1 = this.cmp;
                            if (cmp_1 != null) {
                                inliningTarget__ = (this);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (!Tuple_duplicateFound_) {
                            {
                                inliningTarget__ = (this);
                                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */) {
                                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode), guardIndex=0] */;
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) && ((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                                    CmpNode cmp_1;
                                    CmpNode cmp_1_shared = this.cmp;
                                    if (cmp_1_shared != null) {
                                        cmp_1 = cmp_1_shared;
                                    } else {
                                        cmp_1 = this.insert((createCmp()));
                                        if (cmp_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.cmp == null) {
                                        this.cmp = cmp_1;
                                    }
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.AbstractCmpNode.doPTuple(VirtualFrame, PTuple, PTuple, CmpNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doTuple(VirtualFrame, Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                    this.state_0_ = state_0;
                                    Tuple_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Tuple_duplicateFound_) {
                            return AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                        }
                        break;
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.AbstractCmpNode.doOther(Object, Object)] */;
                this.state_0_ = state_0;
                return AbstractCmpNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(RichCompareNode.class)
    static final class RichCompareNodeFactory implements NodeFactory<RichCompareNode> {

        private static final RichCompareNodeFactory RICH_COMPARE_NODE_FACTORY_INSTANCE = new RichCompareNodeFactory();

        private RichCompareNodeFactory() {
        }

        @Override
        public Class<RichCompareNode> getNodeClass() {
            return RichCompareNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public RichCompareNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RichCompareNode> getInstance() {
            return RICH_COMPARE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RichCompareNode create() {
            return new RichCompareNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RichCompareNode#doPTuple}
         *     Activation probability: 0.65000
         *     With/without class size: 22/8 bytes
         *   Specialization {@link RichCompareNode#doGeneric}
         *     Activation probability: 0.35000
         *     With/without class size: 20/26 bytes
         * </pre> */
        @GeneratedBy(RichCompareNode.class)
        @SuppressWarnings("javadoc")
        static final class RichCompareNodeGen extends RichCompareNode {

            private static final StateField GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
            static final ReferenceField<PTupleData> P_TUPLE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pTuple_cache", PTupleData.class);
            static final ReferenceField<GenericData> GENERIC_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "generic_cache", GenericData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doGeneric}
             *   Parameter: {@link PyTupleCheckNode} checkLeft
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_GENERIC_CHECK_LEFT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(3, 3), ReferenceField.create(GenericData.lookup_(), "generic_checkLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doGeneric}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_GENERIC_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(6, 3), ReferenceField.create(GenericData.lookup_(), "generic_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doGeneric}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GENERIC_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(9, 2), ReferenceField.create(GenericData.lookup_(), "generic_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doGeneric}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GENERIC_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(11, 2), ReferenceField.create(GenericData.lookup_(), "generic_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RichCompareNode#doPTuple}
             *   1: SpecializationActive {@link RichCompareNode#doGeneric}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private PTupleData pTuple_cache;
            @UnsafeAccessedField @Child private GenericData generic_cache;

            private RichCompareNodeGen() {
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[TupleBuiltins.RichCompareNode.doPTuple(VirtualFrame, PTuple, PTuple, int, ComparisonOp, CmpNode)] || SpecializationActive[TupleBuiltins.RichCompareNode.doGeneric(VirtualFrame, Object, Object, int, Node, ComparisonOp, PyTupleCheckNode, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.RichCompareNode.doPTuple(VirtualFrame, PTuple, PTuple, int, ComparisonOp, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            PTupleData s0_ = this.pTuple_cache;
                            while (s0_ != null) {
                                if ((arg2Value_ == decodeComparisonOp((s0_.pTuple_state_0_ >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doPTuple(..., ComparisonOp cachedOp, ...)] */) - 2).opCode)) {
                                    return RichCompareNode.doPTuple(frameValue, arg0Value_, arg1Value_, arg2Value_, decodeComparisonOp((s0_.pTuple_state_0_ >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doPTuple(..., ComparisonOp cachedOp, ...)] */) - 2), s0_.cmpNode_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.RichCompareNode.doGeneric(VirtualFrame, Object, Object, int, Node, ComparisonOp, PyTupleCheckNode, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */) {
                        GenericData s1_ = this.generic_cache;
                        while (s1_ != null) {
                            if ((arg2Value_ == decodeComparisonOp(((s1_.generic_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doGeneric(..., ComparisonOp cachedOp, ...)] */) - 2).opCode)) {
                                Node inliningTarget__ = (s1_);
                                return RichCompareNode.doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__, decodeComparisonOp(((s1_.generic_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doGeneric(..., ComparisonOp cachedOp, ...)] */) - 2), INLINED_GENERIC_CHECK_LEFT_, INLINED_GENERIC_CHECK_RIGHT_, INLINED_GENERIC_GET_LEFT_, INLINED_GENERIC_GET_RIGHT_, s1_.cmpNode_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TupleBuiltins.RichCompareNode.doGeneric(VirtualFrame, Object, Object, int, Node, ComparisonOp, PyTupleCheckNode, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            while (true) {
                                int count0_ = 0;
                                PTupleData s0_ = P_TUPLE_CACHE_UPDATER.getVolatile(this);
                                PTupleData s0_original = s0_;
                                while (s0_ != null) {
                                    if ((arg2Value_ == decodeComparisonOp((s0_.pTuple_state_0_ >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doPTuple(..., ComparisonOp cachedOp, ...)] */) - 2).opCode)) {
                                        break;
                                    }
                                    count0_++;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ == null) {
                                    {
                                        ComparisonOp cachedOp__ = (ComparisonOp.fromOpCode(arg2Value_));
                                        if ((arg2Value_ == cachedOp__.opCode) && count0_ < (6)) {
                                            s0_ = this.insert(new PTupleData(s0_original));
                                            s0_.pTuple_state_0_ = (s0_.pTuple_state_0_ | ((encodeComparisonOp(cachedOp__) + 2) << 0) /* set-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doPTuple(..., ComparisonOp cachedOp, ...)] */);
                                            CmpNode cmpNode__ = s0_.insert((RichCompareNode.createCmpNode(cachedOp__)));
                                            Objects.requireNonNull(cmpNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.cmpNode_ = cmpNode__;
                                            if (!P_TUPLE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.RichCompareNode.doPTuple(VirtualFrame, PTuple, PTuple, int, ComparisonOp, CmpNode)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                                if (s0_ != null) {
                                    return RichCompareNode.doPTuple(frameValue, arg0Value_, arg1Value_, arg2Value_, decodeComparisonOp((s0_.pTuple_state_0_ >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doPTuple(..., ComparisonOp cachedOp, ...)] */) - 2), s0_.cmpNode_);
                                }
                                break;
                            }
                        }
                    }
                    {
                        Node inliningTarget__ = null;
                        while (true) {
                            int count1_ = 0;
                            GenericData s1_ = GENERIC_CACHE_UPDATER.getVolatile(this);
                            GenericData s1_original = s1_;
                            while (s1_ != null) {
                                if ((arg2Value_ == decodeComparisonOp(((s1_.generic_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doGeneric(..., ComparisonOp cachedOp, ...)] */) - 2).opCode)) {
                                    inliningTarget__ = (s1_);
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                {
                                    ComparisonOp cachedOp__1 = (ComparisonOp.fromOpCode(arg2Value_));
                                    if ((arg2Value_ == cachedOp__1.opCode) && count1_ < (6)) {
                                        s1_ = this.insert(new GenericData(s1_original));
                                        inliningTarget__ = (s1_);
                                        s1_.generic_state_0_ = (s1_.generic_state_0_ | ((encodeComparisonOp(cachedOp__1) + 2) << 0) /* set-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doGeneric(..., ComparisonOp cachedOp, ...)] */);
                                        CmpNode cmpNode__1 = s1_.insert((RichCompareNode.createCmpNode(cachedOp__1)));
                                        Objects.requireNonNull(cmpNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s1_.cmpNode_ = cmpNode__1;
                                        if (!GENERIC_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        this.pTuple_cache = null;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TupleBuiltins.RichCompareNode.doPTuple(VirtualFrame, PTuple, PTuple, int, ComparisonOp, CmpNode)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.RichCompareNode.doGeneric(VirtualFrame, Object, Object, int, Node, ComparisonOp, PyTupleCheckNode, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, CmpNode)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s1_ != null) {
                                return RichCompareNode.doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__, decodeComparisonOp(((s1_.generic_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TupleBuiltins.RichCompareNode.doGeneric(..., ComparisonOp cachedOp, ...)] */) - 2), INLINED_GENERIC_CHECK_LEFT_, INLINED_GENERIC_CHECK_RIGHT_, INLINED_GENERIC_GET_LEFT_, INLINED_GENERIC_GET_RIGHT_, s1_.cmpNode_);
                            }
                            break;
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @GeneratedBy(RichCompareNode.class)
            @DenyReplace
            private static final class PTupleData extends Node implements SpecializationDataNode {

                @Child PTupleData next_;
                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=TupleBuiltins.RichCompareNode.doPTuple(..., ComparisonOp cachedOp, ...)]
                 * </pre> */
                @CompilationFinal private int pTuple_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doPTuple}
                 *   Parameter: {@link CmpNode} cmpNode</pre> */
                @Child CmpNode cmpNode_;

                PTupleData(PTupleData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(RichCompareNode.class)
            @DenyReplace
            private static final class GenericData extends Node implements SpecializationDataNode {

                @Child GenericData next_;
                /**
                 * State Info: <pre>
                 *   0-2: EncodedEnum[cache=TupleBuiltins.RichCompareNode.doGeneric(..., ComparisonOp cachedOp, ...)]
                 *   3-5: InlinedCache
                 *        Specialization: {@link RichCompareNode#doGeneric}
                 *        Parameter: {@link PyTupleCheckNode} checkLeft
                 *        Inline method: {@link PyTupleCheckNodeGen#inline}
                 *   6-8: InlinedCache
                 *        Specialization: {@link RichCompareNode#doGeneric}
                 *        Parameter: {@link PyTupleCheckNode} checkRight
                 *        Inline method: {@link PyTupleCheckNodeGen#inline}
                 *   9-10: InlinedCache
                 *        Specialization: {@link RichCompareNode#doGeneric}
                 *        Parameter: {@link GetTupleStorage} getLeft
                 *        Inline method: {@link GetTupleStorageNodeGen#inline}
                 *   11-12: InlinedCache
                 *        Specialization: {@link RichCompareNode#doGeneric}
                 *        Parameter: {@link GetTupleStorage} getRight
                 *        Inline method: {@link GetTupleStorageNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doGeneric}
                 *   Parameter: {@link PyTupleCheckNode} checkLeft
                 *   Inline method: {@link PyTupleCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_checkLeft__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doGeneric}
                 *   Parameter: {@link PyTupleCheckNode} checkRight
                 *   Inline method: {@link PyTupleCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_checkRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doGeneric}
                 *   Parameter: {@link GetTupleStorage} getLeft
                 *   Inline method: {@link GetTupleStorageNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_getLeft__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doGeneric}
                 *   Parameter: {@link GetTupleStorage} getRight
                 *   Inline method: {@link GetTupleStorageNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_getRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doGeneric}
                 *   Parameter: {@link CmpNode} cmpNode</pre> */
                @Child CmpNode cmpNode_;

                GenericData(GenericData next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(TupleConcatNode.class)
    static final class TupleConcatNodeFactory implements NodeFactory<TupleConcatNode> {

        private static final TupleConcatNodeFactory TUPLE_CONCAT_NODE_FACTORY_INSTANCE = new TupleConcatNodeFactory();

        private TupleConcatNodeFactory() {
        }

        @Override
        public Class<TupleConcatNode> getNodeClass() {
            return TupleConcatNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TupleConcatNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TupleConcatNode> getInstance() {
            return TUPLE_CONCAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleConcatNode create() {
            return new TupleConcatNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TupleConcatNode#doTuple}
         *     Activation probability: 0.65000
         *     With/without class size: 30/21 bytes
         *   Specialization {@link TupleConcatNode#doGeneric}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(TupleConcatNode.class)
        @SuppressWarnings("javadoc")
        static final class TupleConcatNodeGen extends TupleConcatNode {

            private static final StateField TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER = StateField.create(TupleData.lookup_(), "tuple_state_0_");
            static final ReferenceField<TupleData> TUPLE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "tuple_cache", TupleData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleConcatNode#doTuple}
             *   Parameter: {@link PyTupleCheckNode} checkRight
             *   Inline method: {@link PyTupleCheckNodeGen#inline}</pre> */
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineTarget.create(PyTupleCheckNode.class, TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER.subUpdater(2, 3), ReferenceField.create(TupleData.lookup_(), "tuple_checkRight__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleConcatNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER.subUpdater(5, 2), ReferenceField.create(TupleData.lookup_(), "tuple_getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleConcatNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getRight
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER.subUpdater(7, 2), ReferenceField.create(TupleData.lookup_(), "tuple_getRight__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TupleConcatNode#doTuple}
             *   1: SpecializationActive {@link TupleConcatNode#doGeneric}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private TupleData tuple_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TupleConcatNode#doGeneric}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode fallback_raiseNode_;

            private TupleConcatNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                {
                    TupleData s0_ = this.tuple_cache;
                    if ((s0_ == null || ((s0_.tuple_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.TupleConcatNode.doTuple(Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, ConcatNode, PythonObjectFactory), guardIndex=0] */ || (INLINED_TUPLE_CHECK_RIGHT_.execute((s0_), arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[TupleBuiltins.TupleConcatNode.doTuple(Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, ConcatNode, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.TupleConcatNode.doGeneric(Object, Object, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.TupleConcatNode.doTuple(Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, ConcatNode, PythonObjectFactory)] */) {
                        TupleData s0_ = this.tuple_cache;
                        if (s0_ != null) {
                            if ((s0_.tuple_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                Node inliningTarget__ = (s0_);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    return TupleConcatNode.doTuple(arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, s0_.concatNode_, s0_.factory_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.TupleConcatNode.doGeneric(Object, Object, PRaiseNode)] */) {
                        {
                            PRaiseNode raiseNode__ = this.fallback_raiseNode_;
                            if (raiseNode__ != null) {
                                if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                    return TupleConcatNode.doGeneric(arg0Value, arg1Value, raiseNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        int count0_ = 0;
                        TupleData s0_ = TUPLE_CACHE_UPDATER.getVolatile(this);
                        TupleData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.tuple_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                inliningTarget__ = (s0_);
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    break;
                                }
                            }
                            if ((s0_.tuple_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                count0_++;
                            }
                            s0_ = null;
                            break;
                        }
                        if (s0_ == null && count0_ < 1) {
                            {
                                s0_ = this.insert(new TupleData());
                                inliningTarget__ = (s0_);
                                if (((s0_.tuple_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=TupleBuiltins.TupleConcatNode.doTuple(Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, ConcatNode, PythonObjectFactory), guardIndex=0] */) {
                                    s0_.tuple_state_0_ = s0_.tuple_state_0_ | 0b1 /* add GuardActive[specialization=TupleBuiltins.TupleConcatNode.doTuple(Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, ConcatNode, PythonObjectFactory), guardIndex=0] */;
                                    if (!TUPLE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    s0_original = s0_;
                                    s0_ = this.insert(new TupleData(s0_));
                                }
                                if ((INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value))) {
                                    ConcatNode concatNode__ = s0_.insert((TupleConcatNode.createConcat()));
                                    Objects.requireNonNull(concatNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.concatNode_ = concatNode__;
                                    PythonObjectFactory factory__ = s0_.insert((PythonObjectFactory.create()));
                                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.factory_ = factory__;
                                    s0_.tuple_state_0_ = s0_.tuple_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                                    if (!TUPLE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.TupleConcatNode.doTuple(Object, Object, Node, PyTupleCheckNode, GetTupleStorage, GetTupleStorage, ConcatNode, PythonObjectFactory)] */;
                                    this.state_0_ = state_0;
                                } else {
                                    s0_ = null;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return TupleConcatNode.doTuple(arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, s0_.concatNode_, s0_.factory_);
                        }
                        break;
                    }
                }
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.TupleConcatNode.doGeneric(Object, Object, PRaiseNode)] */;
                this.state_0_ = state_0;
                return TupleConcatNode.doGeneric(arg0Value, arg1Value, raiseNode__);
            }

            @GeneratedBy(TupleConcatNode.class)
            @DenyReplace
            private static final class TupleData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0: GuardActive[guardIndex=0] {@link TupleConcatNode#doTuple}
                 *   1: SpecializationCachesInitialized {@link TupleConcatNode#doTuple}
                 *   2-4: InlinedCache
                 *        Specialization: {@link TupleConcatNode#doTuple}
                 *        Parameter: {@link PyTupleCheckNode} checkRight
                 *        Inline method: {@link PyTupleCheckNodeGen#inline}
                 *   5-6: InlinedCache
                 *        Specialization: {@link TupleConcatNode#doTuple}
                 *        Parameter: {@link GetTupleStorage} getLeft
                 *        Inline method: {@link GetTupleStorageNodeGen#inline}
                 *   7-8: InlinedCache
                 *        Specialization: {@link TupleConcatNode#doTuple}
                 *        Parameter: {@link GetTupleStorage} getRight
                 *        Inline method: {@link GetTupleStorageNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int tuple_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TupleConcatNode#doTuple}
                 *   Parameter: {@link PyTupleCheckNode} checkRight
                 *   Inline method: {@link PyTupleCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_checkRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TupleConcatNode#doTuple}
                 *   Parameter: {@link GetTupleStorage} getLeft
                 *   Inline method: {@link GetTupleStorageNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getLeft__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TupleConcatNode#doTuple}
                 *   Parameter: {@link GetTupleStorage} getRight
                 *   Inline method: {@link GetTupleStorageNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node tuple_getRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TupleConcatNode#doTuple}
                 *   Parameter: {@link ConcatNode} concatNode</pre> */
                @Child ConcatNode concatNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link TupleConcatNode#doTuple}
                 *   Parameter: {@link PythonObjectFactory} factory</pre> */
                @Child PythonObjectFactory factory_;

                TupleData() {
                }

                TupleData(TupleData delegate) {
                    this.tuple_state_0_ = delegate.tuple_state_0_;
                    this.tuple_checkRight__field1_ = delegate.tuple_checkRight__field1_;
                    this.tuple_getLeft__field1_ = delegate.tuple_getLeft__field1_;
                    this.tuple_getRight__field1_ = delegate.tuple_getRight__field1_;
                    this.concatNode_ = delegate.concatNode_;
                    this.factory_ = delegate.factory_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(MulNode.class)
    static final class MulNodeFactory implements NodeFactory<MulNode> {

        private static final MulNodeFactory MUL_NODE_FACTORY_INSTANCE = new MulNodeFactory();

        private MulNodeFactory() {
        }

        @Override
        public Class<MulNode> getNodeClass() {
            return MulNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public MulNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<MulNode> getInstance() {
            return MUL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MulNode create() {
            return new MulNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link MulNode#doTuple}
         *     Activation probability: 1.00000
         *     With/without class size: 44/22 bytes
         * </pre> */
        @GeneratedBy(MulNode.class)
        @SuppressWarnings("javadoc")
        static final class MulNodeGen extends MulNode {

            private static final StateField STATE_0_MulNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link PyTupleCheckExactNode} checkTuple
             *   Inline method: {@link PyTupleCheckExactNodeGen#inline}</pre> */
            private static final PyTupleCheckExactNode INLINED_CHECK_TUPLE_ = PyTupleCheckExactNodeGen.inline(InlineTarget.create(PyTupleCheckExactNode.class, STATE_0_MulNode_UPDATER.subUpdater(1, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_LEFT_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_MulNode_UPDATER.subUpdater(3, 2), ReferenceField.create(MethodHandles.lookup(), "getLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link InlinedConditionProfile} isSingleRepeat
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_IS_SINGLE_REPEAT_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_MulNode_UPDATER.subUpdater(5, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}</pre> */
            private static final PyNumberAsSizeNode INLINED_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineTarget.create(PyNumberAsSizeNode.class, STATE_0_MulNode_UPDATER.subUpdater(7, 5), ReferenceField.create(MethodHandles.lookup(), "asSizeNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "asSizeNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy} factory
             *   Inline method: {@link com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy INLINED_FACTORY_ = com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy.class, STATE_0_MulNode_UPDATER.subUpdater(12, 1), ReferenceField.create(MethodHandles.lookup(), "factory__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MulNode#doTuple}
             *   1-2: InlinedCache
             *        Specialization: {@link MulNode#doTuple}
             *        Parameter: {@link PyTupleCheckExactNode} checkTuple
             *        Inline method: {@link PyTupleCheckExactNodeGen#inline}
             *   3-4: InlinedCache
             *        Specialization: {@link MulNode#doTuple}
             *        Parameter: {@link GetTupleStorage} getLeft
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   5-6: InlinedCache
             *        Specialization: {@link MulNode#doTuple}
             *        Parameter: {@link InlinedConditionProfile} isSingleRepeat
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   7-11: InlinedCache
             *        Specialization: {@link MulNode#doTuple}
             *        Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *        Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   12: InlinedCache
             *        Specialization: {@link MulNode#doTuple}
             *        Parameter: {@link com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy} factory
             *        Inline method: {@link com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link GetTupleStorage} getLeft
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link RepeatNode} repeatNode</pre> */
            @Child private RepeatNode repeatNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doTuple}
             *   Parameter: {@link com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy} factory
             *   Inline method: {@link com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node factory__field1_;

            private MulNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.MulNode.doTuple(VirtualFrame, Object, int, Node, PyTupleCheckExactNode, GetTupleStorage, InlinedConditionProfile, PyNumberAsSizeNode, RepeatNode, Lazy)] */) {
                    {
                        RepeatNode repeatNode__ = this.repeatNode_;
                        if (repeatNode__ != null) {
                            Node inliningTarget__ = (this);
                            return MulNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_CHECK_TUPLE_, INLINED_GET_LEFT_, INLINED_IS_SINGLE_REPEAT_, INLINED_AS_SIZE_NODE_, repeatNode__, INLINED_FACTORY_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    RepeatNode repeatNode__ = this.insert((RepeatNode.create()));
                    Objects.requireNonNull(repeatNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.repeatNode_ = repeatNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.MulNode.doTuple(VirtualFrame, Object, int, Node, PyTupleCheckExactNode, GetTupleStorage, InlinedConditionProfile, PyNumberAsSizeNode, RepeatNode, Lazy)] */;
                    this.state_0_ = state_0;
                    return MulNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_CHECK_TUPLE_, INLINED_GET_LEFT_, INLINED_IS_SINGLE_REPEAT_, INLINED_AS_SIZE_NODE_, repeatNode__, INLINED_FACTORY_);
                }
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode.class)
    static final class ContainsNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode> {

        private static final ContainsNodeFactory CONTAINS_NODE_FACTORY_INSTANCE = new ContainsNodeFactory();

        private ContainsNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode> getInstance() {
            return CONTAINS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode create() {
            return new com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory.ContainsNodeFactory.ContainsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
         *     Activation probability: 1.00000
         *     With/without class size: 32/10 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode.class)
        @SuppressWarnings("javadoc")
        static final class ContainsNodeGen extends com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode {

            private static final StateField STATE_0_ContainsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_ContainsNode_UPDATER.subUpdater(0, 2), ReferenceField.create(MethodHandles.lookup(), "getTupleStorage__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ContainsNode} containsNode
             *   Inline method: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.ContainsNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ContainsNode INLINED_CONTAINS_NODE_ = com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.ContainsNodeGen.inline(InlineTarget.create(com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ContainsNode.class, STATE_0_ContainsNode_UPDATER.subUpdater(2, 7), ReferenceField.create(MethodHandles.lookup(), "containsNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
             *        Parameter: {@link GetTupleStorage} getTupleStorage
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             *   2-8: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
             *        Parameter: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ContainsNode} containsNode
             *        Inline method: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.ContainsNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getTupleStorage__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.ContainsNode#contains}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ContainsNode} containsNode
             *   Inline method: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.ContainsNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node containsNode__field1_;

            private ContainsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    return contains(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, INLINED_CONTAINS_NODE_);
                }
            }

        }
    }
    @GeneratedBy(IterNode.class)
    public static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#doPTupleInt}
         *     Activation probability: 0.27381
         *     With/without class size: 7/0 bytes
         *   Specialization {@link IterNode#doPTupleObject}
         *     Activation probability: 0.23095
         *     With/without class size: 6/0 bytes
         *   Specialization {@link IterNode#doPTupleLong}
         *     Activation probability: 0.18810
         *     With/without class size: 6/0 bytes
         *   Specialization {@link IterNode#doPTupleDouble}
         *     Activation probability: 0.14524
         *     With/without class size: 5/0 bytes
         *   Specialization {@link IterNode#doPTuple}
         *     Activation probability: 0.10238
         *     With/without class size: 5/0 bytes
         *   Specialization {@link IterNode#doNativeTuple}
         *     Activation probability: 0.05952
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#doPTupleInt}
             *   1: SpecializationActive {@link IterNode#doPTupleObject}
             *   2: SpecializationActive {@link IterNode#doPTupleLong}
             *   3: SpecializationActive {@link IterNode#doPTupleDouble}
             *   4: SpecializationActive {@link IterNode#doPTuple}
             *   5: SpecializationActive {@link IterNode#doNativeTuple}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IterNode#doPTupleInt}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTupleInt(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTupleObject(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTupleLong(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTupleDouble(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTuple(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doNativeTuple(PythonAbstractNativeObject, PythonObjectFactory)] */) {
                    if ((state_0 & 0b11111) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTupleInt(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTupleObject(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTupleLong(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTupleDouble(PTuple, PythonObjectFactory)] || SpecializationActive[TupleBuiltins.IterNode.doPTuple(PTuple, PythonObjectFactory)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTupleInt(PTuple, PythonObjectFactory)] */) {
                            {
                                PythonObjectFactory factory_ = this.factory;
                                if (factory_ != null) {
                                    if ((PGuards.isIntStorage(arg0Value_))) {
                                        return IterNode.doPTupleInt(arg0Value_, factory_);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTupleObject(PTuple, PythonObjectFactory)] */) {
                            {
                                PythonObjectFactory factory_1 = this.factory;
                                if (factory_1 != null) {
                                    if ((PGuards.isObjectStorage(arg0Value_))) {
                                        return IterNode.doPTupleObject(arg0Value_, factory_1);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTupleLong(PTuple, PythonObjectFactory)] */) {
                            {
                                PythonObjectFactory factory_2 = this.factory;
                                if (factory_2 != null) {
                                    if ((PGuards.isLongStorage(arg0Value_))) {
                                        return IterNode.doPTupleLong(arg0Value_, factory_2);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTupleDouble(PTuple, PythonObjectFactory)] */) {
                            {
                                PythonObjectFactory factory_3 = this.factory;
                                if (factory_3 != null) {
                                    if ((PGuards.isDoubleStorage(arg0Value_))) {
                                        return IterNode.doPTupleDouble(arg0Value_, factory_3);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doPTuple(PTuple, PythonObjectFactory)] */) {
                            {
                                PythonObjectFactory factory_4 = this.factory;
                                if (factory_4 != null) {
                                    if ((!(PGuards.isIntStorage(arg0Value_))) && (!(PGuards.isLongStorage(arg0Value_))) && (!(PGuards.isDoubleStorage(arg0Value_)))) {
                                        return IterNode.doPTuple(arg0Value_, factory_4);
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TupleBuiltins.IterNode.doNativeTuple(PythonAbstractNativeObject, PythonObjectFactory)] */ && arg0Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject) arg0Value;
                        {
                            PythonObjectFactory factory_5 = this.factory;
                            if (factory_5 != null) {
                                return IterNode.doNativeTuple(arg0Value_, factory_5);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PBuiltinIterator executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if ((PGuards.isIntStorage(arg0Value_))) {
                        PythonObjectFactory factory_;
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = this.insert((PythonObjectFactory.create()));
                            if (factory_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.IterNode.doPTupleInt(PTuple, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return IterNode.doPTupleInt(arg0Value_, factory_);
                    }
                    if ((PGuards.isObjectStorage(arg0Value_))) {
                        PythonObjectFactory factory_1;
                        PythonObjectFactory factory_1_shared = this.factory;
                        if (factory_1_shared != null) {
                            factory_1 = factory_1_shared;
                        } else {
                            factory_1 = this.insert((PythonObjectFactory.create()));
                            if (factory_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_1;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.IterNode.doPTupleObject(PTuple, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return IterNode.doPTupleObject(arg0Value_, factory_1);
                    }
                    if ((PGuards.isLongStorage(arg0Value_))) {
                        PythonObjectFactory factory_2;
                        PythonObjectFactory factory_2_shared = this.factory;
                        if (factory_2_shared != null) {
                            factory_2 = factory_2_shared;
                        } else {
                            factory_2 = this.insert((PythonObjectFactory.create()));
                            if (factory_2 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_2;
                        }
                        state_0 = state_0 | 0b100 /* add SpecializationActive[TupleBuiltins.IterNode.doPTupleLong(PTuple, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return IterNode.doPTupleLong(arg0Value_, factory_2);
                    }
                    if ((PGuards.isDoubleStorage(arg0Value_))) {
                        PythonObjectFactory factory_3;
                        PythonObjectFactory factory_3_shared = this.factory;
                        if (factory_3_shared != null) {
                            factory_3 = factory_3_shared;
                        } else {
                            factory_3 = this.insert((PythonObjectFactory.create()));
                            if (factory_3 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_3;
                        }
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[TupleBuiltins.IterNode.doPTupleDouble(PTuple, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return IterNode.doPTupleDouble(arg0Value_, factory_3);
                    }
                    if ((!(PGuards.isIntStorage(arg0Value_))) && (!(PGuards.isLongStorage(arg0Value_))) && (!(PGuards.isDoubleStorage(arg0Value_)))) {
                        PythonObjectFactory factory_4;
                        PythonObjectFactory factory_4_shared = this.factory;
                        if (factory_4_shared != null) {
                            factory_4 = factory_4_shared;
                        } else {
                            factory_4 = this.insert((PythonObjectFactory.create()));
                            if (factory_4 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_4;
                        }
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[TupleBuiltins.IterNode.doPTuple(PTuple, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return IterNode.doPTuple(arg0Value_, factory_4);
                    }
                }
                if (arg0Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject) arg0Value;
                    PythonObjectFactory factory_5;
                    PythonObjectFactory factory_5_shared = this.factory;
                    if (factory_5_shared != null) {
                        factory_5 = factory_5_shared;
                    } else {
                        factory_5 = this.insert((PythonObjectFactory.create()));
                        if (factory_5 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        VarHandle.storeStoreFence();
                        this.factory = factory_5;
                    }
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TupleBuiltins.IterNode.doNativeTuple(PythonAbstractNativeObject, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return IterNode.doNativeTuple(arg0Value_, factory_5);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(HashNode.class)
    public static final class HashNodeFactory implements NodeFactory<HashNode> {

        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        @Override
        public Class<HashNode> getNodeClass() {
            return HashNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public HashNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNode create() {
            return new HashNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HashNode#getHash}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
         *     Activation probability: 0.33333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link HashNode#computeHash(VirtualFrame, PythonAbstractNativeObject, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode, GetNativeTupleStorage)}
         *     Activation probability: 0.18333
         *     With/without class size: 7/4 bytes
         * </pre> */
        @GeneratedBy(HashNode.class)
        @SuppressWarnings("javadoc")
        public static final class HashNodeGen extends HashNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_HASH = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, STATE_0_UPDATER.subUpdater(3, 7), ReferenceField.create(MethodHandles.lookup(), "hash_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hash_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hash_field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HashNode#getHash}
             *   1: SpecializationActive {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *   2: SpecializationActive {@link HashNode#computeHash(VirtualFrame, PythonAbstractNativeObject, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode, GetNativeTupleStorage)}
             *   3-9: InlinedCache
             *        Specialization: {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *        Parameter: {@link PyObjectHashNode} hashNode
             *        Inline method: {@link PyObjectHashNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode} getItemNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hash_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hash_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#computeHash(VirtualFrame, PTuple, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode)}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hash_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#computeHash(VirtualFrame, PythonAbstractNativeObject, Node, com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode, PyObjectHashNode, GetNativeTupleStorage)}
             *   Parameter: {@link GetNativeTupleStorage} getStorage</pre> */
            @Child private GetNativeTupleStorage computeHash1_getStorage_;

            private HashNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[TupleBuiltins.HashNode.getHash(PTuple)] || SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PTuple, Node, GetItemNode, PyObjectHashNode)] || SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PythonAbstractNativeObject, Node, GetItemNode, PyObjectHashNode, GetNativeTupleStorage)] */) {
                    if ((state_0 & 0b11) != 0 /* is SpecializationActive[TupleBuiltins.HashNode.getHash(PTuple)] || SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PTuple, Node, GetItemNode, PyObjectHashNode)] */ && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.HashNode.getHash(PTuple)] */) {
                            if ((arg0Value_.getHash() != HashNode.HASH_UNSET)) {
                                return getHash(arg0Value_);
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PTuple, Node, GetItemNode, PyObjectHashNode)] */) {
                            {
                                com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem_ = this.getItem;
                                if (getItem_ != null) {
                                    if ((arg0Value_.getHash() == HashNode.HASH_UNSET)) {
                                        Node inliningTarget__ = (this);
                                        return computeHash(frameValue, arg0Value_, inliningTarget__, getItem_, INLINED_HASH);
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PythonAbstractNativeObject, Node, GetItemNode, PyObjectHashNode, GetNativeTupleStorage)] */ && arg0Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject) arg0Value;
                        {
                            com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem_1 = this.getItem;
                            if (getItem_1 != null) {
                                GetNativeTupleStorage getStorage__ = this.computeHash1_getStorage_;
                                if (getStorage__ != null) {
                                    Node inliningTarget__1 = (this);
                                    return computeHash(frameValue, arg0Value_, inliningTarget__1, getItem_1, INLINED_HASH, getStorage__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple) arg0Value;
                    if ((arg0Value_.getHash() != HashNode.HASH_UNSET)) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.HashNode.getHash(PTuple)] */;
                        this.state_0_ = state_0;
                        return getHash(arg0Value_);
                    }
                    {
                        Node inliningTarget__ = null;
                        if ((arg0Value_.getHash() == HashNode.HASH_UNSET)) {
                            inliningTarget__ = (this);
                            com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem_;
                            com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem__shared = this.getItem;
                            if (getItem__shared != null) {
                                getItem_ = getItem__shared;
                            } else {
                                getItem_ = this.insert((com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode.createNotNormalized()));
                                if (getItem_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.getItem == null) {
                                VarHandle.storeStoreFence();
                                this.getItem = getItem_;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PTuple, Node, GetItemNode, PyObjectHashNode)] */;
                            this.state_0_ = state_0;
                            return computeHash(frameValue, arg0Value_, inliningTarget__, getItem_, INLINED_HASH);
                        }
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    if (arg0Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject) arg0Value;
                        inliningTarget__1 = (this);
                        com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem_1;
                        com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode getItem_1_shared = this.getItem;
                        if (getItem_1_shared != null) {
                            getItem_1 = getItem_1_shared;
                        } else {
                            getItem_1 = this.insert((com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemNode.createNotNormalized()));
                            if (getItem_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getItem == null) {
                            VarHandle.storeStoreFence();
                            this.getItem = getItem_1;
                        }
                        GetNativeTupleStorage getStorage__ = this.insert((GetNativeTupleStorageNodeGen.create()));
                        Objects.requireNonNull(getStorage__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.computeHash1_getStorage_ = getStorage__;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[TupleBuiltins.HashNode.computeHash(VirtualFrame, PythonAbstractNativeObject, Node, GetItemNode, PyObjectHashNode, GetNativeTupleStorage)] */;
                        this.state_0_ = state_0;
                        return computeHash(frameValue, arg0Value_, inliningTarget__1, getItem_1, INLINED_HASH, getStorage__);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(GetNewargsNode.class)
    public static final class GetNewargsNodeFactory implements NodeFactory<GetNewargsNode> {

        private static final GetNewargsNodeFactory GET_NEWARGS_NODE_FACTORY_INSTANCE = new GetNewargsNodeFactory();

        private GetNewargsNodeFactory() {
        }

        @Override
        public Class<GetNewargsNode> getNodeClass() {
            return GetNewargsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetNewargsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetNewargsNode> getInstance() {
            return GET_NEWARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNewargsNode create() {
            return new GetNewargsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNewargsNode#doIt}
         *     Activation probability: 1.00000
         *     With/without class size: 32/9 bytes
         * </pre> */
        @GeneratedBy(GetNewargsNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetNewargsNodeGen extends GetNewargsNode {

            private static final StateField STATE_0_GetNewargsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewargsNode#doIt}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}</pre> */
            private static final GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = GetTupleStorageNodeGen.inline(InlineTarget.create(GetTupleStorage.class, STATE_0_GetNewargsNode_UPDATER.subUpdater(1, 2), ReferenceField.create(MethodHandles.lookup(), "getTupleStorage__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetNewargsNode#doIt}
             *   1-2: InlinedCache
             *        Specialization: {@link GetNewargsNode#doIt}
             *        Parameter: {@link GetTupleStorage} getTupleStorage
             *        Inline method: {@link GetTupleStorageNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewargsNode#doIt}
             *   Parameter: {@link GetTupleStorage} getTupleStorage
             *   Inline method: {@link GetTupleStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getTupleStorage__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewargsNode#doIt}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private GetNewargsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TupleBuiltins.GetNewargsNode.doIt(Object, Node, GetTupleStorage, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return GetNewargsNode.doIt(arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PTuple executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.GetNewargsNode.doIt(Object, Node, GetTupleStorage, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return GetNewargsNode.doIt(arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, factory__);
                }
            }

        }
    }
    @GeneratedBy(ClassGetItemNode.class)
    public static final class ClassGetItemNodeFactory implements NodeFactory<ClassGetItemNode> {

        private static final ClassGetItemNodeFactory CLASS_GET_ITEM_NODE_FACTORY_INSTANCE = new ClassGetItemNodeFactory();

        private ClassGetItemNodeFactory() {
        }

        @Override
        public Class<ClassGetItemNode> getNodeClass() {
            return ClassGetItemNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ClassGetItemNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ClassGetItemNode> getInstance() {
            return CLASS_GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ClassGetItemNode create() {
            return new ClassGetItemNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ClassGetItemNode#classGetItem}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(ClassGetItemNode.class)
        @SuppressWarnings("javadoc")
        public static final class ClassGetItemNodeGen extends ClassGetItemNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ClassGetItemNode#classGetItem}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ClassGetItemNode#classGetItem}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private ClassGetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[TupleBuiltins.ClassGetItemNode.classGetItem(Object, Object, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            return ClassGetItemNode.classGetItem(arg0Value, arg1Value, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[TupleBuiltins.ClassGetItemNode.classGetItem(Object, Object, PythonObjectFactory)] */;
                this.state_0_ = state_0;
                return ClassGetItemNode.classGetItem(arg0Value, arg1Value, factory__);
            }

        }
    }
}
