// CheckStyle: start generated
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.frame.PFrame.Reference;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link GetCurrentFrameRef#doWithFrame}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link GetCurrentFrameRef#doWithoutFrame}
 *     Activation probability: 0.33333
 *     With/without class size: 9/4 bytes
 *   Specialization {@link GetCurrentFrameRef#doGeneric}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre> */
@GeneratedBy(GetCurrentFrameRef.class)
@SuppressWarnings("javadoc")
public final class GetCurrentFrameRefNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static GetCurrentFrameRef getUncached() {
        return GetCurrentFrameRefNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#withoutFrame_flag_}
     * </ul> */
    @NeverDefault
    public static GetCurrentFrameRef inline(@RequiredField(bits = 3, value = StateField.class)@RequiredField(dimensions = 1, type = Object[].class, value = ReferenceField.class) InlineTarget target) {
        return new GetCurrentFrameRefNodeGen.Inlined(target);
    }

    @GeneratedBy(GetCurrentFrameRef.class)
    @DenyReplace
    private static final class Inlined extends GetCurrentFrameRef implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link GetCurrentFrameRef#doWithFrame}
         *   1: SpecializationActive {@link GetCurrentFrameRef#doGeneric}
         *   2: SpecializationActive {@link GetCurrentFrameRef#doWithoutFrame}
         * </pre> */
        private final StateField state_0_;
        private final ReferenceField<ConditionProfile[]> withoutFrame_flag_;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(GetCurrentFrameRef.class);
            this.state_0_ = target.getState(0, 3);
            this.withoutFrame_flag_ = target.getReference(1, ConditionProfile[].class);
        }

        @Override
        public Reference execute(Frame frameValue, Node arg0Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0 /* is SpecializationActive[GetCurrentFrameRef.doWithFrame(Frame)] || SpecializationActive[GetCurrentFrameRef.doWithoutFrame(Frame, ConditionProfile[])] || SpecializationActive[GetCurrentFrameRef.doGeneric(Frame)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[GetCurrentFrameRef.doWithFrame(Frame)] */) {
                    if ((frameValue != null)) {
                        return GetCurrentFrameRef.doWithFrame(frameValue);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[GetCurrentFrameRef.doWithoutFrame(Frame, ConditionProfile[])] */) {
                    {
                        ConditionProfile[] flag__ = this.withoutFrame_flag_.get(arg0Value);
                        if (flag__ != null) {
                            if ((frameValue == null)) {
                                return doWithoutFrame(frameValue, flag__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[GetCurrentFrameRef.doGeneric(Frame)] */) {
                    return doGeneric(frameValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value);
        }

        private Reference executeAndSpecialize(Frame frameValue, Node arg0Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[GetCurrentFrameRef.doGeneric(Frame)] */) {
                if ((frameValue != null)) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GetCurrentFrameRef.doWithFrame(Frame)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return GetCurrentFrameRef.doWithFrame(frameValue);
                }
            }
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[GetCurrentFrameRef.doGeneric(Frame)] */) {
                if ((frameValue == null)) {
                    ConditionProfile[] flag__ = (GetCurrentFrameRef.getFlag());
                    Objects.requireNonNull(flag__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.withoutFrame_flag_.set(arg0Value, flag__);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[GetCurrentFrameRef.doWithoutFrame(Frame, ConditionProfile[])] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doWithoutFrame(frameValue, flag__);
                }
            }
            this.withoutFrame_flag_.set(arg0Value, null);
            state_0 = state_0 & 0xfffffffa /* remove SpecializationActive[GetCurrentFrameRef.doWithFrame(Frame)], SpecializationActive[GetCurrentFrameRef.doWithoutFrame(Frame, ConditionProfile[])] */;
            state_0 = state_0 | 0b10 /* add SpecializationActive[GetCurrentFrameRef.doGeneric(Frame)] */;
            this.state_0_.set(arg0Value, state_0);
            return doGeneric(frameValue);
        }

    }
    @GeneratedBy(GetCurrentFrameRef.class)
    @DenyReplace
    private static final class Uncached extends GetCurrentFrameRef implements UnadoptableNode {

        @Override
        public Reference execute(Frame frameValue, Node arg0Value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return doGeneric(frameValue);
        }

    }
}
