/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNodeGen;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class MaybeBindDescriptorNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    public static Object executeUncached(Frame frame, Object descriptor, Object receiver, Object receiverType) {
        return MaybeBindDescriptorNodeGen.getUncached().execute(frame, null, descriptor, receiver, receiverType);
    }

    @Specialization(guards={"isNoValue(descriptor)"})
    static Object doNoValue(Object descriptor, Object receiver, Object receiverType) {
        return descriptor;
    }

    @Specialization
    static Object doBuiltin(BuiltinMethodDescriptor descriptor, Object receiver, Object receiverType) {
        return descriptor;
    }

    @Specialization
    static Object doBuiltin(PBuiltinFunction descriptor, Object receiver, Object receiverType) {
        return descriptor;
    }

    @Specialization
    static Object doBuiltin(PBuiltinMethod descriptor, Object receiver, Object receiverType) {
        return new BoundDescriptor(descriptor);
    }

    @Specialization
    static Object doFunction(PFunction descriptor, Object receiver, Object receiverType) {
        return descriptor;
    }

    public static boolean isMethodDescriptor(Object descriptor) {
        PBuiltinFunction pbf;
        return descriptor instanceof BuiltinMethodDescriptor || descriptor instanceof PBuiltinFunction && !(pbf = (PBuiltinFunction)descriptor).needsDeclaringType() || descriptor instanceof PFunction;
    }

    public static boolean needsToBind(Object descriptor) {
        return descriptor != PNone.NO_VALUE && !MaybeBindDescriptorNode.isMethodDescriptor(descriptor);
    }

    @Specialization(guards={"needsToBind(descriptor)"})
    static Object doBind(VirtualFrame frame, Node inliningTarget, Object descriptor, Object receiver, Object receiverType, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TpSlotDescrGet.CallSlotDescrGet callGetNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, descriptor);
        if (slots.tp_descr_get() != null) {
            return new BoundDescriptor(callGetNode.execute(frame, inliningTarget, slots.tp_descr_get(), descriptor, receiver, receiverType));
        }
        return new BoundDescriptor(descriptor);
    }
}

