/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorArray;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorObject;
import com.oracle.truffle.tools.chromeinspector.objects.JSONTruffleArray;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public final class JSONTruffleObject
extends AbstractInspectorObject {
    private final JSONObject json;
    private final TruffleObject keys;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private volatile String[] names;

    public JSONTruffleObject(JSONObject json) {
        this.json = json;
        this.keys = new JSONKeys(this);
    }

    protected TruffleObject getMembers(boolean includeInternal) {
        return this.keys;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean isField(String name) {
        return this.json.has(name);
    }

    @Override
    protected boolean isMethod(String name) {
        return false;
    }

    private String[] getNames() {
        if (this.names == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.names = this.json.keySet().toArray(new String[this.json.length()]);
        }
        return this.names;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object getFieldValueOrNull(String name) {
        Object value = this.json.opt(name);
        if (value != null) {
            value = JSONTruffleObject.getTruffleValueFromJSONValue(value);
        }
        return value;
    }

    @Override
    protected Object invokeMember(String name, Object[] arguments) throws UnknownIdentifierException {
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create((String)name);
    }

    static Object getTruffleValueFromJSONValue(Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (value instanceof JSONObject) {
            return new JSONTruffleObject((JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return new JSONTruffleArray((JSONArray)value);
        }
        return value;
    }

    @Override
    TriState isIdenticalOrUndefined(Object other) {
        if (other instanceof JSONTruffleObject) {
            JSONTruffleObject otherObject = (JSONTruffleObject)other;
            return TriState.valueOf((this.json == otherObject.json ? 1 : 0) != 0);
        }
        return TriState.UNDEFINED;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    int identityHashCode() {
        return this.json.hashCode();
    }

    static final class JSONKeys
    extends AbstractInspectorArray {
        private final JSONTruffleObject obj;

        JSONKeys(JSONTruffleObject obj) {
            this.obj = obj;
        }

        @Override
        int getArraySize() {
            return this.obj.getNames().length;
        }

        @Override
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            String[] allNames = this.obj.getNames();
            if (index < 0L || index >= (long)allNames.length) {
                CompilerDirectives.transferToInterpreter();
                throw InvalidArrayIndexException.create((long)index);
            }
            return allNames[(int)index];
        }

        @Override
        TriState isIdenticalOrUndefined(Object other) {
            if (other instanceof JSONKeys) {
                JSONKeys otherKeys = (JSONKeys)other;
                return TriState.valueOf((this.obj == otherKeys.obj ? 1 : 0) != 0);
            }
            return TriState.UNDEFINED;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        int identityHashCode() {
            return this.obj.hashCode();
        }
    }
}

