/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorArray;
import java.util.Arrays;

public final class JavaTruffleArray
extends AbstractInspectorArray {
    private final Object[] array;

    JavaTruffleArray(Object[] array) {
        this.array = array;
    }

    @Override
    int getArraySize() {
        return this.array.length;
    }

    @Override
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (index < 0L || index >= (long)this.array.length) {
            CompilerDirectives.transferToInterpreter();
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.array[(int)index];
    }

    @Override
    TriState isIdenticalOrUndefined(Object other) {
        if (other instanceof JavaTruffleArray) {
            JavaTruffleArray otherArray = (JavaTruffleArray)other;
            return TriState.valueOf((this.array == otherArray.array ? 1 : 0) != 0);
        }
        return TriState.UNDEFINED;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    int identityHashCode() {
        return Arrays.hashCode(this.array);
    }
}

