/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.tools.chromeinspector.types.Location;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public final class Scope {
    private final String type;
    private final RemoteObject object;
    private final String name;
    private final Location startLocation;
    private final Location endLocation;
    private final int internalIndex;

    public Scope(String type, RemoteObject object, String name, Location startLocation, Location endLocation, int internalIndex) {
        this.type = type;
        this.object = object;
        this.name = name;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.internalIndex = internalIndex;
    }

    public String getType() {
        return this.type;
    }

    public RemoteObject getObject() {
        return this.object;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public Location getEndLocation() {
        return this.endLocation;
    }

    public int getInternalIndex() {
        return this.internalIndex;
    }

    private JSONObject createJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.type);
        json.put("object", (Object)this.object.toJSON());
        json.putOpt("name", (Object)this.name);
        if (this.startLocation != null) {
            json.put("startLocation", (Object)this.startLocation.toJSON());
        }
        if (this.endLocation != null) {
            json.put("endLocation", (Object)this.endLocation.toJSON());
        }
        return json;
    }

    static JSONArray createScopesJSON(Scope[] scopes) {
        JSONArray array = new JSONArray();
        for (Scope scope : scopes) {
            DebugScope dscope = scope.object.getScope();
            if (!dscope.isFunctionScope() && !dscope.getDeclaredValues().iterator().hasNext()) continue;
            array.put((Object)scope.createJSON());
        }
        return array;
    }
}

