/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.LanguageChecks;
import com.oracle.truffle.tools.chromeinspector.objects.NullObject;
import com.oracle.truffle.tools.chromeinspector.types.CustomPreview;
import com.oracle.truffle.tools.chromeinspector.types.ObjectPreview;
import com.oracle.truffle.tools.chromeinspector.types.TypeInfo;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class RemoteObject {
    private static final Double NEGATIVE_DOUBLE_0 = Double.valueOf("-0");
    private static final Float NEGATIVE_FLOAT_0 = Float.valueOf("-0");
    private static final AtomicLong LAST_ID = new AtomicLong(0L);
    private final DebugValue valueValue;
    private final DebugScope valueScope;
    private final boolean generatePreview;
    private final String objectId;
    private final InspectorExecutionContext context;
    private final IndexRange indexRange;
    private TypeInfo typeInfo;
    private Object value;
    private boolean replicableValue;
    private String unserializableValue;
    private String description;
    private JSONObject preview;
    private JSONObject customPreview;
    private JSONObject jsonObject;
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    public RemoteObject(DebugValue debugValue, boolean generatePreview, InspectorExecutionContext context) {
        this(debugValue, false, generatePreview, context);
    }

    public RemoteObject(DebugValue debugValue, boolean readEagerly, boolean generatePreview, InspectorExecutionContext context) {
        this(debugValue, readEagerly, generatePreview, context, null);
    }

    public RemoteObject(DebugValue debugValue, boolean readEagerly, boolean generatePreview, InspectorExecutionContext context, IndexRange indexRange) {
        this.valueValue = debugValue;
        this.valueScope = null;
        this.generatePreview = generatePreview;
        this.context = context;
        this.indexRange = indexRange;
        if (!debugValue.hasReadSideEffects() || readEagerly) {
            boolean isObject = this.initFromValue();
            this.objectId = isObject ? Long.toString(LAST_ID.incrementAndGet()) : null;
            this.jsonObject = this.createJSON();
        } else {
            this.objectId = Long.toString(LAST_ID.incrementAndGet());
        }
    }

    private boolean initFromValue() {
        block27: {
            boolean readable;
            PrintWriter err;
            LanguageInfo originalLanguage;
            DebugValue debugValue;
            block26: {
                String toString;
                debugValue = this.valueValue;
                originalLanguage = debugValue.getOriginalLanguage();
                if (originalLanguage != null) {
                    debugValue = debugValue.asInLanguage(originalLanguage);
                }
                err = this.context != null ? this.context.getErr() : null;
                this.typeInfo = TypeInfo.fromValue(debugValue, originalLanguage, err);
                readable = debugValue.isReadable();
                boolean addType = true;
                Object rawValue = null;
                String unserializable = null;
                boolean replicableRawValue = true;
                try {
                    if (readable) {
                        SourceSection sourceSection;
                        if (this.typeInfo.isFunction && (sourceSection = debugValue.getSourceLocation()) != null && sourceSection.isAvailable() && sourceSection.getSource().hasCharacters()) {
                            toString = sourceSection.getCharacters().toString();
                            addType = false;
                        } else {
                            toString = debugValue.toDisplayString(this.context.areToStringSideEffectsAllowed());
                            if (TypeInfo.TYPE.STRING.getId().equals(this.typeInfo.type) || TypeInfo.TYPE.SYMBOL.getId().equals(this.typeInfo.type)) {
                                addType = false;
                            }
                        }
                    } else {
                        toString = "<not readable>";
                        replicableRawValue = false;
                    }
                    if (readable && !this.typeInfo.isObject) {
                        if ("null".equals(this.typeInfo.subtype) && TypeInfo.TYPE.OBJECT.getId().equals(this.typeInfo.type)) {
                            replicableRawValue = false;
                        } else if (TypeInfo.TYPE.UNDEFINED.getId().equals(this.typeInfo.type)) {
                            replicableRawValue = false;
                        } else if (debugValue.isBoolean()) {
                            rawValue = debugValue.asBoolean();
                        } else if (debugValue.isNumber()) {
                            rawValue = TypeInfo.toNumber(debugValue);
                            if (!RemoteObject.isFinite((Number)rawValue)) {
                                unserializable = rawValue.toString();
                                rawValue = null;
                            }
                        } else {
                            replicableRawValue = false;
                            rawValue = toString;
                        }
                    }
                }
                catch (DebugException ex) {
                    if (err != null && ex.isInternalError()) {
                        err.println(debugValue.getName() + " toDisplayString() has caused: " + (Object)((Object)ex));
                        ex.printStackTrace(err);
                    }
                    throw ex;
                }
                this.value = rawValue;
                this.replicableValue = replicableRawValue;
                this.unserializableValue = unserializable;
                this.description = addType && this.typeInfo.descriptionType != null && !this.typeInfo.descriptionType.equals(toString) ? this.typeInfo.descriptionType + (toString != null && !toString.isEmpty() ? " " + toString : "") : toString;
                if (this.typeInfo.isObject && addType && this.typeInfo.isJS && this.generatePreview) {
                    try {
                        this.preview = ObjectPreview.create(debugValue, this.typeInfo.type, this.typeInfo.subtype, this.context.areToStringSideEffectsAllowed(), originalLanguage, err);
                    }
                    catch (DebugException ex) {
                        if (err == null || !ex.isInternalError()) break block26;
                        err.println(debugValue.getName() + " preview has caused: " + (Object)((Object)ex));
                        ex.printStackTrace(err);
                    }
                }
            }
            if (readable && this.context != null && this.context.isCustomObjectFormatterEnabled() && originalLanguage != null) {
                try {
                    this.customPreview = CustomPreview.create(debugValue, originalLanguage, this.context);
                }
                catch (DebugException ex) {
                    if (err == null) break block27;
                    if (ex.isInternalError()) {
                        err.println(debugValue.getName() + " custom preview has caused: " + (Object)((Object)ex));
                        ex.printStackTrace(err);
                    }
                    err.println("Custom Formatter Failed: " + ex.getLocalizedMessage());
                }
            }
        }
        return this.typeInfo.isObject;
    }

    public RemoteObject(DebugScope scope) {
        this(scope, null);
    }

    public RemoteObject(DebugScope scope, String objectId) {
        this.valueValue = null;
        this.valueScope = scope;
        this.generatePreview = false;
        this.context = null;
        this.indexRange = null;
        this.typeInfo = new TypeInfo(TypeInfo.TYPE.OBJECT.getId(), null, null, null, true, false, false, false);
        this.value = null;
        this.replicableValue = false;
        this.unserializableValue = null;
        this.objectId = objectId == null ? Long.toString(LAST_ID.incrementAndGet()) : objectId;
        this.description = scope.getName();
        this.jsonObject = this.createJSON();
    }

    private RemoteObject(String type, String subtype, String className, String description) {
        this.valueValue = null;
        this.valueScope = null;
        this.generatePreview = false;
        this.context = null;
        this.indexRange = null;
        this.typeInfo = new TypeInfo(type, subtype, className, null, true, false, false, false);
        this.value = null;
        this.replicableValue = false;
        this.unserializableValue = null;
        this.objectId = Long.toString(LAST_ID.incrementAndGet());
        this.description = description;
        this.jsonObject = this.createJSON();
    }

    public static RemoteObject createSimpleObject(String type, String className, String description) {
        return new RemoteObject(type, null, className, description);
    }

    public static RemoteObject createNullObject(TruffleInstrument.Env env, LanguageInfo language) {
        String nullStr;
        try {
            nullStr = INTEROP.asString(INTEROP.toDisplayString(env.getLanguageView(language, (Object)NullObject.INSTANCE)));
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)e);
        }
        return new RemoteObject("object", "null", null, nullStr);
    }

    private JSONObject createJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.typeInfo.type);
        json.putOpt("subtype", (Object)this.typeInfo.subtype);
        json.putOpt("className", (Object)this.typeInfo.className);
        json.putOpt("unserializableValue", (Object)this.unserializableValue);
        json.putOpt("value", this.value);
        if (this.typeInfo.isNull) {
            json.put("value", JSONObject.NULL);
        }
        json.putOpt("description", (Object)this.description);
        json.putOpt("objectId", (Object)this.objectId);
        json.putOpt("preview", (Object)this.preview);
        json.putOpt("customPreview", (Object)this.customPreview);
        return json;
    }

    static DebugValue getMetaObject(DebugValue debugValue, LanguageInfo originalLanguage, PrintWriter err) {
        DebugValue metaObject;
        try {
            metaObject = debugValue.getMetaObject();
            if (originalLanguage != null && metaObject != null) {
                metaObject = metaObject.asInLanguage(originalLanguage);
            }
        }
        catch (DebugException ex) {
            if (err != null && ex.isInternalError()) {
                err.println("getMetaObject(" + debugValue.getName() + ") has caused: " + (Object)((Object)ex));
                ex.printStackTrace(err);
            }
            throw ex;
        }
        return metaObject;
    }

    static String toString(DebugValue value, boolean allowSideEffects, PrintWriter err) {
        if (!value.isReadable()) {
            return "<not readable>";
        }
        try {
            return value.toDisplayString(allowSideEffects);
        }
        catch (DebugException ex) {
            if (err != null && ex.isInternalError()) {
                err.println(value.getName() + " toDisplayString() has caused: " + (Object)((Object)ex));
                ex.printStackTrace(err);
            }
            throw ex;
        }
    }

    static String toMetaName(DebugValue metaValue, PrintWriter err) {
        try {
            return metaValue.getMetaSimpleName();
        }
        catch (DebugException ex) {
            if (err != null && ex.isInternalError()) {
                err.println(" getMetaSimpleName() has caused: " + (Object)((Object)ex));
                ex.printStackTrace(err);
            }
            return null;
        }
    }

    public static JSONObject createJSONResultValue(DebugValue debugValue, boolean allowToStringSideEffects, PrintWriter err) {
        JSONObject json = new JSONObject();
        DebugValue metaObject = RemoteObject.getMetaObject(debugValue, null, err);
        boolean isObject = TypeInfo.isObject(debugValue, err);
        boolean isJS = LanguageChecks.isJS(debugValue.getOriginalLanguage());
        String vtype = null;
        if (metaObject != null & isJS) {
            try {
                Collection properties = metaObject.getProperties();
                if (properties != null) {
                    for (DebugValue prop : properties) {
                        String name = prop.getName();
                        if (!"type".equals(name)) continue;
                        vtype = RemoteObject.toMetaName(prop, err);
                    }
                }
            }
            catch (DebugException ex) {
                if (err != null && ex.isInternalError()) {
                    err.println("getProperties of meta object of (" + debugValue.getName() + ") has caused: " + (Object)((Object)ex));
                    ex.printStackTrace(err);
                }
                throw ex;
            }
        }
        if (vtype == null) {
            vtype = isObject ? "object" : (metaObject != null ? RemoteObject.toString(metaObject, allowToStringSideEffects, err) : "object");
        }
        json.put("type", (Object)vtype);
        String[] unserializablePtr = new String[1];
        try {
            json.putOpt("value", RemoteObject.createJSONValue(debugValue, allowToStringSideEffects, unserializablePtr, err));
        }
        catch (DebugException ex) {
            if (err != null && ex.isInternalError()) {
                err.println("getProperties(" + debugValue.getName() + ") has caused: " + (Object)((Object)ex));
                ex.printStackTrace(err);
            }
            throw ex;
        }
        json.putOpt("unserializableValue", (Object)unserializablePtr[0]);
        return json;
    }

    private static Object createJSONValue(DebugValue debugValue, boolean allowToStringSideEffects, String[] unserializablePtr, PrintWriter err) {
        List valueArray;
        if (!debugValue.isReadable()) {
            return "<not readable>";
        }
        if (debugValue.isArray() && (valueArray = debugValue.getArray()) != null) {
            JSONArray array = new JSONArray();
            for (DebugValue element : valueArray) {
                array.put(RemoteObject.createJSONValue(element, allowToStringSideEffects, null, err));
            }
            return array;
        }
        Collection properties = debugValue.getProperties();
        if (properties != null) {
            JSONObject props = new JSONObject();
            for (DebugValue property : properties) {
                props.put(property.getName(), RemoteObject.createJSONValue(property, allowToStringSideEffects, null, err));
            }
            return props;
        }
        if (unserializablePtr != null) {
            Number num;
            if (debugValue.isBoolean()) {
                return debugValue.asBoolean();
            }
            if (debugValue.isNumber() && (num = TypeInfo.toNumber(debugValue)) != null) {
                if (!RemoteObject.isFinite(num)) {
                    unserializablePtr[0] = num.toString();
                    return null;
                }
                return num;
            }
        }
        return debugValue.toDisplayString(allowToStringSideEffects);
    }

    public String getId() {
        return this.objectId;
    }

    public JSONObject toJSON() {
        if (this.jsonObject == null) {
            this.initFromValue();
            this.jsonObject = this.createJSON();
        }
        return this.jsonObject;
    }

    public boolean isReplicable() {
        return this.replicableValue;
    }

    public DebugValue getDebugValue() {
        return this.valueValue;
    }

    public Object getRawValue() {
        return this.value;
    }

    public DebugScope getScope() {
        return this.valueScope;
    }

    public IndexRange getIndexRange() {
        return this.indexRange;
    }

    private static boolean isFinite(Number n) {
        if (n instanceof Double) {
            Double d = (Double)n;
            return !d.isInfinite() && !d.isNaN() && !d.equals(NEGATIVE_DOUBLE_0);
        }
        if (n instanceof Float) {
            Float f = (Float)n;
            return !f.isInfinite() && !f.isNaN() && !f.equals(NEGATIVE_FLOAT_0);
        }
        return true;
    }

    public static void resetIDs() {
        LAST_ID.set(0L);
    }

    public static final class IndexRange {
        private int start;
        private int end;
        private boolean named;

        public IndexRange(int start, int end, boolean named) {
            this.start = start;
            this.end = end;
            this.named = named;
        }

        public boolean isNamed() {
            return this.named;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }
    }
}

