/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugStackTraceElement;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.List;

public final class StackTrace {
    private final JSONObject jsonObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTrace(InspectorExecutionContext context, List<List<DebugStackTraceElement>> stacks) {
        JSONObject jsonStack = this.jsonObject = new JSONObject();
        JSONObject jsonParentStack = null;
        for (List<DebugStackTraceElement> frames : stacks) {
            if (jsonParentStack != null) {
                jsonStack.put("parent", jsonParentStack);
                jsonStack = jsonParentStack;
            }
            JSONArray callFrames = new JSONArray();
            for (DebugStackTraceElement frame : frames) {
                SourceSection sourceSection = frame.getSourceSection();
                if (sourceSection == null || !context.isInspectInternal() && frame.isInternal()) continue;
                Source source = sourceSection.getSource();
                if (!context.isInspectInternal() && source.isInternal()) continue;
                JSONObject callFrame = new JSONObject();
                callFrame.put("functionName", (Object)frame.getName());
                ScriptsHandler sch = context.acquireScriptsHandler();
                try {
                    int scriptId = sch.assureLoaded(source);
                    if (scriptId == -1) continue;
                    callFrame.put("scriptId", (Object)Integer.toString(scriptId));
                    callFrame.put("url", (Object)sch.getScript(scriptId).getUrl());
                    callFrame.put("lineNumber", sourceSection.getStartLine() - 1);
                    callFrame.put("columnNumber", sourceSection.getStartColumn() - 1);
                    callFrames.put((Object)callFrame);
                }
                finally {
                    context.releaseScriptsHandler();
                }
            }
            jsonStack.put("callFrames", (Object)callFrames);
            jsonParentStack = new JSONObject();
        }
    }

    public JSONObject toJSON() {
        return this.jsonObject;
    }
}

