/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.websockets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;
import org.nanohttpd.protocols.websockets.CloseCode;
import org.nanohttpd.protocols.websockets.CloseFrame;
import org.nanohttpd.protocols.websockets.NanoWSD;
import org.nanohttpd.protocols.websockets.OpCode;
import org.nanohttpd.protocols.websockets.State;
import org.nanohttpd.protocols.websockets.WebSocketException;
import org.nanohttpd.protocols.websockets.WebSocketFrame;

public abstract class WebSocket {
    private final InputStream in;
    private OutputStream out;
    private OpCode continuousOpCode = null;
    private final List<WebSocketFrame> continuousFrames = new LinkedList<WebSocketFrame>();
    private State state = State.UNCONNECTED;
    protected boolean enforceNoGzip = true;
    private final IHTTPSession handshakeRequest;
    private final Response handshakeResponse = new Response(Status.SWITCH_PROTOCOL, null, null, 0L){

        @Override
        public void send(OutputStream out) {
            WebSocket.this.out = out;
            WebSocket.this.state = State.CONNECTING;
            super.send(out);
            WebSocket.this.state = State.OPEN;
            WebSocket.this.onOpen();
            WebSocket.this.readWebsocket();
        }
    };

    public WebSocket(IHTTPSession handshakeRequest) {
        this.handshakeRequest = handshakeRequest;
        this.in = handshakeRequest.getInputStream();
        if (this.enforceNoGzip) {
            this.handshakeResponse.setUseGzip(false);
        }
        this.handshakeResponse.addHeader("upgrade", "websocket");
        this.handshakeResponse.addHeader("connection", "Upgrade");
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    protected abstract void onOpen();

    protected abstract void onClose(CloseCode var1, String var2, boolean var3);

    protected abstract void onMessage(WebSocketFrame var1);

    protected abstract void onPong(WebSocketFrame var1);

    protected abstract void onException(IOException var1);

    protected void debugFrameReceived(WebSocketFrame frame) {
    }

    protected void debugFrameSent(WebSocketFrame frame) {
    }

    public void close(CloseCode code, String reason, boolean initiatedByRemote) throws IOException {
        State oldState = this.state;
        this.state = State.CLOSING;
        if (oldState == State.OPEN) {
            this.sendFrame(new CloseFrame(code, reason));
        } else {
            this.doClose(code, reason, initiatedByRemote);
        }
    }

    private void doClose(CloseCode code, String reason, boolean initiatedByRemote) {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                NanoWSD.LOG.log(Level.FINE, "close failed", e);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                NanoWSD.LOG.log(Level.FINE, "close failed", e);
            }
        }
        this.state = State.CLOSED;
        this.onClose(code, reason, initiatedByRemote);
    }

    public IHTTPSession getHandshakeRequest() {
        return this.handshakeRequest;
    }

    public Response getHandshakeResponse() {
        return this.handshakeResponse;
    }

    private void handleCloseFrame(WebSocketFrame frame) throws IOException {
        CloseCode code = CloseCode.NormalClosure;
        String reason = "";
        if (frame instanceof CloseFrame) {
            code = ((CloseFrame)frame).getCloseCode();
            reason = ((CloseFrame)frame).getCloseReason();
        }
        if (this.state == State.CLOSING) {
            this.doClose(code, reason, false);
        } else {
            this.close(code, reason, true);
        }
    }

    private void handleFrameFragment(WebSocketFrame frame) throws IOException {
        if (frame.getOpCode() != OpCode.Continuation) {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Previous continuous frame sequence not completed.");
            }
            this.continuousOpCode = frame.getOpCode();
            this.continuousFrames.clear();
            this.continuousFrames.add(frame);
        } else if (frame.isFin()) {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
            this.onMessage(new WebSocketFrame(this.continuousOpCode, this.continuousFrames));
            this.continuousOpCode = null;
            this.continuousFrames.clear();
        } else {
            if (this.continuousOpCode == null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence was not started.");
            }
            this.continuousFrames.add(frame);
        }
    }

    private void handleWebsocketFrame(WebSocketFrame frame) throws IOException {
        this.debugFrameReceived(frame);
        if (frame.getOpCode() == OpCode.Close) {
            this.handleCloseFrame(frame);
        } else if (frame.getOpCode() == OpCode.Ping) {
            this.sendFrame(new WebSocketFrame(OpCode.Pong, true, frame.getBinaryPayload()));
        } else if (frame.getOpCode() == OpCode.Pong) {
            this.onPong(frame);
        } else if (!frame.isFin() || frame.getOpCode() == OpCode.Continuation) {
            this.handleFrameFragment(frame);
        } else {
            if (this.continuousOpCode != null) {
                throw new WebSocketException(CloseCode.ProtocolError, "Continuous frame sequence not completed.");
            }
            if (frame.getOpCode() == OpCode.Text || frame.getOpCode() == OpCode.Binary) {
                this.onMessage(frame);
            } else {
                throw new WebSocketException(CloseCode.ProtocolError, "Non control or continuous frame expected.");
            }
        }
    }

    public void ping(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Ping, true, payload));
    }

    private void readWebsocket() {
        try {
            while (this.state == State.OPEN) {
                this.handleWebsocketFrame(WebSocketFrame.read(this.in));
            }
        }
        catch (CharacterCodingException e) {
            this.onException(e);
            this.doClose(CloseCode.InvalidFramePayloadData, e.toString(), false);
        }
        catch (IOException e) {
            this.onException(e);
            if (e instanceof WebSocketException) {
                this.doClose(((WebSocketException)e).getCode(), ((WebSocketException)e).getReason(), false);
            }
        }
        finally {
            this.doClose(CloseCode.InternalServerError, "Handler terminated without closing the connection.", false);
        }
    }

    public void send(byte[] payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Binary, true, payload));
    }

    public void send(String payload) throws IOException {
        this.sendFrame(new WebSocketFrame(OpCode.Text, true, payload));
    }

    public synchronized void sendFrame(WebSocketFrame frame) throws IOException {
        this.debugFrameSent(frame);
        frame.write(this.out);
    }
}

