/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.grails.datastore.gorm.mongo.bean.factory.MongoClientFactoryBean;
import org.grails.datastore.gorm.mongo.extensions.MongoExtensions;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.mongo.MongoCodecSession;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.grails.datastore.mapping.mongo.engine.codecs.AdditionalCodecs;
import org.grails.datastore.mapping.mongo.engine.codecs.PersistentEntityCodec;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.env.PropertyResolver;

public class MongoDatastore
extends AbstractDatastore
implements InitializingBean,
MappingContext.Listener,
DisposableBean,
StatelessDatastore {
    public static final String SETTING_DATABASE_NAME = "grails.mongodb.databaseName";
    public static final String SETTING_CONNECTION_STRING = "grails.mongodb.connectionString";
    public static final String SETTING_URL = "grails.mongodb.url";
    public static final String SETTING_DEFAULT_MAPPING = "grails.mongodb.default.mapping";
    public static final String SETTING_OPTIONS = "grails.mongodb.options";
    public static final String SETTING_HOST = "grails.mongodb.host";
    public static final String SETTING_PORT = "grails.mongodb.port";
    public static final String SETTING_USERNAME = "grails.mongodb.username";
    public static final String SETTING_PASSWORD = "grails.mongodb.password";
    public static final String SETTING_REPLICA_SET = "grails.mongodb.replicaSet";
    public static final String SETTING_REPLICA_PAIR = "grails.mongodb.replicaPair";
    public static final String SETTING_STATELESS = "grails.mongodb.stateless";
    public static final String SETTING_ENGINE = "grails.mongodb.engine";
    public static final String INDEX_ATTRIBUTES = "indexAttributes";
    public static final String CODEC_ENGINE = "codec";
    protected MongoClient mongo;
    protected MongoClientOptions mongoOptions;
    protected final String defaultDatabase;
    protected Map<PersistentEntity, String> mongoCollections = new ConcurrentHashMap<PersistentEntity, String>();
    protected Map<PersistentEntity, String> mongoDatabases = new ConcurrentHashMap<PersistentEntity, String>();
    protected boolean stateless = false;
    protected boolean codecEngine = true;
    protected CodecRegistry codecRegistry;

    public MongoDatastore(MongoMappingContext mappingContext, Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, MongoDatastore.mapToPropertyResolver(connectionDetails), ctx);
    }

    public MongoDatastore(MongoMappingContext mappingContext, PropertyResolver configuration, ConfigurableApplicationContext ctx) {
        super((MappingContext)mappingContext, configuration, ctx);
        if (mappingContext != null) {
            mappingContext.addMappingContextListener(this);
        }
        this.defaultDatabase = mappingContext.getDefaultDatabaseName();
        this.initializeConverters((MappingContext)mappingContext);
        ConverterRegistry converterRegistry = mappingContext.getConverterRegistry();
        converterRegistry.addConverter((Converter)new Converter<String, ObjectId>(){

            public ObjectId convert(String source) {
                return new ObjectId(source);
            }
        });
        converterRegistry.addConverter((Converter)new Converter<ObjectId, String>(){

            public String convert(ObjectId source) {
                return source.toString();
            }
        });
        converterRegistry.addConverter((Converter)new Converter<byte[], Binary>(){

            public Binary convert(byte[] source) {
                return new Binary(source);
            }
        });
        converterRegistry.addConverter((Converter)new Converter<Binary, byte[]>(){

            public byte[] convert(Binary source) {
                return source.getData();
            }
        });
        for (Converter converter : AdditionalCodecs.getBsonConverters()) {
            converterRegistry.addConverter(converter);
        }
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new AdditionalCodecs(), new PersistentEntityCodeRegistry()})});
    }

    public MongoDatastore(MongoMappingContext mappingContext, ConfigurableApplicationContext ctx) {
        this(mappingContext, (PropertyResolver)ctx.getEnvironment(), ctx);
    }

    public MongoDatastore() {
        this(new MongoMappingContext("test"), Collections.emptyMap(), null);
    }

    public MongoDatastore(MongoMappingContext mappingContext, Map<String, Object> connectionDetails, MongoClientOptions mongoOptions, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        if (mongoOptions != null) {
            this.mongoOptions = mongoOptions;
        }
    }

    public MongoDatastore(MongoMappingContext mappingContext) {
        this(mappingContext, Collections.emptyMap(), null);
    }

    public MongoDatastore(MongoMappingContext mappingContext, MongoClient mongo, ConfigurableApplicationContext ctx) {
        this(mappingContext, (PropertyResolver)ctx.getEnvironment(), ctx);
        this.mongo = mongo;
    }

    public MongoDatastore(MongoMappingContext mappingContext, MongoClient mongo, Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        this.mongo = mongo;
    }

    @Deprecated
    public MongoDatastore(MongoMappingContext mappingContext, Mongo mongo, ConfigurableApplicationContext ctx) {
        this(mappingContext, (PropertyResolver)ctx.getEnvironment(), ctx);
        this.mongo = (MongoClient)mongo;
    }

    @Deprecated
    public MongoDatastore(MongoMappingContext mappingContext, Mongo mongo, Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        this.mongo = (MongoClient)mongo;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Autowired(required=false)
    public void setCodecRegistries(List<CodecRegistry> codecRegistries) {
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.codecRegistry, CodecRegistries.fromRegistries(codecRegistries)});
    }

    @Autowired(required=false)
    public void setCodecProviders(List<CodecProvider> codecProviders) {
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.codecRegistry, CodecRegistries.fromProviders(codecProviders)});
    }

    @Autowired(required=false)
    public void setCodecs(List<Codec<?>> codecs) {
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.codecRegistry, CodecRegistries.fromCodecs(codecs)});
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public PersistentEntityCodec getPersistentEntityCodec(PersistentEntity entity) {
        if (entity instanceof EmbeddedPersistentEntity) {
            return new PersistentEntityCodec(this, entity);
        }
        return this.getPersistentEntityCodec(entity.getJavaClass());
    }

    public PersistentEntityCodec getPersistentEntityCodec(Class entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Argument [entityClass] cannot be null");
        }
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(entityClass.getName());
        if (entity == null) {
            throw new IllegalArgumentException("Argument [" + entityClass + "] is not an entity");
        }
        return (PersistentEntityCodec)this.getCodecRegistry().get(entity.getJavaClass());
    }

    @Deprecated
    public Mongo getMongo() {
        return this.mongo;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public String getCollectionName(PersistentEntity entity) {
        String collectionName = this.mongoCollections.get(entity);
        if (collectionName == null) {
            String decapitalizedName = entity.getDecapitalizedName();
            this.mongoCollections.put(entity, decapitalizedName);
            return decapitalizedName;
        }
        return collectionName;
    }

    protected Session createSession(PropertyResolver connDetails) {
        if (this.stateless) {
            return this.createStatelessSession(connDetails);
        }
        if (this.codecEngine) {
            return new MongoCodecSession(this, (MappingContext)this.getMappingContext(), this.getApplicationEventPublisher(), false);
        }
        return new MongoSession(this, (MappingContext)this.getMappingContext(), this.getApplicationEventPublisher(), false);
    }

    protected Session createStatelessSession(PropertyResolver connectionDetails) {
        if (this.codecEngine) {
            return new MongoCodecSession(this, (MappingContext)this.getMappingContext(), this.getApplicationEventPublisher(), true);
        }
        return new MongoSession(this, (MappingContext)this.getMappingContext(), this.getApplicationEventPublisher(), true);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mongo == null && this.connectionDetails != null) {
            ServerAddress defaults = new ServerAddress();
            String username = this.connectionDetails.getProperty(SETTING_USERNAME, (String)null);
            String password = this.connectionDetails.getProperty(SETTING_PASSWORD, (String)null);
            DocumentMappingContext dc = this.getMappingContext();
            String databaseName = dc.getDefaultDatabaseName();
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            if (username != null && password != null) {
                credentials.add(MongoCredential.createCredential((String)username, (String)databaseName, (char[])password.toCharArray()));
            }
            String host = this.connectionDetails.getProperty(SETTING_HOST, defaults.getHost());
            int port = (Integer)this.connectionDetails.getProperty(SETTING_PORT, Integer.class, (Object)defaults.getPort());
            ServerAddress serverAddress = new ServerAddress(host, port);
            if (this.mongoOptions != null) {
                this.mongo = new MongoClient(serverAddress, credentials, this.mongoOptions);
            } else {
                MongoClientOptions.Builder builder = MongoClientOptions.builder();
                builder.codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), new MongoClientFactoryBean.DefaultGrailsCodecRegistry()}));
                this.mongoOptions = builder.build();
                this.mongo = new MongoClient(serverAddress, credentials, this.mongoOptions);
            }
        } else if (this.mongo == null) {
            MongoClientOptions.Builder builder = MongoClientOptions.builder();
            builder.codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), new MongoClientFactoryBean.DefaultGrailsCodecRegistry()}));
            this.mongoOptions = builder.build();
            this.mongo = new MongoClient(new ServerAddress(), this.mongoOptions);
        }
        if (this.connectionDetails != null) {
            this.stateless = (Boolean)this.connectionDetails.getProperty(SETTING_STATELESS, Boolean.class, (Object)false);
            this.codecEngine = ((String)this.connectionDetails.getProperty(SETTING_ENGINE, String.class, (Object)CODEC_ENGINE)).equals(CODEC_ENGINE);
        }
        for (PersistentEntity entity : this.mappingContext.getPersistentEntities()) {
            if (entity.isExternal()) continue;
            this.initializeIndices(entity);
        }
    }

    public DocumentMappingContext getMappingContext() {
        return (DocumentMappingContext)super.getMappingContext();
    }

    protected void initializeIndices(PersistentEntity entity) {
        MongoCollection mappedForm;
        String collectionName = entity.getDecapitalizedName();
        String databaseName = this.getMappingContext().getDefaultDatabaseName();
        MongoCollection collectionMapping = (MongoCollection)entity.getMapping().getMappedForm();
        if (collectionMapping.getCollection() != null) {
            collectionName = collectionMapping.getCollection();
        }
        if (collectionMapping.getDatabase() != null) {
            databaseName = collectionMapping.getDatabase();
        }
        this.mongoCollections.put(entity, collectionName);
        this.mongoDatabases.put(entity, databaseName);
        com.mongodb.client.MongoCollection collection = this.getMongoClient().getDatabase(databaseName).getCollection(collectionName);
        ClassMapping classMapping = entity.getMapping();
        if (classMapping != null && (mappedForm = (MongoCollection)classMapping.getMappedForm()) != null) {
            List<MongoCollection.Index> indices = mappedForm.getIndices();
            for (MongoCollection.Index index : indices) {
                Map<String, Object> options = index.getOptions();
                IndexOptions indexOptions = MongoExtensions.mapToObject(IndexOptions.class, options);
                collection.createIndex((Bson)new Document(index.getDefinition()), indexOptions);
            }
            for (Map compoundIndex : mappedForm.getCompoundIndices()) {
                Object o;
                Map indexAttributes = null;
                if (compoundIndex.containsKey(INDEX_ATTRIBUTES) && (o = compoundIndex.remove(INDEX_ATTRIBUTES)) instanceof Map) {
                    indexAttributes = (Map)o;
                }
                Document indexDef = new Document(compoundIndex);
                if (indexAttributes != null) {
                    IndexOptions indexOptions = MongoExtensions.mapToObject(IndexOptions.class, indexAttributes);
                    collection.createIndex((Bson)indexDef, indexOptions);
                    continue;
                }
                collection.createIndex((Bson)indexDef);
            }
        }
        for (PersistentProperty property : entity.getPersistentProperties()) {
            HashMap attributes;
            boolean indexed = this.isIndexed(property);
            if (!indexed) continue;
            MongoAttribute mongoAttributeMapping = (MongoAttribute)property.getMapping().getMappedForm();
            Document dbObject = new Document();
            String fieldName = this.getMongoFieldNameForProperty((PersistentProperty<MongoAttribute>)property);
            dbObject.put(fieldName, (Object)1);
            Document options = new Document();
            if (mongoAttributeMapping != null && (attributes = mongoAttributeMapping.getIndexAttributes()) != null) {
                if ((attributes = new HashMap(attributes)).containsKey("type")) {
                    dbObject.put(fieldName, attributes.remove("type"));
                }
                options.putAll(attributes);
            }
            if (options.isEmpty()) {
                collection.createIndex((Bson)dbObject);
                continue;
            }
            IndexOptions indexOptions = MongoExtensions.mapToObject(IndexOptions.class, (Map<String, Object>)options);
            collection.createIndex((Bson)dbObject, indexOptions);
        }
    }

    String getMongoFieldNameForProperty(PersistentProperty<MongoAttribute> property) {
        PropertyMapping pm = property.getMapping();
        String propKey = null;
        if (pm.getMappedForm() != null) {
            propKey = ((MongoAttribute)pm.getMappedForm()).getField();
        }
        if (propKey == null) {
            propKey = property.getName();
        }
        return propKey;
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.initializeIndices(entity);
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public boolean isSchemaless() {
        return true;
    }

    public String getDatabaseName(PersistentEntity entity) {
        String databaseName = this.mongoDatabases.get(entity);
        if (databaseName == null) {
            this.mongoDatabases.put(entity, this.defaultDatabase);
            return this.defaultDatabase;
        }
        return databaseName;
    }

    class PersistentEntityCodeRegistry
    implements CodecProvider {
        Map<String, PersistentEntityCodec> codecs = new HashMap<String, PersistentEntityCodec>();

        PersistentEntityCodeRegistry() {
        }

        public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
            PersistentEntity entity;
            String entityName = clazz.getName();
            PersistentEntityCodec codec = this.codecs.get(entityName);
            if (codec == null && (entity = MongoDatastore.this.getMappingContext().getPersistentEntity(entityName)) != null) {
                codec = new PersistentEntityCodec(MongoDatastore.this, entity);
                this.codecs.put(entityName, codec);
            }
            return codec;
        }
    }
}

