/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection.test;

import grails.test.mixin.TestMixin;
import grails.test.mixin.support.MixinMethod;
import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObjectSupport;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.test.TestForTransformation;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TestMixinTransformation
implements ASTTransformation {
    public static final AnnotationNode MIXIN_METHOD_ANNOTATION = new AnnotationNode(new ClassNode(MixinMethod.class));
    private static final ClassNode MY_TYPE = new ClassNode(TestMixin.class);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    public static final String OBJECT_CLASS = "java.lang.Object";
    public static final String SPEC_CLASS = "spock.lang.Specification";
    private static final String JUNIT3_CLASS = "junit.framework.TestCase";
    public static final String SET_UP_METHOD = "setUp";
    public static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");
    public static final String TEAR_DOWN_METHOD = "tearDown";
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = new ClassNode(GroovyObjectSupport.class);

    public void visit(ASTNode[] astNodes, SourceUnit source) {
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!MY_TYPE.equals((Object)node.getClassNode()) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode classNode = (ClassNode)parent;
        String cName = classNode.getName();
        if (classNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
        }
        this.autoAnnotateSetupTeardown(classNode);
        ListExpression values = this.getListOfClasses(node);
        this.weaveMixinsIntoClass(classNode, values);
    }

    protected ListExpression getListOfClasses(AnnotationNode node) {
        Expression value = node.getMember("value");
        ListExpression values = null;
        if (value instanceof ListExpression) {
            values = (ListExpression)value;
        } else if (value instanceof ClassExpression) {
            values = new ListExpression();
            values.addExpression(value);
        }
        return values;
    }

    public void weaveMixinsIntoClass(ClassNode classNode, ListExpression values) {
        if (values != null) {
            boolean isJunit3 = TestMixinTransformation.isJunit3Test(classNode);
            ArrayList<MethodNode> beforeMethods = null;
            ArrayList<MethodNode> afterMethods = null;
            if (isJunit3) {
                beforeMethods = new ArrayList<MethodNode>();
                afterMethods = new ArrayList<MethodNode>();
            }
            for (Expression current : values.getExpressions()) {
                String fieldName;
                if (!(current instanceof ClassExpression)) continue;
                ClassExpression ce = (ClassExpression)current;
                ClassNode mixinClassNode = ce.getType();
                FieldNode fieldNode = GrailsASTUtils.addFieldIfNonExistent((ClassNode)classNode, (ClassNode)mixinClassNode, (String)(fieldName = '$' + GrailsNameUtils.getPropertyName((String)mixinClassNode.getName())));
                if (fieldNode == null) {
                    return;
                }
                VariableExpression fieldReference = new VariableExpression(fieldName);
                while (!mixinClassNode.getName().equals(OBJECT_CLASS)) {
                    List mixinMethods = mixinClassNode.getMethods();
                    int beforeClassMethodCount = 0;
                    int afterClassMethodCount = 0;
                    for (MethodNode mixinMethod : mixinMethods) {
                        MethodNode methodNode;
                        if (!this.isCandidateMethod(mixinMethod) || this.hasDeclaredMethod(classNode, mixinMethod)) continue;
                        if (mixinMethod.isStatic()) {
                            methodNode = GrailsASTUtils.addDelegateStaticMethod((ClassNode)classNode, (MethodNode)mixinMethod);
                            if (methodNode != null) {
                                methodNode.addAnnotation(MIXIN_METHOD_ANNOTATION);
                            }
                        } else {
                            methodNode = GrailsASTUtils.addDelegateInstanceMethod((ClassNode)classNode, (Expression)fieldReference, (MethodNode)mixinMethod, (boolean)false);
                            if (methodNode != null) {
                                methodNode.addAnnotation(MIXIN_METHOD_ANNOTATION);
                            }
                        }
                        if (!isJunit3) continue;
                        if (this.hasAnnotation(mixinMethod, Before.class)) {
                            beforeMethods.add(mixinMethod);
                        }
                        if (this.hasAnnotation(mixinMethod, BeforeClass.class)) {
                            beforeMethods.add(beforeClassMethodCount++, mixinMethod);
                        }
                        if (this.hasAnnotation(mixinMethod, After.class)) {
                            afterMethods.add(mixinMethod);
                        }
                        if (!this.hasAnnotation(mixinMethod, AfterClass.class)) continue;
                        afterMethods.add(afterClassMethodCount++, mixinMethod);
                    }
                    mixinClassNode = mixinClassNode.getSuperClass();
                }
            }
            if (isJunit3) {
                this.addMethodCallsToMethod(classNode, SET_UP_METHOD, beforeMethods);
                this.addMethodCallsToMethod(classNode, TEAR_DOWN_METHOD, afterMethods);
            }
        }
    }

    protected boolean hasDeclaredMethod(ClassNode classNode, MethodNode mixinMethod) {
        return classNode.hasDeclaredMethod(mixinMethod.getName(), mixinMethod.getParameters());
    }

    protected boolean hasAnnotation(MethodNode mixinMethod, Class<?> beforeClass) {
        return !mixinMethod.getAnnotations(new ClassNode(beforeClass)).isEmpty();
    }

    protected void addMethodCallsToMethod(ClassNode classNode, String name, List<MethodNode> methods) {
        if (methods != null && !methods.isEmpty()) {
            BlockStatement setupMethodBody = this.getOrCreateNoArgsMethodBody(classNode, name);
            for (MethodNode beforeMethod : methods) {
                setupMethodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, beforeMethod.getName(), (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
            }
        }
    }

    protected BlockStatement getOrCreateNoArgsMethodBody(ClassNode classNode, String name) {
        MethodNode setupMethod = classNode.getMethod(name, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        return this.getOrCreateMethodBody(classNode, setupMethod, name);
    }

    protected BlockStatement getOrCreateMethodBody(ClassNode classNode, MethodNode setupMethod, String name) {
        BlockStatement methodBody;
        if (setupMethod.getDeclaringClass().getName().equals(TestCase.class.getName())) {
            methodBody = new BlockStatement();
            setupMethod = new MethodNode(name, 1, setupMethod.getReturnType(), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)methodBody);
            classNode.addMethod(setupMethod);
        } else {
            Statement setupMethodBody = setupMethod.getCode();
            if (!(setupMethodBody instanceof BlockStatement)) {
                methodBody = new BlockStatement();
                if (setupMethodBody != null && !(setupMethodBody instanceof ReturnStatement)) {
                    methodBody.addStatement(setupMethodBody);
                }
                setupMethod.setCode((Statement)methodBody);
            } else {
                methodBody = (BlockStatement)setupMethodBody;
            }
        }
        return methodBody;
    }

    public static boolean isJunit3Test(ClassNode classNode) {
        return TestMixinTransformation.isSubclassOf(classNode, JUNIT3_CLASS);
    }

    public static boolean isSpockTest(ClassNode classNode) {
        return TestMixinTransformation.isSubclassOf(classNode, SPEC_CLASS);
    }

    private static boolean isSubclassOf(ClassNode classNode, String testType) {
        for (ClassNode currentSuper = classNode.getSuperClass(); currentSuper != null && !currentSuper.getName().equals(OBJECT_CLASS); currentSuper = currentSuper.getSuperClass()) {
            if (!currentSuper.getName().equals(testType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCandidateMethod(MethodNode declaredMethod) {
        return TestMixinTransformation.isAddableMethod(declaredMethod);
    }

    public static boolean isAddableMethod(MethodNode declaredMethod) {
        ClassNode groovyMethods = GROOVY_OBJECT_CLASS_NODE;
        String methodName = declaredMethod.getName();
        return !declaredMethod.isSynthetic() && !methodName.contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !Modifier.isAbstract(declaredMethod.getModifiers()) && !groovyMethods.hasMethod(declaredMethod.getName(), declaredMethod.getParameters());
    }

    protected void error(SourceUnit source, String me) {
        source.getErrorCollector().addError((Message)new SimpleMessage(me, (ProcessingUnit)source), true);
    }

    protected void autoAnnotateSetupTeardown(ClassNode classNode) {
        MethodNode tearDown;
        MethodNode setupMethod = classNode.getMethod(SET_UP_METHOD, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (setupMethod != null && setupMethod.getAnnotations(TestForTransformation.BEFORE_CLASS_NODE).size() == 0) {
            setupMethod.addAnnotation(TestForTransformation.BEFORE_ANNOTATION);
        }
        if ((tearDown = classNode.getMethod(TEAR_DOWN_METHOD, GrailsArtefactClassInjector.ZERO_PARAMETERS)) != null && tearDown.getAnnotations(TestForTransformation.AFTER_CLASS_NODE).size() == 0) {
            tearDown.addAnnotation(TestForTransformation.AFTER_ANNOTATION);
        }
    }
}

