/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.criteria.JoinType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.Triple;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.tools.Pair;

@Incubating
public class AuditAssociationQueryImpl<Q extends AuditQueryImplementor>
implements AuditAssociationQuery<Q>,
AuditQueryImplementor {
    private final EnversService enversService;
    private final AuditReaderImplementor auditReader;
    private final Q parent;
    private final QueryBuilder queryBuilder;
    private final JoinType joinType;
    private final String entityName;
    private final IdMapper ownerAssociationIdMapper;
    private final String ownerAlias;
    private final String alias;
    private final List<AuditCriterion> criterions = new ArrayList<AuditCriterion>();
    private final Parameters parameters;
    private final List<AuditAssociationQueryImpl<?>> associationQueries = new ArrayList();
    private final Map<String, AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>>> associationQueryMap = new HashMap<String, AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>>>();
    private boolean hasProjections;
    private boolean hasOrders;

    public AuditAssociationQueryImpl(EnversService enversService, AuditReaderImplementor auditReader, Q parent, QueryBuilder queryBuilder, String ownerEntityName, String propertyName, JoinType joinType, String ownerAlias) {
        this.enversService = enversService;
        this.auditReader = auditReader;
        this.parent = parent;
        this.queryBuilder = queryBuilder;
        this.joinType = joinType;
        RelationDescription relationDescription = CriteriaTools.getRelatedEntity(enversService, ownerEntityName, propertyName);
        if (relationDescription == null) {
            throw new IllegalArgumentException("Property " + propertyName + " of entity " + ownerEntityName + " is not a valid association for queries");
        }
        this.entityName = relationDescription.getToEntityName();
        this.ownerAssociationIdMapper = relationDescription.getIdMapper();
        this.ownerAlias = ownerAlias;
        this.alias = queryBuilder.generateAlias();
        this.parameters = queryBuilder.addParameters(this.alias);
    }

    @Override
    public List getResultList() throws AuditException {
        return this.parent.getResultList();
    }

    @Override
    public Object getSingleResult() throws AuditException, NonUniqueResultException, NoResultException {
        return this.parent.getSingleResult();
    }

    public AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>> traverseRelation(String associationName, JoinType joinType) {
        AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>> result = this.associationQueryMap.get(associationName);
        if (result == null) {
            result = new AuditAssociationQueryImpl<AuditAssociationQueryImpl>(this.enversService, this.auditReader, this, this.queryBuilder, this.entityName, associationName, joinType, this.alias);
            this.associationQueries.add(result);
            this.associationQueryMap.put(associationName, result);
        }
        return result;
    }

    @Override
    public AuditAssociationQueryImpl<Q> add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> addProjection(AuditProjection projection) {
        this.hasProjections = true;
        Triple<String, String, Boolean> projectionData = projection.getData(this.enversService);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.auditReader, this.entityName, projectionData.getSecond());
        this.queryBuilder.addProjection(projectionData.getFirst(), this.alias, propertyName, projectionData.getThird());
        this.registerProjection(this.entityName, projection);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> addOrder(AuditOrder order) {
        this.hasOrders = true;
        Pair<String, Boolean> orderData = order.getData(this.enversService);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.auditReader, this.entityName, orderData.getFirst());
        this.queryBuilder.addOrder(this.alias, propertyName, orderData.getSecond());
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setMaxResults(int maxResults) {
        this.parent.setMaxResults(maxResults);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setFirstResult(int firstResult) {
        this.parent.setFirstResult(firstResult);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setCacheable(boolean cacheable) {
        this.parent.setCacheable(cacheable);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setCacheRegion(String cacheRegion) {
        this.parent.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setComment(String comment) {
        this.parent.setComment(comment);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setFlushMode(FlushMode flushMode) {
        this.parent.setFlushMode(flushMode);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setCacheMode(CacheMode cacheMode) {
        this.parent.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setTimeout(int timeout) {
        this.parent.setTimeout(timeout);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setLockMode(LockMode lockMode) {
        this.parent.setLockMode(lockMode);
        return this;
    }

    @Override
    public Q up() {
        return this.parent;
    }

    protected boolean hasCriterions() {
        boolean result;
        boolean bl = result = !this.criterions.isEmpty();
        if (!result) {
            for (AuditAssociationQueryImpl<?> sub : this.associationQueries) {
                if (!sub.hasCriterions()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected boolean hasOrders() {
        boolean result = this.hasOrders;
        if (!result) {
            for (AuditAssociationQueryImpl<?> sub : this.associationQueries) {
                if (!sub.hasOrders()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected boolean hasProjections() {
        boolean result = this.hasProjections;
        if (!result) {
            for (AuditAssociationQueryImpl<?> sub : this.associationQueries) {
                if (!sub.hasProjections()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void addCriterionsToQuery(AuditReaderImplementor versionsReader) {
        if (this.hasCriterions() || this.hasOrders() || this.hasProjections()) {
            if (this.enversService.getEntitiesConfigurations().isVersioned(this.entityName)) {
                String auditEntityName = this.enversService.getAuditEntitiesConfiguration().getAuditEntityName(this.entityName);
                this.queryBuilder.addFrom(auditEntityName, this.alias, false);
                AuditEntitiesConfiguration auditEntitiesConfiguration = this.enversService.getAuditEntitiesConfiguration();
                String originalIdPropertyName = auditEntitiesConfiguration.getOriginalIdPropName();
                IdMapper idMapperTarget = this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMapper();
                String prefix = this.alias.concat(".").concat(originalIdPropertyName);
                this.ownerAssociationIdMapper.addIdsEqualToQuery(this.queryBuilder.getRootParameters(), this.ownerAlias, idMapperTarget, prefix);
                String revisionPropertyPath = auditEntitiesConfiguration.getRevisionNumberPath();
                MiddleIdData referencedIdData = new MiddleIdData(auditEntitiesConfiguration, this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMappingData(), null, this.entityName, this.enversService.getEntitiesConfigurations().isVersioned(this.entityName));
                this.enversService.getAuditStrategy().addEntityAtRevisionRestriction(this.enversService.getGlobalConfiguration(), this.queryBuilder, this.parameters, revisionPropertyPath, auditEntitiesConfiguration.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, this.alias, this.queryBuilder.generateAlias(), true);
            } else {
                this.queryBuilder.addFrom(this.entityName, this.alias, false);
                IdMapper idMapperTarget = this.enversService.getEntitiesConfigurations().getNotVersionEntityConfiguration(this.entityName).getIdMapper();
                this.ownerAssociationIdMapper.addIdsEqualToQuery(this.queryBuilder.getRootParameters(), this.ownerAlias, idMapperTarget, this.alias);
            }
            for (AuditCriterion auditCriterion : this.criterions) {
                auditCriterion.addToQuery(this.enversService, versionsReader, this.entityName, this.alias, this.queryBuilder, this.parameters);
            }
            for (AuditAssociationQueryImpl auditAssociationQueryImpl : this.associationQueries) {
                auditAssociationQueryImpl.addCriterionsToQuery(versionsReader);
            }
        }
    }

    @Override
    public void registerProjection(String entityName, AuditProjection projection) {
        this.parent.registerProjection(entityName, projection);
    }
}

