/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.util.StringHelper;

public abstract class AbstractMetaDataDialect
implements MetaDataDialect {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Connection connection;
    private DatabaseMetaData metaData;
    private ReverseEngineeringRuntimeInfo info;

    public void configure(ReverseEngineeringRuntimeInfo info) {
        this.info = info;
    }

    public void close() {
        this.metaData = null;
        if (this.connection != null) {
            try {
                this.info.getConnectionProvider().closeConnection(this.connection);
            }
            catch (SQLException e) {
                throw this.getSQLExceptionConverter().convert(e, "Problem while closing connection", null);
            }
            finally {
                this.connection = null;
            }
        }
        this.info = null;
    }

    protected DatabaseMetaData getMetaData() throws JDBCBinderException {
        if (this.metaData == null) {
            try {
                this.metaData = this.getConnection().getMetaData();
            }
            catch (SQLException e) {
                throw this.getSQLExceptionConverter().convert(e, "Getting database metadata", null);
            }
        }
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDatabaseStructure(String catalog, String schema) {
        ResultSet schemaRs = null;
        ResultSet catalogRs = null;
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(nl);
        sb.append("Configured schema:").append(schema).append(nl);
        sb.append("Configured catalog:").append(catalog).append(nl);
        try {
            schemaRs = this.getMetaData().getSchemas();
            sb.append("Available schemas:").append(nl);
            while (schemaRs.next()) {
                sb.append("  ").append(schemaRs.getString("TABLE_SCHEM")).append(nl);
            }
        }
        catch (SQLException e2) {
            this.log.warn((Object)"Could not get schemas", (Throwable)e2);
            sb.append("  <SQLException while getting schemas>").append(nl);
        }
        finally {
            try {
                schemaRs.close();
            }
            catch (Exception e2) {}
        }
        try {
            catalogRs = this.getMetaData().getCatalogs();
            sb.append("Available catalogs:").append(nl);
            while (catalogRs.next()) {
                sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
            }
        }
        catch (SQLException e2) {
            this.log.warn((Object)"Could not get catalogs", (Throwable)e2);
            sb.append("  <SQLException while getting catalogs>").append(nl);
        }
        finally {
            try {
                catalogRs.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.info.getConnectionProvider().getConnection();
        }
        return this.connection;
    }

    public ReverseEngineeringRuntimeInfo getReverseEngineeringRuntimeInfo() {
        return this.info;
    }

    public void close(Iterator iterator) {
        if (iterator instanceof ResultSetIterator) {
            ((ResultSetIterator)iterator).close();
        }
    }

    protected SQLExceptionConverter getSQLExceptionConverter() {
        return this.info.getSQLExceptionConverter();
    }

    public boolean needQuote(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(45) > 0) {
            return true;
        }
        if (name.indexOf(32) > 0) {
            return true;
        }
        return name.indexOf(46) > 0;
    }

    protected String caseForSearch(String value) throws SQLException {
        if (this.needQuote(value)) {
            if (this.getMetaData().storesMixedCaseQuotedIdentifiers()) {
                return value;
            }
            if (this.getMetaData().storesUpperCaseQuotedIdentifiers()) {
                return StringHelper.toUpperCase((String)value);
            }
            if (this.getMetaData().storesLowerCaseQuotedIdentifiers()) {
                return StringHelper.toLowerCase((String)value);
            }
            return value;
        }
        if (this.getMetaData().storesMixedCaseQuotedIdentifiers()) {
            return value;
        }
        if (this.getMetaData().storesUpperCaseIdentifiers()) {
            return StringHelper.toUpperCase((String)value);
        }
        if (this.getMetaData().storesLowerCaseIdentifiers()) {
            return StringHelper.toLowerCase((String)value);
        }
        return value;
    }

    public Iterator getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("TABLE_CAT", catalog);
        m.put("TABLE_SCHEMA", schema);
        m.put("TABLE_NAME", table);
        m.put("HIBERNATE_STRATEGY", null);
        ArrayList<HashMap<String, String>> l = new ArrayList<HashMap<String, String>>();
        l.add(m);
        return l.iterator();
    }
}

