/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.cfg.Configuration;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.pojo.AnnotationBuilder;
import org.hibernate.tool.hbm2x.pojo.BasicPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.hbm2x.pojo.SkipBackRefPropertyIterator;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public class EntityPOJOClass
extends BasicPOJOClass {
    private PersistentClass clazz;

    public EntityPOJOClass(PersistentClass clazz, Cfg2JavaTool cfg) {
        super((MetaAttributable)clazz, cfg);
        this.clazz = clazz;
        this.init();
    }

    protected String getMappedClassName() {
        return this.clazz.getClassName();
    }

    public String getExtends() {
        String extendz = "";
        if (this.isInterface()) {
            if (this.clazz.getSuperclass() != null) {
                extendz = this.clazz.getSuperclass().getClassName();
            }
            if (this.clazz.getMetaAttribute("extends") != null) {
                if (!"".equals(extendz)) {
                    extendz = extendz + ",";
                }
                extendz = extendz + this.getMetaAsString("extends", ",");
            }
        } else if (this.clazz.getSuperclass() != null) {
            if (!this.c2j.getPOJOClass(this.clazz.getSuperclass()).isInterface()) {
                extendz = this.clazz.getSuperclass().getClassName();
            }
        } else if (this.clazz.getMetaAttribute("extends") != null) {
            extendz = this.getMetaAsString("extends", ",");
        }
        return "".equals(extendz) ? null : extendz;
    }

    public String getImplements() {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (this.clazz.getProxyInterfaceName() != null && !this.clazz.getProxyInterfaceName().equals(this.clazz.getClassName())) {
            interfaces.add(this.clazz.getProxyInterfaceName());
        }
        if (!this.isInterface()) {
            if (this.clazz.getSuperclass() != null && this.c2j.getPOJOClass(this.clazz.getSuperclass()).isInterface()) {
                interfaces.add(this.clazz.getSuperclass().getClassName());
            }
            if (this.clazz.getMetaAttribute("implements") != null) {
                interfaces.addAll(this.clazz.getMetaAttribute("implements").getValues());
            }
            interfaces.add(Serializable.class.getName());
        }
        if (interfaces.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                sbuf.append(iter.next());
                if (!iter.hasNext()) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
        return null;
    }

    public Iterator getAllPropertiesIterator() {
        return this.getAllPropertiesIterator(this.clazz);
    }

    public Iterator getAllPropertiesIterator(PersistentClass pc) {
        ArrayList<Object> properties = new ArrayList<Object>();
        ArrayList iterators = new ArrayList();
        if (pc.getSuperclass() == null) {
            if (pc.hasIdentifierProperty()) {
                properties.add(pc.getIdentifierProperty());
            } else if (pc.hasEmbeddedIdentifier()) {
                Component embeddedComponent = (Component)pc.getIdentifier();
                iterators.add(embeddedComponent.getPropertyIterator());
            }
        }
        Iterator pit = pc.getPropertyIterator();
        while (pit.hasNext()) {
            Property element = (Property)pit.next();
            if (element.getValue() instanceof Component && element.getPropertyAccessorName().equals("embedded")) {
                Component component = (Component)element.getValue();
                Iterator embeddedProperty = component.getPropertyIterator();
                while (embeddedProperty.hasNext()) {
                    properties.add(embeddedProperty.next());
                }
                continue;
            }
            properties.add(element);
        }
        iterators.add(properties.iterator());
        Iterator[] it = iterators.toArray(new Iterator[iterators.size()]);
        return new SkipBackRefPropertyIterator((Iterator)new JoinedIterator(it));
    }

    public boolean isComponent() {
        return false;
    }

    public boolean hasIdentifierProperty() {
        return this.clazz.hasIdentifierProperty() && this.clazz instanceof RootClass;
    }

    public Property getIdentifierProperty() {
        return this.clazz.getIdentifierProperty();
    }

    public String generateAnnTableUniqueConstraint() {
        if (!(this.clazz instanceof Subclass)) {
            Table table = this.clazz.getTable();
            return this.generateAnnTableUniqueConstraint(table);
        }
        return "";
    }

    protected String generateAnnTableUniqueConstraint(Table table) {
        Iterator uniqueKeys = table.getUniqueKeyIterator();
        ArrayList<String> cons = new ArrayList<String>();
        while (uniqueKeys.hasNext()) {
            UniqueKey key = (UniqueKey)uniqueKeys.next();
            if (table.hasPrimaryKey() && table.getPrimaryKey().getColumns().equals(key.getColumns())) continue;
            AnnotationBuilder constraint = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.UniqueConstraint"));
            constraint.addQuotedAttributes("columnNames", new IteratorTransformer(key.getColumnIterator()){

                public Object transform(Object object) {
                    return ((Column)object).getName();
                }
            });
            cons.add(constraint.getResult());
        }
        AnnotationBuilder builder = AnnotationBuilder.createAnnotation("dummyAnnotation");
        builder.addAttributes("dummyAttribute", cons.iterator());
        String attributeAsString = builder.getAttributeAsString("dummyAttribute");
        return attributeAsString == null ? "" : attributeAsString;
    }

    public String generateAnnIdGenerator() {
        KeyValue identifier = this.clazz.getIdentifier();
        String strategy = null;
        Properties properties = null;
        StringBuffer wholeString = new StringBuffer("    ");
        if (identifier instanceof Component) {
            wholeString.append(AnnotationBuilder.createAnnotation(this.importType("javax.persistence.EmbeddedId")).getResult());
        } else if (identifier instanceof SimpleValue) {
            SimpleValue simpleValue = (SimpleValue)identifier;
            strategy = simpleValue.getIdentifierGeneratorStrategy();
            properties = this.c2j.getFilteredIdentifierGeneratorProperties(simpleValue);
            StringBuffer idResult = new StringBuffer();
            AnnotationBuilder builder = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.Id"));
            idResult.append(builder.getResult());
            idResult.append(" ");
            boolean isGenericGenerator = false;
            if (!"assigned".equals(strategy)) {
                if (!"native".equals(strategy)) {
                    if ("identity".equals(strategy)) {
                        builder.resetAnnotation(this.importType("javax.persistence.GeneratedValue"));
                        builder.addAttribute("strategy", this.staticImport("javax.persistence.GenerationType", "IDENTITY"));
                        idResult.append(builder.getResult());
                    } else if ("sequence".equals(strategy)) {
                        builder.resetAnnotation(this.importType("javax.persistence.GeneratedValue")).addAttribute("strategy", this.staticImport("javax.persistence.GenerationType", "SEQUENCE")).addQuotedAttribute("generator", "generator");
                        idResult.append(builder.getResult());
                        builder.resetAnnotation(this.importType("javax.persistence.SequenceGenerator")).addQuotedAttribute("name", "generator").addQuotedAttribute("sequenceName", properties.getProperty("sequence", null));
                        wholeString.append(builder.getResult());
                    } else if (MultipleHiLoPerTableGenerator.class.getName().equals(strategy)) {
                        builder.resetAnnotation(this.importType("javax.persistence.GeneratedValue")).addAttribute("strategy", this.staticImport("javax.persistence.GenerationType", "TABLE")).addQuotedAttribute("generator", "generator");
                        idResult.append(builder.getResult());
                        this.buildAnnTableGenerator(wholeString, properties);
                    } else {
                        isGenericGenerator = true;
                        builder.resetAnnotation(this.importType("javax.persistence.GeneratedValue"));
                        builder.addQuotedAttribute("generator", "generator");
                        idResult.append(builder.getResult());
                    }
                } else {
                    builder.resetAnnotation(this.importType("javax.persistence.GeneratedValue"));
                    idResult.append(builder.getResult());
                }
            }
            if (isGenericGenerator) {
                builder.resetAnnotation(this.importType("org.hibernate.annotations.GenericGenerator")).addQuotedAttribute("name", "generator").addQuotedAttribute("strategy", strategy);
                ArrayList<AnnotationBuilder> params = new ArrayList<AnnotationBuilder>();
                if (properties != null) {
                    Enumeration<?> propNames = properties.propertyNames();
                    while (propNames.hasMoreElements()) {
                        String propertyName = (String)propNames.nextElement();
                        AnnotationBuilder parameter = AnnotationBuilder.createAnnotation(this.importType("org.hibernate.annotations.Parameter")).addQuotedAttribute("name", propertyName).addQuotedAttribute("value", properties.getProperty(propertyName));
                        params.add(parameter);
                    }
                }
                builder.addAttributes("parameters", params.iterator());
                wholeString.append(builder.getResult());
            }
            wholeString.append(idResult);
        }
        return wholeString.toString();
    }

    private void buildAnnTableGenerator(StringBuffer wholeString, Properties properties) {
        AnnotationBuilder builder = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.TableGenerator"));
        builder.addQuotedAttribute("name", "generator");
        builder.addQuotedAttribute("table", properties.getProperty("generatorTableName", "hibernate_sequences"));
        if (!this.isPropertyDefault("catalog", properties)) {
            builder.addQuotedAttribute("catalog", properties.getProperty("catalog", ""));
        }
        if (!this.isPropertyDefault("schema", properties)) {
            builder.addQuotedAttribute("schema", properties.getProperty("schema", ""));
        }
        if (!this.isPropertyDefault("primary_key_value", properties)) {
            builder.addQuotedAttribute("pkColumnValue", properties.getProperty("primary_key_value", ""));
        }
        if (!this.isPropertyDefault("max_lo", properties, "50")) {
            builder.addAttribute("allocationSize", properties.getProperty("max_lo", "50"));
        }
        if (!this.isPropertyDefault("primary_key_column", properties)) {
            builder.addQuotedAttribute("pkColumnName", properties.getProperty("primary_key_column", ""));
        }
        if (!this.isPropertyDefault("value_column", properties)) {
            builder.addQuotedAttribute("valueColumnName", properties.getProperty("value_column", ""));
        }
        wholeString.append(builder.getResult() + "\n    ");
    }

    private boolean isPropertyDefault(String property, Properties properties) {
        return StringHelper.isEmpty((String)properties.getProperty(property));
    }

    private boolean isPropertyDefault(String property, Properties properties, String defaultValue) {
        String propertyValue = properties.getProperty(property);
        return propertyValue != null && propertyValue.equals(defaultValue);
    }

    public String generateJoinColumnsAnnotation(Property property, Configuration cfg) {
        String referencedEntityName;
        PersistentClass target;
        Iterator columnIterator;
        int span;
        boolean insertable = property.isInsertable();
        boolean updatable = property.isUpdateable();
        Value value = property.getValue();
        Iterator referencedColumnsIterator = null;
        if (value != null && value instanceof Collection) {
            Collection collection = (Collection)value;
            span = collection.getKey().getColumnSpan();
            columnIterator = collection.getKey().getColumnIterator();
        } else {
            span = property.getColumnSpan();
            columnIterator = property.getColumnIterator();
        }
        if (property.getValue() instanceof ToOne && (target = cfg.getClassMapping(referencedEntityName = ((ToOne)property.getValue()).getReferencedEntityName())) != null) {
            referencedColumnsIterator = target.getKey().getColumnIterator();
        }
        StringBuffer annotations = new StringBuffer("    ");
        if (span == 1) {
            Selectable selectable = (Selectable)columnIterator.next();
            this.buildJoinColumnAnnotation(selectable, null, annotations, insertable, updatable);
        } else {
            Iterator columns = columnIterator;
            annotations.append("@").append(this.importType("javax.persistence.JoinColumns")).append("( { ");
            this.buildArrayOfJoinColumnAnnotation(columns, referencedColumnsIterator, annotations, insertable, updatable);
            annotations.append(" } )");
        }
        return annotations.toString();
    }

    private void buildArrayOfJoinColumnAnnotation(Iterator columns, Iterator referencedColumnsIterator, StringBuffer annotations, boolean insertable, boolean updatable) {
        while (columns.hasNext()) {
            Selectable selectable = (Selectable)columns.next();
            Selectable referencedColumn = null;
            if (referencedColumnsIterator != null) {
                referencedColumn = (Selectable)referencedColumnsIterator.next();
            }
            if (selectable.isFormula()) continue;
            annotations.append("\n        ");
            this.buildJoinColumnAnnotation(selectable, referencedColumn, annotations, insertable, updatable);
            annotations.append(", ");
        }
        annotations.setLength(annotations.length() - 2);
    }

    private void buildJoinColumnAnnotation(Selectable selectable, Selectable referencedColumn, StringBuffer annotations, boolean insertable, boolean updatable) {
        if (!selectable.isFormula()) {
            Column column = (Column)selectable;
            annotations.append("@").append(this.importType("javax.persistence.JoinColumn")).append("(name=\"").append(column.getName()).append("\"");
            if (referencedColumn != null) {
                annotations.append(", referencedColumnName=\"").append(referencedColumn.getText()).append("\"");
            }
            this.appendCommonColumnInfo(annotations, column, insertable, updatable);
            annotations.append(")");
        }
    }

    public String[] getCascadeTypes(Property property) {
        StringTokenizer st = new StringTokenizer(property.getCascade(), ", ", false);
        ArrayList<String> types = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).toLowerCase();
            if ("persist".equals(element)) {
                types.add(this.importType("javax.persistence.CascadeType") + ".PERSIST");
                continue;
            }
            if ("merge".equals(element)) {
                types.add(this.importType("javax.persistence.CascadeType") + ".MERGE");
                continue;
            }
            if ("delete".equals(element)) {
                types.add(this.importType("javax.persistence.CascadeType") + ".REMOVE");
                continue;
            }
            if ("refresh".equals(element)) {
                types.add(this.importType("javax.persistence.CascadeType") + ".REFRESH");
                continue;
            }
            if (!"all".equals(element)) continue;
            types.add(this.importType("javax.persistence.CascadeType") + ".ALL");
        }
        return types.toArray(new String[types.size()]);
    }

    public String generateManyToOneAnnotation(Property property) {
        StringBuffer buffer = new StringBuffer(AnnotationBuilder.createAnnotation(this.importType("javax.persistence.ManyToOne")).addAttribute("cascade", this.getCascadeTypes(property)).addAttribute("fetch", this.getFetchType(property)).getResult());
        buffer.append(this.getHibernateCascadeTypeAnnotation(property));
        return buffer.toString();
    }

    public boolean isSharedPkBasedOneToOne(OneToOne oneToOne) {
        Iterator joinColumnsIt = oneToOne.getColumnIterator();
        HashSet joinColumns = new HashSet();
        while (joinColumnsIt.hasNext()) {
            joinColumns.add(joinColumnsIt.next());
        }
        if (joinColumns.size() == 0) {
            return false;
        }
        Iterator idColumnsIt = this.getIdentifierProperty().getColumnIterator();
        HashSet idColumns = new HashSet();
        while (idColumnsIt.hasNext()) {
            if (joinColumns.contains(idColumnsIt.next())) continue;
            return false;
        }
        return true;
    }

    public String generateOneToOneAnnotation(Property property, Configuration cfg) {
        OneToOne oneToOne = (OneToOne)property.getValue();
        boolean pkIsAlsoFk = this.isSharedPkBasedOneToOne(oneToOne);
        AnnotationBuilder ab = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.OneToOne")).addAttribute("cascade", this.getCascadeTypes(property)).addAttribute("fetch", this.getFetchType(property));
        if (oneToOne.getForeignKeyType().equals(ForeignKeyDirection.FOREIGN_KEY_TO_PARENT)) {
            ab.addQuotedAttribute("mappedBy", this.getOneToOneMappedBy(cfg, oneToOne));
        }
        StringBuffer buffer = new StringBuffer(ab.getResult());
        buffer.append(this.getHibernateCascadeTypeAnnotation(property));
        if (pkIsAlsoFk && oneToOne.getForeignKeyType().equals(ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT)) {
            AnnotationBuilder ab1 = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.PrimaryKeyJoinColumn"));
            buffer.append(ab1.getResult());
        }
        return buffer.toString();
    }

    public String getHibernateCascadeTypeAnnotation(Property property) {
        StringTokenizer st = new StringTokenizer(property.getCascade(), ", ", false);
        String cascadeType = null;
        StringBuffer cascade = new StringBuffer();
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).toLowerCase();
            if ("all-delete-orphan".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".ALL").append(", ").append(cascadeType).append(".DELETE_ORPHAN").append(", ");
                continue;
            }
            if ("delete-orphan".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".DELETE_ORPHAN").append(", ");
                continue;
            }
            if ("save-update".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".SAVE_UPDATE").append(", ");
                continue;
            }
            if ("replicate".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".REPLICATE").append(", ");
                continue;
            }
            if ("lock".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".LOCK").append(", ");
                continue;
            }
            if (!"evict".equals(element)) continue;
            if (cascadeType == null) {
                cascadeType = this.importType("org.hibernate.annotations.CascadeType");
            }
            cascade.append(cascadeType).append(".EVICT").append(", ");
        }
        if (cascade.length() >= 2) {
            String hibernateCascade = this.importType("org.hibernate.annotations.Cascade");
            cascade.insert(0, "@" + hibernateCascade + "( {");
            cascade.setLength(cascade.length() - 2);
            cascade.append("} )");
        }
        return cascade.toString();
    }

    public String getFetchType(Property property) {
        Value value = property.getValue();
        String fetchType = this.importType("javax.persistence.FetchType");
        boolean lazy = false;
        lazy = value instanceof ToOne ? ((ToOne)value).isLazy() : (value instanceof Collection ? ((Collection)value).isLazy() : property.isLazy());
        if (lazy) {
            return fetchType + "." + "LAZY";
        }
        return fetchType + "." + "EAGER";
    }

    public Object getDecoratedObject() {
        return this.clazz;
    }

    public String generateCollectionAnnotation(Property property, Configuration cfg) {
        StringBuffer annotation = new StringBuffer();
        Value value = property.getValue();
        if (value != null && value instanceof Collection) {
            String mappedBy;
            Collection collection = (Collection)value;
            if (collection.isOneToMany()) {
                mappedBy = null;
                AnnotationBuilder ab = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.OneToMany"));
                ab.addAttribute("cascade", this.getCascadeTypes(property));
                ab.addAttribute("fetch", this.getFetchType(property));
                if (collection.isInverse()) {
                    mappedBy = this.getOneToManyMappedBy(cfg, collection);
                    ab.addQuotedAttribute("mappedBy", mappedBy);
                }
                annotation.append(ab.getResult());
                if (mappedBy == null) {
                    annotation.append("\n").append(this.generateJoinColumnsAnnotation(property, cfg));
                }
            } else {
                mappedBy = null;
                AnnotationBuilder ab = AnnotationBuilder.createAnnotation(this.importType("javax.persistence.ManyToMany"));
                ab.addAttribute("cascade", this.getCascadeTypes(property));
                ab.addAttribute("fetch", this.getFetchType(property));
                if (collection.isInverse()) {
                    mappedBy = this.getManyToManyMappedBy(cfg, collection);
                    ab.addQuotedAttribute("mappedBy", mappedBy);
                }
                annotation.append(ab.getResult());
                if (mappedBy == null) {
                    String uniqueConstraint;
                    annotation.append("\n    @");
                    annotation.append(this.importType("javax.persistence.JoinTable")).append("(name=\"");
                    Table table = collection.getCollectionTable();
                    annotation.append(table.getName());
                    annotation.append("\"");
                    if (StringHelper.isNotEmpty((String)table.getSchema())) {
                        annotation.append(", schema=\"").append(table.getSchema()).append("\"");
                    }
                    if (StringHelper.isNotEmpty((String)table.getCatalog())) {
                        annotation.append(", catalog=\"").append(table.getCatalog()).append("\"");
                    }
                    if ((uniqueConstraint = this.generateAnnTableUniqueConstraint(table)).length() > 0) {
                        annotation.append(", uniqueConstraints=").append(uniqueConstraint);
                    }
                    annotation.append(", joinColumns = { ");
                    this.buildArrayOfJoinColumnAnnotation(collection.getKey().getColumnIterator(), null, annotation, property.isInsertable(), property.isUpdateable());
                    annotation.append(" }");
                    annotation.append(", inverseJoinColumns = { ");
                    this.buildArrayOfJoinColumnAnnotation(collection.getElement().getColumnIterator(), null, annotation, property.isInsertable(), property.isUpdateable());
                    annotation.append(" }");
                    annotation.append(")");
                }
            }
            String hibernateCascade = this.getHibernateCascadeTypeAnnotation(property);
            if (hibernateCascade.length() > 0) {
                annotation.append("\n    ").append(hibernateCascade);
            }
        }
        return annotation.toString();
    }

    private String getManyToManyMappedBy(Configuration cfg, Collection collection) {
        Iterator joinColumnsIt = collection.getKey().getColumnIterator();
        HashSet joinColumns = new HashSet();
        while (joinColumnsIt.hasNext()) {
            joinColumns.add(joinColumnsIt.next());
        }
        ManyToOne manyToOne = (ManyToOne)collection.getElement();
        PersistentClass pc = cfg.getClassMapping(manyToOne.getReferencedEntityName());
        Iterator properties = pc.getPropertyClosureIterator();
        boolean isOtherSide = false;
        String mappedBy = "unresolved";
        while (!isOtherSide && properties.hasNext()) {
            Collection realCollectionValue;
            Property collectionProperty = (Property)properties.next();
            Value collectionValue = collectionProperty.getValue();
            if (collectionValue == null || !(collectionValue instanceof Collection) || (realCollectionValue = (Collection)collectionValue).isOneToMany() || joinColumns.size() != realCollectionValue.getElement().getColumnSpan()) continue;
            isOtherSide = true;
            Iterator it = realCollectionValue.getElement().getColumnIterator();
            while (it.hasNext()) {
                Object column = it.next();
                if (joinColumns.contains(column)) continue;
                isOtherSide = false;
                break;
            }
            if (!isOtherSide) continue;
            mappedBy = collectionProperty.getName();
        }
        return mappedBy;
    }

    private String getOneToManyMappedBy(Configuration cfg, Collection collection) {
        Iterator joinColumnsIt = collection.getKey().getColumnIterator();
        HashSet joinColumns = new HashSet();
        while (joinColumnsIt.hasNext()) {
            joinColumns.add(joinColumnsIt.next());
        }
        OneToMany oneToMany = (OneToMany)collection.getElement();
        PersistentClass pc = cfg.getClassMapping(oneToMany.getReferencedEntityName());
        Iterator properties = pc.getPropertyClosureIterator();
        boolean isOtherSide = false;
        String mappedBy = "unresolved";
        while (!isOtherSide && properties.hasNext()) {
            Property manyProperty = (Property)properties.next();
            Value manyValue = manyProperty.getValue();
            if (manyValue == null || !(manyValue instanceof ManyToOne) || joinColumns.size() != manyValue.getColumnSpan()) continue;
            isOtherSide = true;
            Iterator it = manyValue.getColumnIterator();
            while (it.hasNext()) {
                Object column = it.next();
                if (joinColumns.contains(column)) continue;
                isOtherSide = false;
                break;
            }
            if (!isOtherSide) continue;
            mappedBy = manyProperty.getName();
        }
        return mappedBy;
    }

    private String getOneToOneMappedBy(Configuration cfg, OneToOne oneToOne) {
        Iterator joinColumnsIt = oneToOne.getColumnIterator();
        HashSet joinColumns = new HashSet();
        while (joinColumnsIt.hasNext()) {
            joinColumns.add(joinColumnsIt.next());
        }
        PersistentClass pc = cfg.getClassMapping(oneToOne.getReferencedEntityName());
        String referencedPropertyName = oneToOne.getReferencedPropertyName();
        if (referencedPropertyName != null) {
            return referencedPropertyName;
        }
        Iterator properties = pc.getPropertyClosureIterator();
        boolean isOtherSide = false;
        String mappedBy = "unresolved";
        while (!isOtherSide && properties.hasNext()) {
            Property oneProperty = (Property)properties.next();
            Value manyValue = oneProperty.getValue();
            if (manyValue == null || !(manyValue instanceof OneToOne) && !(manyValue instanceof ManyToOne) || joinColumns.size() != manyValue.getColumnSpan()) continue;
            isOtherSide = true;
            Iterator it = manyValue.getColumnIterator();
            while (it.hasNext()) {
                Object column = it.next();
                if (joinColumns.contains(column)) continue;
                isOtherSide = false;
                break;
            }
            if (!isOtherSide) continue;
            mappedBy = oneProperty.getName();
        }
        return mappedBy;
    }

    public boolean isSubclass() {
        return this.clazz.getSuperclass() != null;
    }

    public List getPropertyClosureForFullConstructor() {
        return this.getPropertyClosureForFullConstructor(this.clazz);
    }

    protected List getPropertyClosureForFullConstructor(PersistentClass pc) {
        ArrayList l = new ArrayList(this.getPropertyClosureForSuperclassFullConstructor(pc));
        l.addAll(this.getPropertiesForFullConstructor(pc));
        return l;
    }

    public List getPropertiesForFullConstructor() {
        return this.getPropertiesForFullConstructor(this.clazz);
    }

    protected List getPropertiesForFullConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        Iterator myFields = this.getAllPropertiesIterator(pc);
        while (myFields.hasNext()) {
            Property field = (Property)myFields.next();
            if (field.equals(pc.getIdentifierProperty()) && !this.isAssignedIdentifier(pc, field) || field.equals(pc.getVersion()) || field.isBackRef() || this.isFormula(field)) continue;
            result.add(field);
        }
        return result;
    }

    private boolean isFormula(Property field) {
        Value value = field.getValue();
        boolean foundFormula = false;
        if (value != null && value.getColumnSpan() > 0) {
            Iterator columnIterator = value.getColumnIterator();
            while (columnIterator.hasNext()) {
                Selectable element = (Selectable)columnIterator.next();
                if (!(element instanceof Formula)) {
                    return false;
                }
                foundFormula = true;
            }
        } else {
            return false;
        }
        return foundFormula;
    }

    public List getPropertyClosureForSuperclassFullConstructor() {
        return this.getPropertyClosureForSuperclassFullConstructor(this.clazz);
    }

    public List getPropertyClosureForSuperclassFullConstructor(PersistentClass pc) {
        ArrayList result = new ArrayList();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassFullConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForFullConstructor(pc.getSuperclass()));
        }
        return result;
    }

    public List getPropertyClosureForMinimalConstructor() {
        return this.getPropertyClosureForMinimalConstructor(this.clazz);
    }

    protected List getPropertyClosureForMinimalConstructor(PersistentClass pc) {
        ArrayList l = new ArrayList(this.getPropertyClosureForSuperclassMinConstructor(pc));
        l.addAll(this.getPropertiesForMinimalConstructor(pc));
        return l;
    }

    public List getPropertiesForMinimalConstructor() {
        return this.getPropertiesForMinimalConstructor(this.clazz);
    }

    protected List getPropertiesForMinimalConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        Iterator myFields = this.getAllPropertiesIterator(pc);
        while (myFields.hasNext()) {
            Property property = (Property)myFields.next();
            if (property.equals(pc.getIdentifierProperty())) {
                if (!this.isAssignedIdentifier(pc, property)) continue;
                result.add(property);
                continue;
            }
            if (property.equals(pc.getVersion()) || !this.isRequiredInConstructor(property)) continue;
            result.add(property);
        }
        return result;
    }

    protected boolean isAssignedIdentifier(PersistentClass pc, Property property) {
        SimpleValue sv;
        return property.equals(pc.getIdentifierProperty()) && property.getValue().isSimpleValue() && "assigned".equals((sv = (SimpleValue)property.getValue()).getIdentifierGeneratorStrategy());
    }

    public List getPropertyClosureForSuperclassMinimalConstructor() {
        return this.getPropertyClosureForSuperclassMinConstructor(this.clazz);
    }

    protected List getPropertyClosureForSuperclassMinConstructor(PersistentClass pc) {
        ArrayList result = new ArrayList();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassMinConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForMinimalConstructor(pc.getSuperclass()));
        }
        return result;
    }

    public POJOClass getSuperClass() {
        if (!this.isSubclass()) {
            return null;
        }
        return new EntityPOJOClass(this.clazz.getSuperclass(), this.c2j);
    }

    public String toString() {
        return "Entity: " + (this.clazz == null ? "<none>" : this.clazz.getEntityName());
    }

    public boolean hasVersionProperty() {
        return this.clazz.isVersioned() && this.clazz instanceof RootClass;
    }

    public Property getVersionProperty() {
        return this.clazz.getVersion();
    }

    public static abstract class IteratorTransformer
    implements Iterator {
        private Iterator delegate;

        public IteratorTransformer(Iterator delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            return this.transform(this.delegate.next());
        }

        public abstract Object transform(Object var1);

        public void remove() {
            this.delegate.remove();
        }
    }
}

