/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.annotation.ErrorHandler;
import org.hibernate.jpamodelgen.annotation.NameMetaAttribute;
import org.hibernate.jpamodelgen.annotation.NamedQueryMethod;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.Metamodel;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.validation.ProcessorSessionFactory;
import org.hibernate.jpamodelgen.validation.Validation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public abstract class AnnotationMeta
implements Metamodel {
    void addAuxiliaryMembers() {
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedNativeQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedNativeQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.SqlResultSetMapping", "MAPPING_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.SqlResultSetMappings", "MAPPING_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedEntityGraph", "GRAPH_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedEntityGraphs", "GRAPH_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.NamedQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.NamedQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.NamedNativeQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.NamedNativeQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.FetchProfile", "PROFILE_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.FetchProfiles", "PROFILE_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.FilterDef", "FILTER_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.FilterDefs", "FILTER_");
    }

    void checkNamedQueries() {
        boolean checkHql = TypeUtils.containsAnnotation(this.getElement(), "org.hibernate.annotations.processing.CheckHQL") || TypeUtils.containsAnnotation(this.getElement().getEnclosingElement(), "org.hibernate.annotations.processing.CheckHQL");
        this.handleNamedQueryAnnotation("jakarta.persistence.NamedQuery", checkHql);
        this.handleNamedQueryRepeatableAnnotation("jakarta.persistence.NamedQueries", checkHql);
        this.handleNamedQueryAnnotation("org.hibernate.annotations.NamedQuery", checkHql);
        this.handleNamedQueryRepeatableAnnotation("org.hibernate.annotations.NamedQueries", checkHql);
    }

    private void handleNamedQueryAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null) {
            this.handleNamedQuery(mirror, checkHql);
        }
    }

    private void handleNamedQueryRepeatableAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
        Object value;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null && (value = TypeUtils.getAnnotationValue(mirror, "value")) instanceof List) {
            List values = (List)value;
            for (AnnotationMirror annotationMirror : values) {
                this.handleNamedQuery(annotationMirror, checkHql);
            }
        }
    }

    private void handleNamedQuery(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
        Object nameValue = TypeUtils.getAnnotationValue(mirror, "name");
        if (nameValue instanceof String) {
            String hql;
            SqmStatement<?> statement;
            Object query;
            String name = nameValue.toString();
            boolean reportErrors = this.getContext().checkNamedQuery(name);
            AnnotationValue value = TypeUtils.getAnnotationValueRef(mirror, "query");
            if (value != null && (query = value.getValue()) instanceof String && (statement = Validation.validate(hql = (String)query, null, true, new WarningErrorHandler(this.getContext(), this.getElement(), mirror, value, hql, reportErrors, checkHql), ProcessorSessionFactory.create(this.getContext().getProcessingEnvironment()))) instanceof SqmSelectStatement && AnnotationMeta.isQueryMethodName(name)) {
                this.putMember(name, new NamedQueryMethod(this, (SqmSelectStatement)statement, name.substring(1), this.belongsToDao(), this.getSessionType(), this.getContext().addNonnullAnnotation()));
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isQueryMethodName(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.length() >= 2 && name.charAt(0) == '#' && Character.isJavaIdentifierStart(name.charAt(1)) && name.substring(2).chars().allMatch(Character::isJavaIdentifierPart);
    }

    private void addAuxiliaryMembersForRepeatableAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        Object value;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null && (value = TypeUtils.getAnnotationValue(mirror, "value")) instanceof List) {
            List values = (List)value;
            for (AnnotationMirror annotationMirror : values) {
                this.addAuxiliaryMembersForMirror(annotationMirror, prefix);
            }
        }
    }

    private void addAuxiliaryMembersForAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null) {
            this.addAuxiliaryMembersForMirror(mirror, prefix);
        }
    }

    private void addAuxiliaryMembersForMirror(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String prefix) {
        mirror.getElementValues().forEach((key, value) -> {
            String name;
            if (key.getSimpleName().contentEquals("name") && !(name = value.getValue().toString()).isEmpty()) {
                this.putMember(prefix + name, new NameMetaAttribute(this, name, prefix));
            }
        });
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean belongsToDao();

    abstract @Nullable @UnknownKeyFor @Initialized String getSessionType();

    abstract void putMember(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized MetaAttribute var2);

    private static class WarningErrorHandler
    extends ErrorHandler {
        private final @UnknownKeyFor @NonNull @Initialized boolean reportErrors;
        private final @UnknownKeyFor @NonNull @Initialized boolean checkHql;

        private WarningErrorHandler(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized boolean reportErrors, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
            super(context, element, mirror, value, hql);
            this.reportErrors = reportErrors;
            this.checkHql = checkHql;
        }

        @Override
        public void error(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized String message) {
            if (this.reportErrors) {
                if (this.checkHql) {
                    super.error(start, end, message);
                } else {
                    super.warn(start, end, message);
                }
            }
        }

        @Override
        public void warn(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized String message) {
            if (this.reportErrors) {
                super.warn(start, end, message);
            }
        }

        @Override
        public void syntaxError(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Recognizer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> recognizer, @UnknownKeyFor @NonNull @Initialized Object offendingSymbol, @UnknownKeyFor @NonNull @Initialized int line, @UnknownKeyFor @NonNull @Initialized int charPositionInLine, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized RecognitionException e) {
            if (this.reportErrors) {
                super.syntaxError(recognizer, offendingSymbol, line, charPositionInLine, message, e);
            }
        }
    }
}

