/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.reflect.Field;
import java.util.List;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.util.Constants;

final class Fail {
    private static final int SB_SIZE = 512;

    private Fail() {
    }

    static InstancioApiException withSettingsOnNullField() {
        String msg = new StringBuilder(512).append("Cause:").append(Constants.NL).append(" -> @WithSettings must be annotated on a non-null field.").append(Constants.NL).toString();
        return Fail.apiException(msg);
    }

    static InstancioApiException withSettingsOnNullOrNonStaticField() {
        String msg = new StringBuilder(512).append("Possible causes:").append(Constants.NL).append(" -> @WithSettings must be annotated on a non-null field.").append(Constants.NL).append(" -> If @WithSettings is used in a test class that contains a @ParameterizedTest,").append(Constants.NL).append("    the annotated Settings field must be static.").toString();
        return Fail.apiException(msg);
    }

    static InstancioApiException withSettingsOnWrongFieldType(Field field) {
        String msg = new StringBuilder(512).append("Cause:").append(Constants.NL).append(" -> @WithSettings must be annotated on a Settings field.").append(Constants.NL).append(Constants.NL).append("Found annotation on:").append(Constants.NL).append(" -> ").append(field).toString();
        return Fail.apiException(msg);
    }

    static InstancioApiException multipleAnnotatedFields(List<Field> fields) {
        StringBuilder sb = new StringBuilder(512).append("Cause:").append(Constants.NL).append(" -> Found more than one field annotated '@WithSettings'").append(Constants.NL).append(Constants.NL);
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            sb.append("    (").append(i + 1).append(") ").append(field).append(Constants.NL);
        }
        String msg = sb.append(Constants.NL).append("Only one annotated Settings field is expected").toString();
        return Fail.apiException(msg);
    }

    private static InstancioApiException apiException(String msg) {
        return new InstancioApiException(String.format("Error running test%n%n%s%n", msg));
    }
}

