/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelFinder {
    private Map<String, List<Class<? extends Model>>> modelClasses = new HashMap<String, List<Class<? extends Model>>>();

    void findModels(String dbName) throws IOException, ClassNotFoundException {
        List<String> models = Registry.instance().getConfiguration().getModelNames(dbName);
        if (models != null && models.size() != 0) {
            for (String model : models) {
                this.classFound(model);
            }
        } else {
            throw new InitException("you are trying to work with models, but no models are found. Maybe you have no models in project, or you did not instrument the models. It is expected that you have a file activejdbc_models.properties on classpath");
        }
    }

    protected List<Class<? extends Model>> getModelsForDb(String dbName) {
        return this.modelClasses.get(dbName);
    }

    protected void classFound(String className) throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        if (Model.class.isAssignableFrom(clazz) && clazz != null && !clazz.equals(Model.class)) {
            String dbName = MetaModel.getDbName(clazz);
            if (this.modelClasses.get(dbName) == null) {
                this.modelClasses.put(dbName, new ArrayList());
            }
            this.modelClasses.get(dbName).add(clazz);
        }
    }
}

