/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers.gherkin;

import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.parser.Parser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.parsers.RegexStoryParser;
import org.jbehave.core.parsers.StoryParser;
import org.jbehave.core.parsers.StoryTransformer;
import org.jbehave.core.parsers.TransformingStoryParser;

public class GherkinStoryParser
extends TransformingStoryParser {
    public GherkinStoryParser() {
        this((StoryParser)new RegexStoryParser());
    }

    public GherkinStoryParser(StoryParser delegate) {
        super(delegate, new StoryTransformer[]{new GherkinTransformer()});
    }

    public static class GherkinTransformer
    implements StoryTransformer {
        private LocalizedKeywords keywords;

        public GherkinTransformer() {
            this(new LocalizedKeywords());
        }

        public GherkinTransformer(LocalizedKeywords keywords) {
            this.keywords = keywords;
        }

        public String transform(String storyAsText) {
            final StringBuffer out = new StringBuffer();
            Formatter formatter = new Formatter(){

                public void uri(String uri) {
                    out.append(uri).append("\n");
                }

                public void feature(Feature feature) {
                    out.append(feature.getName()).append("\n\n");
                    this.writeNarrative(feature.getDescription());
                    this.writeMeta(feature.getTags());
                }

                private void writeMeta(List<Tag> tags) {
                    if (tags.isEmpty()) {
                        return;
                    }
                    out.append(GherkinTransformer.this.keywords.meta()).append(" ");
                    for (Tag tag : tags) {
                        out.append(tag.getName()).append(" ");
                    }
                    out.append("\n");
                }

                private void writeNarrative(String description) {
                    String narrative;
                    boolean matches = false;
                    Matcher findingNarrative = Pattern.compile(".*" + GherkinTransformer.this.keywords.narrative() + "(.*?)", 32).matcher(description);
                    if (findingNarrative.matches() && !(matches = this.writeNarrativeWithDefaultSyntax(out, narrative = findingNarrative.group(1).trim()))) {
                        matches = this.writeNarrativeWithAlternativeSyntax(out, narrative);
                    }
                    if (!matches) {
                        out.append(description);
                    }
                }

                private boolean writeNarrativeWithDefaultSyntax(StringBuffer out2, String narrative) {
                    boolean matches = false;
                    Matcher findingElements = Pattern.compile(".*" + GherkinTransformer.this.keywords.inOrderTo() + "(.*)\\s*" + GherkinTransformer.this.keywords.asA() + "(.*)\\s*" + GherkinTransformer.this.keywords.iWantTo() + "(.*)", 32).matcher(narrative);
                    if (findingElements.matches()) {
                        String inOrderTo = findingElements.group(1).trim();
                        String asA = findingElements.group(2).trim();
                        String iWantTo = findingElements.group(3).trim();
                        out2.append(GherkinTransformer.this.keywords.narrative()).append("\n");
                        out2.append(GherkinTransformer.this.keywords.inOrderTo()).append(" ").append(inOrderTo).append("\n");
                        out2.append(GherkinTransformer.this.keywords.asA()).append(" ").append(asA).append("\n");
                        out2.append(GherkinTransformer.this.keywords.iWantTo()).append(" ").append(iWantTo).append("\n\n");
                        matches = true;
                    }
                    return matches;
                }

                private boolean writeNarrativeWithAlternativeSyntax(StringBuffer out2, String narrative) {
                    boolean matches = false;
                    Matcher findingElements = Pattern.compile(".*" + GherkinTransformer.this.keywords.asA() + "(.*)\\s*" + GherkinTransformer.this.keywords.iWantTo() + "(.*)\\s*" + GherkinTransformer.this.keywords.soThat() + "(.*)", 32).matcher(narrative);
                    if (findingElements.matches()) {
                        String asA = findingElements.group(1).trim();
                        String iWantTo = findingElements.group(2).trim();
                        String soThat = findingElements.group(3).trim();
                        out2.append(GherkinTransformer.this.keywords.narrative()).append("\n");
                        out2.append(GherkinTransformer.this.keywords.asA()).append(" ").append(asA).append("\n");
                        out2.append(GherkinTransformer.this.keywords.iWantTo()).append(" ").append(iWantTo).append("\n\n");
                        out2.append(GherkinTransformer.this.keywords.soThat()).append(" ").append(soThat).append("\n");
                        matches = true;
                    }
                    return matches;
                }

                public void background(Background background) {
                    out.append(GherkinTransformer.this.keywords.lifecycle() + background.getName()).append("\n").append(GherkinTransformer.this.keywords.before() + "\n");
                }

                public void scenario(Scenario scenario) {
                    out.append("\n").append(GherkinTransformer.this.keywords.scenario() + scenario.getName()).append("\n\n");
                    this.writeMeta(scenario.getTags());
                }

                public void scenarioOutline(ScenarioOutline scenarioOutline) {
                    out.append("\n").append(GherkinTransformer.this.keywords.scenario() + scenarioOutline.getName()).append("\n\n");
                    this.writeMeta(scenarioOutline.getTags());
                }

                public void examples(Examples examples) {
                    out.append("\n").append(GherkinTransformer.this.keywords.examplesTable() + examples.getName()).append("\n");
                    this.writeRows(examples.getRows());
                }

                public void step(Step step) {
                    out.append(step.getKeyword() + step.getName()).append("\n");
                    this.writeRows(step.getRows());
                }

                public void eof() {
                }

                public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
                }

                public void done() {
                }

                public void close() {
                }

                private void writeRows(List<? extends Row> rows) {
                    if (rows != null && rows.size() > 0) {
                        for (Row row : rows) {
                            out.append("|");
                            for (String c : row.getCells()) {
                                out.append(c).append("|");
                            }
                            out.append("\n");
                        }
                    }
                }
            };
            new Parser(formatter).parse(storyAsText, "", Integer.valueOf(0));
            return out.toString();
        }
    }
}

