/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.groovy;

import groovy.lang.GroovyClassLoader;
import org.jbehave.core.annotations.groovy.UsingGroovy;
import org.jbehave.core.configuration.AnnotationBuilder;
import org.jbehave.core.configuration.AnnotationMonitor;
import org.jbehave.core.configuration.AnnotationRequired;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.groovy.GroovyContext;
import org.jbehave.core.configuration.groovy.GroovyResourceFinder;
import org.jbehave.core.steps.CompositeStepsFactory;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.groovy.GroovyStepsFactory;

public class GroovyAnnotationBuilder
extends AnnotationBuilder {
    private GroovyContext context;

    public GroovyAnnotationBuilder(Class<?> annotatedClass) {
        super(annotatedClass);
    }

    public GroovyAnnotationBuilder(Class<?> annotatedClass, AnnotationMonitor annotationMonitor) {
        super(annotatedClass, annotationMonitor);
    }

    public Configuration buildConfiguration() throws AnnotationRequired {
        if (this.annotationFinder().isAnnotationPresent(UsingGroovy.class)) {
            Class classLoaderClass = (Class)this.annotationFinder().getAnnotatedValue(UsingGroovy.class, Class.class, "classLoader");
            Class resourceFinderClass = (Class)this.annotationFinder().getAnnotatedValue(UsingGroovy.class, Class.class, "resourceFinder");
            try {
                GroovyClassLoader classLoader = (GroovyClassLoader)super.instanceOf(classLoaderClass, classLoaderClass);
                GroovyResourceFinder resourceFinder = (GroovyResourceFinder)super.instanceOf(resourceFinderClass, resourceFinderClass);
                this.context = this.createGroovyContext(classLoader, resourceFinder);
            }
            catch (Exception e) {
                this.annotationMonitor().elementCreationFailed(GroovyContext.class, e);
            }
        } else {
            this.annotationMonitor().annotationNotFound(UsingGroovy.class, (Object)this.annotatedClass());
        }
        return super.buildConfiguration();
    }

    public InjectableStepsFactory buildStepsFactory(Configuration configuration) {
        InjectableStepsFactory factoryUsingSteps = super.buildStepsFactory(configuration);
        if (this.context != null) {
            return new CompositeStepsFactory(new InjectableStepsFactory[]{new GroovyStepsFactory(configuration, this.context), factoryUsingSteps});
        }
        return factoryUsingSteps;
    }

    protected <T, V extends T> T instanceOf(Class<T> type, Class<V> ofClass) {
        if (this.context != null) {
            try {
                return this.context.getInstanceOfType(type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)super.instanceOf(type, ofClass);
    }

    protected GroovyContext createGroovyContext(GroovyClassLoader classLoader, GroovyResourceFinder resourceFinder) {
        if (this.context != null) {
            return this.context;
        }
        return new GroovyContext(classLoader, resourceFinder);
    }
}

