/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.annotations.guice.UsingGuice;
import org.jbehave.core.configuration.AnnotationBuilder;
import org.jbehave.core.configuration.AnnotationFinder;
import org.jbehave.core.configuration.AnnotationMonitor;
import org.jbehave.core.configuration.AnnotationRequired;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.PrintStreamAnnotationMonitor;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.CompositeStepsFactory;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.guice.GuiceStepsFactory;

public class GuiceAnnotationBuilder
extends AnnotationBuilder {
    public Injector injector;

    public GuiceAnnotationBuilder(Class<?> annotatedClass) {
        this(annotatedClass, (AnnotationMonitor)new PrintStreamAnnotationMonitor());
    }

    public GuiceAnnotationBuilder(Class<?> annotatedClass, AnnotationMonitor annotationMonitor) {
        super(annotatedClass, annotationMonitor);
    }

    public Configuration buildConfiguration() throws AnnotationRequired {
        AnnotationFinder finder = this.annotationFinder();
        if (finder.isAnnotationPresent(UsingGuice.class)) {
            List moduleClasses = finder.getAnnotatedValues(UsingGuice.class, Class.class, "modules");
            ArrayList<Module> modules = new ArrayList<Module>();
            for (Class moduleClass : moduleClasses) {
                try {
                    modules.add((Module)moduleClass.newInstance());
                }
                catch (Exception e) {
                    this.annotationMonitor().elementCreationFailed(moduleClass, e);
                }
            }
            if (modules.size() > 0) {
                this.injector = this.createInjector(modules);
            }
        } else {
            this.annotationMonitor().annotationNotFound(UsingGuice.class, (Object)this.annotatedClass());
        }
        return super.buildConfiguration();
    }

    public InjectableStepsFactory buildStepsFactory(Configuration configuration) {
        InjectableStepsFactory factoryUsingSteps = super.buildStepsFactory(configuration);
        if (this.injector != null) {
            return new CompositeStepsFactory(new InjectableStepsFactory[]{new GuiceStepsFactory(configuration, this.injector), factoryUsingSteps});
        }
        return factoryUsingSteps;
    }

    protected ParameterConverters parameterConverters(AnnotationFinder annotationFinder, TableTransformers tableTransformers) {
        ParameterConverters converters = super.parameterConverters(annotationFinder, tableTransformers);
        if (this.injector != null) {
            return converters.addConverters(this.findConverters(this.injector));
        }
        return converters;
    }

    private List<ParameterConverters.ParameterConverter> findConverters(Injector injector) {
        List bindingsByType = injector.findBindingsByType((TypeLiteral)new TypeLiteral<ParameterConverters.ParameterConverter>(){});
        if (bindingsByType.isEmpty() && injector.getParent() != null) {
            return this.findConverters(injector.getParent());
        }
        ArrayList<ParameterConverters.ParameterConverter> converters = new ArrayList<ParameterConverters.ParameterConverter>();
        for (Binding binding : bindingsByType) {
            converters.add((ParameterConverters.ParameterConverter)binding.getProvider().get());
        }
        return converters;
    }

    protected <T, V extends T> T instanceOf(final Class<T> type, final Class<V> ofClass) {
        if (this.injector != null) {
            if (!type.equals(Object.class)) {
                try {
                    boolean bindingFound = this.findBinding(this.injector, type);
                    if (bindingFound) {
                        return (T)this.injector.getInstance(type);
                    }
                    AbstractModule module = new AbstractModule(){

                        protected void configure() {
                            if (!type.equals(ofClass)) {
                                this.bind(type).to(ofClass);
                            } else {
                                this.bind(ofClass);
                            }
                        }
                    };
                    this.injector = this.injector.createChildInjector(new Module[]{module});
                    return (T)this.injector.getInstance(type);
                }
                catch (Exception e) {
                    return (T)this.injector.getInstance(ofClass);
                }
            }
            return (T)this.injector.getBinding(ofClass).getProvider().get();
        }
        return (T)super.instanceOf(type, ofClass);
    }

    private boolean findBinding(Injector injector, Class<?> type) {
        boolean found = false;
        for (Key key : injector.getBindings().keySet()) {
            if (!key.getTypeLiteral().getRawType().equals(type)) continue;
            found = true;
            break;
        }
        if (!found && injector.getParent() != null) {
            return this.findBinding(injector.getParent(), type);
        }
        return found;
    }

    protected Injector createInjector(List<Module> modules) {
        if (this.injector != null) {
            return this.injector;
        }
        Injector root = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
            }
        }});
        return root.createChildInjector(new Module[]{Modules.combine(modules)});
    }

    protected Injector injector() {
        return this.injector;
    }
}

