/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.arquillian.container.test.impl.SecurityActions;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.core.spi.ExtensionLoader;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.core.spi.Validate;

public class RemoteExtensionLoader
implements ExtensionLoader {
    private static final String SERVICES = "META-INF/services";
    private static final String EXCLUSIONS = "META-INF/exclusions";

    public Collection<LoadableExtension> load() {
        ArrayList<LoadableExtension> extensions = new ArrayList<LoadableExtension>();
        Collection<Object> loaded = Collections.emptyList();
        if (SecurityActions.getThreadContextClassLoader() != null) {
            loaded = this.all(SecurityActions.getThreadContextClassLoader(), RemoteLoadableExtension.class);
        }
        if (loaded.size() == 0) {
            loaded = this.all(RemoteExtensionLoader.class.getClassLoader(), RemoteLoadableExtension.class);
        }
        for (RemoteLoadableExtension extension : loaded) {
            extensions.add((LoadableExtension)extension);
        }
        return extensions;
    }

    public Map<Class<?>, Set<Class<?>>> loadVetoed() {
        return this.loadVetoed(SecurityActions.getThreadContextClassLoader());
    }

    private <T> Collection<T> all(ClassLoader classLoader, Class<T> serviceClass) {
        Validate.notNull((Object)classLoader, (String)"ClassLoader must be provided");
        Validate.notNull(serviceClass, (String)"ServiceClass must be provided");
        return this.createInstances(serviceClass, this.load(serviceClass, classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Class<?>, Set<Class<?>>> loadVetoed(ClassLoader classLoader) {
        Validate.notNull((Object)classLoader, (String)"ClassLoader must be provided");
        LinkedHashMap vetoed = new LinkedHashMap();
        try {
            Enumeration<URL> exclusions = classLoader.getResources(EXCLUSIONS);
            while (exclusions.hasMoreElements()) {
                URL exclusion = exclusions.nextElement();
                Properties vetoedElements = new Properties();
                InputStream inStream = exclusion.openStream();
                try {
                    vetoedElements.load(inStream);
                    Set<Map.Entry<Object, Object>> entries = vetoedElements.entrySet();
                    for (Map.Entry<Object, Object> entry : entries) {
                        String service = (String)entry.getKey();
                        String serviceImpls = (String)entry.getValue();
                        this.addVetoedClasses(service, serviceImpls, classLoader, vetoed);
                    }
                }
                finally {
                    if (inStream == null) continue;
                    inStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load exclusions from META-INF/exclusions", e);
        }
        return vetoed;
    }

    private void addVetoedClasses(String serviceName, String serviceImpls, ClassLoader classLoader, Map<Class<?>, Set<Class<?>>> vetoed) {
        try {
            Class<?> serviceClass = classLoader.loadClass(serviceName);
            Set<Class<?>> classes = this.loadVetoedServiceImpl(serviceImpls, classLoader);
            Set<Class<?>> registeredVetoedClasses = vetoed.get(serviceClass);
            if (registeredVetoedClasses == null) {
                vetoed.put(serviceClass, classes);
            } else {
                registeredVetoedClasses.addAll(classes);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private Set<Class<?>> loadVetoedServiceImpl(String serviceImpls, ClassLoader classLoader) {
        StringTokenizer serviceImplsSeparator = new StringTokenizer(serviceImpls, ",");
        LinkedHashSet serviceImplsClass = new LinkedHashSet();
        while (serviceImplsSeparator.hasMoreTokens()) {
            try {
                serviceImplsClass.add(classLoader.loadClass(serviceImplsSeparator.nextToken().trim()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return serviceImplsClass;
    }

    private <T> Set<Class<? extends T>> load(Class<T> serviceClass, ClassLoader loader) {
        String serviceFile = "META-INF/services/" + serviceClass.getName();
        LinkedHashSet<Class<T>> providers = new LinkedHashSet<Class<T>>();
        LinkedHashSet<Class<T>> vetoedProviders = new LinkedHashSet<Class<T>>();
        try {
            Enumeration<URL> enumeration = loader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream is = url.openStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        if ((line = this.skipCommentAndTrim(line)).length() > 0) {
                            try {
                                boolean mustBeVetoed = line.startsWith("!");
                                if (mustBeVetoed) {
                                    line = line.substring(1);
                                }
                                Class<T> provider = loader.loadClass(line).asSubclass(serviceClass);
                                if (mustBeVetoed) {
                                    vetoedProviders.add(provider);
                                }
                                if (vetoedProviders.contains(provider)) {
                                    providers.remove(provider);
                                } else {
                                    providers.add(provider);
                                }
                            }
                            catch (ClassCastException e) {
                                throw new IllegalStateException("Service " + line + " does not implement expected type " + serviceClass.getName());
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException exc) {
                    throw new RuntimeException("Could not read file: " + url);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load services for " + serviceClass.getName(), e);
        }
        return providers;
    }

    private String skipCommentAndTrim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        line = line.trim();
        return line;
    }

    private <T> Set<T> createInstances(Class<T> serviceType, Set<Class<? extends T>> providers) {
        LinkedHashSet<T> providerImpls = new LinkedHashSet<T>();
        for (Class<T> clazz : providers) {
            providerImpls.add(this.createInstance(clazz));
        }
        return providerImpls;
    }

    private <T> T createInstance(Class<? extends T> serviceImplClass) {
        try {
            return SecurityActions.newInstance(serviceImplClass, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of Service implementation " + serviceImplClass.getName(), e);
        }
    }
}

