/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.io.File;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;
import org.jboss.arquillian.container.wls.ShrinkWrapUtil;
import org.jboss.arquillian.container.wls.WebLogicDeployerClient;
import org.jboss.arquillian.container.wls.WebLogicJMXClient;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteContainer {
    private WebLogicJMXClient jmxClient;
    private WebLogicDeployerClient deployerClient;
    private CommonWebLogicConfiguration configuration;

    public RemoteContainer(CommonWebLogicConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        this.deployerClient = new WebLogicDeployerClient(this.configuration);
        this.jmxClient = new WebLogicJMXClient(this.configuration);
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = this.getDeploymentName(archive);
        File deploymentArchive = ShrinkWrapUtil.toFile(archive, this.configuration.isDeployExplodedArchive());
        this.deployerClient.deploy(deploymentName, deploymentArchive);
        return this.jmxClient.verifyDeployment(deploymentName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = this.getDeploymentName(archive);
        this.deployerClient.undeploy(deploymentName);
        this.jmxClient.verifyUndeployment(deploymentName);
    }

    public void stop() throws LifecycleException {
        this.jmxClient.close();
    }

    private String getDeploymentName(Archive<?> archive) {
        String archiveFilename = archive.getName();
        int indexOfDot = archiveFilename.indexOf(".");
        if (indexOfDot != -1) {
            return archiveFilename.substring(0, indexOfDot);
        }
        return archiveFilename;
    }
}

