/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.wls.CommandBuilder;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicDeployerClient {
    private static final Logger logger = Logger.getLogger(WebLogicDeployerClient.class.getName());
    private Process deployer;
    private CommonWebLogicConfiguration configuration;
    private StringBuilder buffer;

    public WebLogicDeployerClient(CommonWebLogicConfiguration configuration) {
        this.configuration = configuration;
    }

    public void deploy(String deploymentName, File deploymentArchive) throws DeploymentException {
        CommandBuilder builder = new CommandBuilder().setClassPath(this.configuration.getClassPath()).setAdminUrl(this.configuration.getAdminUrl()).setAdminUserName(this.configuration.getAdminUserName()).setAdminPassword(this.configuration.getAdminPassword()).setDeploymentName(deploymentName).setDeploymentArchivePath(deploymentArchive.getAbsolutePath()).setTargets(this.configuration.getTarget()).setUseDemoTrust(this.configuration.isUseDemoTrust()).setUseCustomTrust(this.configuration.isUseCustomTrust()).setCustomTrustStore(this.configuration.getTrustStoreLocation()).setUseJavaStandardTrust(this.configuration.isUseJavaStandardTrust()).setIgnoreHostNameVerification(this.configuration.isIgnoreHostNameVerification()).setHostnameVerifierClass(this.configuration.getHostnameVerifierClass()).setUseURandom(this.configuration.isUseURandom());
        logger.log(Level.INFO, "Starting weblogic.Deployer to deploy the test artifact.");
        this.forkWebLogicDeployer(builder.buildDeployCommand());
    }

    public void undeploy(String deploymentName) throws DeploymentException {
        CommandBuilder builder = new CommandBuilder().setClassPath(this.configuration.getClassPath()).setAdminUrl(this.configuration.getAdminUrl()).setAdminUserName(this.configuration.getAdminUserName()).setAdminPassword(this.configuration.getAdminPassword()).setDeploymentName(deploymentName).setTargets(this.configuration.getTarget()).setUseDemoTrust(this.configuration.isUseDemoTrust()).setUseCustomTrust(this.configuration.isUseCustomTrust()).setCustomTrustStore(this.configuration.getTrustStoreLocation()).setUseJavaStandardTrust(this.configuration.isUseJavaStandardTrust()).setIgnoreHostNameVerification(this.configuration.isIgnoreHostNameVerification()).setHostnameVerifierClass(this.configuration.getHostnameVerifierClass()).setUseURandom(this.configuration.isUseURandom());
        logger.log(Level.INFO, "Starting weblogic.Deployer to undeploy the test artifact.");
        this.forkWebLogicDeployer(builder.buildUndeployCommand());
    }

    private void forkWebLogicDeployer(List<String> deployerCmd) throws DeploymentException {
        try {
            this.buffer = new StringBuilder();
            ProcessBuilder builder = new ProcessBuilder(deployerCmd);
            builder.redirectErrorStream(true);
            this.deployer = builder.start();
            Thread outputReader = new Thread(new DeployerOutputReader());
            outputReader.start();
            int exitValue = this.deployer.waitFor();
            if (exitValue == 0) {
                logger.log(Level.INFO, "weblogic.Deployer appears to have terminated successfully.");
            } else {
                logger.log(Level.WARNING, "weblogic.Deployer terminated abnormally with exit code {0}", exitValue);
                logger.log(Level.INFO, "The output of the weblogic.Deployer process was:\n {0}", this.buffer.toString());
            }
        }
        catch (InterruptedException interruptEx) {
            throw new DeploymentException("The thread was interrupted.", (Throwable)interruptEx);
        }
        catch (IOException ioEx) {
            throw new DeploymentException("Failed to execute weblogic.Deployer", (Throwable)ioEx);
        }
    }

    class DeployerOutputReader
    implements Runnable {
        DeployerOutputReader() {
        }

        public void run() {
            InputStream is = WebLogicDeployerClient.this.deployer.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    logger.log(Level.FINE, line);
                    WebLogicDeployerClient.this.buffer.append(line);
                    WebLogicDeployerClient.this.buffer.append('\n');
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

