/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls.jmx;

import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.wls.CommonManagedWebLogicConfiguration;
import org.jboss.arquillian.container.wls.WebLogicServerControl;
import org.jboss.arquillian.container.wls.jmx.FullJMXRemoteContainer;

public class FullJMXManagedContainer
extends FullJMXRemoteContainer {
    private CommonManagedWebLogicConfiguration configuration;
    private WebLogicServerControl serverControl;
    private boolean connectedToRunningServer = false;

    public FullJMXManagedContainer(CommonManagedWebLogicConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws LifecycleException {
        this.serverControl = new WebLogicServerControl(this.configuration);
        if (this.serverControl.isServerRunning()) {
            if (!this.configuration.isAllowConnectingToRunningServer()) throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
            this.connectedToRunningServer = true;
            super.start();
            return;
        } else {
            this.serverControl.startServer();
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        try {
            super.stop();
        }
        finally {
            if (!this.connectedToRunningServer) {
                this.serverControl.stopServer();
            }
        }
    }
}

