/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls.rest;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.jsonp.JsonProcessingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;
import org.jboss.arquillian.container.wls.ShrinkWrapUtil;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTUtils {
    private static final String DOT = ".";
    private static final String COMMON_APP_URI = "/management/wls/latest/deployments/application";
    private static final String COMMON_APP_ID_URI = "/management/wls/latest/deployments/application/id/";
    private static final String MONITORING_URI = "/management/tenant-monitoring/servers/";
    private static final String PURGE_PROGRESSS_OBJECTS_URI = "/management/weblogic/latest/domainRuntime/deploymentManager/purgeCompletedDeploymentProgressObjects";
    private static final String MULTIPART_JSON_MODEL_PART_NAME = "model";
    private static final String MULTIPART_JSON_MODEL_NAME = "name";
    private static final String MULTIPART_JSON_MODEL_TARGETS = "targets";
    private static final String MULTIPART_JSON_MODEL_TYPE = "type";
    private static final String MULTIPART_JSON_MODEL_TYPE_VALUE = "application";
    private static final String MULTIPART_DEPLOYMENT_PART_NAME = "deployment";
    private static final String HEADER_X_REQUESTED_BY_NAME = "X-Requested-By";
    private static final String HEADER_X_REQUESTED_BY_VALUE = "Arquillian WLS Container Adapter";
    private static final String JSON_RESPONSE_BODY = "body";
    private static final String JSON_RESPONSE_ITEM = "item";
    private static final String JSON_RESPONSE_STATUS = "status";
    private static final String JSON_RESPONSE_STATUS_FAIL = "failed";
    private static final String JSON_RESPONSE_ERROR = "error";
    private static final String JSON_RESPONSE_ERRORS = "errors";
    private static final String JSON_RESPONSE_NAME = "name";
    private static final String JSON_RESPONSE_TARGETS = "targets";
    private static final String JSON_RESPONSE_STATE = "state";
    private static final String JSON_RESPONSE_SERVLETS = "servlets";
    private static final String JSON_RESPONSE_SERVLET_NAME = "servletName";
    private static final String JSON_RESPONSE_CONTEXT_PATH = "contextPath";
    private static final String JSON_RESPONSE_STATE_VALUE_RUNNING = "\"RUNNING\"";

    public static Client getClient(CommonWebLogicConfiguration config, Logger logger) {
        HttpAuthenticationFeature httpAuthFeature = HttpAuthenticationFeature.universalBuilder().credentialsForBasic(config.getAdminUserName(), config.getAdminPassword()).build();
        ClientBuilder restClientBuilder = ClientBuilder.newBuilder();
        restClientBuilder.register(CsrfProtectionFilter.class);
        restClientBuilder.register((Object)httpAuthFeature);
        restClientBuilder.register(MultiPartFeature.class);
        restClientBuilder.register(JsonProcessingFeature.class);
        restClientBuilder.property("javax.json.stream.JsonGenerator.prettyPrinting", (Object)true);
        if (config.isLogRESTMessages() || config.isLogRESTEntities()) {
            restClientBuilder.register((Object)new LoggingFilter(logger, config.isLogRESTEntities()));
        }
        return restClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerRunning(CommonWebLogicConfiguration config, Logger logger) {
        boolean isRunning = false;
        Client client = RESTUtils.getClient(config, logger);
        WebTarget target = client.target(config.getAdminUrl() + MONITORING_URI + config.getTarget());
        try {
            JsonObject item;
            JsonObject body;
            JsonObject jsonResponse;
            Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity() && (jsonResponse = (JsonObject)response.readEntity(JsonObject.class)).containsKey((Object)JSON_RESPONSE_BODY) && (body = jsonResponse.getJsonObject(JSON_RESPONSE_BODY)).containsKey((Object)JSON_RESPONSE_ITEM) && (item = body.getJsonObject(JSON_RESPONSE_ITEM)).containsKey((Object)JSON_RESPONSE_STATE)) {
                JsonValue state = (JsonValue)item.get((Object)JSON_RESPONSE_STATE);
                isRunning = JSON_RESPONSE_STATE_VALUE_RUNNING.equals(state.toString().toUpperCase());
            }
        }
        catch (Exception e) {
        }
        finally {
            client.close();
        }
        return isRunning;
    }

    public static ProtocolMetaData deploy(CommonWebLogicConfiguration config, Logger logger, Archive<?> archive) throws DeploymentException {
        URI location;
        URI applicationRestURI;
        URL adminUrl;
        File deploymentArchive = ShrinkWrapUtil.toFile(archive);
        JsonObject model = Json.createObjectBuilder().add("name", RESTUtils.getDeploymentName(archive)).add("targets", (JsonValue)Json.createArrayBuilder().add(config.getTarget()).build()).add(MULTIPART_JSON_MODEL_TYPE, MULTIPART_JSON_MODEL_TYPE_VALUE).build();
        FormDataMultiPart form = new FormDataMultiPart();
        form.field(MULTIPART_JSON_MODEL_PART_NAME, (Object)model, MediaType.APPLICATION_JSON_TYPE);
        form.bodyPart((BodyPart)new FileDataBodyPart(MULTIPART_DEPLOYMENT_PART_NAME, deploymentArchive, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        try {
            adminUrl = new URL(config.getAdminUrl());
            applicationRestURI = new URI(adminUrl.toURI().toString() + COMMON_APP_URI).normalize();
        }
        catch (Exception e) {
            throw new DeploymentException("Error constructing deployment resource URL.", (Throwable)e);
        }
        Client restClient = RESTUtils.getClient(config, logger);
        Invocation.Builder requestBuilder = restClient.target(applicationRestURI).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        requestBuilder.header(HEADER_X_REQUESTED_BY_NAME, (Object)HEADER_X_REQUESTED_BY_VALUE);
        Response response = requestBuilder.post(Entity.entity((Object)form, (MediaType)form.getMediaType()));
        if (response.getStatus() != Response.Status.CREATED.getStatusCode() && response.hasEntity()) {
            JsonObject jsonItem;
            String responseItemStatus;
            if (MediaType.APPLICATION_JSON_TYPE != response.getMediaType()) {
                Response.StatusType status = response.getStatusInfo();
                throw new DeploymentException("Deployment Failed: " + deploymentArchive.getName() + " ; " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            JsonObject jsonResponse = (JsonObject)response.readEntity(JsonObject.class);
            if (jsonResponse.containsKey((Object)JSON_RESPONSE_ITEM) && JSON_RESPONSE_STATUS_FAIL.equals(responseItemStatus = (jsonItem = jsonResponse.getJsonObject(JSON_RESPONSE_ITEM)).getString(JSON_RESPONSE_STATUS))) {
                String exceptionMsg = jsonItem.getString(JSON_RESPONSE_ERROR);
                throw new DeploymentException(exceptionMsg, (Throwable)new RuntimeException(exceptionMsg));
            }
        }
        if ((location = response.getLocation()) != null) {
            response = restClient.target(location).request(new String[]{"application/json"}).get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new DeploymentException(RESTUtils.getJSONResponseErrorMessage((JsonObject)response.readEntity(JsonObject.class)));
            }
        } else {
            throw new DeploymentException("Deployment failed! No resource location available from response.");
        }
        ProtocolMetaData metadata = new ProtocolMetaData();
        try {
            JsonObject item;
            HTTPContext httpContext = new HTTPContext(adminUrl.getHost(), adminUrl.getPort());
            JsonObject jsonResponse = (JsonObject)response.readEntity(JsonObject.class);
            if (jsonResponse.containsKey((Object)JSON_RESPONSE_ITEM) && (item = jsonResponse.getJsonObject(JSON_RESPONSE_ITEM)).containsKey((Object)JSON_RESPONSE_SERVLETS)) {
                JsonArray servlets = item.getJsonArray(JSON_RESPONSE_SERVLETS);
                for (JsonValue servlet : servlets) {
                    JsonObject servletJsonObject = (JsonObject)servlet;
                    if (!servletJsonObject.containsKey((Object)JSON_RESPONSE_SERVLET_NAME) || !servletJsonObject.containsKey((Object)JSON_RESPONSE_CONTEXT_PATH)) continue;
                    httpContext.add(new Servlet(servletJsonObject.getString(JSON_RESPONSE_SERVLET_NAME), servletJsonObject.getString(JSON_RESPONSE_CONTEXT_PATH)));
                }
            }
            metadata.addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to populate the ProtocolMetaData with the deployment details.", (Throwable)e);
        }
        boolean purgedCompletedProgressObjects = false;
        try {
            purgedCompletedProgressObjects = RESTUtils.purgeCompletedDeploymentProgressObjects(restClient, config.getAdminUrl());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!purgedCompletedProgressObjects) {
            logger.warning("Failed to purge deployment progress object(s).");
        }
        restClient.close();
        return metadata;
    }

    public static void undeploy(CommonWebLogicConfiguration config, Logger logger, Archive<?> archive) throws DeploymentException {
        Response response;
        String deploymentName = RESTUtils.getDeploymentName(archive);
        try {
            Client restClient = RESTUtils.getClient(config, logger);
            Invocation.Builder requestBuilder = restClient.target(new URI(config.getAdminUrl() + COMMON_APP_ID_URI + deploymentName)).request();
            response = requestBuilder.delete();
            restClient.close();
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Deployment failed", (Throwable)e);
        }
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new DeploymentException(response.toString());
        }
    }

    private static Map<String, List<String>> getTargetErrors(JsonObject response) {
        return RESTUtils.getTargetErrors(RESTUtils.getTargets(response));
    }

    private static Map<String, List<String>> getTargetErrors(List<JsonObject> targets) {
        HashMap<String, List<String>> targetErrors = new HashMap<String, List<String>>();
        for (JsonObject target : targets) {
            JsonArray targetErrorsArray = target.getJsonArray(JSON_RESPONSE_ERRORS);
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (JsonValue targetError : targetErrorsArray) {
                errorMessages.add(targetError.toString());
            }
            targetErrors.put(target.getString("name"), errorMessages);
        }
        return targetErrors;
    }

    private static Map<String, String> getTargetStatuses(List<JsonObject> targets) {
        HashMap<String, String> targetStatuses = new HashMap<String, String>();
        for (JsonObject target : targets) {
            targetStatuses.put(target.getString("name"), target.getString(JSON_RESPONSE_STATUS));
        }
        return targetStatuses;
    }

    private static List<JsonObject> getTargets(JsonObject response) {
        ArrayList<JsonObject> targetJsonObjects = new ArrayList<JsonObject>();
        JsonObject item = response.getJsonObject(JSON_RESPONSE_ITEM);
        if (item != null) {
            JsonArray targets = item.getJsonArray("targets");
            for (JsonValue target : targets) {
                JsonObject targetJsonObject = (JsonObject)target;
                targetJsonObjects.add(targetJsonObject);
            }
        }
        return targetJsonObjects;
    }

    private static String getJSONResponseErrorMessage(JsonObject jsonResponse) {
        JsonObject item;
        String responseErrorMessage = null;
        if (jsonResponse.containsKey((Object)JSON_RESPONSE_ITEM) && (item = jsonResponse.getJsonObject(JSON_RESPONSE_ITEM)).containsKey((Object)JSON_RESPONSE_ERROR)) {
            responseErrorMessage = item.getString(JSON_RESPONSE_ERROR);
        }
        return responseErrorMessage;
    }

    private static boolean purgeCompletedDeploymentProgressObjects(Client restClient, String adminURL) throws Exception {
        String resourceURI = adminURL + PURGE_PROGRESSS_OBJECTS_URI;
        Invocation.Builder requestBuilder = restClient.target(new URI(resourceURI)).request();
        Response response = requestBuilder.post(null);
        return response.getStatus() == Response.Status.OK.getStatusCode();
    }

    public static String getDeploymentName(Archive<?> archive) {
        String archiveFilename = archive.getName();
        int indexOfDot = archiveFilename.indexOf(DOT);
        if (indexOfDot != -1) {
            return archiveFilename.substring(0, indexOfDot);
        }
        return archiveFilename;
    }
}

