/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBuilder {
    private String classPath;
    private String adminUrl;
    private String adminUserName;
    private String adminPassword;
    private String deploymentName;
    private String targets;
    private String deploymentArchivePath;
    private boolean useDemoTrust;
    private boolean useCustomTrust;
    private String customTrustStore;
    private boolean useJavaStandardTrust;
    private String trustStorePassword;
    private boolean ignoreHostNameVerification;
    private String hostnameVerifierClass;
    private boolean useURandom;

    public CommandBuilder setClassPath(String classPath) {
        this.classPath = classPath;
        return this;
    }

    public CommandBuilder setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
        return this;
    }

    public CommandBuilder setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
        return this;
    }

    public CommandBuilder setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public CommandBuilder setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public CommandBuilder setTargets(String targets) {
        this.targets = targets;
        return this;
    }

    public CommandBuilder setDeploymentArchivePath(String deploymentArchivePath) {
        this.deploymentArchivePath = deploymentArchivePath;
        return this;
    }

    public CommandBuilder setUseDemoTrust(boolean useDemoTrust) {
        this.useDemoTrust = useDemoTrust;
        return this;
    }

    public CommandBuilder setUseCustomTrust(boolean useCustomTrust) {
        this.useCustomTrust = useCustomTrust;
        return this;
    }

    public CommandBuilder setUseJavaStandardTrust(boolean useJavaStandardTrust) {
        this.useJavaStandardTrust = useJavaStandardTrust;
        return this;
    }

    public CommandBuilder setCustomTrustStore(String customTrustStore) {
        this.customTrustStore = customTrustStore;
        return this;
    }

    public CommandBuilder setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public CommandBuilder setIgnoreHostNameVerification(boolean ignoreHostNameVerification) {
        this.ignoreHostNameVerification = ignoreHostNameVerification;
        return this;
    }

    public CommandBuilder setHostnameVerifierClass(String hostnameVerifierClass) {
        this.hostnameVerifierClass = hostnameVerifierClass;
        return this;
    }

    public CommandBuilder setUseURandom(boolean useURandom) {
        this.useURandom = useURandom;
        return this;
    }

    public List<String> buildDeployCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-classpath");
        cmd.add(this.classPath);
        if (this.useDemoTrust) {
            cmd.add("-Dweblogic.security.TrustKeyStore=DemoTrust");
        }
        if (this.useCustomTrust) {
            cmd.add("-Dweblogic.security.TrustKeyStore=CustomTrust");
            cmd.add("-Dweblogic.security.CustomTrustKeyStoreFileName=" + this.customTrustStore);
            cmd.add("-Dweblogic.security.TrustKeystoreType=jks");
            if (this.trustStorePassword != null && !this.trustStorePassword.equals("")) {
                cmd.add("-Dweblogic.security.CustomTrustKeyStorePassPhrase=" + this.trustStorePassword);
            }
        }
        if (this.useJavaStandardTrust) {
            cmd.add("-Dweblogic.security.TrustKeyStore=JavaStandardTrust");
            if (this.trustStorePassword != null && !this.trustStorePassword.equals("")) {
                cmd.add("-Dweblogic.security.JavaStandardTrustKeyStorePassPhrase=" + this.trustStorePassword);
            }
        }
        if (this.ignoreHostNameVerification) {
            cmd.add("-Dweblogic.security.SSL.ignoreHostnameVerification=true");
        }
        if (this.hostnameVerifierClass != null && !this.hostnameVerifierClass.equals("")) {
            cmd.add("-Dweblogic.security.SSL.hostnameVerifier=" + this.hostnameVerifierClass);
        }
        if (this.useURandom) {
            cmd.add("-Djava.security.egd=file:/dev/./urandom");
        }
        cmd.add("weblogic.Deployer");
        cmd.add("-adminurl");
        cmd.add(this.adminUrl);
        cmd.add("-username");
        cmd.add(this.adminUserName);
        cmd.add("-password");
        cmd.add(this.adminPassword);
        cmd.add("-deploy");
        cmd.add("-name");
        cmd.add(this.deploymentName);
        cmd.add("-source");
        cmd.add(this.deploymentArchivePath);
        cmd.add("-targets");
        cmd.add(this.targets);
        cmd.add("-upload");
        cmd.add("-debug");
        return cmd;
    }

    public List<String> buildUndeployCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-classpath");
        cmd.add(this.classPath);
        if (this.useDemoTrust) {
            cmd.add("-Dweblogic.security.TrustKeyStore=DemoTrust");
        }
        if (this.useCustomTrust) {
            cmd.add("-Dweblogic.security.TrustKeyStore=CustomTrust");
            cmd.add("-Dweblogic.security.CustomTrustKeyStoreFileName=" + this.customTrustStore);
            cmd.add("-Dweblogic.security.TrustKeystoreType=jks");
            if (this.trustStorePassword != null && !this.trustStorePassword.equals("")) {
                cmd.add("-Dweblogic.security.CustomTrustKeyStorePassPhrase=" + this.trustStorePassword);
            }
        }
        if (this.useJavaStandardTrust) {
            cmd.add("-Dweblogic.security.TrustKeyStore=JavaStandardTrust");
            if (this.trustStorePassword != null && !this.trustStorePassword.equals("")) {
                cmd.add("-Dweblogic.security.JavaStandardTrustKeyStorePassPhrase=" + this.trustStorePassword);
            }
        }
        if (this.ignoreHostNameVerification) {
            cmd.add("-Dweblogic.security.SSL.ignoreHostnameVerification=true");
        }
        if (this.hostnameVerifierClass != null && !this.hostnameVerifierClass.equals("")) {
            cmd.add("-Dweblogic.security.SSL.hostnameVerifier=" + this.hostnameVerifierClass);
        }
        if (this.useURandom) {
            cmd.add("-Djava.security.egd=file:/dev/./urandom");
        }
        cmd.add("weblogic.Deployer");
        cmd.add("-adminurl");
        cmd.add(this.adminUrl);
        cmd.add("-username");
        cmd.add(this.adminUserName);
        cmd.add("-password");
        cmd.add(this.adminPassword);
        cmd.add("-undeploy");
        cmd.add("-name");
        cmd.add(this.deploymentName);
        cmd.add("-targets");
        cmd.add(this.targets);
        cmd.add("-debug");
        return cmd;
    }
}

