/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.wls.Validate;

public class CommonWebLogicConfiguration
implements ContainerConfiguration {
    private static final Logger logger = Logger.getLogger(CommonWebLogicConfiguration.class.getName());
    private static final String WEBLOGIC_JAR_PATH = "server/lib/weblogic.jar";
    private static final String JMX_CLIENT_JAR_PATH = "server/lib/wljmxclient.jar";
    private String adminUrl;
    private String adminProtocol;
    private String adminListenAddress;
    private int adminListenPort;
    private String adminUserName;
    private String adminPassword;
    private String wlsHome;
    private String wlHome = System.getenv("WL_HOME");
    private String target;
    private String weblogicJarPath;
    private String jmxClientJarPath;
    private String jmxProtocol;
    private String jmxHost;
    private int jmxPort;
    private boolean useDemoTrust = false;
    private boolean useCustomTrust = false;
    private boolean useJavaStandardTrust = false;
    private String trustStoreLocation;
    private String trustStorePassword;
    private boolean ignoreHostNameVerification;
    private String hostnameVerifierClass;
    private String classPath;
    private boolean useURandom;
    private boolean deployExplodedArchive;
    private boolean restMessageLogging = false;
    private boolean restEntityLogging = false;

    public void validate() throws ConfigurationException {
        if (this.wlsHome != null && this.wlsHome.length() > 0) {
            Validate.directoryExists(this.wlsHome, "The wlsHome directory resolved to " + this.wlsHome + " and could not be located. Verify the property in arquillian.xml");
            logger.log(Level.WARNING, "The wlsHome property is deprecated. Use the wlHome property instead.");
            this.wlHome = this.wlsHome;
        }
        Validate.directoryExists(this.wlHome, "The wlHome directory resolved to " + this.wlHome + " and could not be located. Verify the property in arquillian.xml");
        Validate.notNullOrEmpty(this.adminUrl, "The adminUrl is empty. Verify the property in arquillian.xml");
        Validate.notNullOrEmpty(this.adminUserName, "The username provided to weblogic.Deployer is empty. Verify the credentials in arquillian.xml");
        Validate.notNullOrEmpty(this.adminPassword, "The password provided to weblogic.Deployer is empty. Verify the credentials in arquillian.xml");
        Validate.notNullOrEmpty(this.target, "The target for the deployment is empty. Verify the properties in arquillian.xml");
        try {
            URI adminURI = new URI(this.adminUrl);
            this.adminProtocol = adminURI.getScheme();
            this.adminListenAddress = adminURI.getHost();
            this.adminListenPort = adminURI.getPort();
            Validate.notNullOrEmpty(this.adminProtocol, "The adminProtocol is empty. Verify the adminUrl and adminProtocol properties in arquillian.xml");
            Validate.isInList(this.adminProtocol, new String[]{"t3", "t3s", "http", "https", "iiop", "iiops"}, "The adminProtocol is invalid. It must be either t3, t3s, http, https, iiop or iiops.");
            Validate.notNullOrEmpty(this.adminListenAddress, "The adminListenAddress is empty. Verify the adminUrl and adminListenAddress properties in arquillian.xml");
            Validate.isInRange(this.adminListenPort, 0, 65535, "The adminListenPort is invalid. Verify the adminUrl and adminListenPort properties in arquillian.xml");
        }
        catch (URISyntaxException uriEx) {
            throw new IllegalArgumentException("Failed to parse the adminUrl property - " + this.adminUrl + " as a URI.", uriEx);
        }
        if (this.weblogicJarPath == null || this.weblogicJarPath.equals("")) {
            String string = this.weblogicJarPath = this.wlHome.endsWith(File.separator) ? this.wlHome.concat(WEBLOGIC_JAR_PATH) : this.wlHome.concat(File.separator).concat(WEBLOGIC_JAR_PATH);
        }
        if (this.jmxClientJarPath == null || this.jmxClientJarPath.equals("")) {
            String string = this.jmxClientJarPath = this.wlHome.endsWith(File.separator) ? this.wlHome.concat(JMX_CLIENT_JAR_PATH) : this.wlHome.concat(File.separator).concat(JMX_CLIENT_JAR_PATH);
        }
        if ((this.jmxProtocol == null || this.jmxProtocol.equals("")) && (this.jmxHost == null || this.jmxHost.equals(""))) {
            this.jmxProtocol = this.adminProtocol;
            this.jmxHost = this.adminListenAddress;
            this.jmxPort = this.adminListenPort;
        }
        Boolean[] trustTypes = new Boolean[]{this.useDemoTrust, this.useCustomTrust, this.useJavaStandardTrust};
        int specifiedTrustType = 0;
        for (int ctr = 0; ctr < trustTypes.length; ++ctr) {
            if (!trustTypes[ctr].booleanValue()) continue;
            ++specifiedTrustType;
        }
        if (specifiedTrustType > 1) {
            throw new IllegalArgumentException("Only one of useDemoTrust, useCustomTrust and useJavaStandardTrust must be specified as true. Verify these properties in arquillian.xml ");
        }
        if (this.useDemoTrust) {
            this.trustStoreLocation = this.wlHome.endsWith(File.separator) ? this.wlHome.concat("server/lib/DemoTrust.jks") : this.wlHome.concat(File.separator).concat("server/lib/DemoTrust.jks");
            Validate.isValidFile(this.trustStoreLocation, "The DemoTrust.jks file was resolved to " + this.trustStoreLocation + " and could not be located. Verify the wlsHome and useDemoTrust properties in arquillian.xml");
        }
        if (this.useCustomTrust) {
            Validate.isValidFile(this.trustStoreLocation, "The trustStoreLocation file was resolved to " + this.trustStoreLocation + " and could not be located. Verify the useCustomTrust and trustStoreLocation properties in arquillian.xml");
        }
        if (this.useJavaStandardTrust) {
            this.trustStoreLocation = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            Validate.isValidFile(this.trustStoreLocation, "The trustStoreLocation file was resolved to " + this.trustStoreLocation + " and could not be located. Verify that the cacerts file is present in the JRE installation.");
        }
        Validate.isValidFile(this.weblogicJarPath, "The weblogic.jar could not be located. Verify the wlsHome and weblogicJarPath properties in arquillian.xml");
        this.classPath = this.classPath != null && !this.classPath.equals("") ? this.weblogicJarPath + File.pathSeparator + this.classPath : this.weblogicJarPath;
        Validate.notNullOrEmpty(this.jmxProtocol, "The jmxProtocol is empty. Verify the adminUrl, adminProtocol and jmxProtocol properties in arquillian.xml");
        Validate.isInList(this.jmxProtocol, new String[]{"t3", "t3s", "http", "https", "iiop", "iiops"}, "The jmxProtocol is invalid. It must be either t3, t3s, http, https, iiop or iiops.");
        Validate.notNullOrEmpty(this.jmxHost, "The jmxHost is empty. Verify the adminUrl, adminListenAddress and jmxHost properties in arquillian.xml");
        Validate.isInRange(this.jmxPort, 0, 65535, "The jmxPort is invalid. Verify the adminUrl, adminListenPort and jmxPort properties in arquillian.xml");
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public String getAdminProtocol() {
        return this.adminProtocol;
    }

    public void setAdminProtocol(String adminProtocol) {
        this.adminProtocol = adminProtocol;
    }

    public String getAdminListenAddress() {
        return this.adminListenAddress;
    }

    public void setAdminListenAddress(String adminListenAddress) {
        this.adminListenAddress = adminListenAddress;
    }

    public int getAdminListenPort() {
        return this.adminListenPort;
    }

    public void setAdminListenPort(int adminListenPort) {
        this.adminListenPort = adminListenPort;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getWlsHome() {
        return this.wlsHome;
    }

    public void setWlsHome(String wlsHome) {
        this.wlsHome = wlsHome;
    }

    public String getWlHome() {
        return this.wlHome;
    }

    public void setWlHome(String wlHome) {
        this.wlHome = wlHome;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getWeblogicJarPath() {
        return this.weblogicJarPath;
    }

    public void setWeblogicJarPath(String weblogicJarPath) {
        this.weblogicJarPath = weblogicJarPath;
    }

    public String getJmxClientJarPath() {
        return this.jmxClientJarPath;
    }

    public void setJmxClientJarPath(String jmxClientJarPath) {
        this.jmxClientJarPath = jmxClientJarPath;
    }

    public String getJmxProtocol() {
        return this.jmxProtocol;
    }

    public void setJmxProtocol(String jmxProtocol) {
        this.jmxProtocol = jmxProtocol;
    }

    public String getJmxHost() {
        return this.jmxHost;
    }

    public void setJmxHost(String jmxHost) {
        this.jmxHost = jmxHost;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public boolean isUseDemoTrust() {
        return this.useDemoTrust;
    }

    public void setUseDemoTrust(boolean useDemoTrust) {
        this.useDemoTrust = useDemoTrust;
    }

    public boolean isUseCustomTrust() {
        return this.useCustomTrust;
    }

    public void setUseCustomTrust(boolean useCustomTrust) {
        this.useCustomTrust = useCustomTrust;
    }

    public boolean isUseJavaStandardTrust() {
        return this.useJavaStandardTrust;
    }

    public void setUseJavaStandardTrust(boolean useJavaStandardTrust) {
        this.useJavaStandardTrust = useJavaStandardTrust;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public boolean isIgnoreHostNameVerification() {
        return this.ignoreHostNameVerification;
    }

    public void setIgnoreHostNameVerification(boolean ignoreHostNameVerification) {
        this.ignoreHostNameVerification = ignoreHostNameVerification;
    }

    public String getHostnameVerifierClass() {
        return this.hostnameVerifierClass;
    }

    public void setHostnameVerifierClass(String hostnameVerifierClass) {
        this.hostnameVerifierClass = hostnameVerifierClass;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public boolean isUseURandom() {
        return this.useURandom;
    }

    public void setUseURandom(boolean useURandom) {
        this.useURandom = useURandom;
    }

    public boolean isDeployExplodedArchive() {
        return this.deployExplodedArchive;
    }

    public void setDeployExplodedArchive(boolean deployExplodedArchive) {
        this.deployExplodedArchive = deployExplodedArchive;
    }

    public void setLogRESTMessages(boolean restMessageLogging) {
        this.restMessageLogging = restMessageLogging;
    }

    public boolean isLogRESTMessages() {
        return this.restMessageLogging;
    }

    public void setLogRESTEntities(boolean restEntityLogging) {
        this.restEntityLogging = restEntityLogging;
    }

    public boolean isLogRESTEntities() {
        return this.restEntityLogging;
    }
}

