/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpContextBuilder {
    private static final String RUNNING = "RUNNING";
    private HTTPContext httpContext;
    private String deploymentName;
    private CommonWebLogicConfiguration configuration;
    private MBeanServerConnection connection;
    private ObjectName domainRuntimeService;
    private ObjectName[] wlServerRuntimes;

    public HttpContextBuilder(String deploymentName, CommonWebLogicConfiguration configuration, MBeanServerConnection connection, ObjectName domainRuntimeService) {
        this.deploymentName = deploymentName;
        this.configuration = configuration;
        this.connection = connection;
        this.domainRuntimeService = domainRuntimeService;
    }

    public HTTPContext createContext() throws Exception {
        ObjectName[] targets;
        ObjectName appDeployment = this.findMatchingDeployment(this.deploymentName);
        if (appDeployment == null) {
            throw new DeploymentException("The specified deployment could not be found in the MBean Server.\nThe deployment must have failed. Verify the output of the weblogic.Deployer process.");
        }
        for (ObjectName target : targets = (ObjectName[])this.connection.getAttribute(appDeployment, "Targets")) {
            String targetType = (String)this.connection.getAttribute(target, "Type");
            String targetName = (String)this.connection.getAttribute(target, "Name");
            if (!targetName.equals(this.configuration.getTarget())) continue;
            if (targetType.equals("Server")) {
                this.wlServerRuntimes = this.findRunningWLServerRuntimes(targetName);
                this.buildHTTPContext();
                break;
            }
            if (!targetType.equals("Cluster")) break;
            String[] clusterMemberNames = this.findMembersOfCluster(target);
            this.wlServerRuntimes = this.findRunningWLServerRuntimes(clusterMemberNames);
            this.buildHTTPContext();
            break;
        }
        if (this.httpContext == null) {
            throw new DeploymentException("An unexpected condition was encountered. The HTTPContext could not be created.");
        }
        return this.httpContext;
    }

    private void buildHTTPContext() throws Exception {
        if (this.wlServerRuntimes.length < 1) {
            throw new DeploymentException("None of the targets are in the RUNNING state.");
        }
        ObjectName wlServerRuntime = this.wlServerRuntimes[0];
        String httpUrlAsString = (String)this.connection.invoke(wlServerRuntime, "getURL", new Object[]{"http"}, new String[]{"java.lang.String"});
        URL serverHttpUrl = new URL(httpUrlAsString);
        this.httpContext = new HTTPContext(serverHttpUrl.getHost(), serverHttpUrl.getPort());
        List<ObjectName> servletRuntimes = this.findServletRuntimes(wlServerRuntime, this.deploymentName);
        for (ObjectName servletRuntime : servletRuntimes) {
            String servletName = (String)this.connection.getAttribute(servletRuntime, "ServletName");
            String servletContextRoot = (String)this.connection.getAttribute(servletRuntime, "ContextPath");
            this.httpContext.add(new Servlet(servletName, servletContextRoot));
        }
    }

    private String[] findMembersOfCluster(ObjectName cluster) throws Exception {
        ObjectName[] servers = (ObjectName[])this.connection.getAttribute(cluster, "Servers");
        ArrayList<String> clusterServers = new ArrayList<String>();
        for (ObjectName server : servers) {
            String serverName = (String)this.connection.getAttribute(server, "Name");
            clusterServers.add(serverName);
        }
        return clusterServers.toArray(new String[0]);
    }

    private ObjectName[] findRunningWLServerRuntimes(String ... runtimeNames) throws Exception {
        ObjectName[] wlServerRuntimes;
        List<String> runtimeNamesList = Arrays.asList(runtimeNames);
        ArrayList<ObjectName> wlServerRuntimeList = new ArrayList<ObjectName>();
        for (ObjectName wlServerRuntime : wlServerRuntimes = (ObjectName[])this.connection.getAttribute(this.domainRuntimeService, "ServerRuntimes")) {
            String runtimeName = (String)this.connection.getAttribute(wlServerRuntime, "Name");
            String runtimeState = (String)this.connection.getAttribute(wlServerRuntime, "State");
            if (!runtimeNamesList.contains(runtimeName) || !runtimeState.equals(RUNNING)) continue;
            wlServerRuntimeList.add(wlServerRuntime);
        }
        return wlServerRuntimeList.toArray(new ObjectName[0]);
    }

    private List<ObjectName> findServletRuntimes(ObjectName wlServerRuntime, String deploymentName) throws Exception {
        ObjectName[] applicationRuntimes;
        for (ObjectName applicationRuntime : applicationRuntimes = (ObjectName[])this.connection.getAttribute(wlServerRuntime, "ApplicationRuntimes")) {
            String applicationName = (String)this.connection.getAttribute(applicationRuntime, "Name");
            if (!applicationName.equals(deploymentName)) continue;
            ObjectName[] componentRuntimes = (ObjectName[])this.connection.getAttribute(applicationRuntime, "ComponentRuntimes");
            ArrayList<ObjectName> servletRuntimes = new ArrayList<ObjectName>();
            for (ObjectName componentRuntime : componentRuntimes) {
                String componentType = (String)this.connection.getAttribute(componentRuntime, "Type");
                if (!componentType.toString().equals("WebAppComponentRuntime")) continue;
                servletRuntimes.addAll(Arrays.asList((ObjectName[])this.connection.getAttribute(componentRuntime, "Servlets")));
            }
            return servletRuntimes;
        }
        throw new DeploymentException("The deployment details were not found in the MBean Server. Possible causes include:\n1. The deployment failed. Review the admin server and the target's log files.\n2. The deployment succeeded partially. The deployment must be the Active state. Instead, it might be in the 'New' state.\n   Verify that the the admin server can connect to the target(s), and that no firewall rules are blocking the traffic on the admin channel.");
    }

    public ObjectName findMatchingDeployment(String deploymentName) throws Exception {
        ObjectName[] appDeployments;
        for (ObjectName appDeployment : appDeployments = this.findAllAppDeployments()) {
            String appDeploymentName = (String)this.connection.getAttribute(appDeployment, "Name");
            if (!appDeploymentName.equals(deploymentName)) continue;
            return appDeployment;
        }
        return null;
    }

    private ObjectName[] findAllAppDeployments() throws Exception {
        ObjectName domainConfig = (ObjectName)this.connection.getAttribute(this.domainRuntimeService, "DomainConfiguration");
        return (ObjectName[])this.connection.getAttribute(domainConfig, "AppDeployments");
    }
}

