/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.name;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.name.;
import org.jboss.cdi.tck.tests.definition.name.Haddock;
import org.jboss.cdi.tck.tests.definition.name.JSFBean;
import org.jboss.cdi.tck.tests.definition.name.Minnow;
import org.jboss.cdi.tck.tests.definition.name.Moose;
import org.jboss.cdi.tck.tests.definition.name.RedSnapper;
import org.jboss.cdi.tck.tests.definition.name.SeaBass;
import org.jboss.cdi.tck.tests.definition.name._Underscore;
import org.jboss.cdi.tck.tests.definition.name.lowerCase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class NameDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NameDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_name", id="a"), @SpecAssertion(section="concepts", id="e"), @SpecAssertion(section="declaring_managed_bean", id="bb")})
    public void testNonDefaultNamed() {
        Bean<Moose> moose = this.getUniqueBean(Moose.class, new Annotation[0]);
        Assert.assertEquals((String)moose.getName(), (String)"aMoose");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="default_name", id="a"), @SpecAssertion(section="managed_bean_name", id="a"), @SpecAssertion(section="default_name", id="fa")})
    public void testDefaultNamed() {
        String name = "haddock";
        Bean<Haddock> haddock = this.getUniqueBean(Haddock.class, new Annotation[0]);
        Assert.assertEquals((String)haddock.getName(), (String)name);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)haddock.getQualifiers(), new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE, NamedLiteral.of((String)name)}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="a"), @SpecAssertion(section="named_stereotype", id="aa")})
    public void testStereotypeDefaultsName() {
        Bean<RedSnapper> bean = this.getUniqueBean(RedSnapper.class, new Annotation[0]);
        Assert.assertEquals((String)bean.getName(), (String)"redSnapper");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="beans_with_no_name", id="a"), @SpecAssertion(section="concepts", id="e")})
    public void testNamedNotDeclaredByBean() {
        Bean<SeaBass> bean = this.getUniqueBean(SeaBass.class, new Annotation[0]);
        Assert.assertNull((Object)bean.getName());
    }

    @Test
    @SpecAssertion(section="beans_with_no_name", id="a")
    public void testNamedNotDeclaredByStereotype() {
        Bean<Minnow> bean = this.getUniqueBean(Minnow.class, new Annotation[0]);
        Assert.assertNull((Object)bean.getName());
    }

    @Test
    @SpecAssertion(section="managed_bean_name", id="a")
    public void testNameStartingWithMultipleUpperCaseCharacters() {
        Bean<JSFBean> bean = this.getUniqueBean(JSFBean.class, new Annotation[0]);
        Assert.assertEquals((String)bean.getName(), (String)"jSFBean");
    }

    @Test
    @SpecAssertion(section="managed_bean_name", id="a")
    public void testNameStartingWithUnderScoreCharacter() {
        Bean<_Underscore> bean = this.getUniqueBean(_Underscore.class, new Annotation[0]);
        Assert.assertEquals((String)bean.getName(), (String)"_Underscore");
    }

    @Test
    @SpecAssertion(section="managed_bean_name", id="a")
    public void testNameStartingWithDollarCharacter() {
        Bean<.Dollar> bean = this.getUniqueBean(.Dollar.class, new Annotation[0]);
        Assert.assertEquals((String)bean.getName(), (String)"$Dollar");
    }

    @Test
    @SpecAssertion(section="managed_bean_name", id="a")
    public void testNameStartingWithLowerCaseCharacter() {
        Bean<lowerCase> bean = this.getUniqueBean(lowerCase.class, new Annotation[0]);
        Assert.assertEquals((String)bean.getName(), (String)"lowerCase");
    }
}

