/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.io.ObjectStreamException;
import java.lang.reflect.InvocationHandler;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.invocation.proxy.SerializableProxy;

public class DefaultSerializableProxy
implements SerializableProxy {
    private static final long serialVersionUID = -1296036574026839239L;
    private InvocationHandler handler;
    private String proxyClassName;

    @Override
    public void setProxyInstance(Object proxy) {
        this.proxyClassName = proxy.getClass().getName();
        this.handler = ProxyFactory.getInvocationHandlerStatic(proxy);
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            Class<?> proxyClass = this.getProxyClass();
            Object instance = proxyClass.newInstance();
            ProxyFactory.setInvocationHandlerStatic(instance, this.handler);
            return instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Class<?> getProxyClass() throws ClassNotFoundException {
        ClassLoader classLoader = this.getProxyClassLoader();
        return Class.forName(this.proxyClassName, false, classLoader);
    }

    protected ClassLoader getProxyClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

