/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

final class Utils {
    static final char[] ONES;
    static final char[] TENS;
    static final byte[] EMPTY_BYTES;
    static final char[] BASE64_ENC_TABLE;
    static final char[] BASE64_NEWLINE;
    static final int[] BASE64_DEC_TABLE;
    static final int[] HEX_TABLE;
    static final int INCORRECT_DATA = -1;

    private Utils() {
    }

    static boolean isControl(int c) {
        return c <= 31;
    }

    static boolean isBase64Char(int c) {
        return 97 <= c && c <= 122 || 65 <= c && c <= 90 || 48 <= c && c <= 57 || c == 43 || c == 47 || c == 61;
    }

    static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    static boolean isNumberChar(int c) {
        return 48 <= c && c <= 57 || c == 45 || c == 43 || c == 46 || c == 101 || c == 69;
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isHexNumberChar(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70 || c == 45 || c == 43 || c == 46 || c == 101 || c == 69;
    }

    static int stringSizeOf(long l) {
        int signSize = 1;
        if (l >= 0L) {
            signSize = 0;
            l = -l;
        }
        long temp = -10L;
        for (int j = 1; j < 19; ++j) {
            if (l > temp) {
                return j + signSize;
            }
            temp = 10L * temp;
        }
        return 19 + signSize;
    }

    static int stringSizeOf(int i) {
        int signSize = 1;
        if (i >= 0) {
            signSize = 0;
            i = -i;
        }
        int temp = -10;
        for (int j = 1; j < 10; ++j) {
            if (i > temp) {
                return j + signSize;
            }
            temp = 10 * temp;
        }
        return 10 + signSize;
    }

    static {
        int i;
        int c;
        EMPTY_BYTES = new byte[0];
        BASE64_ENC_TABLE = new char[64];
        BASE64_NEWLINE = "\\r\\n".toCharArray();
        BASE64_DEC_TABLE = new int[256];
        HEX_TABLE = new int[256];
        ONES = new char[100];
        TENS = new char[100];
        for (int i2 = 0; i2 < 100; ++i2) {
            Utils.ONES[i2] = (char)(48 + i2 % 10);
            Utils.TENS[i2] = (char)(48 + i2 / 10);
        }
        int j = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Utils.BASE64_ENC_TABLE[j++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Utils.BASE64_ENC_TABLE[j++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Utils.BASE64_ENC_TABLE[j++] = c;
        }
        Utils.BASE64_ENC_TABLE[j++] = 43;
        Utils.BASE64_ENC_TABLE[j] = 47;
        for (i = 0; i < 256; ++i) {
            Utils.BASE64_DEC_TABLE[i] = -1;
        }
        j = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Utils.BASE64_DEC_TABLE[c] = j++;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Utils.BASE64_DEC_TABLE[c] = j++;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Utils.BASE64_DEC_TABLE[c] = j++;
        }
        Utils.BASE64_DEC_TABLE[43] = j++;
        Utils.BASE64_DEC_TABLE[47] = j;
        for (i = 0; i < 256; ++i) {
            Utils.HEX_TABLE[i] = -1;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Utils.HEX_TABLE[c] = c - 65 + 10;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Utils.HEX_TABLE[c] = c - 97 + 10;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Utils.HEX_TABLE[c] = c - 48;
        }
    }
}

