/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.processor.apt.ParameterFactory;
import org.jboss.logging.processor.apt.ReturnTypeFactory;
import org.jboss.logging.processor.apt.ThrowableTypeFactory;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

final class MessageMethodBuilder {
    private static final String MESSAGE_METHOD_SUFFIX = "$str";
    private final List<ExecutableElement> methods;
    private final Elements elements;
    private final Types types;

    private MessageMethodBuilder(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
        this.methods = new LinkedList<ExecutableElement>();
    }

    MessageMethodBuilder add(ExecutableElement method) {
        this.methods.add(method);
        return this;
    }

    Set<MessageMethod> build() {
        LinkedHashSet<AptMessageMethod> result = new LinkedHashSet<AptMessageMethod>();
        for (ExecutableElement elementMethod : this.methods) {
            AptMessageMethod resultMethod = new AptMessageMethod(this.elements, elementMethod);
            resultMethod.inheritsMessage = ElementHelper.inheritsMessage(this.methods, elementMethod);
            resultMethod.message = this.findMessage(this.methods, elementMethod);
            resultMethod.isOverloaded = ElementHelper.isOverloaded(this.methods, elementMethod);
            for (TypeMirror typeMirror : elementMethod.getThrownTypes()) {
                resultMethod.thrownTypes.add(ThrowableTypeFactory.of(this.elements, this.types, typeMirror));
            }
            for (Parameter parameter : ParameterFactory.of(this.elements, this.types, resultMethod.method)) {
                resultMethod.add(parameter);
            }
            if (resultMethod.isOverloaded()) {
                resultMethod.messageMethodName = resultMethod.name() + resultMethod.formatParameterCount() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name() + "." + resultMethod.formatParameterCount();
            } else {
                resultMethod.messageMethodName = resultMethod.name() + MESSAGE_METHOD_SUFFIX;
                resultMethod.translationKey = resultMethod.name();
            }
            resultMethod.returnType = ReturnTypeFactory.of(this.elements, this.types, elementMethod.getReturnType(), resultMethod);
            result.add(resultMethod);
        }
        return Collections.unmodifiableSet(result);
    }

    private MessageMethod.Message findMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        AptMessage result;
        block4: {
            Message message;
            block2: {
                block3: {
                    result = null;
                    message = method.getAnnotation(Message.class);
                    if (message == null) break block2;
                    result = new AptMessage(message);
                    result.hasId = this.hasMessageId(message);
                    result.inheritsId = message.id() == -1;
                    if (!result.inheritsId()) break block3;
                    result.id = this.findMessageId(methods, method);
                    if (result.id <= 0) break block4;
                    result.hasId = true;
                    break block4;
                }
                result.id = message.id();
                break block4;
            }
            Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName(), ElementHelper.parameterCount(method.getParameters()));
            for (ExecutableElement m : allMethods) {
                message = m.getAnnotation(Message.class);
                if (message == null) continue;
                result = new AptMessage(message);
                result.hasId = this.hasMessageId(message);
                result.inheritsId = message.id() == -1;
                if (result.inheritsId()) {
                    result.id = this.findMessageId(methods, m);
                    if (result.id <= 0) break;
                    result.hasId = true;
                    break;
                }
                result.id = message.id();
                break;
            }
        }
        return result;
    }

    private int findMessageId(Collection<ExecutableElement> methods, ExecutableElement method) {
        int result = -2;
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            Message message = m.getAnnotation(Message.class);
            if (message == null || message.id() == -1) continue;
            result = message.id();
        }
        return result;
    }

    private boolean hasMessageId(Message message) {
        return message != null && message.id() != 0 && message.id() != -1;
    }

    static MessageMethodBuilder create(Elements elements, Types types) {
        return new MessageMethodBuilder(elements, types);
    }

    private static class AptMessage
    implements MessageMethod.Message {
        private final Message message;
        private int id;
        private boolean hasId;
        private boolean inheritsId;

        private AptMessage(Message message) {
            this.message = message;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public boolean hasId() {
            return this.hasId;
        }

        @Override
        public boolean inheritsId() {
            return this.inheritsId;
        }

        @Override
        public String value() {
            return this.message.value();
        }

        @Override
        public Message.Format format() {
            return this.message.format();
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("hasId", this.hasId).add("id", this.id()).add("inheritsId", this.inheritsId).add("value", this.value()).add("formatType", this.format()).toString();
        }
    }

    private static class AptMessageMethod
    implements MessageMethod {
        private final Elements elements;
        private final Map<Parameter.ParameterType, Set<Parameter>> parameters;
        private final Set<ThrowableType> thrownTypes;
        private final ExecutableElement method;
        private ReturnType returnType;
        private Parameter cause;
        private boolean inheritsMessage;
        private boolean isOverloaded;
        private MessageMethod.Message message;
        private String messageMethodName;
        private String translationKey;

        AptMessageMethod(Elements elements, ExecutableElement method) {
            this.elements = elements;
            this.method = method;
            this.inheritsMessage = false;
            this.isOverloaded = false;
            this.parameters = new EnumMap<Parameter.ParameterType, Set<Parameter>>(Parameter.ParameterType.class);
            this.thrownTypes = new LinkedHashSet<ThrowableType>();
        }

        void add(Parameter parameter) {
            if (this.parameters.containsKey((Object)Parameter.ParameterType.ANY)) {
                this.parameters.get((Object)Parameter.ParameterType.ANY).add(parameter);
            } else {
                LinkedHashSet<Parameter> any = new LinkedHashSet<Parameter>();
                any.add(parameter);
                this.parameters.put(Parameter.ParameterType.ANY, any);
            }
            if (this.parameters.containsKey((Object)parameter.parameterType())) {
                this.parameters.get((Object)parameter.parameterType()).add(parameter);
            } else {
                LinkedHashSet<Parameter> set = new LinkedHashSet<Parameter>();
                set.add(parameter);
                this.parameters.put(parameter.parameterType(), set);
            }
            if (parameter.parameterType() == Parameter.ParameterType.CAUSE) {
                this.cause = parameter;
            }
        }

        @Override
        public String name() {
            return this.method.getSimpleName().toString();
        }

        @Override
        public Set<Parameter> parameters(Parameter.ParameterType parameterType) {
            if (this.parameters.containsKey((Object)parameterType)) {
                return this.parameters.get((Object)parameterType);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Parameter> parameters(Parameter.ParameterType parameterType, Parameter.ParameterType ... parameterTypes) {
            LinkedHashSet<Parameter> result = new LinkedHashSet<Parameter>();
            if (this.parameters.containsKey((Object)parameterType)) {
                result.addAll((Collection)this.parameters.get((Object)parameterType));
            }
            for (Parameter.ParameterType pt : parameterTypes) {
                if (!this.parameters.containsKey((Object)pt)) continue;
                result.addAll((Collection<Parameter>)this.parameters.get((Object)pt));
            }
            return result;
        }

        @Override
        public ReturnType returnType() {
            return this.returnType;
        }

        @Override
        public Set<ThrowableType> thrownTypes() {
            return Collections.unmodifiableSet(this.thrownTypes);
        }

        @Override
        public MessageMethod.Message message() {
            return this.message;
        }

        @Override
        public boolean inheritsMessage() {
            return this.inheritsMessage;
        }

        @Override
        public String messageMethodName() {
            return this.messageMethodName;
        }

        @Override
        public String translationKey() {
            return this.translationKey;
        }

        @Override
        public boolean hasCause() {
            return this.cause != null;
        }

        @Override
        public boolean isOverloaded() {
            return this.isOverloaded;
        }

        @Override
        public Parameter cause() {
            return this.cause;
        }

        @Override
        public String loggerMethod() {
            switch (this.message.format()) {
                case MESSAGE_FORMAT: {
                    return "logv";
                }
                case NO_FORMAT: {
                    return "log";
                }
                case PRINTF: {
                    return "logf";
                }
            }
            return "log";
        }

        @Override
        public String logLevel() {
            LogMessage logMessage = this.method.getAnnotation(LogMessage.class);
            Logger.Level logLevel = logMessage.level() == null ? Logger.Level.INFO : logMessage.level();
            return String.format("%s.%s.%s", Logger.class.getName(), Logger.Level.class.getSimpleName(), logLevel.name());
        }

        @Override
        public int formatParameterCount() {
            int result = this.parameters(Parameter.ParameterType.FORMAT, Parameter.ParameterType.TRANSFORM).size();
            for (Parameter params : this.parameters(Parameter.ParameterType.POS)) {
                result += params.pos().value().length;
            }
            return result;
        }

        @Override
        public boolean isLoggerMethod() {
            return ElementHelper.isAnnotatedWith(this.method, LogMessage.class);
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).add(this.parameters(Parameter.ParameterType.ANY)).add(this.returnType()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageMethod)) {
                return false;
            }
            AptMessageMethod other = (AptMessageMethod)obj;
            return Objects.areEqual(this.name(), other.name()) && Objects.areEqual(this.parameters, this.parameters) && Objects.areEqual(this.returnType, other.returnType);
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("returnType", this.returnType()).add("parameters", this.parameters(Parameter.ParameterType.ANY)).add("loggerMethod", this.loggerMethod()).toString();
        }

        @Override
        public ExecutableElement reference() {
            return this.method;
        }

        @Override
        public int compareTo(MessageMethod o) {
            int result = this.name().compareTo(o.name());
            result = result != 0 ? result : this.returnType.name().compareTo(o.returnType().name());
            int n = result = result != 0 ? result : this.parameters(Parameter.ParameterType.ANY).size() - o.parameters(Parameter.ParameterType.ANY).size();
            if (result == 0) {
                Iterator<Parameter> params1 = this.parameters(Parameter.ParameterType.ANY).iterator();
                Iterator<Parameter> params2 = o.parameters(Parameter.ParameterType.ANY).iterator();
                while (params1.hasNext()) {
                    if (params2.hasNext()) {
                        Parameter param1 = params1.next();
                        Parameter param2 = params2.next();
                        result = param1.compareTo(param2);
                    } else {
                        result = 1;
                    }
                    if (result == 0) continue;
                    break;
                }
            }
            return result;
        }

        @Override
        public String getComment() {
            return this.elements.getDocComment(this.method);
        }
    }
}

