/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;
import org.jboss.metadata.property.PropertyReplacer;

public class StatefulTimeoutMetaDataParser
extends AbstractMetaDataParser<StatefulTimeoutMetaData> {
    public static final StatefulTimeoutMetaDataParser INSTANCE = new StatefulTimeoutMetaDataParser();
    private static final Map<String, TimeUnit> TIME_UNITS;

    @Override
    public StatefulTimeoutMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        StatefulTimeoutMetaData schedule = new StatefulTimeoutMetaData();
        this.processElements(schedule, reader, propertyReplacer);
        return schedule;
    }

    @Override
    protected void processElement(StatefulTimeoutMetaData schedule, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case UNIT: {
                this.processUnitElement(schedule, reader, propertyReplacer);
                break;
            }
            case TIMEOUT: {
                this.processValueElement(schedule, reader, propertyReplacer);
                break;
            }
            default: {
                super.processElement(schedule, reader, propertyReplacer);
            }
        }
    }

    private void processValueElement(StatefulTimeoutMetaData schedule, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        schedule.setTimeout(Long.valueOf(StatefulTimeoutMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
    }

    protected void processUnitElement(StatefulTimeoutMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        TimeUnit unit = TIME_UNITS.get(StatefulTimeoutMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
        if (unit == null) {
            throw new RuntimeException("Cannot parse unit in <stateful-timeout> " + reader.getElementText());
        }
        metaData.setUnit(unit);
    }

    static {
        HashMap<String, TimeUnit> units = new HashMap<String, TimeUnit>();
        units.put("Days", TimeUnit.DAYS);
        units.put("Hours", TimeUnit.HOURS);
        units.put("Minutes", TimeUnit.MINUTES);
        units.put("Seconds", TimeUnit.SECONDS);
        units.put("Milliseconds", TimeUnit.MILLISECONDS);
        units.put("Microseconds", TimeUnit.MICROSECONDS);
        units.put("Nanoseconds", TimeUnit.NANOSECONDS);
        TIME_UNITS = Collections.unmodifiableMap(units);
    }
}

