/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.jta.recovery.arjunacore.NameScopedXAResource;
import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.xa.Xid;

public class RecoveryXids {
    private final Map<XidImple, Long> _whenFirstSeen = new HashMap<XidImple, Long>();
    private final Map<XidImple, Long> _whenLastSeen = new HashMap<XidImple, Long>();
    private NameScopedXAResource _xares;
    private long _lastValidated;
    private static volatile int staleSafetyIntervalMillis;
    private static volatile int safetyIntervalMillis;

    public RecoveryXids(NameScopedXAResource xares) {
        this._xares = xares;
        this._lastValidated = System.currentTimeMillis();
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("RecoveryXids new recoveryXids " + xares + " " + this._lastValidated));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecoveryXids) {
            try {
                return ((RecoveryXids)obj).isSameRM(this._xares);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final void nextScan(Xid[] trans) {
        long currentTime = System.currentTimeMillis();
        if (trans != null) {
            for (Xid xid : trans) {
                XidImple xidImple = new XidImple(xid);
                if (!this._whenFirstSeen.containsKey(xidImple)) {
                    this._whenFirstSeen.put(xidImple, currentTime);
                    if (tsLogger.logger.isTraceEnabled()) {
                        tsLogger.logger.trace((Object)("RecoveryXids _whenFirstSeen put nextScan " + this._xares + " " + currentTime + " === " + xidImple));
                    }
                }
                this._whenLastSeen.put(xidImple, currentTime);
            }
        }
        HashSet<XidImple> candidates = new HashSet<XidImple>(this._whenFirstSeen.keySet());
        for (XidImple candidate : candidates) {
            if (this._whenLastSeen.get(candidate) == currentTime) continue;
            this._whenFirstSeen.remove(candidate);
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("RecoveryXids _whenFirstSeen remove nextScan" + this._xares + " " + currentTime + " === " + candidate));
            }
            this._whenLastSeen.remove(candidate);
        }
    }

    public final Xid[] toRecover() {
        LinkedList<Xid> oldEnoughXids = new LinkedList<Xid>();
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<XidImple, Long> entry : this._whenFirstSeen.entrySet()) {
            if (entry.getValue() + (long)safetyIntervalMillis <= currentTime) {
                oldEnoughXids.add(entry.getKey());
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("RecoveryXids _whenFirstSeen toRecover yes " + this._xares + " " + entry.getValue() + " === " + currentTime));
                }
            }
            if (!tsLogger.logger.isTraceEnabled()) continue;
            tsLogger.logger.trace((Object)("RecoveryXids _whenFirstSeen toRecover no " + this._xares + " " + entry.getValue() + " === " + currentTime));
        }
        return oldEnoughXids.toArray(new Xid[oldEnoughXids.size()]);
    }

    public final boolean isSameRM(NameScopedXAResource xares) {
        try {
            if (xares == null) {
                return false;
            }
            return XAUtils.isSameRM(xares.getXaResource(), this._xares.getXaResource());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean contains(Xid xid) {
        XidImple xidImple = new XidImple(xid);
        return this._whenFirstSeen.containsKey(xidImple);
    }

    public boolean isStale() {
        boolean result;
        long now = System.currentTimeMillis();
        long threshold = this._lastValidated + (long)(2 * safetyIntervalMillis < staleSafetyIntervalMillis ? staleSafetyIntervalMillis : 2 * safetyIntervalMillis);
        long diff = now - threshold;
        boolean bl = result = diff > 0L;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("RecoveryXids isStale Check " + this._xares + " " + this._lastValidated + " " + now + " " + result));
        }
        return result;
    }

    public boolean remove(Xid xid) {
        XidImple xidImple = new XidImple(xid);
        if (this._whenFirstSeen.containsKey(xidImple)) {
            this._whenFirstSeen.remove(xidImple);
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("RecoveryXids _whenFirstSeen remove remove " + this._xares + " " + this._lastValidated + " " + xidImple));
            }
            this._whenLastSeen.remove(xidImple);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._whenFirstSeen.isEmpty();
    }

    public boolean updateIfEquivalentRM(NameScopedXAResource xaResource, Xid[] xids) {
        if (xaResource.isSameName(this._xares) || this.isSameRM(xaResource)) {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("RecoveryXids updateIfEquivalent updated with strong match. prev=" + this._xares + ", replacement=" + xaResource + ", _lastValidated=" + this._lastValidated));
            }
            this._xares = xaResource;
            this._lastValidated = System.currentTimeMillis();
            return true;
        }
        if (this._xares.isAnonymous() && xaResource.isAnonymous() && xids != null && xids.length > 0) {
            for (int i = 0; i < xids.length; ++i) {
                if (!this.contains(xids[i]) || xids[i].getFormatId() != 131077) continue;
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("RecoveryXids updateIfEquivalent updated with weak match. prev=" + this._xares + ", replacement=" + xaResource + ", _lastValidated=" + this._lastValidated));
                }
                this._xares = xaResource;
                this._lastValidated = System.currentTimeMillis();
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this._whenFirstSeen.size();
    }

    public static synchronized void setSafetyIntervalMillis(int safetyIntervalMillis) {
        RecoveryXids.safetyIntervalMillis = safetyIntervalMillis;
        staleSafetyIntervalMillis = safetyIntervalMillis > 0 ? safetyIntervalMillis * 2 : 20000;
    }

    static {
        RecoveryXids.setSafetyIntervalMillis(jtaPropertyManager.getJTAEnvironmentBean().getOrphanSafetyInterval());
    }
}

