/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.jts.orbspecific;

import com.arjuna.ArjunaOTS.OTSAbstractRecord;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.XAResourceRecord;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;

public class LastResourceRecord
extends XAResourceRecord {
    private static final String UID = Uid.lastResourceUid().stringForm();
    private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES = arjPropertyManager.getCoreEnvironmentBean().isAllowMultipleLastResources();
    private static boolean _disableMLRWarning = false;
    private static boolean _issuedWarning = false;

    public LastResourceRecord(TransactionImple tx, XAResource xaResource, Xid xid, Object[] params) {
        super(tx, xaResource, xid, params);
    }

    @Override
    public int type_id() throws SystemException {
        return Integer.MAX_VALUE;
    }

    @Override
    public String uid() throws SystemException {
        return UID;
    }

    @Override
    public void commit() throws SystemException, NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
    }

    @Override
    public Vote prepare() throws HeuristicMixed, HeuristicHazard, SystemException {
        try {
            this.commit_one_phase();
            return Vote.VoteCommit;
        }
        catch (TRANSACTION_ROLLEDBACK tr) {
            return Vote.VoteRollback;
        }
    }

    @Override
    public String type() {
        return "/CosTransactions/LastXAResourceRecord";
    }

    @Override
    public boolean saveRecord() throws SystemException {
        return false;
    }

    @Override
    public boolean shouldAdd(OTSAbstractRecord record) throws SystemException {
        if (record.type_id() == this.type_id()) {
            if (ALLOW_MULTIPLE_LAST_RESOURCES) {
                if (!_disableMLRWarning || _disableMLRWarning && !_issuedWarning) {
                    jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_lastResource_multipleWarning(record.toString());
                    _issuedWarning = true;
                }
                return true;
            }
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_lastResource_disallow(record.toString());
            return false;
        }
        return true;
    }

    static {
        if (ALLOW_MULTIPLE_LAST_RESOURCES) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_lastResource_startupWarning();
        }
        if (arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning()) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_lastResource_disableWarning();
            _disableMLRWarning = true;
        }
    }
}

