/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.internal.jta.utils.jts.XidUtils;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import javax.transaction.xa.Xid;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Unavailable;

public class AtomicTransaction
extends com.arjuna.ats.jts.extensions.AtomicTransaction {
    public AtomicTransaction() {
    }

    public AtomicTransaction(ControlWrapper tx) {
        super(tx);
    }

    public synchronized void end(boolean report_heuristics) throws NoTransaction, HeuristicMixed, HeuristicHazard, WrongTransaction, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("AtomicTransaction::end ( " + report_heuristics + " ) for " + String.valueOf(this._theAction)));
        }
        if (this._theAction == null) {
            throw new NoTransaction();
        }
        try {
            this._theAction.commit(report_heuristics);
            this._theStatus = Status.StatusCommitted;
        }
        catch (Unavailable e) {
            this._theStatus = Status.StatusNoTransaction;
            throw new NoTransaction();
        }
        catch (HeuristicMixed e) {
            this._theStatus = this.getStatus();
            throw e;
        }
        catch (HeuristicHazard e) {
            this._theStatus = this.getStatus();
            throw e;
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            this._theStatus = Status.StatusRolledBack;
            throw e;
        }
        catch (SystemException e) {
            this._theStatus = this.getStatus();
            throw e;
        }
        finally {
            TransactionReaper.transactionReaper().remove((Object)this._theAction);
        }
    }

    public synchronized void abort() throws NoTransaction, WrongTransaction, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("AtomicTransaction::abort for " + String.valueOf(this._theAction)));
        }
        if (this._theAction == null) {
            throw new NoTransaction();
        }
        try {
            this._theAction.rollback();
        }
        catch (Unavailable e) {
            this._theStatus = Status.StatusNoTransaction;
            throw new NoTransaction();
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            this._theStatus = Status.StatusRolledBack;
            throw e;
        }
        catch (SystemException e) {
            this._theStatus = this.getStatus();
            throw e;
        }
        finally {
            TransactionReaper.transactionReaper().remove((Object)this._theAction);
        }
    }

    public final ControlWrapper getControlWrapper() {
        return this._theAction;
    }

    public final Xid get_xid(boolean branch) throws SystemException {
        ControlImple controlImple = this._theAction.getImple();
        if (controlImple != null) {
            return XidUtils.getXid(controlImple.get_uid(), branch);
        }
        return XidUtils.getXid(this._theAction.getControl(), branch);
    }
}

