/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.jts.BaseTransaction;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jts.OTSManager;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.omg.CORBA.TRANSACTION_UNAVAILABLE;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.InvalidControl;
import org.omg.PortableInterceptor.InvalidSlot;

public class TransactionManagerImple
extends BaseTransaction
implements TransactionManager,
ObjectFactory {
    public Transaction getTransaction() throws SystemException {
        try {
            return TransactionImple.getTransaction();
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (TRANSACTION_UNAVAILABLE e) {
            try {
                Uid uid = OTSImpleManager.systemCurrent().contextManager().getReceivedCoordinatorUid();
                if (uid != null) {
                    return TransactionImple.getTransactions().get(uid);
                }
                return null;
            }
            catch (InvalidSlot e1) {
                SystemException systemException = new SystemException(e.toString());
                systemException.initCause((Throwable)e);
                throw systemException;
            }
        }
        catch (Exception e) {
            SystemException systemException = new SystemException(e.toString());
            systemException.initCause((Throwable)e);
            throw systemException;
        }
    }

    public Transaction suspend() throws SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionManagerImple.suspend");
        }
        try {
            TransactionImple tx = TransactionImple.getTransaction();
            Control theControl = OTSManager.get_current().suspend();
            return tx;
        }
        catch (TRANSACTION_UNAVAILABLE e) {
            try {
                Uid uid = OTSImpleManager.systemCurrent().contextManager().getReceivedCoordinatorUid();
                if (uid != null) {
                    OTSImpleManager.systemCurrent().contextManager().disassociateContext(OTSManager.getReceivedSlotId());
                    return TransactionImple.getTransactions().get(uid);
                }
                return null;
            }
            catch (InvalidSlot e1) {
                SystemException systemException = new SystemException(e.toString());
                systemException.initCause((Throwable)e);
                throw systemException;
            }
        }
        catch (Exception e) {
            SystemException systemException = new SystemException(e.toString());
            systemException.initCause((Throwable)e);
            throw systemException;
        }
    }

    public void resume(Transaction which) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionManagerImple.resume");
        }
        super.checkTransactionState();
        if (which == null || which instanceof TransactionImple) {
            TransactionImple theTransaction = (TransactionImple)which;
            try {
                ControlWrapper cont = theTransaction == null ? null : theTransaction.getControlWrapper();
                OTSImpleManager.current().resumeWrapper(cont);
                cont = null;
                theTransaction = null;
            }
            catch (InvalidControl e1) {
                InvalidTransactionException invalidTransactionException = new InvalidTransactionException();
                invalidTransactionException.initCause((Throwable)e1);
                throw invalidTransactionException;
            }
            catch (org.omg.CORBA.SystemException e2) {
                SystemException systemException = new SystemException(e2.toString());
                systemException.initCause((Throwable)e2);
                throw systemException;
            }
        } else {
            throw new InvalidTransactionException();
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return this;
    }
}

