/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;
import org.mvel2.integration.VariableResolverFactory;

public class MVELReturnValueEvaluator
implements ReturnValueEvaluator,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;

    public MVELReturnValueEvaluator() {
    }

    public MVELReturnValueEvaluator(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    public void compile(MVELDialectRuntimeData data) {
        this.expr = this.unit.getCompiledExpression(data);
    }

    public void compile(MVELDialectRuntimeData data, RuleImpl rule) {
        this.expr = this.unit.getCompiledExpression(data);
    }

    public String getDialect() {
        return this.id;
    }

    @Override
    public Object evaluate(ProcessContext context) throws Exception {
        Object value;
        int length = this.unit.getOtherIdentifiers().length;
        Object[] vars = new Object[length];
        if (this.unit.getOtherIdentifiers() != null) {
            for (int i = 0; i < length; ++i) {
                vars[i] = context.getVariable(this.unit.getOtherIdentifiers()[i]);
            }
        }
        InternalWorkingMemory internalWorkingMemory = null;
        if (context.getKieRuntime() instanceof StatefulKnowledgeSessionImpl) {
            internalWorkingMemory = ((StatefulKnowledgeSessionImpl)context.getKieRuntime()).getInternalWorkingMemory();
        } else if (context.getKieRuntime() instanceof StatelessKnowledgeSession) {
            StatefulKnowledgeSession statefulKnowledgeSession = ((StatelessKnowledgeSessionImpl)context.getKieRuntime()).newWorkingMemory();
            internalWorkingMemory = ((StatefulKnowledgeSessionImpl)statefulKnowledgeSession).getInternalWorkingMemory();
        }
        VariableResolverFactory factory = this.unit.getFactory((Object)context, null, null, null, null, vars, internalWorkingMemory, (GlobalResolver)context.getKieRuntime().getGlobals());
        KiePackage pkg = context.getKieRuntime().getKieBase().getKiePackage("MAIN");
        if (pkg != null && pkg instanceof KnowledgePackageImpl) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)((KnowledgePackageImpl)pkg).getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        if (!((value = MVELSafeHelper.getEvaluator().executeExpression((Object)this.expr, null, factory)) instanceof Boolean)) {
            throw new RuntimeException("Constraints must return boolean values: " + this.unit.getExpression() + " returns " + value + (value == null ? "" : " (type=" + value.getClass()));
        }
        return (boolean)((Boolean)value);
    }

    public Serializable getCompExpr() {
        return this.expr;
    }

    public String toString() {
        return this.unit.getExpression();
    }
}

