/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/EnumCompanionInEnumConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "resolvedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getResolvedDescriptor", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Visitor", "frontend"})
public final class EnumCompanionInEnumConstructorCallChecker
implements DeclarationChecker {
    @NotNull
    public static final EnumCompanionInEnumConstructorCallChecker INSTANCE = new EnumCompanionInEnumConstructorCallChecker();

    private EnumCompanionInEnumConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Object object;
        ClassDescriptor enumCompanion;
        ClassDescriptor enumDescriptor;
        block10: {
            block9: {
                Object v3;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (!(declaration instanceof KtEnumEntry) || !(descriptor2 instanceof ClassDescriptor)) {
                        return;
                    }
                    if (((ClassDescriptor)descriptor2).getKind() != ClassKind.ENUM_ENTRY) {
                        return;
                    }
                    DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                    ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                    if (classDescriptor2 == null) {
                        return;
                    }
                    enumDescriptor = classDescriptor2;
                    ClassDescriptor classDescriptor3 = enumDescriptor.getCompanionObjectDescriptor();
                    if (classDescriptor3 == null) {
                        return;
                    }
                    enumCompanion = classDescriptor3;
                    object = ((KtEnumEntry)declaration).getInitializerList();
                    if (object == null || (object = ((KtInitializerList)object).getInitializers()) == null) break block9;
                    Iterable $this$firstIsInstanceOrNull$iv = (Iterable)object;
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtSuperTypeCallEntry)) continue;
                        v3 = element$iv;
                        break block8;
                    }
                    v3 = null;
                }
                if ((object = (KtSuperTypeCallEntry)v3) != null) break block10;
            }
            return;
        }
        Object initializer2 = object;
        BindingTrace bindingTrace = context.getTrace();
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingTrace.bindingContext");
        Visitor visitor2 = new Visitor(enumDescriptor, enumCompanion, bindingContext, bindingTrace, context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitAccessToEnumCompanionMembersInEnumConstructorCall));
        ((PsiElementBase)initializer2).acceptChildren(visitor2);
    }

    private final DeclarationDescriptor getResolvedDescriptor(ReceiverValue $this$resolvedDescriptor) {
        if (!($this$resolvedDescriptor instanceof ClassValueReceiver) && !($this$resolvedDescriptor instanceof ImplicitClassReceiver)) {
            return null;
        }
        return $this$resolvedDescriptor.getType().unwrap().getConstructor().getDeclarationDescriptor();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/EnumCompanionInEnumConstructorCallChecker$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "enumDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "companionDescriptor", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportError", "", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Z)V", "getCompanionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getEnumDescriptor", "getReportError", "()Z", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "analyzeExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitExpression", "frontend"})
    private static final class Visitor
    extends KtVisitorVoid {
        @NotNull
        private final ClassDescriptor enumDescriptor;
        @NotNull
        private final ClassDescriptor companionDescriptor;
        @NotNull
        private final BindingContext context;
        @NotNull
        private final DiagnosticSink reporter;
        private final boolean reportError;

        public Visitor(@NotNull ClassDescriptor enumDescriptor, @NotNull ClassDescriptor companionDescriptor, @NotNull BindingContext context, @NotNull DiagnosticSink reporter, boolean reportError2) {
            Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
            Intrinsics.checkNotNullParameter((Object)companionDescriptor, (String)"companionDescriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.enumDescriptor = enumDescriptor;
            this.companionDescriptor = companionDescriptor;
            this.context = context;
            this.reporter = reporter;
            this.reportError = reportError2;
        }

        @NotNull
        public final ClassDescriptor getEnumDescriptor() {
            return this.enumDescriptor;
        }

        @NotNull
        public final ClassDescriptor getCompanionDescriptor() {
            return this.companionDescriptor;
        }

        @NotNull
        public final BindingContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticSink getReporter() {
            return this.reporter;
        }

        public final boolean getReportError() {
            return this.reportError;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this);
        }

        @Override
        public void visitExpression(@NotNull KtExpression expression2) {
            block2: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    boolean needAnalyzeReceiver = this.analyzeExpression(expression2);
                    if (!needAnalyzeReceiver) break block1;
                    expression2.acceptChildren(this);
                    break block2;
                }
                if (!(expression2 instanceof KtCallExpression)) break block2;
                KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression2).getValueArgumentList();
                if (ktValueArgumentList != null) {
                    ktValueArgumentList.acceptChildren(this);
                }
            }
        }

        private final boolean analyzeExpression(KtExpression expression2) {
            if (expression2.getParent() instanceof KtCallExpression) {
                return true;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.context);
            if (resolvedCall2 == null) {
                return true;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            DeclarationDescriptor dispatchDescriptor = INSTANCE.getResolvedDescriptor(resolvedCall3.getDispatchReceiver());
            DeclarationDescriptor extensionDescriptor = INSTANCE.getResolvedDescriptor(resolvedCall3.getExtensionReceiver());
            boolean dispatchIsCompanion = Intrinsics.areEqual((Object)dispatchDescriptor, (Object)this.companionDescriptor);
            boolean extensionIsCompanion = Intrinsics.areEqual((Object)extensionDescriptor, (Object)this.companionDescriptor);
            boolean dispatchIsImplicit = resolvedCall3.getDispatchReceiver() instanceof ImplicitClassReceiver;
            boolean extensionIsImplicit = resolvedCall3.getExtensionReceiver() instanceof ImplicitClassReceiver;
            if (!this.reportError && expression2 instanceof KtCallExpression && (dispatchIsCompanion && dispatchIsImplicit || extensionIsCompanion && extensionIsImplicit)) {
                return false;
            }
            if (dispatchIsCompanion || extensionIsCompanion) {
                KtExpression ktExpression;
                KtExpression receiverExpression;
                KtQualifiedExpression ktQualifiedExpression = expression2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)expression2 : null;
                KtExpression ktExpression2 = receiverExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
                if ((receiverExpression instanceof KtSimpleNameExpression ? receiverExpression : (ktExpression = receiverExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)receiverExpression).getSelectorExpression() : null)) == null) {
                    ktExpression = expression2;
                }
                KtExpression reportOn = ktExpression;
                DiagnosticFactory1<KtExpression, ClassDescriptor> factory2 = this.reportError ? Errors.UNINITIALIZED_ENUM_COMPANION : Errors.UNINITIALIZED_ENUM_COMPANION_WARNING;
                this.reporter.report(factory2.on((KtExpression)((PsiElement)reportOn), this.enumDescriptor));
                return false;
            }
            return true;
        }
    }
}

