/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeLibraryGenerationRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.dsl.NativeCacheKind;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.targets.native.KonanPropertiesBuildService;
import org.jetbrains.kotlin.gradle.targets.native.internal.PlatformLibrariesGenerator;
import org.jetbrains.kotlin.gradle.tasks.CacheBuilder;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.DistributionKt;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.util.VisibleNamedKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 12\u00020\u0001:\u000212B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020*H\u0002J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020.H\u0002J\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0#*\b\u0012\u0004\u0012\u00020\u001d0#H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0015\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0015\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator;", "", "project", "Lorg/gradle/api/Project;", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/konan/target/KonanTarget;)V", "alreadyProcessed", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "getAlreadyProcessed", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "defDirectory", "Ljava/io/File;", "kotlin.jvm.PlatformType", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "konanCacheKind", "Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "getKonanCacheKind", "()Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "konanCacheKind$delegate", "Lkotlin/Lazy;", "konanPropertiesService", "Lorg/jetbrains/kotlin/gradle/targets/native/KonanPropertiesBuildService;", "getKonanPropertiesService", "()Lorg/jetbrains/kotlin/gradle/targets/native/KonanPropertiesBuildService;", "getKonanTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "mode", "", "getMode", "()Ljava/lang/String;", "mode$delegate", "platformLibsDirectory", "presentDefs", "", "getPresentDefs", "()Ljava/util/Set;", "presentDefs$delegate", "getProject", "()Lorg/gradle/api/Project;", "shouldBuildCaches", "", "checkCaches", "checkLibrariesInDistribution", "generatePlatformLibsIfNeeded", "", "runGenerationTool", "toPlatformLibNames", "Companion", "PlatformLibsInfo", "kotlin-gradle-plugin_common"})
public final class PlatformLibrariesGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final KonanTarget konanTarget;
    @NotNull
    private final Distribution distribution;
    private final File platformLibsDirectory;
    private final File defDirectory;
    @NotNull
    private final Lazy konanCacheKind$delegate;
    private final boolean shouldBuildCaches;
    @NotNull
    private final Lazy mode$delegate;
    @NotNull
    private final Lazy presentDefs$delegate;
    @NotNull
    private static final String GENERATED_LIBS_PROPERTY_NAME = "org.jetbrains.kotlin.native.platform.libs.info";

    public PlatformLibrariesGenerator(@NotNull Project project, @NotNull KonanTarget konanTarget2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)konanTarget2, (String)"konanTarget");
        this.project = project;
        this.konanTarget = konanTarget2;
        this.distribution = DistributionKt.customerDistribution(NativeToolRunnersKt.getKonanHome(this.project));
        this.platformLibsDirectory = new File(this.distribution.platformLibs(this.konanTarget)).getAbsoluteFile();
        this.defDirectory = new File(this.distribution.platformDefs(this.konanTarget)).getAbsoluteFile();
        this.konanCacheKind$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativeCacheKind>(this){
            final /* synthetic */ PlatformLibrariesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativeCacheKind invoke() {
                return NativeToolRunnersKt.getKonanCacheKind(this.this$0.getProject(), this.this$0.getKonanTarget());
            }
        }));
        this.shouldBuildCaches = this.getKonanPropertiesService().cacheWorksFor$kotlin_gradle_plugin_common(this.konanTarget) && this.getKonanCacheKind() != NativeCacheKind.NONE;
        this.mode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PlatformLibrariesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return PropertiesProvider.Companion.invoke(this.this$0.getProject()).getNativePlatformLibrariesMode();
            }
        }));
        this.presentDefs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ PlatformLibrariesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<String> invoke() {
                void $this$mapTo$iv$iv;
                File[] $this$orEmpty$iv = PlatformLibrariesGenerator.access$getDefDirectory$p(this.this$0).listFiles(presentDefs.1.INSTANCE);
                boolean $i$f$orEmpty = false;
                File[] fileArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    fileArray = new File[]{};
                }
                File[] $this$map$iv = fileArray;
                boolean $i$f$map = false;
                File[] fileArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var6_6 = $this$mapTo$iv$iv;
                int n = ((void)var6_6).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var10_10 = item$iv$iv = var6_6[j];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(FilesKt.getNameWithoutExtension((File)it));
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final KonanTarget getKonanTarget() {
        return this.konanTarget;
    }

    private final KonanPropertiesBuildService getKonanPropertiesService() {
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        Object object = KonanPropertiesBuildService.Companion.registerIfAbsent(gradle).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"KonanPropertiesBuildServ\u2026ent(project.gradle).get()");
        return (KonanPropertiesBuildService)object;
    }

    private final NativeCacheKind getKonanCacheKind() {
        Lazy lazy = this.konanCacheKind$delegate;
        return (NativeCacheKind)((Object)lazy.getValue());
    }

    private final String getMode() {
        Lazy lazy = this.mode$delegate;
        return (String)lazy.getValue();
    }

    private final Set<String> getPresentDefs() {
        Lazy lazy = this.presentDefs$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> toPlatformLibNames(Set<String> $this$toPlatformLibNames) {
        void var3_3;
        void $this$mapTo$iv;
        Iterable iterable = $this$toPlatformLibNames;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add("org.jetbrains.kotlin.native.platform." + (String)it);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkLibrariesInDistribution() {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            File[] $this$orEmpty$iv = this.platformLibsDirectory.listFiles(checkLibrariesInDistribution.presentPlatformLibs.1.INSTANCE);
            boolean $i$f$orEmpty = false;
            File[] fileArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                fileArray = new File[]{};
            }
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = var7_7[j];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Set presentPlatformLibs2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$all$iv = this.toPlatformLibNames(this.getPresentDefs());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (presentPlatformLibs2.contains(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean checkCaches() {
        boolean bl;
        block4: {
            if (!this.shouldBuildCaches) {
                return true;
            }
            File cacheDirectory = CacheBuilder.Companion.getRootCacheDirectory$kotlin_gradle_plugin_common(new File(NativeToolRunnersKt.getKonanHome(this.project)), this.konanTarget, true, this.getKonanCacheKind());
            Iterable $this$all$iv = this.toPlatformLibNames(this.getPresentDefs());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    File[] fileArray = FileUtilsKt.listFilesOrEmpty(FilesKt.resolve((File)cacheDirectory, (String)CacheBuilder.Companion.getCacheFileName$kotlin_gradle_plugin_common(it, this.getKonanCacheKind())));
                    if (!(fileArray.length == 0)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final PlatformLibsInfo getAlreadyProcessed() {
        ExtraPropertiesExtension extraPropertiesExtension;
        ExtraPropertiesExtension $this$_get_alreadyProcessed__u24lambda_u2d4 = extraPropertiesExtension = this.project.getRootProject().getExtensions().getExtraProperties();
        boolean bl = false;
        if (!$this$_get_alreadyProcessed__u24lambda_u2d4.has(GENERATED_LIBS_PROPERTY_NAME)) {
            $this$_get_alreadyProcessed__u24lambda_u2d4.set(GENERATED_LIBS_PROPERTY_NAME, (Object)new PlatformLibsInfo());
        }
        Object object = $this$_get_alreadyProcessed__u24lambda_u2d4.get(GENERATED_LIBS_PROPERTY_NAME);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.native.internal.PlatformLibrariesGenerator.PlatformLibsInfo");
        return (PlatformLibsInfo)object;
    }

    private final void runGenerationTool() {
        Project project;
        Project $this$runGenerationTool_u24lambda_u2d7 = project = this.project;
        boolean bl = false;
        Object[] objectArray = new String[]{"-target", this.konanTarget.getVisibleName()};
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        if ($this$runGenerationTool_u24lambda_u2d7.getLogger().isInfoEnabled()) {
            args.add("-verbose");
        }
        if (this.shouldBuildCaches) {
            String string = this.getKonanCacheKind().getProduce();
            Intrinsics.checkNotNull((Object)string);
            KotlinNativeTasksKt.addArg(args, "-cache-kind", string);
            String string2 = CacheBuilder.Companion.getRootCacheDirectory$kotlin_gradle_plugin_common(new File(NativeToolRunnersKt.getKonanHome($this$runGenerationTool_u24lambda_u2d7)), this.konanTarget, true, this.getKonanCacheKind()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CacheBuilder.getRootCach\u2026anCacheKind).absolutePath");
            KotlinNativeTasksKt.addArg(args, "-cache-directory", string2);
            KotlinNativeTasksKt.addArg(args, "-cache-arg", "-g");
            List<String> additionalCacheFlags = this.getKonanPropertiesService().additionalCacheFlags$kotlin_gradle_plugin_common(this.konanTarget);
            Iterable $this$forEach$iv = additionalCacheFlags;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                KotlinNativeTasksKt.addArg(args, "-cache-arg", it);
            }
        }
        String string = this.getMode();
        if (string != null) {
            String string3;
            String it = string3 = string;
            boolean bl3 = false;
            KotlinNativeTasksKt.addArg(args, "-mode", it);
        }
        new KotlinNativeLibraryGenerationRunner($this$runGenerationTool_u24lambda_u2d7).run(args);
    }

    /*
     * WARNING - void declaration
     */
    public final void generatePlatformLibsIfNeeded() {
        void $this$lifecycleWithDuration$iv;
        String string;
        boolean cachesAreReady;
        Project project;
        Project $this$generatePlatformLibsIfNeeded_u24lambda_u2d11 = project = this.project;
        boolean bl = false;
        if (!new HostManager(this.distribution, false, 2, null).isEnabled(this.konanTarget)) {
            return;
        }
        PlatformLibsInfo platformLibsInfo = this.getAlreadyProcessed();
        File file = this.platformLibsDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"platformLibsDirectory");
        boolean alreadyGenerated = platformLibsInfo.isGenerated(file);
        PlatformLibsInfo platformLibsInfo2 = this.getAlreadyProcessed();
        File file2 = this.platformLibsDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"platformLibsDirectory");
        boolean alreadyCached = platformLibsInfo2.isCached(file2, this.getKonanCacheKind());
        if (alreadyGenerated && alreadyCached || !this.defDirectory.exists()) {
            return;
        }
        boolean platformLibsAreReady = this.checkLibrariesInDistribution();
        if (platformLibsAreReady) {
            PlatformLibsInfo platformLibsInfo3 = this.getAlreadyProcessed();
            File file3 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"platformLibsDirectory");
            platformLibsInfo3.setGenerated(file3);
        }
        if (cachesAreReady = this.checkCaches()) {
            PlatformLibsInfo platformLibsInfo4 = this.getAlreadyProcessed();
            File file4 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"platformLibsDirectory");
            platformLibsInfo4.setCached(file4, this.getKonanCacheKind());
        }
        if (!platformLibsAreReady && !cachesAreReady) {
            string = "Generate and precompile platform libraries for " + this.konanTarget + " (precompilation: " + VisibleNamedKt.getVisibleName((Enum)this.getKonanCacheKind()) + ')';
        } else if (platformLibsAreReady && !cachesAreReady) {
            string = "Precompile platform libraries for " + this.konanTarget + " (precompilation: " + VisibleNamedKt.getVisibleName((Enum)this.getKonanCacheKind()) + ')';
        } else if (!platformLibsAreReady && cachesAreReady) {
            string = "Generate platform libraries for " + this.konanTarget;
        } else {
            return;
        }
        String generationMessage = string;
        $this$generatePlatformLibsIfNeeded_u24lambda_u2d11.getLogger().lifecycle(generationMessage);
        Logger logger = $this$generatePlatformLibsIfNeeded_u24lambda_u2d11.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Logger logger2 = logger;
        String messagePrefix$iv = generationMessage + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl2 = false;
        this.runGenerationTool();
        Unit result$iv = Unit.INSTANCE;
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        boolean librariesAreActuallyGenerated = this.checkLibrariesInDistribution();
        if (_Assertions.ENABLED && !librariesAreActuallyGenerated) {
            boolean $i$a$-assert-PlatformLibrariesGenerator$generatePlatformLibsIfNeeded$1$42 = false;
            String $i$a$-assert-PlatformLibrariesGenerator$generatePlatformLibsIfNeeded$1$42 = "Some platform libraries were not generated";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-PlatformLibrariesGenerator$generatePlatformLibsIfNeeded$1$42));
        }
        if (librariesAreActuallyGenerated) {
            PlatformLibsInfo platformLibsInfo5 = this.getAlreadyProcessed();
            File file5 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"platformLibsDirectory");
            platformLibsInfo5.setGenerated(file5);
        }
        boolean librariesAreActuallyCached = this.checkCaches();
        if (_Assertions.ENABLED && !librariesAreActuallyCached) {
            boolean bl3 = false;
            String string2 = "Some platform libraries were not precompiled";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (librariesAreActuallyCached) {
            PlatformLibsInfo platformLibsInfo6 = this.getAlreadyProcessed();
            File file6 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"platformLibsDirectory");
            platformLibsInfo6.setCached(file6, this.getKonanCacheKind());
        }
    }

    public static final /* synthetic */ File access$getDefDirectory$p(PlatformLibrariesGenerator $this) {
        return $this.defDirectory;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "", "()V", "cached", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "", "Ljava/io/File;", "generated", "cacheKind", "isCached", "", "path", "kind", "isGenerated", "setCached", "", "setGenerated", "kotlin-gradle-plugin_common"})
    private static final class PlatformLibsInfo {
        @NotNull
        private final Set<File> generated;
        @NotNull
        private final ConcurrentHashMap<NativeCacheKind, Set<File>> cached;

        public PlatformLibsInfo() {
            Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(ConcurrentHashMap<File, Boolean>())");
            this.generated = set2;
            this.cached = new ConcurrentHashMap();
        }

        private final Set<File> cached(NativeCacheKind cacheKind) {
            ConcurrentMap $this$getOrPut$iv = this.cached;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get((Object)cacheKind);
            if (object == null) {
                Set set2;
                boolean bl = false;
                Set default$iv = set2 = Collections.newSetFromMap(new ConcurrentHashMap());
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(cacheKind, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"cached.getOrPut(cacheKin\u2026le, Boolean>())\n        }");
            return (Set)object;
        }

        public final boolean isGenerated(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.generated.contains(path);
        }

        public final void setGenerated(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.generated.add(path);
        }

        public final boolean isCached(@NotNull File path, @NotNull NativeCacheKind kind) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            return kind == NativeCacheKind.NONE || this.cached(kind).contains(path);
        }

        public final void setCached(@NotNull File path, @NotNull NativeCacheKind kind) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            if (kind != NativeCacheKind.NONE) {
                this.cached(kind).add(path);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$Companion;", "", "()V", "GENERATED_LIBS_PROPERTY_NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

