/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram.internal;

import org.globus.util.Util;
import org.globus.util.http.HTTPProtocol;

public class GRAMProtocol
extends HTTPProtocol {
    public static final int GRAM_PROTOCOL_VERSION = 2;
    public static final String APPLICATION = "application/x-globus-gram";
    public static final String PROTOCOL_VERSION = "protocol-version: ";
    public static final String JOB_STATE_MASK = "job-state-mask: ";
    public static final String CALLBACK_URL = "callback-url: ";
    public static final String RSL = "rsl: ";
    public static final String STATUS = "status";
    public static final String CANCEL = "cancel";
    public static final String REGISTER = "register";
    public static final String UNREGISTER = "unregister";
    public static final String SIGNAL = "signal";
    public static final String RENEW = "renew";
    public static final String PROTOCOL_VERSION_LINE = "protocol-version: 2\r\n";

    public static String REQUEST(String servicename, String hostname, int state_mask, String callback_url, String rsl_string) {
        StringBuffer msg = new StringBuffer();
        msg.append(PROTOCOL_VERSION_LINE);
        msg.append(JOB_STATE_MASK).append(String.valueOf(state_mask)).append("\r\n");
        msg.append(CALLBACK_URL).append(callback_url).append("\r\n");
        msg.append(RSL).append(Util.quote((String)rsl_string)).append("\r\n").append("\r\n");
        return GRAMProtocol.createHTTPHeader((String)servicename, (String)hostname, (String)APPLICATION, (StringBuffer)msg);
    }

    public static String PING(String servicename, String hostname) {
        return GRAMProtocol.createHTTPHeader((String)("ping" + servicename), (String)hostname, (String)APPLICATION, (StringBuffer)new StringBuffer(0));
    }

    public static String STATUS_POLL(String jobmanager_url, String hostname) {
        return GRAMProtocol.JMREQUEST(jobmanager_url, hostname, STATUS);
    }

    public static String SIGNAL(String jobmanager_url, String hostname, int signal, String arg) {
        return GRAMProtocol.JMREQUEST(jobmanager_url, hostname, "signal " + signal + " " + arg);
    }

    public static String REGISTER_CALLBACK(String jobmanager_url, String hostname, int state_mask, String callback_url) {
        return GRAMProtocol.JMREQUEST(jobmanager_url, hostname, "register " + state_mask + " " + callback_url);
    }

    public static String UNREGISTER_CALLBACK(String jobmanager_url, String hostname, String callback_url) {
        return GRAMProtocol.JMREQUEST(jobmanager_url, hostname, "unregister " + callback_url);
    }

    public static String RENEW(String jobmanager_url, String hostname) {
        return GRAMProtocol.JMREQUEST(jobmanager_url, hostname, RENEW);
    }

    public static String CANCEL_JOB(String jobmanager_url, String hostname) {
        return GRAMProtocol.JMREQUEST(jobmanager_url, hostname, CANCEL);
    }

    private static final String JMREQUEST(String jobmanager_url, String hostname, String request) {
        StringBuffer msg = new StringBuffer();
        msg.append(PROTOCOL_VERSION_LINE);
        msg.append(Util.quote((String)request));
        msg.append("\r\n").append("\r\n");
        return GRAMProtocol.createHTTPHeader((String)jobmanager_url, (String)hostname, (String)APPLICATION, (StringBuffer)msg);
    }

    public static String OKReply() {
        return GRAMProtocol.getOKReply((String)APPLICATION);
    }
}

