/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.examples;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.examples.LocalCredentialHelper;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;

public class TwoPartyTransfer {
    private static Log log = LogFactory.getLog(TwoPartyTransfer.class);
    private String host;
    private int port;
    private String source;
    private String dest;
    private String direction;

    public static void main(String[] args) throws Exception {
        String host = "localhost";
        int port = 50500;
        String direction = "download";
        String source = "~/test/test1";
        String dest = "/tmp/testx";
        new TwoPartyTransfer(host, port, source, dest, direction).doTransfer();
    }

    public TwoPartyTransfer(String host, int port, String source, String dest, String direction) {
        if (!direction.equals("download") && !direction.equals("upload")) {
            throw new IllegalArgumentException("Invalid direction: \"download\" || \"upload\"");
        }
        this.host = host;
        this.port = port;
        this.source = source;
        this.dest = dest;
        this.direction = direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransfer() throws Exception {
        GridFTPClient client = null;
        try {
            client = new GridFTPClient(this.host, this.port);
            client.setAuthorization((Authorization)new IdentityAuthorization("/O=Grid/OU=GlobusTest/OU=simpleCA-ubuntu/CN=Vijay Anand"));
            client.authenticate(new LocalCredentialHelper().getDefaultCredential());
            client.setType(1);
            client.setPassive();
            client.setLocalActive();
            if (this.direction.equals("download")) {
                client.get(this.source, new File(this.dest));
            } else {
                client.put(new File(this.source), this.dest, false);
            }
        }
        finally {
            try {
                if (client != null) {
                    client.close(true);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't close connection.", (Throwable)e);
            }
        }
    }
}

