/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.extended;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.globus.gsi.gssapi.net.GssOutputStream;
import org.ietf.jgss.GSSContext;

public class GridFTPOutputStream
extends GssOutputStream {
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] ADAT = "ADAT ".getBytes();
    private static final byte[] MIC = "MIC ".getBytes();
    private static final byte[] ENC = "ENC ".getBytes();

    public GridFTPOutputStream(OutputStream out, GSSContext context) {
        super((OutputStream)new BufferedOutputStream(out), context);
    }

    public void flush() throws IOException {
        if (this.index == 0) {
            return;
        }
        if (this.context.getConfState()) {
            this.writeToken(ENC, this.wrap());
        } else {
            this.writeToken(MIC, this.wrap());
        }
        this.index = 0;
    }

    public void writeHandshakeToken(byte[] token) throws IOException {
        this.writeToken(ADAT, token);
    }

    private void writeToken(byte[] header, byte[] token) throws IOException {
        this.out.write(header);
        this.out.write(Base64.encode((byte[])token));
        this.out.write(CRLF);
        this.out.flush();
    }
}

