/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.EdgeProvider;
import org.jgrapht.ext.GraphImporter;
import org.jgrapht.ext.ImportException;
import org.jgrapht.ext.VertexProvider;
import org.jgrapht.ext.VertexUpdater;
import org.jgrapht.graph.AbstractBaseGraph;

public class DOTImporter<V, E>
implements GraphImporter<V, E> {
    private static final int HEADER = 1;
    private static final int NODE = 2;
    private static final int EDGE = 3;
    private static final int LINE_COMMENT = 4;
    private static final int BLOCK_COMMENT = 5;
    private static final int NODE_QUOTES = 6;
    private static final int EDGE_QUOTES = 7;
    private static final int NEXT = 8;
    private static final int DONE = 32;
    private VertexProvider<V> vertexProvider;
    private VertexUpdater<V> vertexUpdater;
    private EdgeProvider<V, E> edgeProvider;

    public DOTImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this.vertexProvider = vertexProvider;
        this.vertexUpdater = null;
        this.edgeProvider = edgeProvider;
    }

    public DOTImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, VertexUpdater<V> updater) {
        this.vertexProvider = vertexProvider;
        this.vertexUpdater = updater;
        this.edgeProvider = edgeProvider;
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        BufferedReader br = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.read(br.lines().collect(Collectors.joining("\n")), graph);
    }

    @Deprecated
    public void read(String input, AbstractBaseGraph<V, E> graph) throws ImportException {
        this.read(input, (Graph<V, E>)graph);
    }

    private void read(String input, Graph<V, E> graph) throws ImportException {
        if (input == null || input.isEmpty()) {
            throw new ImportException("Dot string was empty");
        }
        HashMap vertexes = new HashMap();
        int state = 1;
        int lastState = 1;
        StringBuilder sectionBuffer = new StringBuilder();
        block10: for (int position = 0; state != 32 && position < input.length(); ++position) {
            int existingState = state;
            switch (state) {
                case 1: {
                    state = this.processHeader(input, position, sectionBuffer, graph);
                    continue block10;
                }
                case 2: {
                    state = this.processNode(input, position, sectionBuffer, graph, vertexes);
                    continue block10;
                }
                case 3: {
                    state = this.processEdge(input, position, sectionBuffer, graph, vertexes);
                    continue block10;
                }
                case 4: {
                    state = this.processLineComment(input, position, sectionBuffer, lastState);
                    if (state != lastState) continue block10;
                    --position;
                    continue block10;
                }
                case 5: {
                    state = this.processBlockComment(input, position, lastState);
                    continue block10;
                }
                case 6: {
                    state = this.processNodeQuotes(input, position, sectionBuffer);
                    continue block10;
                }
                case 7: {
                    state = this.processEdgeQuotes(input, position, sectionBuffer);
                    continue block10;
                }
                case 8: {
                    state = this.processNext(input, position, sectionBuffer, graph, vertexes);
                    continue block10;
                }
                default: {
                    throw new ImportException("Error importing escaped state machine");
                }
            }
        }
        if (state == 1) {
            throw new ImportException("Invalid Header");
        }
    }

    private int processHeader(String input, int position, StringBuilder sectionBuffer, Graph<V, E> graph) throws ImportException {
        if (this.isStartOfLineComment(input, position)) {
            return 4;
        }
        if (this.isStartOfBlockComment(input, position)) {
            return 5;
        }
        char current = input.charAt(position);
        sectionBuffer.append(current);
        if (current == '{') {
            String[] headerParts = sectionBuffer.toString().split(" ", 4);
            if (headerParts.length < 3) {
                throw new ImportException("Not enough parts in header");
            }
            int i = 0;
            if (graph instanceof AbstractBaseGraph && ((AbstractBaseGraph)graph).isAllowingMultipleEdges() && headerParts[i].equals("strict")) {
                throw new ImportException("graph defines strict but Multigraph given.");
            }
            if (headerParts[i].equals("strict")) {
                ++i;
            }
            if (graph instanceof DirectedGraph && headerParts[i].equals("graph")) {
                throw new ImportException("input asks for undirected graph and directed graph provided.");
            }
            if (!(graph instanceof DirectedGraph) && headerParts[i].equals("digraph")) {
                throw new ImportException("input asks for directed graph but undirected graph provided.");
            }
            if (!headerParts[i].equals("graph") && !headerParts[i].equals("digraph")) {
                throw new ImportException("unknown graph type");
            }
            sectionBuffer.setLength(0);
            return 8;
        }
        return 1;
    }

    private int processNext(String input, int position, StringBuilder sectionBuffer, Graph<V, E> graph, Map<String, V> vertexes) throws ImportException {
        if (this.isStartOfLineComment(input, position)) {
            return 4;
        }
        if (this.isStartOfBlockComment(input, position)) {
            return 5;
        }
        char current = input.charAt(position);
        if (current == '\n' || current == '\r') {
            return 8;
        }
        if (sectionBuffer.length() == 0 && (current == ' ' || current == ';')) {
            return 8;
        }
        if (current == ';') {
            this.processCompleteNode(sectionBuffer.toString(), graph, vertexes);
            sectionBuffer.setLength(0);
            return 8;
        }
        sectionBuffer.append(input.charAt(position));
        if (position < input.length() - 1) {
            char next = input.charAt(position + 1);
            if (current == '-') {
                if (next == '-' && graph instanceof DirectedGraph) {
                    throw new ImportException("graph is directed but undirected edge found");
                }
                if (next == '>' && !(graph instanceof DirectedGraph)) {
                    throw new ImportException("graph is undirected but directed edge found");
                }
                if (next == '-' || next == '>') {
                    return 3;
                }
            }
        }
        if (current == '[') {
            return 2;
        }
        return 8;
    }

    private int processNode(String input, int position, StringBuilder sectionBuffer, Graph<V, E> graph, Map<String, V> vertexes) throws ImportException {
        if (this.isStartOfLineComment(input, position)) {
            return 4;
        }
        if (this.isStartOfBlockComment(input, position)) {
            return 5;
        }
        char current = input.charAt(position);
        sectionBuffer.append(input.charAt(position));
        if (current == '\"') {
            return 6;
        }
        if (current == ']' || current == ';') {
            this.processCompleteNode(sectionBuffer.toString(), graph, vertexes);
            sectionBuffer.setLength(0);
            return 8;
        }
        return 2;
    }

    private int processNodeQuotes(String input, int position, StringBuilder sectionBuffer) {
        char current = input.charAt(position);
        sectionBuffer.append(input.charAt(position));
        if (current == '\"' && input.charAt(position - 1) != '\\') {
            return 2;
        }
        return 6;
    }

    private int processEdge(String input, int position, StringBuilder sectionBuffer, Graph<V, E> graph, Map<String, V> vertexes) throws ImportException {
        if (this.isStartOfLineComment(input, position)) {
            return 4;
        }
        if (this.isStartOfBlockComment(input, position)) {
            return 5;
        }
        char current = input.charAt(position);
        sectionBuffer.append(input.charAt(position));
        if (current == '\"') {
            return 7;
        }
        if (current == ';' || current == '\r' || current == '\n') {
            this.processCompleteEdge(sectionBuffer.toString(), graph, vertexes);
            sectionBuffer.setLength(0);
            return 8;
        }
        return 3;
    }

    private int processEdgeQuotes(String input, int position, StringBuilder sectionBuffer) {
        char current = input.charAt(position);
        sectionBuffer.append(input.charAt(position));
        if (current == '\"' && input.charAt(position - 1) != '\\') {
            return 3;
        }
        return 7;
    }

    private int processLineComment(String input, int position, StringBuilder sectionBuffer, int returnState) {
        char current = input.charAt(position);
        if (current == '\r' || current == '\n') {
            sectionBuffer.append(current);
            return returnState;
        }
        return 4;
    }

    private int processBlockComment(String input, int position, int returnState) {
        char current = input.charAt(position);
        if (current == '/' && input.charAt(position - 1) == '*') {
            return returnState;
        }
        return 5;
    }

    private boolean isStartOfLineComment(String input, int position) {
        char current = input.charAt(position);
        if (current == '#') {
            return true;
        }
        return current == '/' && position < input.length() - 1 && input.charAt(position + 1) == '/';
    }

    private boolean isStartOfBlockComment(String input, int position) {
        char current = input.charAt(position);
        return current == '/' && position < input.length() - 1 && input.charAt(position + 1) == '*';
    }

    private void processCompleteNode(String node, Graph<V, E> graph, Map<String, V> vertexes) throws ImportException {
        V existing;
        Map<String, String> attributes = this.extractAttributes(node);
        String id = node.trim();
        int bracketIndex = node.indexOf(91);
        if (bracketIndex > 0) {
            id = node.substring(0, node.indexOf(91)).trim();
        }
        if ((existing = vertexes.get(id)) == null) {
            V vertex = this.vertexProvider.buildVertex(id, attributes);
            graph.addVertex(vertex);
            vertexes.put(id, vertex);
        } else if (this.vertexUpdater != null) {
            this.vertexUpdater.updateVertex(existing, attributes);
        } else {
            throw new ImportException("Update required for vertex " + id + " but no vertexUpdater provided");
        }
    }

    private void processCompleteEdge(String edge, Graph<V, E> graph, Map<String, V> vertexes) throws ImportException {
        Map<String, String> attributes = this.extractAttributes(edge);
        List<String> ids = this.extractEdgeIds(edge);
        for (int i = 0; i < ids.size() - 1; ++i) {
            V v1 = this.getVertex(ids.get(i), vertexes, graph);
            V v2 = this.getVertex(ids.get(i + 1), vertexes, graph);
            E resultEdge = this.edgeProvider.buildEdge(v1, v2, attributes.get("label"), attributes);
            graph.addEdge(v1, v2, resultEdge);
        }
    }

    private V getVertex(String id, Map<String, V> vertexes, Graph<V, E> graph) {
        V v = vertexes.get(id);
        if (v == null) {
            v = this.vertexProvider.buildVertex(id, new HashMap<String, String>());
            graph.addVertex(v);
            vertexes.put(id, v);
        }
        return v;
    }

    private List<String> extractEdgeIds(String line) {
        int bracketIndex;
        String idChunk = line.trim();
        if (idChunk.endsWith(";")) {
            idChunk = idChunk.substring(0, idChunk.length() - 1);
        }
        if ((bracketIndex = idChunk.indexOf(91)) > 1) {
            idChunk = idChunk.substring(0, bracketIndex).trim();
        }
        int index = 0;
        ArrayList<String> ids = new ArrayList<String>();
        while (index < idChunk.length()) {
            String chunk;
            int nextSpace = idChunk.indexOf(32, index);
            if (nextSpace > 0) {
                chunk = idChunk.substring(index, nextSpace);
                index = nextSpace + 1;
            } else {
                chunk = idChunk.substring(index);
                index = idChunk.length() + 1;
            }
            if (chunk.equals("--") || chunk.equals("->")) continue;
            ids.add(chunk);
        }
        return ids;
    }

    private Map<String, String> extractAttributes(String line) throws ImportException {
        Map<String, String> attributes = new HashMap<String, String>();
        int bracketIndex = line.indexOf("[");
        if (bracketIndex > 0) {
            attributes = this.splitAttributes(line.substring(bracketIndex + 1, line.lastIndexOf(93)).trim());
        }
        return attributes;
    }

    private Map<String, String> splitAttributes(String input) throws ImportException {
        int index = 0;
        HashMap<String, String> result = new HashMap<String, String>();
        while (index < input.length()) {
            int endOfKey = this.findEndOfSection(input, index = this.skipWhiteSpace(input, index), '=');
            if (endOfKey < 0) {
                throw new ImportException("Invalid attributes");
            }
            if (input.charAt(endOfKey) == '\"') {
                ++index;
            }
            String key = input.substring(index, endOfKey).trim();
            if (endOfKey + 1 >= input.length()) {
                throw new ImportException("Invalid attributes");
            }
            int start = this.skipWhiteSpace(input, endOfKey + 1);
            int endChar = this.findEndOfSection(input, start, ' ');
            if (input.charAt(start) == '\"') {
                ++start;
            }
            if (endChar < 0) {
                endChar = input.length();
            }
            String value = input.substring(start, endChar);
            result.put(key, value);
            index = endChar + 1;
        }
        return result;
    }

    private int skipWhiteSpace(String input, int start) throws ImportException {
        int i = 0;
        while (Character.isWhitespace(input.charAt(start + i)) || input.charAt(start + i) == '=') {
            if (start + ++i < input.length()) continue;
            throw new ImportException("Invalid attributes");
        }
        return start + i;
    }

    private int findEndOfSection(String input, int start, char terminator) {
        if (input.charAt(start) == '\"') {
            return this.findNextQuote(input, start);
        }
        return input.indexOf(terminator, start);
    }

    private int findNextQuote(String input, int start) {
        int result = start;
        while (input.charAt((result = input.indexOf(34, result + 1)) - 1) == '\\' && (input.charAt(result - 1) != '\\' || input.charAt(result - 2) != '\\')) {
        }
        return result;
    }
}

