/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class GmlExporter<V, E>
implements GraphExporter<V, E> {
    private static final String CREATOR = "JGraphT GML Exporter";
    private static final String VERSION = "1";
    private static final String DELIM = " ";
    private static final String TAB1 = "\t";
    private static final String TAB2 = "\t\t";
    @Deprecated
    public static final Integer PRINT_NO_LABELS = 1;
    @Deprecated
    public static final Integer PRINT_EDGE_LABELS = 2;
    @Deprecated
    public static final Integer PRINT_EDGE_VERTEX_LABELS = 3;
    @Deprecated
    public static final Integer PRINT_VERTEX_LABELS = 4;
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeIDProvider;
    private EdgeNameProvider<E> edgeLabelProvider;
    private final Set<Parameter> parameters;

    public GmlExporter() {
        this(new IntegerNameProvider(), null, new IntegerEdgeNameProvider(), null);
    }

    public GmlExporter(VertexNameProvider<V> vertexIDProvider, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeIDProvider, EdgeNameProvider<E> edgeLabelProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeIDProvider = edgeIDProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.parameters = new HashSet<Parameter>();
    }

    private String quoted(String s) {
        return "\"" + s + "\"";
    }

    private void exportHeader(PrintWriter out) {
        out.println("Creator " + this.quoted(CREATOR));
        out.println("Version 1");
    }

    private void exportVertices(PrintWriter out, Graph<V, E> g) {
        boolean exportVertexLabels = this.parameters.contains((Object)Parameter.EXPORT_VERTEX_LABELS);
        for (Object from : g.vertexSet()) {
            out.println("\tnode");
            out.println("\t[");
            out.println("\t\tid " + this.vertexIDProvider.getVertexName(from));
            if (exportVertexLabels) {
                String label = this.vertexLabelProvider == null ? from.toString() : this.vertexLabelProvider.getVertexName(from);
                out.println("\t\tlabel " + this.quoted(label));
            }
            out.println("\t]");
        }
    }

    private void exportEdges(PrintWriter out, Graph<V, E> g) {
        boolean exportEdgeWeights = this.parameters.contains((Object)Parameter.EXPORT_EDGE_WEIGHTS);
        boolean exportEdgeLabels = this.parameters.contains((Object)Parameter.EXPORT_EDGE_LABELS);
        for (Object edge : g.edgeSet()) {
            out.println("\tedge");
            out.println("\t[");
            String id = this.edgeIDProvider.getEdgeName(edge);
            out.println("\t\tid " + id);
            String s = this.vertexIDProvider.getVertexName(g.getEdgeSource(edge));
            out.println("\t\tsource " + s);
            String t = this.vertexIDProvider.getVertexName(g.getEdgeTarget(edge));
            out.println("\t\ttarget " + t);
            if (exportEdgeLabels) {
                String label = this.edgeLabelProvider == null ? edge.toString() : this.edgeLabelProvider.getEdgeName(edge);
                out.println("\t\tlabel " + this.quoted(label));
            }
            if (exportEdgeWeights && g instanceof WeightedGraph) {
                out.println("\t\tweight " + Double.toString(g.getEdgeWeight(edge)));
            }
            out.println("\t]");
        }
    }

    @Deprecated
    public void export(Writer writer, UndirectedGraph<V, E> g) {
        this.exportGraph((Graph<V, E>)g, writer);
    }

    @Deprecated
    public void export(Writer writer, DirectedGraph<V, E> g) {
        this.exportGraph((Graph<V, E>)g, writer);
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        for (Object from : g.vertexSet()) {
            this.vertexIDProvider.getVertexName(from);
        }
        this.exportHeader(out);
        out.println("graph");
        out.println("[");
        out.println("\tlabel " + this.quoted(""));
        if (g instanceof DirectedGraph) {
            out.println("\tdirected 1");
        } else {
            out.println("\tdirected 0");
        }
        this.exportVertices(out, g);
        this.exportEdges(out, g);
        out.println("]");
        out.flush();
    }

    @Deprecated
    public void setPrintLabels(Integer i) {
        if (i == PRINT_NO_LABELS) {
            this.parameters.remove((Object)Parameter.EXPORT_VERTEX_LABELS);
            this.parameters.remove((Object)Parameter.EXPORT_EDGE_LABELS);
        } else if (i == PRINT_EDGE_LABELS) {
            this.parameters.remove((Object)Parameter.EXPORT_VERTEX_LABELS);
            this.parameters.add(Parameter.EXPORT_EDGE_LABELS);
        } else if (i == PRINT_VERTEX_LABELS) {
            this.parameters.add(Parameter.EXPORT_VERTEX_LABELS);
            this.parameters.remove((Object)Parameter.EXPORT_EDGE_LABELS);
        } else if (i == PRINT_EDGE_VERTEX_LABELS) {
            this.parameters.add(Parameter.EXPORT_VERTEX_LABELS);
            this.parameters.add(Parameter.EXPORT_EDGE_LABELS);
        } else {
            throw new IllegalArgumentException("Non-supported parameter value: " + Integer.toString(i));
        }
    }

    @Deprecated
    public Integer getPrintLabels() {
        if (this.parameters.contains((Object)Parameter.EXPORT_VERTEX_LABELS)) {
            if (this.parameters.contains((Object)Parameter.EXPORT_EDGE_LABELS)) {
                return PRINT_EDGE_VERTEX_LABELS;
            }
            return PRINT_VERTEX_LABELS;
        }
        if (this.parameters.contains((Object)Parameter.EXPORT_EDGE_LABELS)) {
            return PRINT_EDGE_LABELS;
        }
        return PRINT_NO_LABELS;
    }

    public boolean isParameter(Parameter p) {
        return this.parameters.contains((Object)p);
    }

    public void setParameter(Parameter p, boolean value) {
        if (value) {
            this.parameters.add(p);
        } else {
            this.parameters.remove((Object)p);
        }
    }

    public static enum Parameter {
        EXPORT_EDGE_LABELS,
        EXPORT_VERTEX_LABELS,
        EXPORT_EDGE_WEIGHTS;

    }
}

