/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.ext.ExportException;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.util.ModifiableInteger;

public class MatrixExporter<V, E>
implements GraphExporter<V, E> {
    private final String delimiter = " ";
    private Format format;
    private VertexNameProvider<V> vertexIDProvider;

    public MatrixExporter() {
        this(Format.SPARSE_ADJACENCY_MATRIX, new IntegerNameProvider());
    }

    public MatrixExporter(Format format) {
        this(format, new IntegerNameProvider());
    }

    public MatrixExporter(Format format, VertexNameProvider<V> vertexIDProvider) {
        this.format = format;
        if (vertexIDProvider == null) {
            throw new IllegalArgumentException("Vertex ID provider must not be null");
        }
        this.vertexIDProvider = vertexIDProvider;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) throws ExportException {
        switch (this.format) {
            case SPARSE_ADJACENCY_MATRIX: {
                this.exportAdjacencyMatrix(g, writer);
                break;
            }
            case SPARSE_LAPLACIAN_MATRIX: {
                if (g instanceof UndirectedGraph) {
                    this.exportLaplacianMatrix((UndirectedGraph)g, writer);
                    break;
                }
                throw new ExportException("Exporter can only export undirected graphs in this format");
            }
            case SPARSE_NORMALIZED_LAPLACIAN_MATRIX: {
                if (g instanceof UndirectedGraph) {
                    this.exportNormalizedLaplacianMatrix((UndirectedGraph)g, writer);
                    break;
                }
                throw new ExportException("Exporter can only export undirected graphs in this format");
            }
        }
    }

    @Deprecated
    public void exportAdjacencyMatrix(Writer output, UndirectedGraph<V, E> g) {
        this.exportAdjacencyMatrix((Graph<V, E>)g, output);
    }

    @Deprecated
    public void exportAdjacencyMatrix(Writer output, DirectedGraph<V, E> g) {
        this.exportAdjacencyMatrix((Graph<V, E>)g, output);
    }

    @Deprecated
    public void exportLaplacianMatrix(Writer output, UndirectedGraph<V, E> g) {
        this.exportLaplacianMatrix(g, output);
    }

    @Deprecated
    public void exportNormalizedLaplacianMatrix(Writer output, UndirectedGraph<V, E> g) {
        this.exportNormalizedLaplacianMatrix(g, output);
    }

    private void exportAdjacencyMatrix(Graph<V, E> g, Writer writer) {
        for (Object from : g.vertexSet()) {
            this.vertexIDProvider.getVertexName(from);
        }
        PrintWriter out = new PrintWriter(writer);
        if (g instanceof DirectedGraph) {
            for (Object from : g.vertexSet()) {
                this.exportAdjacencyMatrixVertex(out, from, Graphs.successorListOf((DirectedGraph)((DirectedGraph)g), from));
            }
        } else {
            for (Object from : g.vertexSet()) {
                this.exportAdjacencyMatrixVertex(out, from, Graphs.neighborListOf(g, from));
            }
        }
        out.flush();
    }

    private void exportAdjacencyMatrixVertex(PrintWriter writer, V from, List<V> neighbors) {
        ModifiableInteger count;
        String toName;
        String fromName = this.vertexIDProvider.getVertexName(from);
        LinkedHashMap<String, ModifiableInteger> counts = new LinkedHashMap<String, ModifiableInteger>();
        for (V v : neighbors) {
            toName = this.vertexIDProvider.getVertexName(v);
            count = (ModifiableInteger)counts.get(toName);
            if (count == null) {
                count = new ModifiableInteger(0);
                counts.put(toName, count);
            }
            count.increment();
            if (!from.equals(v)) continue;
            count.increment();
        }
        for (Map.Entry entry : counts.entrySet()) {
            toName = (String)entry.getKey();
            count = (ModifiableInteger)entry.getValue();
            this.exportEntry(writer, fromName, toName, count.toString());
        }
    }

    private void exportEntry(PrintWriter writer, String from, String to, String value) {
        writer.println(from + " " + to + " " + value);
    }

    private void exportLaplacianMatrix(UndirectedGraph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        IntegerNameProvider nameProvider = new IntegerNameProvider();
        for (Object from : g.vertexSet()) {
            nameProvider.getVertexName(from);
        }
        for (Object from : g.vertexSet()) {
            String fromName = nameProvider.getVertexName(from);
            List neighbors = Graphs.neighborListOf(g, from);
            this.exportEntry(out, fromName, fromName, Integer.toString(neighbors.size()));
            for (Object to : neighbors) {
                String toName = nameProvider.getVertexName(to);
                this.exportEntry(out, fromName, toName, "-1");
            }
        }
        out.flush();
    }

    private void exportNormalizedLaplacianMatrix(UndirectedGraph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        IntegerNameProvider nameProvider = new IntegerNameProvider();
        for (Object from : g.vertexSet()) {
            nameProvider.getVertexName(from);
        }
        for (Object from : g.vertexSet()) {
            String fromName = nameProvider.getVertexName(from);
            LinkedHashSet neighbors = new LinkedHashSet(Graphs.neighborListOf(g, from));
            if (neighbors.isEmpty()) {
                this.exportEntry(out, fromName, fromName, "0");
                continue;
            }
            this.exportEntry(out, fromName, fromName, "1");
            for (Object to : neighbors) {
                String toName = nameProvider.getVertexName(to);
                double value = -1.0 / Math.sqrt(g.degreeOf(from) * g.degreeOf(to));
                this.exportEntry(out, fromName, toName, Double.toString(value));
            }
        }
        out.flush();
    }

    public static enum Format {
        SPARSE_ADJACENCY_MATRIX,
        SPARSE_LAPLACIAN_MATRIX,
        SPARSE_NORMALIZED_LAPLACIAN_MATRIX;

    }
}

